/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.learning;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import org.clulab.learning.Datasets$;
import org.clulab.learning.Datum;
import org.clulab.learning.PerceptronRankingClassifier$;
import org.clulab.learning.RankingClassifier;
import org.clulab.learning.RankingDataset;
import org.clulab.struct.Counter;
import org.clulab.struct.Counters$;
import org.clulab.struct.Lexicon;
import org.clulab.struct.Lexicon$;
import org.clulab.utils.MathUtils$;
import org.clulab.utils.StringUtils$;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\tEd\u0001B\u0001\u0003\u0001%\u00111\u0004U3sG\u0016\u0004HO]8o%\u0006t7.\u001b8h\u00072\f7o]5gS\u0016\u0014(BA\u0002\u0005\u0003!aW-\u0019:oS:<'BA\u0003\u0007\u0003\u0019\u0019G.\u001e7bE*\tq!A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u000b/M!\u0001aC\t!!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0019!cE\u000b\u000e\u0003\tI!\u0001\u0006\u0002\u0003#I\u000bgn[5oO\u000ec\u0017m]:jM&,'\u000f\u0005\u0002\u0017/1\u0001A!\u0002\r\u0001\u0005\u0004I\"!\u0001$\u0012\u0005ii\u0002C\u0001\u0007\u001c\u0013\taRBA\u0004O_RD\u0017N\\4\u0011\u00051q\u0012BA\u0010\u000e\u0005\r\te.\u001f\t\u0003\u0019\u0005J!AI\u0007\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\na!\u001a9pG\"\u001cX#\u0001\u0014\u0011\u000519\u0013B\u0001\u0015\u000e\u0005\rIe\u000e\u001e\u0005\tU\u0001\u0011\t\u0011)A\u0005M\u00059Q\r]8dQN\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002!\t,(O\\%o\u0013R,'/\u0019;j_:\u001c\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002#\t,(O\\%o\u0013R,'/\u0019;j_:\u001c\b\u0005\u0003\u00051\u0001\t\u0015\r\u0011\"\u00012\u0003-i\u0017M]4j]J\u000bG/[8\u0016\u0003I\u0002\"\u0001D\u001a\n\u0005Qj!A\u0002#pk\ndW\r\u0003\u00057\u0001\t\u0005\t\u0015!\u00033\u00031i\u0017M]4j]J\u000bG/[8!\u0011\u0015A\u0004\u0001\"\u0001:\u0003\u0019a\u0014N\\5u}Q!!h\u000f\u001f>!\r\u0011\u0002!\u0006\u0005\bI]\u0002\n\u00111\u0001'\u0011\u001das\u0007%AA\u0002\u0019Bq\u0001M\u001c\u0011\u0002\u0003\u0007!\u0007C\u00039\u0001\u0011\u0005q\b\u0006\u0002;\u0001\")\u0011I\u0010a\u0001\u0005\u0006)\u0001O]8qgB\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005kRLGNC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%A\u0003)s_B,'\u000f^5fg\"91\n\u0001a\u0001\n\u0003a\u0015A\u00044fCR,(/\u001a'fq&\u001cwN\\\u000b\u0002\u001bB\u0019a*U\u000b\u000e\u0003=S!\u0001\u0015\u0003\u0002\rM$(/^2u\u0013\t\u0011vJA\u0004MKbL7m\u001c8\t\u000fQ\u0003\u0001\u0019!C\u0001+\u0006\u0011b-Z1ukJ,G*\u001a=jG>tw\fJ3r)\t1\u0016\f\u0005\u0002\r/&\u0011\u0001,\u0004\u0002\u0005+:LG\u000fC\u0004['\u0006\u0005\t\u0019A'\u0002\u0007a$\u0013\u0007\u0003\u0004]\u0001\u0001\u0006K!T\u0001\u0010M\u0016\fG/\u001e:f\u0019\u0016D\u0018nY8oA!9a\f\u0001a\u0001\n\u0003y\u0016aB<fS\u001eDGo]\u000b\u0002AB\u0019A\"\u0019\u001a\n\u0005\tl!!B!se\u0006L\bb\u00023\u0001\u0001\u0004%\t!Z\u0001\fo\u0016Lw\r\u001b;t?\u0012*\u0017\u000f\u0006\u0002WM\"9!lYA\u0001\u0002\u0004\u0001\u0007B\u00025\u0001A\u0003&\u0001-\u0001\u0005xK&<\u0007\u000e^:!\u0011\u001dQ\u0007\u00011A\u0005\u0002\u0015\n!c];sm&4X\rZ%uKJ\fG/[8og\"9A\u000e\u0001a\u0001\n\u0003i\u0017AF:veZLg/\u001a3Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005Ys\u0007b\u0002.l\u0003\u0003\u0005\rA\n\u0005\u0007a\u0002\u0001\u000b\u0015\u0002\u0014\u0002'M,(O^5wK\u0012LE/\u001a:bi&|gn\u001d\u0011\t\u000fI\u0004\u0001\u0019!C\u0001?\u0006Q\u0011M^4XK&<\u0007\u000e^:\t\u000fQ\u0004\u0001\u0019!C\u0001k\u0006q\u0011M^4XK&<\u0007\u000e^:`I\u0015\fHC\u0001,w\u0011\u001dQ6/!AA\u0002\u0001Da\u0001\u001f\u0001!B\u0013\u0001\u0017aC1wO^+\u0017n\u001a5ug\u0002BqA\u001f\u0001A\u0002\u0013\u0005Q%\u0001\u0007u_R\fG.U;fe&,7\u000fC\u0004}\u0001\u0001\u0007I\u0011A?\u0002!Q|G/\u00197Rk\u0016\u0014\u0018.Z:`I\u0015\fHC\u0001,\u007f\u0011\u001dQ60!AA\u0002\u0019Bq!!\u0001\u0001A\u0003&a%A\u0007u_R\fG.U;fe&,7\u000f\t\u0005\t\u0003\u000b\u0001\u0001\u0019!C\u0001K\u0005aAo\u001c;bYV\u0003H-\u0019;fg\"I\u0011\u0011\u0002\u0001A\u0002\u0013\u0005\u00111B\u0001\u0011i>$\u0018\r\\+qI\u0006$Xm]0%KF$2AVA\u0007\u0011!Q\u0016qAA\u0001\u0002\u00041\u0003bBA\t\u0001\u0001\u0006KAJ\u0001\u000ei>$\u0018\r\\+qI\u0006$Xm\u001d\u0011\t\u0011\u0005U\u0001\u00011A\u0005\u0002\u0015\nq\"\u001e9eCR,7\u000fU3s\u000bB|7\r\u001b\u0005\n\u00033\u0001\u0001\u0019!C\u0001\u00037\t1#\u001e9eCR,7\u000fU3s\u000bB|7\r[0%KF$2AVA\u000f\u0011!Q\u0016qCA\u0001\u0002\u00041\u0003bBA\u0011\u0001\u0001\u0006KAJ\u0001\u0011kB$\u0017\r^3t!\u0016\u0014X\t]8dQ\u0002B\u0001\"!\n\u0001\u0001\u0004%\t!M\u0001\u0007[\u0006\u0014x-\u001b8\t\u0013\u0005%\u0002\u00011A\u0005\u0002\u0005-\u0012AC7be\u001eLgn\u0018\u0013fcR\u0019a+!\f\t\u0011i\u000b9#!AA\u0002IBq!!\r\u0001A\u0003&!'A\u0004nCJ<\u0017N\u001c\u0011\t\u000f\u0005U\u0002\u0001\"\u0011\u00028\u0005)AO]1j]R)a+!\u000f\u0002D!A\u00111HA\u001a\u0001\u0004\ti$A\u0004eCR\f7/\u001a;\u0011\tI\ty$F\u0005\u0004\u0003\u0003\u0012!A\u0004*b].Lgn\u001a#bi\u0006\u001cX\r\u001e\u0005\u000b\u0003\u000b\n\u0019\u0004%AA\u0002\u0005\u001d\u0013!B:qC:\u001c\b#\u0002\u0007\u0002J\u00055\u0013bAA&\u001b\t1q\n\u001d;j_:\u0004b!a\u0014\u0002`\u0005\u0015d\u0002BA)\u00037rA!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/B\u0011A\u0002\u001fs_>$h(C\u0001\u000f\u0013\r\ti&D\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t'a\u0019\u0003\u0011%#XM]1cY\u0016T1!!\u0018\u000e!\u0015a\u0011q\r\u0014'\u0013\r\tI'\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u00055\u0004\u0001\"\u0001\u0002p\u0005Q2m\\7qkR,\u0017I^3sC\u001e,g+Z2u_JdUM\\4uQR)!'!\u001d\u0002t!A\u00111HA6\u0001\u0004\ti\u0004\u0003\u0005\u0002v\u0005-\u0004\u0019AA<\u0003\u001dIg\u000eZ5dKN\u00042\u0001D1'\u0011\u001d\tY\b\u0001C\u0001\u0003{\na!\u001e9eCR,G#\u0002,\u0002\u0000\u0005%\u0005\u0002CAA\u0003s\u0002\r!a!\u0002\r\t,G\u000f^3s!\u0011q\u0015Q\u0011\u0014\n\u0007\u0005\u001duJA\u0004D_VtG/\u001a:\t\u0011\u0005-\u0015\u0011\u0010a\u0001\u0003\u0007\u000bQa^8sg\u0016Dq!a$\u0001\t\u0003\t\t*\u0001\u0005bI\u0012$v.\u0011<h)\u00051\u0006bBAK\u0001\u0011\u0005\u0011qS\u0001\u000ekB$\u0017\r^3XK&<\u0007\u000e^:\u0015\u000bY\u000bI*!(\t\u0011\u0005m\u00151\u0013a\u0001\u0003\u0007\u000b\u0011A\u001e\u0005\b\u0003?\u000b\u0019\n1\u00013\u0003\u00059\bbBAR\u0001\u0011\u0005\u0013QU\u0001\tg\u000e|'/Z:PMR!\u0011qUAU!\u0015\ty%a\u00183\u0011!\tY+!)A\u0002\u00055\u0016aC9vKJLH)\u0019;v[N\u0004b!a\u0014\u0002`\u0005=\u0006#\u0002\n\u00022\u001a*\u0012bAAZ\u0005\t)A)\u0019;v[\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0016a\u00043biVlGi\u001c;Qe>$Wo\u0019;\u0015\u0007I\nY\f\u0003\u0005\u0002>\u0006U\u0006\u0019AA`\u0003\u0005\u0019\u0007\u0003\u0002(\u0002\u0006VAq!a1\u0001\t\u0003\n)-\u0001\u0004tCZ,Gk\u001c\u000b\u0004-\u0006\u001d\u0007\u0002CAe\u0003\u0003\u0004\r!a3\u0002\u0011\u0019LG.\u001a(b[\u0016\u0004B!!4\u0002V:!\u0011qZAi!\r\t\u0019&D\u0005\u0004\u0003'l\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002X\u0006e'AB*ue&twMC\u0002\u0002T6Aq!!8\u0001\t\u0003\ny.\u0001\u0007eSN\u0004H.Y=N_\u0012,G\u000eF\u0002W\u0003CD\u0001\"a9\u0002\\\u0002\u0007\u0011Q]\u0001\u0003a^\u0004B!a:\u0002n6\u0011\u0011\u0011\u001e\u0006\u0004\u0003W4\u0015AA5p\u0013\u0011\ty/!;\u0003\u0017A\u0013\u0018N\u001c;Xe&$XM\u001d\u0005\n\u0003g\u0004\u0011\u0013!C!\u0003k\fq\u0002\u001e:bS:$C-\u001a4bk2$HEM\u000b\u0003\u0003oTC!a\u0012\u0002z.\u0012\u00111 \t\u0005\u0003{\u00149!\u0004\u0002\u0002\u0000*!!\u0011\u0001B\u0002\u0003%)hn\u00195fG.,GMC\u0002\u0003\u00065\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011I!a@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0004\u0003\u000e\tA\tAa\u0004\u00027A+'oY3qiJ|gNU1oW&twm\u00117bgNLg-[3s!\r\u0011\"\u0011\u0003\u0004\u0007\u0003\tA\tAa\u0005\u0014\t\tE1\u0002\t\u0005\bq\tEA\u0011\u0001B\f)\t\u0011y\u0001\u0003\u0006\u0003\u001c\tE!\u0019!C\u0001\u0005;\ta\u0001\\8hO\u0016\u0014XC\u0001B\u0010!\u0011\u0011\tCa\n\u000e\u0005\t\r\"b\u0001B\u0013\r\u0005)1\u000f\u001c45U&!!\u0011\u0006B\u0012\u0005\u0019aunZ4fe\"I!Q\u0006B\tA\u0003%!qD\u0001\bY><w-\u001a:!\u0011!\u0011\tD!\u0005\u0005\u0002\tM\u0012\u0001\u00037pC\u00124%o\\7\u0016\t\tU\"1\b\u000b\u0005\u0005o\u0011i\u0004\u0005\u0003\u0013\u0001\te\u0002c\u0001\f\u0003<\u00111\u0001Da\fC\u0002eA\u0001\"!3\u00030\u0001\u0007\u00111\u001a\u0005\u000b\u0005\u0003\u0012\t\"%A\u0005\u0002\t\r\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0003F\t%SC\u0001B$U\r1\u0013\u0011 \u0003\u00071\t}\"\u0019A\r\t\u0015\t5#\u0011CI\u0001\n\u0003\u0011y%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0005\u0005\u000b\u0012\t\u0006\u0002\u0004\u0019\u0005\u0017\u0012\r!\u0007\u0005\u000b\u0005+\u0012\t\"%A\u0005\u0002\t]\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0003\u0003Z\tuSC\u0001B.U\r\u0011\u0014\u0011 \u0003\u00071\tM#\u0019A\r\t\u0015\t\u0005$\u0011CA\u0001\n\u0013\u0011\u0019'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B3!\u0011\u00119G!\u001c\u000e\u0005\t%$b\u0001B6\r\u0006!A.\u00198h\u0013\u0011\u0011yG!\u001b\u0003\r=\u0013'.Z2u\u0001")
public class PerceptronRankingClassifier<F>
implements RankingClassifier<F>,
scala.Serializable {
    private final int epochs;
    private final int burnInIterations;
    private final double marginRatio;
    private Lexicon<F> featureLexicon;
    private double[] weights;
    private int survivedIterations;
    private double[] avgWeights;
    private int totalQueries;
    private int totalUpdates;
    private int updatesPerEpoch;
    private double margin;

    public static <F> double $lessinit$greater$default$3() {
        return PerceptronRankingClassifier$.MODULE$.$lessinit$greater$default$3();
    }

    public static <F> int $lessinit$greater$default$2() {
        return PerceptronRankingClassifier$.MODULE$.$lessinit$greater$default$2();
    }

    public static <F> int $lessinit$greater$default$1() {
        return PerceptronRankingClassifier$.MODULE$.$lessinit$greater$default$1();
    }

    public static <F> PerceptronRankingClassifier<F> loadFrom(String string) {
        return PerceptronRankingClassifier$.MODULE$.loadFrom(string);
    }

    public static Logger logger() {
        return PerceptronRankingClassifier$.MODULE$.logger();
    }

    @Override
    public Iterable<Object> probabilitiesOf(Iterable<Datum<Object, F>> queryDatums, double gamma) {
        return RankingClassifier.probabilitiesOf$(this, queryDatums, gamma);
    }

    @Override
    public double probabilitiesOf$default$2() {
        return RankingClassifier.probabilitiesOf$default$2$(this);
    }

    public int epochs() {
        return this.epochs;
    }

    public int burnInIterations() {
        return this.burnInIterations;
    }

    public double marginRatio() {
        return this.marginRatio;
    }

    public Lexicon<F> featureLexicon() {
        return this.featureLexicon;
    }

    public void featureLexicon_$eq(Lexicon<F> x$1) {
        this.featureLexicon = x$1;
    }

    public double[] weights() {
        return this.weights;
    }

    public void weights_$eq(double[] x$1) {
        this.weights = x$1;
    }

    public int survivedIterations() {
        return this.survivedIterations;
    }

    public void survivedIterations_$eq(int x$1) {
        this.survivedIterations = x$1;
    }

    public double[] avgWeights() {
        return this.avgWeights;
    }

    public void avgWeights_$eq(double[] x$1) {
        this.avgWeights = x$1;
    }

    public int totalQueries() {
        return this.totalQueries;
    }

    public void totalQueries_$eq(int x$1) {
        this.totalQueries = x$1;
    }

    public int totalUpdates() {
        return this.totalUpdates;
    }

    public void totalUpdates_$eq(int x$1) {
        this.totalUpdates = x$1;
    }

    public int updatesPerEpoch() {
        return this.updatesPerEpoch;
    }

    public void updatesPerEpoch_$eq(int x$1) {
        this.updatesPerEpoch = x$1;
    }

    public double margin() {
        return this.margin;
    }

    public void margin_$eq(double x$1) {
        this.margin = x$1;
    }

    @Override
    public void train(RankingDataset<F> dataset, Option<Iterable<Tuple2<Object, Object>>> spans) {
        int[] indices = Datasets$.MODULE$.mkTrainIndices(dataset.size(), spans);
        this.totalQueries_$eq(indices.length);
        this.featureLexicon_$eq(Lexicon$.MODULE$.apply(dataset.featureLexicon()));
        this.weights_$eq(new double[this.featureLexicon().size()]);
        this.avgWeights_$eq(new double[this.featureLexicon().size()]);
        this.totalUpdates_$eq(0);
        double avgLen = this.computeAverageVectorLength(dataset, indices);
        Datasets$.MODULE$.logger().debug("Average vector length in training: " + avgLen);
        if (this.marginRatio() > 0.0) {
            this.margin_$eq(this.marginRatio() * avgLen * avgLen);
        }
        Random random = new Random(1);
        BooleanRef converged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.epochs()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)epoch -> !converged$1.elem).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)epoch -> {
            block0: {
                int[] randomizedIndices = (int[])MathUtils$.MODULE$.randomize(indices, random);
                this.updatesPerEpoch_$eq(0);
                Datasets$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting epoch #", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epoch)})));
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(randomizedIndices)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)qi -> {
                    int[] labels = (int[])dataset.labels().apply(qi);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), labels.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)di1 -> {
                        int l1 = labels[di1];
                        Counter<Object> d1 = dataset.featuresCounter(qi, di1);
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(di1 + 1), labels.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)di2 -> {
                            block1: {
                                int l2;
                                block0: {
                                    l2 = labels[di2];
                                    if (l1 <= l2) break block0;
                                    Counter<Object> d2 = dataset.featuresCounter(qi, di2);
                                    this.update(d1, d2);
                                    break block1;
                                }
                                if (l1 >= l2) break block1;
                                Counter<Object> d2 = dataset.featuresCounter(qi, di2);
                                this.update(d2, d1);
                            }
                        });
                    });
                });
                this.totalUpdates_$eq(this.totalUpdates() + this.updatesPerEpoch());
                Datasets$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Epoch ", " completed with ", " updates."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epoch), BoxesRunTime.boxToInteger((int)this.updatesPerEpoch())})));
                if (this.updatesPerEpoch() != 0) break block0;
                converged$1.elem = true;
            }
        });
    }

    @Override
    public Option<Iterable<Tuple2<Object, Object>>> train$default$2() {
        return None$.MODULE$;
    }

    public double computeAverageVectorLength(RankingDataset<F> dataset, int[] indices) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        IntRef count = IntRef.create((int)0);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)qi -> {
            int[] labels = (int[])dataset.labels().apply(qi);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), labels.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)di -> {
                Counter<Object> d = dataset.featuresCounter(qi, di);
                sum$1.elem += package$.MODULE$.sqrt(Counters$.MODULE$.dotProduct(d, d));
                ++count$1.elem;
            });
        });
        return sum.elem / (double)count.elem;
    }

    public void update(Counter<Object> better, Counter<Object> worse) {
        if (Counters$.MODULE$.dotProduct(this.weights(), better) - Counters$.MODULE$.dotProduct(this.weights(), worse) <= this.margin()) {
            this.addToAvg();
            this.updateWeights(better, 1.0);
            this.updateWeights(worse, -1.0);
            this.survivedIterations_$eq(0);
            this.updatesPerEpoch_$eq(this.updatesPerEpoch() + 1);
        } else {
            this.survivedIterations_$eq(this.survivedIterations() + 1);
        }
    }

    public void addToAvg() {
        if (this.survivedIterations() > 0 && this.totalUpdates() + this.updatesPerEpoch() > this.burnInIterations()) {
            double mult = (double)this.survivedIterations() * (double)this.totalQueries();
            for (int i = 0; i < this.weights().length; ++i) {
                double[] dArray = this.avgWeights();
                int n = i;
                dArray[n] = dArray[n] + this.weights()[i] * mult;
            }
        }
    }

    public void updateWeights(Counter<Object> v, double w) {
        v.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (i >= this.weights().length) break block0;
                double[] dArray = this.weights();
                dArray[i] = dArray[i] + v.getCount(BoxesRunTime.boxToInteger((int)i)) * w;
            }
        });
    }

    @Override
    public Iterable<Object> scoresOf(Iterable<Datum<Object, F>> queryDatums) {
        ArrayBuffer scores = new ArrayBuffer();
        queryDatums.foreach((Function1 & Serializable & scala.Serializable)d -> {
            Counter c = d.featuresCounter();
            double s = this.datumDotProduct(c);
            return scores.$plus$eq((Object)BoxesRunTime.boxToDouble((double)s));
        });
        return Predef$.MODULE$.wrapDoubleArray((double[])scores.toArray(ClassTag$.MODULE$.Double()));
    }

    public double datumDotProduct(Counter<F> c) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        c.keySet().foreach((Function1 & Serializable & scala.Serializable)f -> {
            PerceptronRankingClassifier.$anonfun$datumDotProduct$1(this, c, sum, f);
            return BoxedUnit.UNIT;
        });
        return sum.elem;
    }

    @Override
    public void saveTo(String fileName) {
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(fileName));
        os.writeObject(this);
        os.close();
    }

    @Override
    public void displayModel(PrintWriter pw) {
        pw.println("Perceptron weights:");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.avgWeights().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> pw.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t#", ": ", " => ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), this.featureLexicon().get(i), BoxesRunTime.boxToDouble((double)this.avgWeights()[i])}))));
    }

    public static final /* synthetic */ void $anonfun$datumDotProduct$1(PerceptronRankingClassifier $this, Counter c$1, DoubleRef sum$2, Object f) {
        block0: {
            Option<Object> i = $this.featureLexicon().get(f);
            if (!i.isDefined()) break block0;
            sum$2.elem += c$1.getCount(f) * $this.avgWeights()[BoxesRunTime.unboxToInt((Object)i.get())];
        }
    }

    public PerceptronRankingClassifier(int epochs, int burnInIterations, double marginRatio) {
        this.epochs = epochs;
        this.burnInIterations = burnInIterations;
        this.marginRatio = marginRatio;
        RankingClassifier.$init$(this);
        this.featureLexicon = null;
        this.weights = null;
        this.survivedIterations = 0;
        this.avgWeights = null;
        this.totalQueries = 0;
        this.totalUpdates = 0;
        this.updatesPerEpoch = 0;
        this.margin = 0.0;
    }

    public PerceptronRankingClassifier(Properties props) {
        this(StringUtils$.MODULE$.getInt(props, "epochs", 2), StringUtils$.MODULE$.getInt(props, "burnInIterations", 0), StringUtils$.MODULE$.getDouble(props, "marginRatio", 1.0));
    }
}

