/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.learning;

import java.io.Serializable;
import java.io.Writer;
import java.util.concurrent.ForkJoinPool;
import org.clulab.learning.Classifier;
import org.clulab.learning.CounterDataset;
import org.clulab.learning.Dataset;
import org.clulab.learning.Datum;
import org.clulab.learning.RFClassifier$;
import org.clulab.learning.RFJob;
import org.clulab.learning.RFLeaf;
import org.clulab.learning.RFNonTerminal;
import org.clulab.learning.RFTree;
import org.clulab.learning.Utility;
import org.clulab.struct.Counter;
import org.clulab.struct.Lexicon;
import org.clulab.utils.MathUtils$;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParSet;
import scala.collection.parallel.immutable.ParSet$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\r5g\u0001B\u0001\u0003\u0001%\u0011AB\u0015$DY\u0006\u001c8/\u001b4jKJT!a\u0001\u0003\u0002\u00111,\u0017M\u001d8j]\u001eT!!\u0002\u0004\u0002\r\rdW\u000f\\1c\u0015\u00059\u0011aA8sO\u000e\u0001Qc\u0001\u0006\u0018CM!\u0001aC\t$!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB!!cE\u000b!\u001b\u0005\u0011\u0011B\u0001\u000b\u0003\u0005)\u0019E.Y:tS\u001aLWM\u001d\t\u0003-]a\u0001\u0001B\u0003\u0019\u0001\t\u0007\u0011DA\u0001M#\tQR\u0004\u0005\u0002\r7%\u0011A$\u0004\u0002\b\u001d>$\b.\u001b8h!\taa$\u0003\u0002 \u001b\t\u0019\u0011I\\=\u0011\u0005Y\tC!\u0002\u0012\u0001\u0005\u0004I\"!\u0001$\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013AA5p\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\u0019M+'/[1mSj\f'\r\\3\t\u00111\u0002!\u0011!Q\u0001\n5\n\u0001B\\;n)J,Wm\u001d\t\u0003\u00199J!aL\u0007\u0003\u0007%sG\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u0003.\u00031i\u0017\r\u001f+sK\u0016$U\r\u001d;i\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014a\u0003;sC&t')Y4QGR\u0004\"\u0001D\u001b\n\u0005Yj!A\u0002#pk\ndW\r\u0003\u00059\u0001\t\u0005\t\u0015!\u00035\u0003a)H/\u001b7jif$vn\\*nC2dG\u000b\u001b:fg\"|G\u000e\u001a\u0005\tu\u0001\u0011\t\u0011)A\u0005i\u0005\u00012\u000f\u001d7jiR{wnU7bY2\u00046\r\u001e\u0005\ty\u0001\u0011\t\u0011)A\u0005[\u0005Qa.^7UQJ,\u0017\rZ:\t\u0011y\u0002!\u0011!Q\u0001\n}\na\u0003[8x\u001b\u0006t\u0017PR3biV\u0014Xm\u001d)fe:{G-\u001a\t\u0005\u0019\u0001kS&\u0003\u0002B\u001b\tIa)\u001e8di&|g.\r\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\u0006Aa.\u001b7MC\n,G\u000eE\u0002\r\u000bVI!AR\u0007\u0003\r=\u0003H/[8o\u0011\u0015A\u0005\u0001\"\u0001J\u0003\u0019a\u0014N\\5u}QI!j\u0013'N\u001d>\u0003\u0016K\u0015\t\u0005%\u0001)\u0002\u0005C\u0004-\u000fB\u0005\t\u0019A\u0017\t\u000fE:\u0005\u0013!a\u0001[!91g\u0012I\u0001\u0002\u0004!\u0004b\u0002\u001dH!\u0003\u0005\r\u0001\u000e\u0005\bu\u001d\u0003\n\u00111\u00015\u0011\u001dat\t%AA\u00025BqAP$\u0011\u0002\u0003\u0007q\bC\u0004D\u000fB\u0005\t\u0019\u0001#\t\u000fQ\u0003\u0001\u0019!C\u0001+\u0006)AO]3fgV\ta\u000bE\u0002\r\u000b^\u00032\u0001\u0004-[\u0013\tIVBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u00137&\u0011AL\u0001\u0002\u0007%\u001a#&/Z3\t\u000fy\u0003\u0001\u0019!C\u0001?\u0006IAO]3fg~#S-\u001d\u000b\u0003A\u000e\u0004\"\u0001D1\n\u0005\tl!\u0001B+oSRDq\u0001Z/\u0002\u0002\u0003\u0007a+A\u0002yIEBaA\u001a\u0001!B\u00131\u0016A\u0002;sK\u0016\u001c\b\u0005C\u0004i\u0001\u0001\u0007I\u0011A5\u0002\u000fY,'OY8tKV\t!\u000e\u0005\u0002\rW&\u0011A.\u0004\u0002\b\u0005>|G.Z1o\u0011\u001dq\u0007\u00011A\u0005\u0002=\f1B^3sE>\u001cXm\u0018\u0013fcR\u0011\u0001\r\u001d\u0005\bI6\f\t\u00111\u0001k\u0011\u0019\u0011\b\u0001)Q\u0005U\u0006Aa/\u001a:c_N,\u0007\u0005C\u0004u\u0001\u0001\u0007I\u0011B;\u0002\u001d\u0019,\u0017\r^;sK2+\u00070[2p]V\ta\u000fE\u0002\r\u000b^\u00042\u0001_>!\u001b\u0005I(B\u0001>\u0005\u0003\u0019\u0019HO];di&\u0011A0\u001f\u0002\b\u0019\u0016D\u0018nY8o\u0011\u001dq\b\u00011A\u0005\n}\f!CZ3biV\u0014X\rT3yS\u000e|gn\u0018\u0013fcR\u0019\u0001-!\u0001\t\u000f\u0011l\u0018\u0011!a\u0001m\"9\u0011Q\u0001\u0001!B\u00131\u0018a\u00044fCR,(/\u001a'fq&\u001cwN\u001c\u0011\t\u0013\u0005%\u0001\u00011A\u0005\n\u0005-\u0011\u0001\u00047bE\u0016dG*\u001a=jG>tWCAA\u0007!\u0011aQ)a\u0004\u0011\u0007a\\X\u0003C\u0005\u0002\u0014\u0001\u0001\r\u0011\"\u0003\u0002\u0016\u0005\u0001B.\u00192fY2+\u00070[2p]~#S-\u001d\u000b\u0004A\u0006]\u0001\"\u00033\u0002\u0012\u0005\u0005\t\u0019AA\u0007\u0011!\tY\u0002\u0001Q!\n\u00055\u0011!\u00047bE\u0016dG*\u001a=jG>t\u0007\u0005C\u0004\u0002 \u0001!\t%!\t\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u000b\u0001\f\u0019#!\f\t\u0011\u0005\u0015\u0012Q\u0004a\u0001\u0003O\tq\u0001Z1uCN,G\u000fE\u0003\u0013\u0003S)\u0002%C\u0002\u0002,\t\u0011q\u0001R1uCN,G\u000f\u0003\u0005\u00020\u0005u\u0001\u0019AA\u0019\u0003\u001dIg\u000eZ5dKN\u00042\u0001\u0004-.\u0011\u001d\ty\u0002\u0001C\u0001\u0003k!R\u0001YA\u001c\u0003\u007fA\u0001\"!\n\u00024\u0001\u0007\u0011\u0011\b\t\u0006%\u0005mR\u0003I\u0005\u0004\u0003{\u0011!AD\"pk:$XM\u001d#bi\u0006\u001cX\r\u001e\u0005\t\u0003_\t\u0019\u00041\u0001\u00022!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013\u0001G2p[B,H/\u001a$fCR,(/\u001a+ie\u0016\u001c\bn\u001c7egR!\u0011qIA&!\u0011a\u0001,!\u0013\u0011\u00071AF\u0007\u0003\u0005\u0002&\u0005\u0005\u0003\u0019AA\u001d\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\n\u0011\"];b]RLG.Z:\u0015\r\u0005%\u00131KA/\u0011!\t)&!\u0014A\u0002\u0005]\u0013A\u0002<bYV,7\u000f\u0005\u0003y\u00033\"\u0014bAA.s\n91i\\;oi\u0016\u0014\bbBA0\u0003\u001b\u0002\r!L\u0001\tE&t7i\\;oi\"I\u00111\r\u0001A\u0002\u0013\u0005\u0011QM\u0001\niJ,WmQ8v]R,\u0012!\f\u0005\n\u0003S\u0002\u0001\u0019!C\u0001\u0003W\nQ\u0002\u001e:fK\u000e{WO\u001c;`I\u0015\fHc\u00011\u0002n!AA-a\u001a\u0002\u0002\u0003\u0007Q\u0006C\u0004\u0002r\u0001\u0001\u000b\u0015B\u0017\u0002\u0015Q\u0014X-Z\"pk:$\b\u0005C\u0004\u0002v\u0001!\t!a\u001e\u0002\u001b\t,\u0018\u000e\u001c3Ue\u0016,W*Y5o)\rQ\u0016\u0011\u0010\u0005\t\u0003w\n\u0019\b1\u0001\u0002~\u0005\u0019!n\u001c2\u0011\u000bI\ty(\u0006\u0011\n\u0007\u0005\u0005%AA\u0003S\r*{'\rC\u0004\u0002\u0006\u0002!\t!a\"\u0002\u000bA\u0014XO\\3\u0015\u0007i\u000bI\tC\u0004\u0002\f\u0006\r\u0005\u0019\u0001.\u0002\tQ\u0014X-\u001a\u0005\b\u0003\u001f\u0003A\u0011AAI\u0003Y\u0001(/\u001b8u\u0007>tG/\u001b8hK:\u001c\u0017\u0010V1cY\u0016\u001cH#\u00021\u0002\u0014\u0006\r\u0006\u0002CAK\u0003\u001b\u0003\r!a&\u0002\rQ\f'\r\\3t!\u0011a\u0001,!'\u0011\t1A\u00161\u0014\t\b\u0019\u0005u\u0015\u0011UAQ\u0013\r\ty*\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\ta\fI&\f\u0005\t\u0003K\u000bi\t1\u0001\u0002H\u0005QA\u000f\u001b:fg\"|G\u000eZ:\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\u00069R\u000f\u001d3bi\u0016\u001cuN\u001c;j]\u001e,gnY=UC\ndWm\u001d\u000b\bA\u00065\u0016\u0011WA[\u0011!\ty+a*A\u0002\u0005E\u0012\u0001\u00034fCR,(/Z:\t\u0011\u0005M\u0016q\u0015a\u0001\u0003/\u000b\u0011cY8oi&tw-\u001a8dsR\u000b'\r\\3t\u0011!\t9,a*A\u0002\u0005\u0005\u0016!D8wKJ\fG\u000e\u001c'bE\u0016d7\u000fC\u0004\u0002<\u0002!\t!!0\u00021\r|W\u000e];uK\u000e{g\u000e^5oO\u0016t7-\u001f+bE2,7\u000f\u0006\u0004\u0002\u0018\u0006}\u0016\u0011\u0019\u0005\t\u0003w\nI\f1\u0001\u0002~!A\u0011qVA]\u0001\u0004\t\t\u0004C\u0004\u0002*\u0002!\t!!2\u0015\u0013\u0001\f9-!3\u0002N\u0006E\u0007\u0002CAK\u0003\u0007\u0004\r!!'\t\u000f\u0005-\u00171\u0019a\u0001[\u0005)A.\u00192fY\"9\u0011qZAb\u0001\u0004!\u0014A\u00014w\u0011!\t)+a1A\u0002\u0005%\u0003bBAk\u0001\u0011\u0005\u0011q[\u0001\nEVLG\u000e\u001a+sK\u0016$2AWAm\u0011!\tY(a5A\u0002\u0005u\u0004bBAo\u0001\u0011\u0005\u0011q\\\u0001\rI\u0016\u0014WoZ+uS2LG/\u001f\u000b\u0006A\u0006\u0005\u00181\u001e\u0005\t\u0003G\fY\u000e1\u0001\u0002f\u00069Q\u000f^5mSRL\bc\u0001\n\u0002h&\u0019\u0011\u0011\u001e\u0002\u0003\u000fU#\u0018\u000e\\5us\"A\u00111PAn\u0001\u0004\ti\bC\u0004\u0002p\u0002!\t!!=\u0002\u001d\u0019,\u0017\r^;sKV#\u0018\u000e\\5usRa\u00111_A{\u0003s\fY0!@\u0003\u001aA!A\"RAs\u0011\u001d\t90!<A\u00025\nqAZ3biV\u0014X\r\u0003\u0005\u0002&\u00065\b\u0019AA%\u0011!\t\u0019,!<A\u0002\u0005e\u0005\u0002CA\u0000\u0003[\u0004\rA!\u0001\u0002\u0017\u0005\u001cG/\u001b<f\u001d>$Wm\u001d\t\u0007\u0005\u0007\u0011\tBa\u0006\u000f\t\t\u0015!Q\u0002\t\u0004\u0005\u000fiQB\u0001B\u0005\u0015\r\u0011Y\u0001C\u0001\u0007yI|w\u000e\u001e \n\u0007\t=Q\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005'\u0011)BA\u0002TKRT1Aa\u0004\u000e!\u0015a\u0011QT\u00175\u0011\u001d\u0011Y\"!<A\u0002Q\nabY;se\u0016tG/\u0016;jY&$\u0018\u0010C\u0004\u0003 \u0001!\tA!\t\u0002\u001f%tgm\u001c:nCRLwN\\$bS:$B\"a=\u0003$\t\u0015\"q\u0005B\u0015\u0005WAq!a>\u0003\u001e\u0001\u0007Q\u0006\u0003\u0005\u0002&\nu\u0001\u0019AA%\u0011!\t\u0019L!\bA\u0002\u0005e\u0005\u0002CA\u0000\u0005;\u0001\rA!\u0001\t\u000f\t5\"Q\u0004a\u0001i\u0005q1-\u001e:sK:$XI\u001c;s_BL\bb\u0002B\u0019\u0001\u0011\u0005!1G\u0001\u001cS:4wN]7bi&|gnR1j]\u001a{'\u000f\u00165sKNDw\u000e\u001c3\u0015\u0015\u0005M(Q\u0007B\u001c\u0005w\u0011y\u0004C\u0004\u0002x\n=\u0002\u0019A\u0017\t\u000f\te\"q\u0006a\u0001i\u0005IA\u000f\u001b:fg\"|G\u000e\u001a\u0005\t\u0005{\u0011y\u00031\u0001\u0002\u001c\u0006\u00012m\u001c8uS:<WM\\2z)\u0006\u0014G.\u001a\u0005\b\u0005[\u0011y\u00031\u00015\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000b\naC]1oI>lg)Z1ukJ,7+\u001a7fGRLwN\u001c\u000b\t\u0003c\u00119E!\u0014\u0003R!A!\u0011\nB!\u0001\u0004\u0011Y%A\bqe\u0016\u001cXM\u001c;GK\u0006$XO]3t!\u0015\u0011\u0019A!\u0005.\u0011\u001d\u0011yE!\u0011A\u00025\n\u0001B\\;n\r\u0016\fGo\u001d\u0005\t\u0005'\u0012\t\u00051\u0001\u0003V\u00051!/\u00198e_6\u0004BAa\u0016\u0003^5\u0011!\u0011\f\u0006\u0004\u00057j\u0011\u0001B;uS2LAAa\u0018\u0003Z\t1!+\u00198e_6DqAa\u0019\u0001\t\u0003\u0011)'\u0001\u0006tC6,G*\u00192fYN$2A\u001bB4\u0011!\tYH!\u0019A\u0002\u0005u\u0004b\u0002B6\u0001\u0011\u0005!QN\u0001\u0006[.\u0014\u0015m\u001a\u000b\u0011\u0003{\u0012yG!\u001d\u0003t\tU$\u0011\u0010B?\u0005\u007fB\u0001\"!\n\u0003j\u0001\u0007\u0011\u0011\b\u0005\t\u0003_\u0011I\u00071\u0001\u00022!A\u0011Q\u0015B5\u0001\u0004\t9\u0005C\u0004\u0003x\t%\u0004\u0019A\u0017\u0002%Q\u0014\u0018-\u001b8J]\u0012L7-Z:MK:<G\u000f\u001b\u0005\b\u0005w\u0012I\u00071\u00015\u0003\u001d)g\u000e\u001e:pafD\u0001Ba\u0015\u0003j\u0001\u0007!Q\u000b\u0005\b\u0005\u0003\u0013I\u00071\u0001.\u0003\u0019ygMZ:fi\"9!Q\u0011\u0001\u0005\u0002\t\u001d\u0015!C7l\u0019\u00164GOS8c)1\tiH!#\u0003\f\n5%q\u0012BI\u0011!\tYHa!A\u0002\u0005u\u0004bBA|\u0005\u0007\u0003\r!\f\u0005\b\u0005s\u0011\u0019\t1\u00015\u0011\u001d\u0011YHa!A\u0002QB\u0001\"a@\u0003\u0004\u0002\u0007!\u0011\u0001\u0005\b\u0005+\u0003A\u0011\u0001BL\u0003)i7NU5hQRTuN\u0019\u000b\r\u0003{\u0012IJa'\u0003\u001e\n}%\u0011\u0015\u0005\t\u0003w\u0012\u0019\n1\u0001\u0002~!9\u0011q\u001fBJ\u0001\u0004i\u0003b\u0002B\u001d\u0005'\u0003\r\u0001\u000e\u0005\b\u0005w\u0012\u0019\n1\u00015\u0011!\tyPa%A\u0002\t\u0005\u0001b\u0002BS\u0001\u0011\u0005#qU\u0001\tg\u000e|'/Z:PMR!!\u0011\u0016BV!\u0011A\u0018\u0011L\u000b\t\u0011\t5&1\u0015a\u0001\u0005_\u000b\u0011\u0001\u001a\t\u0006%\tEV\u0003I\u0005\u0004\u0005g\u0013!!\u0002#biVl\u0007b\u0002B\\\u0001\u0011\u0005#\u0011X\u0001\bG2\f7o](g)\r)\"1\u0018\u0005\t\u0005[\u0013)\f1\u0001\u00030\"9!q\u0018\u0001\u0005B\t\u0005\u0017AB:bm\u0016$v\u000eF\u0002a\u0005\u0007D\u0001B!2\u0003>\u0002\u0007!qY\u0001\u0007oJLG/\u001a:\u0011\u0007\u0011\u0012I-C\u0002\u0003L\u0016\u0012aa\u0016:ji\u0016\u0014xa\u0002Bh\u0005!\u0005!\u0011[\u0001\r%\u001a\u001bE.Y:tS\u001aLWM\u001d\t\u0004%\tMgAB\u0001\u0003\u0011\u0003\u0011)nE\u0003\u0003T.\u00119\u000eE\u0002\r\u00053L!AK\u0007\t\u000f!\u0013\u0019\u000e\"\u0001\u0003^R\u0011!\u0011\u001b\u0005\u000b\u0005C\u0014\u0019N1A\u0005\u0002\t\r\u0018A\u00027pO\u001e,'/\u0006\u0002\u0003fB!!q\u001dBw\u001b\t\u0011IOC\u0002\u0003l\u001a\tQa\u001d7gi)LAAa<\u0003j\n1Aj\\4hKJD\u0011Ba=\u0003T\u0002\u0006IA!:\u0002\u000f1|wmZ3sA!Q!q\u001fBj\u0005\u0004%\t!!\u001a\u0002\u0017I\u000be\nR(N?N+U\t\u0012\u0005\t\u0005w\u0014\u0019\u000e)A\u0005[\u0005a!+\u0011(E\u001f6{6+R#EA!Q!q Bj\u0005\u0004%\t!!\u001a\u0002%E+\u0016I\u0014+J\u0019\u0016{F\u000b\u0013*F'\"{E\n\u0012\u0005\t\u0007\u0007\u0011\u0019\u000e)A\u0005[\u0005\u0019\u0012+V!O)&cUi\u0018+I%\u0016\u001b\u0006j\u0014'EA!A1q\u0001Bj\t\u0003\u0019I!A\ngK\u0006$XO]3t!\u0016\u0014hj\u001c3f'F\u0014H\u000fF\u0002.\u0007\u0017AqAa\u0014\u0004\u0006\u0001\u0007Q\u0006\u0003\u0005\u0004\u0010\tMG\u0011AB\t\u0003a1W-\u0019;ve\u0016\u001c\b+\u001a:O_\u0012,Gk^8UQ&\u0014Hm\u001d\u000b\u0004[\rM\u0001b\u0002B(\u0007\u001b\u0001\r!\f\u0005\t\u0007/\u0011\u0019\u000e\"\u0001\u0004\u001a\u0005\u0011b-Z1ukJ,7\u000fU3s\u001d>$W-\u00117m)\ri31\u0004\u0005\b\u0005\u001f\u001a)\u00021\u0001.\u0011!\u0011YHa5\u0005\u0002\r}Ac\u0001\u001b\u0004\"!A11EB\u000f\u0001\u0004\t\t+\u0001\u0004mC\n,Gn\u001d\u0005\t\u0007O\u0011\u0019\u000e\"\u0001\u0004*\u0005YA.\u00192fY\u000e{WO\u001c;t+\u0019\u0019Yc!\u000e\u0004:Q1\u0011\u0011UB\u0017\u0007_A\u0001\"a\f\u0004&\u0001\u0007\u0011\u0011\u0007\u0005\t\u0003K\u0019)\u00031\u0001\u00042A9!#a\u000f\u00044\r]\u0002c\u0001\f\u00046\u00111\u0001d!\nC\u0002e\u00012AFB\u001d\t\u0019\u00113Q\u0005b\u00013!A1Q\bBj\t\u0003\u0019y$\u0001\u0003m_\u001e\u0014Dc\u0001\u001b\u0004B!9!QVB\u001e\u0001\u0004!\u0004BCB#\u0005'\f\n\u0011\"\u0001\u0004H\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*ba!\u0013\u0004`\r\u0005TCAB&U\ri3QJ\u0016\u0003\u0007\u001f\u0002Ba!\u0015\u0004\\5\u001111\u000b\u0006\u0005\u0007+\u001a9&A\u0005v]\u000eDWmY6fI*\u00191\u0011L\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004^\rM#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121\u0001da\u0011C\u0002e!aAIB\"\u0005\u0004I\u0002BCB3\u0005'\f\n\u0011\"\u0001\u0004h\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*ba!\u0013\u0004j\r-DA\u0002\r\u0004d\t\u0007\u0011\u0004\u0002\u0004#\u0007G\u0012\r!\u0007\u0005\u000b\u0007_\u0012\u0019.%A\u0005\u0002\rE\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0004\u0004t\r]4\u0011P\u000b\u0003\u0007kR3\u0001NB'\t\u0019A2Q\u000eb\u00013\u00111!e!\u001cC\u0002eA!b! \u0003TF\u0005I\u0011AB@\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU111OBA\u0007\u0007#a\u0001GB>\u0005\u0004IBA\u0002\u0012\u0004|\t\u0007\u0011\u0004\u0003\u0006\u0004\b\nM\u0017\u0013!C\u0001\u0007\u0013\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCBB:\u0007\u0017\u001bi\t\u0002\u0004\u0019\u0007\u000b\u0013\r!\u0007\u0003\u0007E\r\u0015%\u0019A\r\t\u0015\rE%1[I\u0001\n\u0003\u0019\u0019*A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0007\u0007\u0013\u001a)ja&\u0005\ra\u0019yI1\u0001\u001a\t\u0019\u00113q\u0012b\u00013!Q11\u0014Bj#\u0003%\ta!(\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\u0019\u0019yja)\u0004&V\u00111\u0011\u0015\u0016\u0004\u007f\r5CA\u0002\r\u0004\u001a\n\u0007\u0011\u0004\u0002\u0004#\u00073\u0013\r!\u0007\u0005\u000b\u0007S\u0013\u0019.%A\u0005\u0002\r-\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0004\u0004.\u000e]6\u0011X\u000b\u0003\u0007_SCa!-\u0004N9\u0019Aba-\n\u0007\rUV\"\u0001\u0003O_:,GA\u0002\r\u0004(\n\u0007\u0011\u0004\u0002\u0004#\u0007O\u0013\r!\u0007\u0005\u000b\u0007{\u0013\u0019.!A\u0005\n\r}\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!1\u0011\t\r\r7\u0011Z\u0007\u0003\u0007\u000bT1aa2(\u0003\u0011a\u0017M\\4\n\t\r-7Q\u0019\u0002\u0007\u001f\nTWm\u0019;")
public class RFClassifier<L, F>
implements Classifier<L, F>,
Serializable {
    private final int numTrees;
    private final int maxTreeDepth;
    private final double trainBagPct;
    private final double utilityTooSmallThreshold;
    private final double splitTooSmallPct;
    private final int numThreads;
    private final Function1<Object, Object> howManyFeaturesPerNode;
    private final Option<L> nilLabel;
    private Option<RFTree[]> trees;
    private boolean verbose;
    private Option<Lexicon<F>> featureLexicon;
    private Option<Lexicon<L>> labelLexicon;
    private int treeCount;

    public static <L, F> None$ $lessinit$greater$default$8() {
        return RFClassifier$.MODULE$.$lessinit$greater$default$8();
    }

    public static <L, F> Function1<Object, Object> $lessinit$greater$default$7() {
        return RFClassifier$.MODULE$.$lessinit$greater$default$7();
    }

    public static <L, F> int $lessinit$greater$default$6() {
        return RFClassifier$.MODULE$.$lessinit$greater$default$6();
    }

    public static <L, F> double $lessinit$greater$default$5() {
        return RFClassifier$.MODULE$.$lessinit$greater$default$5();
    }

    public static <L, F> double $lessinit$greater$default$4() {
        return RFClassifier$.MODULE$.$lessinit$greater$default$4();
    }

    public static <L, F> double $lessinit$greater$default$3() {
        return RFClassifier$.MODULE$.$lessinit$greater$default$3();
    }

    public static <L, F> int $lessinit$greater$default$2() {
        return RFClassifier$.MODULE$.$lessinit$greater$default$2();
    }

    public static <L, F> int $lessinit$greater$default$1() {
        return RFClassifier$.MODULE$.$lessinit$greater$default$1();
    }

    public static double log2(double d) {
        return RFClassifier$.MODULE$.log2(d);
    }

    public static <L, F> Counter<Object> labelCounts(int[] nArray, CounterDataset<L, F> counterDataset) {
        return RFClassifier$.MODULE$.labelCounts(nArray, counterDataset);
    }

    public static double entropy(Counter<Object> counter) {
        return RFClassifier$.MODULE$.entropy(counter);
    }

    public static int featuresPerNodeAll(int n) {
        return RFClassifier$.MODULE$.featuresPerNodeAll(n);
    }

    public static int featuresPerNodeTwoThirds(int n) {
        return RFClassifier$.MODULE$.featuresPerNodeTwoThirds(n);
    }

    public static int featuresPerNodeSqrt(int n) {
        return RFClassifier$.MODULE$.featuresPerNodeSqrt(n);
    }

    public static int QUANTILE_THRESHOLD() {
        return RFClassifier$.MODULE$.QUANTILE_THRESHOLD();
    }

    public static int RANDOM_SEED() {
        return RFClassifier$.MODULE$.RANDOM_SEED();
    }

    public static Logger logger() {
        return RFClassifier$.MODULE$.logger();
    }

    @Override
    public void train(Dataset<L, F> dataset, Option<Iterable<Tuple2<Object, Object>>> spans) {
        Classifier.train$(this, dataset, spans);
    }

    @Override
    public void saveTo(String fileName) {
        Classifier.saveTo$(this, fileName);
    }

    @Override
    public Option<Iterable<Tuple2<Object, Object>>> train$default$2() {
        return Classifier.train$default$2$(this);
    }

    public Option<RFTree[]> trees() {
        return this.trees;
    }

    public void trees_$eq(Option<RFTree[]> x$1) {
        this.trees = x$1;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    private Option<Lexicon<F>> featureLexicon() {
        return this.featureLexicon;
    }

    private void featureLexicon_$eq(Option<Lexicon<F>> x$1) {
        this.featureLexicon = x$1;
    }

    private Option<Lexicon<L>> labelLexicon() {
        return this.labelLexicon;
    }

    private void labelLexicon_$eq(Option<Lexicon<L>> x$1) {
        this.labelLexicon = x$1;
    }

    @Override
    public void train(Dataset<L, F> dataset, int[] indices) {
        this.train(dataset.toCounterDataset(), indices);
    }

    @Override
    public void train(CounterDataset<L, F> dataset, int[] indices) {
        block7: {
            if (this.numThreads < 0) {
                throw new RuntimeException("ERROR: numThreads must be >= 0!");
            }
            if (this.numTrees < 1) {
                throw new RuntimeException("ERROR: numTrees must be >= 1!");
            }
            this.labelLexicon_$eq((Option<Lexicon<L>>)new Some(dataset.labelLexicon()));
            this.featureLexicon_$eq((Option<Lexicon<F>>)new Some(dataset.featureLexicon()));
            RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training on a dataset containing ", " datums, with ", " labels."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dataset.size()), BoxesRunTime.boxToInteger((int)dataset.labelLexicon().size())})));
            double[][] thresholds = this.computeFeatureThresholds(dataset);
            ArrayBuffer bags = new ArrayBuffer();
            int bagSize = (int)package$.MODULE$.ceil(this.trainBagPct * (double)indices.length);
            Random randomSeed = new Random(RFClassifier$.MODULE$.RANDOM_SEED());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numTrees).foreach((Function1 & Serializable & scala.Serializable)i -> bags.$plus$eq(this.mkBag(dataset, indices, thresholds, bagSize, RFClassifier$.MODULE$.entropy(RFClassifier$.MODULE$.labelCounts(indices, dataset)), randomSeed, BoxesRunTime.unboxToInt((Object)i))));
            RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Constructed ", " bag(s), each containing ", " datums"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bags.size()), BoxesRunTime.boxToInteger((int)bagSize)})));
            RFClassifier$.MODULE$.logger().debug("Beginning tree building...");
            int n = this.numThreads;
            switch (n) {
                case 0: {
                    ParSet parBags = (ParSet)bags.toSet().par();
                    this.trees_$eq((Option<RFTree[]>)new Some(((ParIterableLike)parBags.map((Function1 & Serializable & scala.Serializable)job -> this.buildTreeMain((RFJob)job), (CanBuildFrom)ParSet$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RFTree.class))));
                    break;
                }
                case 1: {
                    this.trees_$eq((Option<RFTree[]>)new Some(((TraversableOnce)bags.map((Function1 & Serializable & scala.Serializable)job -> this.buildTreeMain((RFJob)job), ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RFTree.class))));
                    break;
                }
                default: {
                    ParSet parBags = (ParSet)bags.toSet().par();
                    parBags.tasksupport_$eq((TaskSupport)new ForkJoinTaskSupport(new ForkJoinPool(this.numThreads)));
                    this.trees_$eq((Option<RFTree[]>)new Some(((ParIterableLike)parBags.map((Function1 & Serializable & scala.Serializable)job -> this.buildTreeMain((RFJob)job), (CanBuildFrom)ParSet$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RFTree.class))));
                    break;
                }
            }
            if (this.verbose()) {
                RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Label lexicon:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.labelLexicon().get()})));
                RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature lexicon:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.featureLexicon().get()})));
            }
            RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Done building ", " trees."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((RFTree[])this.trees().get()).length)})));
            if (!this.verbose()) break block7;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.trees().get())).foreach((Function1 & Serializable & scala.Serializable)tree -> {
                RFClassifier.$anonfun$train$5(this, tree);
                return BoxedUnit.UNIT;
            });
        }
    }

    public double[][] computeFeatureThresholds(CounterDataset<L, F> dataset) {
        RFClassifier$.MODULE$.logger().debug("Computing feature thresholds...");
        Counter[] featureValues = new Counter[((Lexicon)this.featureLexicon().get()).size()];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureValues)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)f -> {
            featureValues$1[f] = new Counter();
        });
        dataset.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Counter<Object> c = dataset.featuresCounter(i);
            c.keySet().foreach((Function1 & Serializable & scala.Serializable)f -> RFClassifier.$anonfun$computeFeatureThresholds$3(featureValues, c, BoxesRunTime.unboxToInt((Object)f)));
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureValues)).indices().foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)f -> {
            Counter qual$2 = featureValues[f];
            double x$4 = 0.0;
            double x$5 = qual$2.incrementCount$default$2();
            return qual$2.incrementCount(BoxesRunTime.boxToDouble((double)x$4), x$5);
        });
        double[][] thresholds = new double[featureValues.length][];
        IntRef thresholdCount = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureValues)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)f -> {
            ArrayBuffer featThresholds = new ArrayBuffer();
            if (featureValues[f].size() > RFClassifier$.MODULE$.QUANTILE_THRESHOLD()) {
                double[] quantileValues = this.quantiles(featureValues[f], RFClassifier$.MODULE$.QUANTILE_THRESHOLD());
                featThresholds.$plus$plus$eq((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantileValues)));
                thresholdCount$1.elem += quantileValues.length;
            } else {
                List sortedValues = (List)featureValues[f].sorted(false).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._1$mcD$sp()), List$.MODULE$.canBuildFrom());
                if (sortedValues.length() > 1) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sortedValues.length() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        featThresholds.$plus$eq((Object)BoxesRunTime.boxToDouble((double)((BoxesRunTime.unboxToDouble((Object)sortedValues.apply(i)) + BoxesRunTime.unboxToDouble((Object)sortedValues.apply(i + 1))) / 2.0)));
                        ++thresholdCount$1.elem;
                    });
                }
            }
            thresholds$2[f] = (double[])featThresholds.toArray(ClassTag$.MODULE$.Double());
        });
        RFClassifier$.MODULE$.logger().debug("Finished computing feature thresholds.");
        RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " thresholds for ", " features."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)thresholdCount.elem), BoxesRunTime.boxToInteger((int)thresholds.length)})));
        if (this.verbose()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])thresholds)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)f -> RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature [", "]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Lexicon)this.featureLexicon().get()).get(f), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(thresholds[f])).toList()}))));
        }
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])thresholds)).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public double[] quantiles(Counter<Object> values, int binCount) {
        List<Tuple2<Object, Object>> sortedUniq = values.sorted(false);
        ArrayBuffer sorted = new ArrayBuffer();
        sortedUniq.foreach((Function1 & Serializable & scala.Serializable)su -> {
            RFClassifier.$anonfun$quantiles$1(sorted, su);
            return BoxedUnit.UNIT;
        });
        double[] qs = new double[binCount - 1];
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(qs)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            double pos = (double)sorted.length() * (double)(i + 1) / (double)binCount;
            qs$1[i] = pos == RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(pos)) ? (BoxesRunTime.unboxToDouble((Object)sorted.apply((int)pos)) + BoxesRunTime.unboxToDouble((Object)sorted.apply((int)pos - 1))) / 2.0 : BoxesRunTime.unboxToDouble((Object)sorted.apply((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(pos))));
        });
        return qs;
    }

    public int treeCount() {
        return this.treeCount;
    }

    public void treeCount_$eq(int x$1) {
        this.treeCount = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public RFTree buildTreeMain(RFJob<L, F> job) {
        void var3_3;
        RFTree t;
        RFTree pt = t = this.buildTree(job);
        pt.weight_$eq(1.0);
        RFClassifier rFClassifier = this;
        synchronized (rFClassifier) {
            this.treeCount_$eq(this.treeCount() + 1);
            RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Built ", "/", " decision trees of depth ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.treeCount()), BoxesRunTime.boxToInteger((int)this.numTrees), BoxesRunTime.boxToInteger((int)this.maxTreeDepth)})));
        }
        return var3_3;
    }

    public RFTree prune(RFTree tree) {
        RFTree rFTree;
        RFTree rFTree2 = tree;
        if (rFTree2 instanceof RFNonTerminal) {
            RFTree rFTree3;
            RFNonTerminal rFNonTerminal = (RFNonTerminal)rFTree2;
            rFNonTerminal.l_$eq(this.prune(rFNonTerminal.l()));
            rFNonTerminal.r_$eq(this.prune(rFNonTerminal.r()));
            if (((RFTree)rFNonTerminal.left().get()).isLeaf() && ((RFTree)rFNonTerminal.right().get()).isLeaf() && ((RFTree)rFNonTerminal.left().get()).sameLabels((RFTree)rFNonTerminal.right().get())) {
                Predef$.MODULE$.println((Object)"Pruned 1 node");
                rFTree3 = new RFLeaf(((RFTree)rFNonTerminal.left().get()).mergeLabels((RFTree)rFNonTerminal.right().get()));
            } else {
                rFTree3 = rFNonTerminal;
            }
            rFTree = rFTree3;
        } else {
            rFTree = tree;
        }
        return rFTree;
    }

    public void printContingencyTables(Tuple2<Counter<Object>, Counter<Object>>[][] tables, double[][] thresholds) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tables for ", " features."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tables.length)})));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tables)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)f -> {
            block0: {
                if (tables[f] == null) break block0;
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tables for feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)f)})));
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tables[f])).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)t -> {
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tThreshold ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)thresholds[f][t])})));
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t\\tSMALLER: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tables[f][t]._1()})));
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t\\tGREATER: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tables[f][t]._2()})));
                });
            }
        });
    }

    public void updateContingencyTables(int[] features, Tuple2<Counter<Object>, Counter<Object>>[][] contingencyTables, Counter<Object> overallLabels) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(features)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)f -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contingencyTables[f])).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)t -> {
            Counter left = (Counter)contingencyTables[f][t]._1();
            Counter right = (Counter)contingencyTables[f][t]._2();
            Counter seen = new Counter();
            seen.$plus$eq(left);
            seen.$plus$eq(right);
            Counter diff = overallLabels.$minus(seen);
            left.$plus$eq(diff);
        }));
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Counter<Object>, Counter<Object>>[][] computeContingencyTables(RFJob<L, F> job, int[] features) {
        void var3_3;
        Tuple2[][] contingencyTables = new Tuple2[job.dataset().featureLexicon().size()][];
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(features)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)f -> {
            contingencyTables$2[f] = new Tuple2[job.featureThresholds()[f].length];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contingencyTables[f])).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                contingencyTables$2[f$3][i] = new Tuple2(new Counter(), new Counter());
            });
        });
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(job.trainIndices())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int l = BoxesRunTime.unboxToInt((Object)job.dataset().labels().apply(i));
            Counter<Object> fs = job.dataset().featuresCounter(i);
            fs.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)f -> {
                block0: {
                    Tuple2[] tables = contingencyTables[f];
                    if (tables == null) break block0;
                    double fv = fs.getCount(BoxesRunTime.boxToInteger((int)f));
                    this.updateContingencyTables(contingencyTables[f], l, fv, job.featureThresholds()[f]);
                }
            });
        });
        return var3_3;
    }

    public void updateContingencyTables(Tuple2<Counter<Object>, Counter<Object>>[] tables, int label, double fv, double[] thresholds) {
        Predef$.MODULE$.assert(tables.length == thresholds.length);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(thresholds)).indices().foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            double d;
            if (fv <= thresholds[i]) {
                Counter qual$3 = (Counter)tables[i]._1();
                int x$6 = label;
                double x$7 = qual$3.incrementCount$default$2();
                d = qual$3.incrementCount(BoxesRunTime.boxToInteger((int)x$6), x$7);
            } else {
                Counter qual$4 = (Counter)tables[i]._2();
                int x$8 = label;
                double x$9 = qual$4.incrementCount$default$2();
                d = qual$4.incrementCount(BoxesRunTime.boxToInteger((int)x$8), x$9);
            }
            return d;
        });
    }

    public RFTree buildTree(RFJob<L, F> job) {
        RFTree rFTree;
        if (this.sameLabels(job)) {
            return new RFLeaf(job.leafLabels());
        }
        if (this.maxTreeDepth > 0 && job.activeNodes().size() > this.maxTreeDepth) {
            return new RFLeaf(job.leafLabels());
        }
        if (this.splitTooSmallPct > 0.0 && (double)job.trainIndices().length < this.splitTooSmallPct * (double)job.dataset().size()) {
            return new RFLeaf(job.leafLabels());
        }
        int[] currentFeatureIndices = this.randomFeatureSelection(job.features(), job.dataset().featureLexicon().size(), job.random());
        Tuple2<Counter<Object>, Counter<Object>>[][] contingencyTables = this.computeContingencyTables(job, currentFeatureIndices);
        Counter<Object> overallLabels = job.labelCounts();
        this.updateContingencyTables(currentFeatureIndices, contingencyTables, overallLabels);
        ObjectRef best = ObjectRef.create((Object)None$.MODULE$);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(currentFeatureIndices)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)f -> {
            block2: {
                Option<Utility> utility = this.featureUtility(f, job.featureThresholds()[f], contingencyTables[f], job.activeNodes(), job.currentUtility());
                if (this.verbose() && utility.isDefined()) {
                    Predef$.MODULE$.println((Object)"Current utility:");
                    this.debugUtility((Utility)utility.get(), job);
                }
                if (!utility.isDefined() || !((Option)best$1.elem).isEmpty() && !(((Utility)((Option)best$1.elem).get()).value() < ((Utility)utility.get()).value())) break block2;
                best$1.elem = utility;
                if (this.verbose()) {
                    Predef$.MODULE$.println((Object)"CHOSEN NEW BEST!");
                }
            }
        });
        if (((Option)best.elem).isEmpty()) {
            rFTree = new RFLeaf(job.leafLabels());
        } else {
            if (this.verbose()) {
                Predef$.MODULE$.println((Object)"BEST OVERALL:");
                this.debugUtility((Utility)((Option)best.elem).get(), job);
            }
            HashSet newActiveNodes = new HashSet();
            newActiveNodes.$plus$plus$eq(job.activeNodes());
            newActiveNodes.$plus$eq((Object)new Tuple2.mcID.sp(((Utility)((Option)best.elem).get()).feature(), ((Utility)((Option)best.elem).get()).threshold()));
            Set newActiveNodesSet = newActiveNodes.toSet();
            rFTree = new RFNonTerminal(((Utility)((Option)best.elem).get()).feature(), ((Utility)((Option)best.elem).get()).threshold(), this.buildTree(this.mkLeftJob(job, ((Utility)((Option)best.elem).get()).feature(), ((Utility)((Option)best.elem).get()).threshold(), ((Utility)((Option)best.elem).get()).leftChildValue(), (Set<Tuple2<Object, Object>>)newActiveNodesSet)), this.buildTree(this.mkRightJob(job, ((Utility)((Option)best.elem).get()).feature(), ((Utility)((Option)best.elem).get()).threshold(), ((Utility)((Option)best.elem).get()).rightChildValue(), (Set<Tuple2<Object, Object>>)newActiveNodesSet)));
        }
        return rFTree;
    }

    public void debugUtility(Utility utility, RFJob<L, F> job) {
        Predef$.MODULE$.println((Object)"UTILITY DEBUG:");
        Predef$.MODULE$.println((Object)"Using dataset:");
        job.printDataset();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using feature ", " with threshold ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)utility.feature()), BoxesRunTime.boxToDouble((double)utility.threshold())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Contingency table for this feature+threshold is: SMALLER: ", ", GREATER: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{utility.leftCounter(), utility.rightCounter()})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Overall utility: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)utility.value())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parent utility: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)utility.parentValue())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Utility of left child: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)utility.leftChildValue())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Utility of right child: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)utility.rightChildValue())})));
    }

    public Option<Utility> featureUtility(int feature, double[] thresholds, Tuple2<Counter<Object>, Counter<Object>>[] contingencyTables, Set<Tuple2<Object, Object>> activeNodes, double currentUtility) {
        return this.informationGain(feature, thresholds, contingencyTables, activeNodes, currentUtility);
    }

    public Option<Utility> informationGain(int feature, double[] thresholds, Tuple2<Counter<Object>, Counter<Object>>[] contingencyTables, Set<Tuple2<Object, Object>> activeNodes, double currentEntropy) {
        ObjectRef bestThreshold = ObjectRef.create((Object)None$.MODULE$);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(thresholds)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)t -> {
            block0: {
                Option<Utility> ig;
                double threshold = thresholds[t];
                Tuple2 contingencyTable = contingencyTables[t];
                if (activeNodes.contains((Object)new Tuple2.mcID.sp(feature, threshold)) || !(ig = this.informationGainForThreshold(feature, threshold, (Tuple2<Counter<Object>, Counter<Object>>)contingencyTable, currentEntropy)).isDefined() || !((Option)bestThreshold$1.elem).isEmpty() && !(((Utility)((Option)bestThreshold$1.elem).get()).value() < ((Utility)ig.get()).value())) break block0;
                bestThreshold$1.elem = ig;
            }
        });
        return (Option)bestThreshold.elem;
    }

    public Option<Utility> informationGainForThreshold(int feature, double threshold, Tuple2<Counter<Object>, Counter<Object>> contingencyTable, double currentEntropy) {
        double rightEntropy;
        Counter leftCounter = (Counter)contingencyTable._1();
        Counter rightCounter = (Counter)contingencyTable._2();
        if (leftCounter.getTotal() == 0.0 || rightCounter.getTotal() == 0.0) {
            return None$.MODULE$;
        }
        double leftWeight = leftCounter.getTotal() / (leftCounter.getTotal() + rightCounter.getTotal());
        double rightWeight = rightCounter.getTotal() / (leftCounter.getTotal() + rightCounter.getTotal());
        double leftEntropy = RFClassifier$.MODULE$.entropy(leftCounter);
        double value = currentEntropy - leftWeight * leftEntropy - rightWeight * (rightEntropy = RFClassifier$.MODULE$.entropy(rightCounter));
        if (value < this.utilityTooSmallThreshold) {
            return None$.MODULE$;
        }
        return new Some((Object)new Utility(feature, threshold, value, currentEntropy, leftEntropy, rightEntropy, leftCounter, rightCounter));
    }

    public int[] randomFeatureSelection(Set<Object> presentFeatures, int numFeats, Random random) {
        int featCount = package$.MODULE$.min(this.howManyFeaturesPerNode.apply$mcII$sp(numFeats), presentFeatures.size());
        int[] randomizedFeats = (int[])MathUtils$.MODULE$.randomize(presentFeatures.toArray(ClassTag$.MODULE$.Int()), random);
        ObjectRef feats = ObjectRef.create((Object)new ArrayBuffer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), featCount).foreach((Function1 & Serializable & scala.Serializable)i -> RFClassifier.$anonfun$randomFeatureSelection$1(randomizedFeats, feats, BoxesRunTime.unboxToInt((Object)i)));
        return (int[])((ArrayBuffer)feats.elem).toArray(ClassTag$.MODULE$.Int());
    }

    public boolean sameLabels(RFJob<L, F> job) {
        boolean bl;
        Object object = new Object();
        try {
            HashSet ls = new HashSet();
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(job.trainIndices())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                ls.$plus$eq(job.dataset().labels().apply(i));
                if (ls.size() > 1) {
                    throw new NonLocalReturnControl.mcZ.sp(object, false);
                }
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public RFJob<L, F> mkBag(CounterDataset<L, F> dataset, int[] indices, double[][] thresholds, int trainIndicesLength, double entropy, Random random, int offset) {
        ArrayBuffer bagIndices = new ArrayBuffer();
        ArrayBuffer oobIndices = new ArrayBuffer();
        if (trainIndicesLength == indices.length) {
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).foreach((Function1 & Serializable & scala.Serializable)i -> bagIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))));
        } else {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), trainIndicesLength).foreach((Function1 & Serializable & scala.Serializable)i -> bagIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)indices[random.nextInt(indices.length)])));
            Set uniqueBagIndices = bagIndices.toSet();
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).indices().foreach((Function1 & Serializable & scala.Serializable)i -> RFClassifier.$anonfun$mkBag$3(indices, oobIndices, uniqueBagIndices, BoxesRunTime.unboxToInt((Object)i)));
        }
        return new RFJob<L, F>(dataset, (int[])bagIndices.toArray(ClassTag$.MODULE$.Int()), (int[])oobIndices.toArray(ClassTag$.MODULE$.Int()), (Set<Tuple2<Object, Object>>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), this.nilLabel, thresholds, entropy, new Random(RFClassifier$.MODULE$.RANDOM_SEED() + offset));
    }

    public RFJob<L, F> mkLeftJob(RFJob<L, F> job, int feature, double threshold, double entropy, Set<Tuple2<Object, Object>> activeNodes) {
        ArrayBuffer newIndices = new ArrayBuffer();
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(job.trainIndices())).foreach((Function1 & Serializable & scala.Serializable)i -> RFClassifier.$anonfun$mkLeftJob$1(job, feature, threshold, newIndices, BoxesRunTime.unboxToInt((Object)i)));
        return new RFJob<L, F>(job.dataset(), (int[])newIndices.toArray(ClassTag$.MODULE$.Int()), job.oobIndices(), activeNodes, job.nilLabel(), job.featureThresholds(), entropy, job.random());
    }

    public RFJob<L, F> mkRightJob(RFJob<L, F> job, int feature, double threshold, double entropy, Set<Tuple2<Object, Object>> activeNodes) {
        ArrayBuffer newIndices = new ArrayBuffer();
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(job.trainIndices())).foreach((Function1 & Serializable & scala.Serializable)i -> RFClassifier.$anonfun$mkRightJob$1(job, feature, threshold, newIndices, BoxesRunTime.unboxToInt((Object)i)));
        return new RFJob<L, F>(job.dataset(), (int[])newIndices.toArray(ClassTag$.MODULE$.Int()), job.oobIndices(), activeNodes, job.nilLabel(), job.featureThresholds(), entropy, job.random());
    }

    @Override
    public Counter<L> scoresOf(Datum<L, F> d) {
        Counter prettyLabels;
        block2: {
            Counter fs = d.featuresCounter();
            Counter ifs = new Counter();
            fs.keySet().foreach((Function1 & Serializable & scala.Serializable)f -> ((Lexicon)this.featureLexicon().get()).contains(f) ? BoxesRunTime.boxToDouble((double)ifs.incrementCount(((Lexicon)this.featureLexicon().get()).get(f).get(), fs.getCount(f))) : BoxedUnit.UNIT);
            if (this.verbose()) {
                RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classifying datum: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ifs})));
            }
            Counter labels = new Counter();
            IntRef treeIndex = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.trees().get())).foreach((Function1 & Serializable & scala.Serializable)tree -> {
                RFClassifier.$anonfun$scoresOf$2(this, ifs, labels, treeIndex, tree);
                return BoxedUnit.UNIT;
            });
            if (this.verbose()) {
                RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Overall label distribution: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{labels})));
            }
            prettyLabels = new Counter();
            labels.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)l -> prettyLabels.setCount(((Lexicon)this.labelLexicon().get()).get(l), labels.proportion(BoxesRunTime.boxToInteger((int)l))));
            if (!this.verbose()) break block2;
            RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pretty labels: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prettyLabels})));
        }
        return prettyLabels;
    }

    @Override
    public L classOf(Datum<L, F> d) {
        Counter<L> scores = this.scoresOf(d);
        return (L)((Tuple2)scores.sorted().head())._1();
    }

    @Override
    public void saveTo(Writer writer) {
        throw new RuntimeException("ERROR: saveTo not supported yet!");
    }

    public static final /* synthetic */ void $anonfun$train$5(RFClassifier $this, RFTree tree) {
        RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tree:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tree.toPrettyString(0, (Lexicon)$this.featureLexicon().get(), (Lexicon)$this.labelLexicon().get())})));
    }

    public static final /* synthetic */ Object $anonfun$computeFeatureThresholds$3(Counter[] featureValues$1, Counter c$1, int f) {
        Object object;
        double v = c$1.getCount(BoxesRunTime.boxToInteger((int)f));
        if (v != 0.0) {
            Counter qual$1 = featureValues$1[f];
            double x$2 = c$1.getCount(BoxesRunTime.boxToInteger((int)f));
            double x$3 = qual$1.incrementCount$default$2();
            object = BoxesRunTime.boxToDouble((double)qual$1.incrementCount(BoxesRunTime.boxToDouble((double)x$2), x$3));
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$quantiles$1(ArrayBuffer sorted$1, Tuple2 su) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)su._2$mcD$sp()).foreach((Function1 & Serializable & scala.Serializable)i -> sorted$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)su._1$mcD$sp())));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$randomFeatureSelection$1(int[] randomizedFeats$1, ObjectRef feats$1, int i) {
        return ((ArrayBuffer)feats$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)randomizedFeats$1[i]));
    }

    public static final /* synthetic */ Object $anonfun$mkBag$3(int[] indices$2, ArrayBuffer oobIndices$1, Set uniqueBagIndices$1, int i) {
        return !uniqueBagIndices$1.contains((Object)BoxesRunTime.boxToInteger((int)indices$2[i])) ? oobIndices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)indices$2[i])) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$mkLeftJob$1(RFJob job$4, int feature$1, double threshold$1, ArrayBuffer newIndices$1, int i) {
        return job$4.dataset().featuresCounter(i).getCount(BoxesRunTime.boxToInteger((int)feature$1)) <= threshold$1 ? newIndices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$mkRightJob$1(RFJob job$5, int feature$2, double threshold$2, ArrayBuffer newIndices$2, int i) {
        return job$5.dataset().featuresCounter(i).getCount(BoxesRunTime.boxToInteger((int)feature$2)) > threshold$2 ? newIndices$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$scoresOf$2(RFClassifier $this, Counter ifs$1, Counter labels$2, IntRef treeIndex$1, RFTree tree) {
        Counter<Object> labelDist = tree.apply(ifs$1);
        labels$2.$plus$eq(labelDist.$times(tree.weight()));
        if ($this.verbose()) {
            RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Label distribution from tree #", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)treeIndex$1.elem), labelDist})));
            RFClassifier$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tree:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tree})));
        }
        ++treeIndex$1.elem;
    }

    public RFClassifier(int numTrees, int maxTreeDepth, double trainBagPct, double utilityTooSmallThreshold, double splitTooSmallPct, int numThreads, Function1<Object, Object> howManyFeaturesPerNode, Option<L> nilLabel) {
        this.numTrees = numTrees;
        this.maxTreeDepth = maxTreeDepth;
        this.trainBagPct = trainBagPct;
        this.utilityTooSmallThreshold = utilityTooSmallThreshold;
        this.splitTooSmallPct = splitTooSmallPct;
        this.numThreads = numThreads;
        this.howManyFeaturesPerNode = howManyFeaturesPerNode;
        this.nilLabel = nilLabel;
        Classifier.$init$(this);
        this.trees = None$.MODULE$;
        this.verbose = false;
        this.featureLexicon = None$.MODULE$;
        this.labelLexicon = None$.MODULE$;
        this.treeCount = 0;
    }
}

