/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.learning;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import org.clulab.learning.Datum;
import org.clulab.learning.RankingClassifier;
import org.clulab.learning.RankingDataset;
import org.clulab.learning.SVMRankingClassifier$;
import org.clulab.struct.Counter;
import org.clulab.struct.Counters$;
import org.clulab.struct.Lexicon;
import org.clulab.struct.Lexicon$;
import org.clulab.utils.StringUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u0001\u0003\u0001%\u0011Ac\u0015,N%\u0006t7.\u001b8h\u00072\f7o]5gS\u0016\u0014(BA\u0002\u0005\u0003!aW-\u0019:oS:<'BA\u0003\u0007\u0003\u0019\u0019G.\u001e7bE*\tq!A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u000b/M!\u0001aC\t!!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0019!cE\u000b\u000e\u0003\tI!\u0001\u0006\u0002\u0003#I\u000bgn[5oO\u000ec\u0017m]:jM&,'\u000f\u0005\u0002\u0017/1\u0001A!\u0002\r\u0001\u0005\u0004I\"!\u0001$\u0012\u0005ii\u0002C\u0001\u0007\u001c\u0013\taRBA\u0004O_RD\u0017N\\4\u0011\u00051q\u0012BA\u0010\u000e\u0005\r\te.\u001f\t\u0003\u0019\u0005J!AI\u0007\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\n!b^8sW&tw\rR5s+\u00051\u0003CA\u0014/\u001d\tAC\u0006\u0005\u0002*\u001b5\t!F\u0003\u0002,\u0011\u00051AH]8pizJ!!L\u0007\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[5A\u0001B\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\fo>\u00148.\u001b8h\t&\u0014\b\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u0001&\u0003%iw\u000eZ3m\r&dW\r\u0003\u00057\u0001\t\u0005\t\u0015!\u0003'\u0003)iw\u000eZ3m\r&dW\r\t\u0005\tq\u0001\u0011)\u0019!C\u0001K\u0005IAO]1j]\u001aKG.\u001a\u0005\tu\u0001\u0011\t\u0011)A\u0005M\u0005QAO]1j]\u001aKG.\u001a\u0011\t\u0011q\u0002!Q1A\u0005\u0002\u0015\n\u0011\u0002Z3ck\u001e4\u0015\u000e\\3\t\u0011y\u0002!\u0011!Q\u0001\n\u0019\n!\u0002Z3ck\u001e4\u0015\u000e\\3!\u0011!\u0001\u0005A!b\u0001\n\u0003)\u0013\u0001\u0003;fgR4\u0015\u000e\\3\t\u0011\t\u0003!\u0011!Q\u0001\n\u0019\n\u0011\u0002^3ti\u001aKG.\u001a\u0011\t\u0011\u0011\u0003!Q1A\u0005\u0002\u0015\u000baa\u0019'jO\"$X#\u0001$\u0011\u000519\u0015B\u0001%\u000e\u0005\u0019!u.\u001e2mK\"A!\n\u0001B\u0001B\u0003%a)A\u0004d\u0019&<\u0007\u000e\u001e\u0011\t\u00111\u0003!Q1A\u0005\u00025\u000bQc[3fa&sG/\u001a:nK\u0012L\u0017\r^3GS2,7/F\u0001O!\taq*\u0003\u0002Q\u001b\t9!i\\8mK\u0006t\u0007\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\u0002--,W\r]%oi\u0016\u0014X.\u001a3jCR,g)\u001b7fg\u0002BQ\u0001\u0016\u0001\u0005\u0002U\u000ba\u0001P5oSRtD\u0003\u0003,X1fS6\fX/\u0011\u0007I\u0001Q\u0003C\u0003%'\u0002\u0007a\u0005C\u00045'B\u0005\t\u0019\u0001\u0014\t\u000fa\u001a\u0006\u0013!a\u0001M!9Ah\u0015I\u0001\u0002\u00041\u0003b\u0002!T!\u0003\u0005\rA\n\u0005\b\tN\u0003\n\u00111\u0001G\u0011\u001da5\u000b%AA\u00029CQ\u0001\u0016\u0001\u0005\u0002}#\"A\u00161\t\u000b\u0005t\u0006\u0019\u00012\u0002\u000bA\u0014x\u000e]:\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017\u0001B;uS2T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jI\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f-\u0004\u0001\u0019!C\u0001Y\u0006qa-Z1ukJ,G*\u001a=jG>tW#A7\u0011\u00071q\u0007/\u0003\u0002p\u001b\t1q\n\u001d;j_:\u00042!\u001d;\u0016\u001b\u0005\u0011(BA:\u0005\u0003\u0019\u0019HO];di&\u0011QO\u001d\u0002\b\u0019\u0016D\u0018nY8o\u0011\u001d9\b\u00011A\u0005\u0002a\f!CZ3biV\u0014X\rT3yS\u000e|gn\u0018\u0013fcR\u0011\u0011\u0010 \t\u0003\u0019iL!a_\u0007\u0003\tUs\u0017\u000e\u001e\u0005\b{Z\f\t\u00111\u0001n\u0003\rAH%\r\u0005\u0007\u007f\u0002\u0001\u000b\u0015B7\u0002\u001f\u0019,\u0017\r^;sK2+\u00070[2p]\u0002B\u0011\"a\u0001\u0001\u0001\u0004%\t!!\u0002\u0002\u000f],\u0017n\u001a5ugV\u0011\u0011q\u0001\t\u0005\u00199\fI\u0001\u0005\u0003\r\u0003\u00171\u0015bAA\u0007\u001b\t)\u0011I\u001d:bs\"I\u0011\u0011\u0003\u0001A\u0002\u0013\u0005\u00111C\u0001\fo\u0016Lw\r\u001b;t?\u0012*\u0017\u000fF\u0002z\u0003+A\u0011\"`A\b\u0003\u0003\u0005\r!a\u0002\t\u0011\u0005e\u0001\u0001)Q\u0005\u0003\u000f\t\u0001b^3jO\"$8\u000f\t\u0005\n\u0003;\u0001\u0001\u0019!C\u0001\u0003\u000b\tqb^3jO\"$8o\u0014:jO&t\u0017\r\u001c\u0005\n\u0003C\u0001\u0001\u0019!C\u0001\u0003G\t1c^3jO\"$8o\u0014:jO&t\u0017\r\\0%KF$2!_A\u0013\u0011%i\u0018qDA\u0001\u0002\u0004\t9\u0001\u0003\u0005\u0002*\u0001\u0001\u000b\u0015BA\u0004\u0003A9X-[4iiN|%/[4j]\u0006d\u0007\u0005C\u0005\u0002.\u0001\u0001\r\u0011\"\u0001\u00020\u0005AQM^1m\r&dW-\u0006\u0002\u00022A!AB\\A\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001dM\u0006\u0011\u0011n\\\u0005\u0005\u0003{\t9DA\u0006Qe&tGo\u0016:ji\u0016\u0014\b\"CA!\u0001\u0001\u0007I\u0011AA\"\u00031)g/\u00197GS2,w\fJ3r)\rI\u0018Q\t\u0005\n{\u0006}\u0012\u0011!a\u0001\u0003cA\u0001\"!\u0013\u0001A\u0003&\u0011\u0011G\u0001\nKZ\fGNR5mK\u0002B\u0011\"!\u0014\u0001\u0001\u0004%\t!a\u0014\u0002\u0007ELG-\u0006\u0002\u0002RA\u0019A\"a\u0015\n\u0007\u0005USBA\u0002J]RD\u0011\"!\u0017\u0001\u0001\u0004%\t!a\u0017\u0002\u000fELGm\u0018\u0013fcR\u0019\u00110!\u0018\t\u0013u\f9&!AA\u0002\u0005E\u0003\u0002CA1\u0001\u0001\u0006K!!\u0015\u0002\tELG\r\t\u0005\b\u0003K\u0002A\u0011AA4\u0003\u0015!(/Y5o)\u0015I\u0018\u0011NA:\u0011!\tY'a\u0019A\u0002\u00055\u0014a\u00023bi\u0006\u001cX\r\u001e\t\u0005%\u0005=T#C\u0002\u0002r\t\u0011aBU1oW&tw\rR1uCN,G\u000f\u0003\u0006\u0002v\u0005\r\u0004\u0013!a\u0001\u0003o\nQa\u001d9b]N\u0004B\u0001\u00048\u0002zA1\u00111PAC\u0003\u0017sA!! \u0002\u0002:\u0019\u0011&a \n\u00039I1!a!\u000e\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\"\u0002\n\nA\u0011\n^3sC\ndWMC\u0002\u0002\u00046\u0001r\u0001DAG\u0003#\n\t&C\u0002\u0002\u00106\u0011a\u0001V;qY\u0016\u0014\u0004bBAJ\u0001\u0011\u0005\u0011QS\u0001\u0011iJ\f\u0017N\\,ji\"\u0014\u0015mZ4j]\u001e$r!_AL\u00033\u000bi\n\u0003\u0005\u0002l\u0005E\u0005\u0019AA7\u0011!\tY*!%A\u0002\u0005E\u0013a\u00028v[\n\u000bwm\u001d\u0005\t\u0003?\u000b\t\n1\u0001\u00024\u0005\u0011\u0001o\u001e\u0005\b\u0003G\u0003A\u0011AAS\u00031!\u0017n\u001d9mCflu\u000eZ3m)\rI\u0018q\u0015\u0005\t\u0003?\u000b\t\u000b1\u0001\u00024!9\u00111\u0016\u0001\u0005\u0002\u00055\u0016aC2mSB<V-[4iiN$2!_AX\u0011\u001d\t\t,!+A\u0002\u0019\u000ba\u0001\u001e5sKND\u0007bBA[\u0001\u0011\u0005\u0011qW\u0001 G2L\u0007oV3jO\"$8OU3mCRLg/\u001a+p\u001f:,g)Z1ukJ,G#B=\u0002:\u0006m\u0006bBAY\u0003g\u0003\rA\u0012\u0005\b\u0003{\u000b\u0019\f1\u0001\u0016\u0003\u001d1W-\u0019;ve\u0016Dq!!1\u0001\t\u0003\t\u0019-\u0001\tm_\u0006$Wj\u001c3fY^+\u0017n\u001a5ugR!\u0011\u0011BAc\u0011\u001d\t9-a0A\u0002\u0019\n\u0011\"\\8eK2\u0004\u0016\r\u001e5\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\u0006a1\u000f\u001d7jiN3V\nT5oKR!\u0011qZAi!\u0015a\u0011Q\u0012\u0014'\u0011\u001d\t\u0019.!3A\u0002\u0019\nA\u0001\\5oK\"9\u0011q\u001b\u0001\u0005\n\u0005e\u0017AC7l\rVdGNR8mIR!\u0011\u0011PAn\u0011!\ti.!6A\u0002\u0005E\u0013\u0001B:ju\u0016Dq!!9\u0001\t\u0003\t\u0019/A\u0006nWR\u0013\u0018-\u001b8GS2,G\u0003CA)\u0003K\f9/a;\t\u0011\u0005}\u0015q\u001ca\u0001\u0003gA\u0001\"!;\u0002`\u0002\u0007\u0011QN\u0001\u0002I\"A\u0011QOAp\u0001\u0004\t9\bC\u0004\u0002p\u0002!\t!!=\u0002\u00155\\G+Z:u\r&dW\rF\u0004z\u0003g\f)P!\u0001\t\u0011\u0005}\u0015Q\u001ea\u0001\u0003gA\u0001\"a>\u0002n\u0002\u0007\u0011\u0011`\u0001\u0003IN\u0004b!a\u001f\u0002\u0006\u0006m\bC\u0002\n\u0002~\u0006ES#C\u0002\u0002\u0000\n\u0011Q\u0001R1uk6D\u0001\"!\u0014\u0002n\u0002\u0007\u0011\u0011\u000b\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u00035i7\u000eR1uk64Vm\u0019;peR!!\u0011\u0002B\b!\u0015\t(1BA)\u0013\r\u0011iA\u001d\u0002\b\u0007>,h\u000e^3s\u0011!\u0011\tBa\u0001A\u0002\u0005m\u0018!\u00023biVl\u0007b\u0002B\u000b\u0001\u0011\u0005!qC\u0001\r_B,g.\u0012<bY\u001aKG.\u001a\u000b\u0002s\"9!1\u0004\u0001\u0005\u0002\t]\u0011!D2m_N,WI^1m\r&dW\rC\u0004\u0003 \u0001!\tA!\t\u0002\rM,G/U5e)\rI(1\u0005\u0005\t\u0003\u001b\u0012i\u00021\u0001\u0002R!9!q\u0005\u0001\u0005\u0002\t%\u0012\u0001C:d_J,7o\u00144\u0015\t\t-\"Q\u0006\t\u0006\u0003w\n)I\u0012\u0005\t\u0005_\u0011)\u00031\u0001\u0002z\u0006Y\u0011/^3ss\u0012\u000bG/^7t\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005k\taa]1wKR{GcA=\u00038!9!\u0011\bB\u0019\u0001\u00041\u0013\u0001\u00034jY\u0016t\u0015-\\3\t\u000f\tu\u0002\u0001\"\u0001\u0003\u0018\u0005)A-\u001a2vO\"I!\u0011\t\u0001\u0012\u0002\u0013\u0005#1I\u0001\u0010iJ\f\u0017N\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\t\u0016\u0005\u0003o\u00129e\u000b\u0002\u0003JA!!1\nB+\u001b\t\u0011iE\u0003\u0003\u0003P\tE\u0013!C;oG\",7m[3e\u0015\r\u0011\u0019&D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B,\u0005\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f\u001d\u0011YF\u0001E\u0001\u0005;\nAc\u0015,N%\u0006t7.\u001b8h\u00072\f7o]5gS\u0016\u0014\bc\u0001\n\u0003`\u00191\u0011A\u0001E\u0001\u0005C\u001aBAa\u0018\fA!9AKa\u0018\u0005\u0002\t\u0015DC\u0001B/\u0011)\u0011IGa\u0018C\u0002\u0013\u0005!1N\u0001\u0007Y><w-\u001a:\u0016\u0005\t5\u0004\u0003\u0002B8\u0005kj!A!\u001d\u000b\u0007\tMd!A\u0003tY\u001a$$.\u0003\u0003\u0003x\tE$A\u0002'pO\u001e,'\u000fC\u0005\u0003|\t}\u0003\u0015!\u0003\u0003n\u00059An\\4hKJ\u0004\u0003\u0002\u0003B@\u0005?\"\tA!!\u0002\u00111|\u0017\r\u001a$s_6,BAa!\u0003\nR!!Q\u0011BF!\u0011\u0011\u0002Aa\"\u0011\u0007Y\u0011I\t\u0002\u0004\u0019\u0005{\u0012\r!\u0007\u0005\b\u0005s\u0011i\b1\u0001'\u0011)\u0011yIa\u0018\u0012\u0002\u0013\u0005!\u0011S\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\tM%qS\u000b\u0003\u0005+S3A\nB$\t\u0019A\"Q\u0012b\u00013!Q!1\u0014B0#\u0003%\tA!(\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011\u0019Ja(\u0005\ra\u0011IJ1\u0001\u001a\u0011)\u0011\u0019Ka\u0018\u0012\u0002\u0013\u0005!QU\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\t\tM%q\u0015\u0003\u00071\t\u0005&\u0019A\r\t\u0015\t-&qLI\u0001\n\u0003\u0011i+A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0005\u0005'\u0013y\u000b\u0002\u0004\u0019\u0005S\u0013\r!\u0007\u0005\u000b\u0005g\u0013y&%A\u0005\u0002\tU\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0003\u00038\nmVC\u0001B]U\r1%q\t\u0003\u00071\tE&\u0019A\r\t\u0015\t}&qLI\u0001\n\u0003\u0011\t-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeN\u000b\u0005\u0005\u0007\u00149-\u0006\u0002\u0003F*\u001aaJa\u0012\u0005\ra\u0011iL1\u0001\u001a\u0011)\u0011YMa\u0018\u0002\u0002\u0013%!QZ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003PB!!\u0011\u001bBl\u001b\t\u0011\u0019NC\u0002\u0003V\u001a\fA\u0001\\1oO&!!\u0011\u001cBj\u0005\u0019y%M[3di\u0002")
public class SVMRankingClassifier<F>
implements RankingClassifier<F>,
scala.Serializable {
    private final String workingDir;
    private final String modelFile;
    private final String trainFile;
    private final String debugFile;
    private final String testFile;
    private final double cLight;
    private final boolean keepIntermediateFiles;
    private Option<Lexicon<F>> featureLexicon;
    private Option<double[]> weights;
    private Option<double[]> weightsOriginal;
    private Option<PrintWriter> evalFile;
    private int qid;

    public static <F> boolean $lessinit$greater$default$7() {
        return SVMRankingClassifier$.MODULE$.$lessinit$greater$default$7();
    }

    public static <F> double $lessinit$greater$default$6() {
        return SVMRankingClassifier$.MODULE$.$lessinit$greater$default$6();
    }

    public static <F> String $lessinit$greater$default$5() {
        return SVMRankingClassifier$.MODULE$.$lessinit$greater$default$5();
    }

    public static <F> String $lessinit$greater$default$4() {
        return SVMRankingClassifier$.MODULE$.$lessinit$greater$default$4();
    }

    public static <F> String $lessinit$greater$default$3() {
        return SVMRankingClassifier$.MODULE$.$lessinit$greater$default$3();
    }

    public static <F> String $lessinit$greater$default$2() {
        return SVMRankingClassifier$.MODULE$.$lessinit$greater$default$2();
    }

    public static <F> SVMRankingClassifier<F> loadFrom(String string) {
        return SVMRankingClassifier$.MODULE$.loadFrom(string);
    }

    public static Logger logger() {
        return SVMRankingClassifier$.MODULE$.logger();
    }

    @Override
    public Iterable<Object> probabilitiesOf(Iterable<Datum<Object, F>> queryDatums, double gamma) {
        return RankingClassifier.probabilitiesOf$(this, queryDatums, gamma);
    }

    @Override
    public double probabilitiesOf$default$2() {
        return RankingClassifier.probabilitiesOf$default$2$(this);
    }

    public String workingDir() {
        return this.workingDir;
    }

    public String modelFile() {
        return this.modelFile;
    }

    public String trainFile() {
        return this.trainFile;
    }

    public String debugFile() {
        return this.debugFile;
    }

    public String testFile() {
        return this.testFile;
    }

    public double cLight() {
        return this.cLight;
    }

    public boolean keepIntermediateFiles() {
        return this.keepIntermediateFiles;
    }

    public Option<Lexicon<F>> featureLexicon() {
        return this.featureLexicon;
    }

    public void featureLexicon_$eq(Option<Lexicon<F>> x$1) {
        this.featureLexicon = x$1;
    }

    public Option<double[]> weights() {
        return this.weights;
    }

    public void weights_$eq(Option<double[]> x$1) {
        this.weights = x$1;
    }

    public Option<double[]> weightsOriginal() {
        return this.weightsOriginal;
    }

    public void weightsOriginal_$eq(Option<double[]> x$1) {
        this.weightsOriginal = x$1;
    }

    public Option<PrintWriter> evalFile() {
        return this.evalFile;
    }

    public void evalFile_$eq(Option<PrintWriter> x$1) {
        this.evalFile = x$1;
    }

    public int qid() {
        return this.qid;
    }

    public void qid_$eq(int x$1) {
        this.qid = x$1;
    }

    @Override
    public void train(RankingDataset<F> dataset, Option<Iterable<Tuple2<Object, Object>>> spans) {
        String trainPath = this.workingDir() + File.separator + this.trainFile();
        PrintWriter trainWriter = new PrintWriter(trainPath);
        int n = this.mkTrainFile(trainWriter, dataset, spans);
        trainWriter.close();
        SVMRankingClassifier$.MODULE$.logger().debug("Created training file: " + trainPath);
        double cRank = this.cLight() * (double)n;
        String modelPath = this.workingDir() + File.separator + this.modelFile();
        String cmd = "svm_rank_learn -c " + cRank + " " + "-# 2000 " + "-e 0.001 " + trainPath + " " + modelPath;
        SVMRankingClassifier$.MODULE$.logger().debug("Running TRAIN command: " + cmd);
        int exitCode = scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang();
        SVMRankingClassifier$.MODULE$.logger().debug("svm_rank_learn terminated with exit code " + exitCode);
        if (exitCode != 0) {
            throw new RuntimeException("ERROR: svm_rank_learn terminated with exit code " + exitCode + "!");
        }
        this.featureLexicon_$eq((Option<Lexicon<F>>)new Some(Lexicon$.MODULE$.apply(dataset.featureLexicon())));
        this.weights_$eq((Option<double[]>)new Some((Object)this.loadModelWeights(modelPath)));
        this.weightsOriginal_$eq((Option<double[]>)new Some((Object)this.loadModelWeights(modelPath)));
        this.debug();
        if (!this.keepIntermediateFiles()) {
            new File(trainPath).delete();
            new File(modelPath).delete();
        } else {
            SVMRankingClassifier$.MODULE$.logger().info("TRAINING file saved as: " + trainPath);
            SVMRankingClassifier$.MODULE$.logger().info("MODEL file saved as: " + modelPath);
        }
    }

    @Override
    public Option<Iterable<Tuple2<Object, Object>>> train$default$2() {
        return None$.MODULE$;
    }

    public void trainWithBagging(RankingDataset<F> dataset, int numBags, PrintWriter pw) {
        double[] avgWeights = (double[])Array$.MODULE$.fill(dataset.numFeatures() + 1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBags).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i2 -> {
            RankingDataset bagDataset = dataset.bootstrapSample(dataset.size());
            this.train(bagDataset, this.train$default$2());
            double[] bagWeights = (double[])this.weights().get();
            Predef$.MODULE$.println((Object)("bagWeights: " + new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(bagWeights)).size()));
            Predef$.MODULE$.println((Object)("avgWeights: " + new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(avgWeights)).size()));
            Predef$.MODULE$.assert(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(bagWeights)).size() == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(avgWeights)).size());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(bagWeights)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                avgWeights$1[i] = avgWeights[i] + bagWeights[i] / (double)numBags;
            });
            pw.println("*****************");
            pw.println("  BAG SAMPLE " + i2);
            pw.println("*****************");
            this.displayModel(pw);
        });
        this.weights_$eq((Option<double[]>)new Some((Object)avgWeights));
        pw.println("*****************");
        pw.println("    AVERAGED ");
        pw.println("*****************");
        this.displayModel(pw);
    }

    @Override
    public void displayModel(PrintWriter pw) {
        double[] weightSet = (double[])this.weights().get();
        Lexicon lexicon = (Lexicon)this.featureLexicon().get();
        pw.println("SVM Weights: ");
        Predef$.MODULE$.println((Object)("weights.size: " + new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightSet)).size()));
        Predef$.MODULE$.println((Object)("featureLexicon.size " + lexicon.size()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightSet)).size() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            Object featureName = lexicon.get(j);
            Predef$.MODULE$.println((Object)("weight: " + Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)weightSet[j])), "%3.5f") + " \t feature: " + featureName + "  (idx:" + j + ")"));
            pw.println("weight: " + Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)weightSet[j])), "%3.5f") + " \t feature: " + featureName + "  (idx:" + j + ")");
        });
        pw.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - ");
        pw.println("");
        pw.flush();
    }

    public void clipWeights(double thresh) {
        double[] weightsOrig = (double[])this.weightsOriginal().get();
        double[] weightsClipped = new double[new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightsOrig)).size()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightsOrig)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            double median = weightsOrig[j];
            weightsClipped$1[j] = package$.MODULE$.abs(median) >= thresh ? median : 0.0;
        });
        this.weights_$eq((Option<double[]>)new Some((Object)weightsClipped));
    }

    public void clipWeightsRelativeToOneFeature(double thresh, F feature) {
        double[] weightsOrig = (double[])this.weightsOriginal().get();
        double[] weightsClipped = new double[new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightsOrig)).size()];
        DoubleRef irWeight = DoubleRef.create((double)1.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightsOrig)).size() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (!BoxesRunTime.equals(((Lexicon)this.featureLexicon().get()).get(i), (Object)feature)) break block0;
                irWeight$1.elem = weightsOrig[i];
            }
        });
        SVMRankingClassifier$.MODULE$.logger().debug("Reference weight: " + irWeight.elem);
        double newThresh = thresh * irWeight.elem;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightsOrig)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            double median = weightsOrig[j];
            weightsClipped$2[j] = package$.MODULE$.abs(median) >= newThresh ? median : 0.0;
        });
        this.weights_$eq((Option<double[]>)new Some((Object)weightsClipped));
    }

    public double[] loadModelWeights(String modelPath) {
        ObjectRef modelLine = ObjectRef.create((Object)None$.MODULE$);
        IntRef numFeats = IntRef.create((int)0);
        Source$.MODULE$.fromFile(modelPath, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            SVMRankingClassifier.$anonfun$loadModelWeights$1(this, modelLine, numFeats, line);
            return BoxedUnit.UNIT;
        });
        if (numFeats.elem == 0) {
            throw new RuntimeException("ERROR: cannot find the number of features!");
        }
        Option option = (Option)modelLine.elem;
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals(none$) : none$ != null)) {
            throw new RuntimeException("ERROR: cannot find model weights!");
        }
        String[] bits = ((String)((Option)modelLine.elem).get()).split("\\s+");
        if (new StringOps(Predef$.MODULE$.augmentString(bits[0])).toInt() != 1) {
            throw new RuntimeException("ERROR: first value in weight line must be 1!");
        }
        double[] weights = new double[numFeats.elem];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), weights.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            weights$1[i] = 0.0;
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), bits.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String[] feat = bits[i].split(":");
            weights$1[new StringOps((String)Predef$.MODULE$.augmentString((String)feat[0])).toInt() - 1] = new StringOps(Predef$.MODULE$.augmentString(feat[1])).toDouble();
        });
        return weights;
    }

    private Tuple2<String, String> splitSVMLine(String line) {
        int pound = line.indexOf("#");
        if (pound < 0) {
            return new Tuple2((Object)line, (Object)"");
        }
        return new Tuple2((Object)line.substring(0, pound).trim(), (Object)line.substring(pound + 1).trim());
    }

    private Iterable<Tuple2<Object, Object>> mkFullFold(int size) {
        Tuple2[] folds = new Tuple2[]{new Tuple2.mcII.sp(0, size)};
        return Predef$.MODULE$.wrapRefArray((Object[])folds);
    }

    public int mkTrainFile(PrintWriter pw, RankingDataset<F> d, Option<Iterable<Tuple2<Object, Object>>> spans) {
        IntRef n = IntRef.create((int)0);
        Iterable trainFolds = (Iterable)spans.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.mkFullFold(d.size()));
        trainFolds.foreach((Function1 & Serializable & scala.Serializable)fold -> {
            SVMRankingClassifier.$anonfun$mkTrainFile$2(pw, d, n, fold);
            return BoxedUnit.UNIT;
        });
        return n.elem;
    }

    public void mkTestFile(PrintWriter pw, Iterable<Datum<Object, F>> ds, int qid) {
        ds.foreach((Function1 & Serializable & scala.Serializable)d -> {
            SVMRankingClassifier.$anonfun$mkTestFile$1(this, pw, qid, d);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Counter<Object> mkDatumVector(Datum<Object, F> datum) {
        void var2_2;
        Counter c = new Counter();
        Counter fc = datum.featuresCounter();
        fc.keySet().foreach((Function1 & Serializable & scala.Serializable)f -> {
            SVMRankingClassifier.$anonfun$mkDatumVector$1(this, c, fc, f);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public void openEvalFile() {
        String string = this.testFile();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new RuntimeException("ERROR: testFile unspecified!");
        }
        this.evalFile_$eq((Option<PrintWriter>)new Some((Object)new PrintWriter(this.testFile())));
    }

    public void closeEvalFile() {
        this.evalFile().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        SVMRankingClassifier$.MODULE$.logger().info("TESTING file saved as: " + this.testFile());
    }

    public void setQid(int qid) {
        this.qid_$eq(qid);
    }

    @Override
    public Iterable<Object> scoresOf(Iterable<Datum<Object, F>> queryDatums) {
        if (!this.evalFile().isEmpty()) {
            this.mkTestFile((PrintWriter)this.evalFile().get(), queryDatums, this.qid());
        }
        if (this.weights().isEmpty()) {
            throw new RuntimeException("ERROR: cannot call scoresOf without model weights!");
        }
        if (this.featureLexicon().isEmpty()) {
            throw new RuntimeException("ERROR: cannot call scoresOf without a feature lexicon!");
        }
        ArrayBuffer scores = new ArrayBuffer();
        queryDatums.foreach((Function1 & Serializable & scala.Serializable)datum -> {
            Counter<Object> datumVector = this.mkDatumVector((Datum)datum);
            double score = Counters$.MODULE$.dotProduct((double[])this.weights().get(), datumVector);
            return scores.$plus$eq((Object)BoxesRunTime.boxToDouble((double)score));
        });
        return Predef$.MODULE$.wrapDoubleArray((double[])scores.toArray(ClassTag$.MODULE$.Double()));
    }

    @Override
    public void saveTo(String fileName) {
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(fileName));
        os.writeObject(this);
        os.close();
    }

    public void debug() {
        if (this.debugFile().length() == 0) {
            return;
        }
        ObjectRef features = ObjectRef.create((Object)new ArrayBuffer());
        PrintWriter pw = new PrintWriter(this.debugFile());
        ((Lexicon)this.featureLexicon().get()).keySet().foreach((Function1 & Serializable & scala.Serializable)f -> {
            SVMRankingClassifier.$anonfun$debug$1(this, features, f);
            return BoxedUnit.UNIT;
        });
        features.elem = (ArrayBuffer)((ArrayBuffer)features.elem).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)SVMRankingClassifier.$anonfun$debug$3(x$3)), (Ordering)Ordering.Double$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((ArrayBuffer)features.elem).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Tuple3 feature = (Tuple3)((ArrayBuffer)features$1.elem).apply(i);
            ObjectRef featureString = ObjectRef.create((Object)((String)feature._1()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20 - new StringOps(Predef$.MODULE$.augmentString((String)featureString.elem)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                featureString$1.elem = (String)featureString$1.elem + " ";
            });
            pw.println((String)featureString.elem + " \t weight: " + feature._3());
        });
        pw.println("");
        pw.println("Weights:");
        BooleanRef first = BooleanRef.create((boolean)true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])this.weights().get())).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block1: {
                if (((double[])this.weights().get())[i] == 0.0) break block1;
                if (!first$1.elem) {
                    pw.print(" ");
                }
                pw.print(i + ":" + ((double[])this.weights().get())[i]);
                first$1.elem = false;
            }
        });
        pw.println();
        pw.close();
    }

    public static final /* synthetic */ void $anonfun$loadModelWeights$1(SVMRankingClassifier $this, ObjectRef modelLine$1, IntRef numFeats$1, String line) {
        Tuple2<String, String> tuple2 = $this.splitSVMLine(line);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String content = (String)tuple2._1();
        String comment = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)content, (Object)comment);
        Tuple2 tuple23 = tuple22;
        String content2 = (String)tuple23._1();
        String comment2 = (String)tuple23._2();
        if (comment2.contains("kernel type") && new StringOps(Predef$.MODULE$.augmentString(content2)).toInt() != 0) {
            throw new RuntimeException("ERROR: only linear kernels are currently supported!");
        }
        if (comment2.contains("highest feature index")) {
            numFeats$1.elem = new StringOps(Predef$.MODULE$.augmentString(content2)).toInt();
        } else {
            if (comment2.contains("number of support vectors plus 1") && new StringOps(Predef$.MODULE$.augmentString(content2)).toInt() != 2) {
                throw new RuntimeException("ERROR: only linear kernels with a single SV are currently supported!");
            }
            if (comment2.contains("threshold b") && new StringOps(Predef$.MODULE$.augmentString(content2)).toInt() != 0) {
                throw new RuntimeException("ERROR: threshold b must be 0!");
            }
            modelLine$1.elem = new Some((Object)content2);
        }
    }

    public static final /* synthetic */ void $anonfun$mkTrainFile$2(PrintWriter pw$1, RankingDataset d$1, IntRef n$1, Tuple2 fold) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(fold._1$mcI$sp()), fold._2$mcI$sp()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int qid = i + 1;
            int[] queryLabels = (int[])d$1.labels().apply(i);
            pw$1.println("# queryOffset " + qid);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), d$1.querySize(i)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                int l = queryLabels[j];
                Counter<Object> fs = d$1.featuresCounter(i, j);
                List fids = (List)fs.keySet().toList().sorted((Ordering)Ordering.Int$.MODULE$);
                pw$1.print(l + " qid:" + qid);
                fids.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fid -> pw$1.print(" " + (fid + 1) + ":" + fs.getCount(BoxesRunTime.boxToInteger((int)fid))));
                pw$1.println();
            });
            ++n$1.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$mkTestFile$1(SVMRankingClassifier $this, PrintWriter pw$4, int qid$2, Datum d) {
        int l = BoxesRunTime.unboxToInt(d.label());
        Counter<Object> fs = $this.mkDatumVector(d);
        List fids = (List)fs.keySet().toList().sorted((Ordering)Ordering.Int$.MODULE$);
        pw$4.print(l + " qid:" + qid$2);
        fids.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fid -> pw$4.print(" " + (fid + 1) + ":" + fs.getCount(BoxesRunTime.boxToInteger((int)fid))));
        pw$4.println();
    }

    public static final /* synthetic */ void $anonfun$mkDatumVector$1(SVMRankingClassifier $this, Counter c$1, Counter fc$1, Object f) {
        block0: {
            Option<Object> idx = ((Lexicon)$this.featureLexicon().get()).get(f);
            if (idx.isEmpty()) break block0;
            c$1.setCount(idx.get(), fc$1.getCount(f));
        }
    }

    public static final /* synthetic */ void $anonfun$debug$1(SVMRankingClassifier $this, ObjectRef features$1, Object f) {
        Option<Object> idx = ((Lexicon)$this.featureLexicon().get()).get(f);
        Option<Object> option = idx;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            int x = BoxesRunTime.unboxToInt((Object)some.value());
            if (x < new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])$this.weights().get())).size()) {
                ((ArrayBuffer)features$1.elem).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)f.toString(), ((Lexicon)$this.featureLexicon().get()).get(f).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1), (Object)BoxesRunTime.boxToDouble((double)((double[])$this.weights().get())[x]))}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ double $anonfun$debug$3(Tuple3 x$3) {
        return -BoxesRunTime.unboxToDouble((Object)x$3._3());
    }

    public SVMRankingClassifier(String workingDir, String modelFile, String trainFile, String debugFile, String testFile, double cLight, boolean keepIntermediateFiles) {
        this.workingDir = workingDir;
        this.modelFile = modelFile;
        this.trainFile = trainFile;
        this.debugFile = debugFile;
        this.testFile = testFile;
        this.cLight = cLight;
        this.keepIntermediateFiles = keepIntermediateFiles;
        RankingClassifier.$init$(this);
        this.featureLexicon = None$.MODULE$;
        this.weights = None$.MODULE$;
        this.weightsOriginal = None$.MODULE$;
        this.evalFile = None$.MODULE$;
        this.qid = 0;
    }

    public SVMRankingClassifier(Properties props) {
        this(props.getProperty("workingDir", "."), props.getProperty("modelFile", "model.dat"), props.getProperty("trainFile", "train.dat"), props.getProperty("debugFile", ""), props.getProperty("testFile", "test.dat"), StringUtils$.MODULE$.getDouble(props, "c", 0.1), StringUtils$.MODULE$.getBool(props, "keepIntermediateFiles", false));
    }
}

