/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.processors.client;

import akka.actor.ActorNotFound;
import akka.actor.ActorPath$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.PoisonPill$;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.pattern.AskableActorRef$;
import akka.routing.Broadcast;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.clulab.processors.Document;
import org.clulab.processors.ProcessorAnnotator;
import org.clulab.processors.client.ProcessorClient$;
import org.clulab.processors.csshare.ProcessorCSController;
import org.clulab.processors.csshare.ProcessorCSMessages;
import org.clulab.processors.csshare.ProcessorCSMessages$;
import org.clulab.serialization.DocumentSerializer;
import scala.collection.Iterable;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-x!B\u0001\u0003\u0011\u0003Y\u0011a\u0004)s_\u000e,7o]8s\u00072LWM\u001c;\u000b\u0005\r!\u0011AB2mS\u0016tGO\u0003\u0002\u0006\r\u0005Q\u0001O]8dKN\u001cxN]:\u000b\u0005\u001dA\u0011AB2mk2\f'MC\u0001\n\u0003\ry'oZ\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005=\u0001&o\\2fgN|'o\u00117jK:$8\u0003B\u0007\u0011-q\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u001d\u00197o\u001d5be\u0016L!a\u0007\r\u0003+A\u0013xnY3tg>\u00148iU\"p]R\u0014x\u000e\u001c7feB\u0011Q\u0004J\u0007\u0002=)\u0011q\u0004I\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003C\t\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002G\u0005\u00191m\\7\n\u0005\u0015r\"a\u0003'bufdunZ4j]\u001eDQaJ\u0007\u0005\u0002!\na\u0001P5oSRtD#A\u0006\t\u0013)j\u0001\u0019!a\u0001\n\u0013Y\u0013\u0001B0qG\u000e,\u0012\u0001\f\t\u0003\u001952AA\u0004\u0002\u0001]M!Q\u0006E\u0018\u001d!\t\u0001\u0014'D\u0001\u0005\u0013\t\u0011DA\u0001\nQe>\u001cWm]:pe\u0006sgn\u001c;bi>\u0014\b\u0002\u0003\u001b.\u0005\u000b\u0007I\u0011A\u001b\u0002\r\r|gNZ5h+\u00051\u0004CA\u001c:\u001b\u0005A$B\u0001\u001b!\u0013\tQ\u0004H\u0001\u0004D_:4\u0017n\u001a\u0005\ty5\u0012\t\u0011)A\u0005m\u000591m\u001c8gS\u001e\u0004\u0003\"B\u0014.\t\u0003qDC\u0001\u0017@\u0011\u0015!T\b1\u00017\u0011\u001d\tUF1A\u0005\n\t\u000b!b]3sS\u0006d\u0017N_3s+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%B\u0001$\u0007\u00035\u0019XM]5bY&T\u0018\r^5p]&\u0011\u0001*\u0012\u0002\u0013\t>\u001cW/\\3oiN+'/[1mSj,'\u000f\u0003\u0004K[\u0001\u0006IaQ\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005C\u0004M[\t\u0007I\u0011B'\u0002\u0017\r|gN\\3diRKW.Z\u000b\u0002\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\tIV\u0014\u0018\r^5p]*\u00111KE\u0001\u000bG>t7-\u001e:sK:$\u0018BA+Q\u000591\u0015N\\5uK\u0012+(/\u0019;j_:DaaV\u0017!\u0002\u0013q\u0015\u0001D2p]:,7\r\u001e+j[\u0016\u0004\u0003bB-.\u0005\u0004%\tAW\u0001\u0007gf\u001cH/Z7\u0016\u0003m\u0003\"\u0001X1\u000e\u0003uS!AX0\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u0001\fA!Y6lC&\u0011!-\u0018\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u0004e[\u0001\u0006IaW\u0001\bgf\u001cH/Z7!\u0011\u001d1WF1A\u0005\u0004\u001d\fq\u0001^5nK>,H/F\u0001i!\tIG.D\u0001k\u0015\tYw,\u0001\u0003vi&d\u0017BA7k\u0005\u001d!\u0016.\\3pkRDaa\\\u0017!\u0002\u0013A\u0017\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\t\u000fEl#\u0019!C\u0001e\u00061!o\\;uKJ,\u0012a\u001d\t\u00039RL!!^/\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDaa^\u0017!\u0002\u0013\u0019\u0018a\u0002:pkR,'\u000f\t\u0005\u0006s6\"IA_\u0001\rO\u0016$(k\\;uKJ\u0014VM\u001a\u000b\u0003gnDQ\u0001\u000e=A\u0002YBQ!`\u0017\u0005\ny\f!bY1mYN+'O^3s)\ry\u00181\u0005\t\u0005\u0003\u0003\tiB\u0004\u0003\u0002\u0004\u0005ea\u0002BA\u0003\u0003/qA!a\u0002\u0002\u00169!\u0011\u0011BA\n\u001d\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005e!\u0011bAA\u000e1\u0005\u0019\u0002K]8dKN\u001cxN]\"T\u001b\u0016\u001c8/Y4fg&!\u0011qDA\u0011\u0005A\u0001&o\\2fgN|'oQ*SKBd\u0017PC\u0002\u0002\u001caAq!!\n}\u0001\u0004\t9#A\u0004sKF,Xm\u001d;\u0011\t\u0005\u0005\u0011\u0011F\u0005\u0005\u0003W\t\tC\u0001\nQe>\u001cWm]:pe\u000e\u001b6i\\7nC:$\u0007bBA\u0018[\u0011\u0005\u0013\u0011G\u0001\tC:tw\u000e^1uKR1\u00111GA\u001d\u0003\u001b\u00022\u0001MA\u001b\u0013\r\t9\u0004\u0002\u0002\t\t>\u001cW/\\3oi\"A\u00111HA\u0017\u0001\u0004\ti$\u0001\u0003uKb$\b\u0003BA \u0003\u000frA!!\u0011\u0002DA\u0019\u00111\u0002\n\n\u0007\u0005\u0015##\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\nYE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000b\u0012\u0002BCA(\u0003[\u0001\n\u00111\u0001\u0002R\u0005A1.Z3q)\u0016DH\u000fE\u0002\u0012\u0003'J1!!\u0016\u0013\u0005\u001d\u0011un\u001c7fC:Dq!!\u0017.\t\u0003\nY&A\u000bb]:|G/\u0019;f\rJ|WnU3oi\u0016t7-Z:\u0015\r\u0005M\u0012QLA:\u0011!\ty&a\u0016A\u0002\u0005\u0005\u0014!C:f]R,gnY3t!\u0019\t\u0019'!\u001c\u0002>9!\u0011QMA5\u001d\u0011\tY!a\u001a\n\u0003MI1!a\u001b\u0013\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001c\u0002r\tA\u0011\n^3sC\ndWMC\u0002\u0002lIA!\"a\u0014\u0002XA\u0005\t\u0019AA)\u0011\u001d\t9(\fC!\u0003s\n!#\u00198o_R\fG/\u001a$s_6$vn[3ogR1\u00111GA>\u0003\u007fB\u0001\"a\u0018\u0002v\u0001\u0007\u0011Q\u0010\t\u0007\u0003G\ni'!\u0019\t\u0015\u0005=\u0013Q\u000fI\u0001\u0002\u0004\t\t\u0006C\u0004\u0002\u00046\"\t%!\"\u0002\u001dA\u0014X\r\u001d:pG\u0016\u001c8\u000fV3yiR!\u0011QHAD\u0011!\tI)!!A\u0002\u0005u\u0012\u0001C8sS\u001e$V\r\u001f;\t\u000f\u00055U\u0006\"\u0011\u0002\u0010\u0006\u0019\u0002O]3qe>\u001cWm]:TK:$XM\\2fgR!\u0011\u0011MAI\u0011!\t\u0019*a#A\u0002\u0005\u0005\u0014!D8sS\u001e\u001cVM\u001c;f]\u000e,7\u000fC\u0004\u0002\u00186\"\t%!'\u0002!A\u0014X\r\u001d:pG\u0016\u001c8\u000fV8lK:\u001cH\u0003BA?\u00037C\u0001\"a%\u0002\u0016\u0002\u0007\u0011Q\u0010\u0005\b\u0003?kC\u0011IAQ\u00039\u0019\b.\u001e;e_^t7\t\\5f]R,\"!a)\u0011\u0007E\t)+C\u0002\u0002(J\u0011A!\u00168ji\"9\u00111V\u0017\u0005B\u0005\u0005\u0016\u0001F:ikR$wn\u001e8DY&,g\u000e^*feZ,'\u000fC\u0004\u000206\"\t%!)\u0002\u001dMDW\u000f\u001e3po:\u001cVM\u001d<fe\"I\u00111W\u0017\u0012\u0002\u0013\u0005\u0013QW\u0001\u0013C:tw\u000e^1uK\u0012\"WMZ1vYR$#'\u0006\u0002\u00028*\"\u0011\u0011KA]W\t\tY\f\u0005\u0003\u0002>\u0006\u001dWBAA`\u0015\u0011\t\t-a1\u0002\u0013Ut7\r[3dW\u0016$'bAAc%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0017q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAg[E\u0005I\u0011IA[\u0003}\tgN\\8uCR,gI]8n'\u0016tG/\u001a8dKN$C-\u001a4bk2$HE\r\u0005\n\u0003#l\u0013\u0013!C!\u0003k\u000bA$\u00198o_R\fG/\u001a$s_6$vn[3og\u0012\"WMZ1vYR$#\u0007C\u0006\u0002V6\u0001\r\u00111A\u0005\n\u0005]\u0017\u0001C0qG\u000e|F%Z9\u0015\t\u0005\r\u0016\u0011\u001c\u0005\n\u00037\f\u0019.!AA\u00021\n1\u0001\u001f\u00132\u0011)\ty.\u0004a\u0001\u0002\u0003\u0006K\u0001L\u0001\u0006?B\u001c7\r\t\u0005\u0007\u0003GlA\u0011A\u0016\u0002\u0011%t7\u000f^1oG\u0016Dq!a(\u000e\t\u0003\n\t\u000bC\u0004\u0002,6!\t%!)\t\u000f\u0005=V\u0002\"\u0011\u0002\"\u0002")
public class ProcessorClient
implements ProcessorAnnotator,
LazyLogging {
    private final Config config;
    private final DocumentSerializer serializer;
    private final FiniteDuration connectTime;
    private final ActorSystem system;
    private final Timeout timeout;
    private final ActorRef router;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static ProcessorClient instance() {
        return ProcessorClient$.MODULE$.instance();
    }

    private Logger logger$lzycompute() {
        ProcessorClient processorClient = this;
        synchronized (processorClient) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Config config() {
        return this.config;
    }

    private DocumentSerializer serializer() {
        return this.serializer;
    }

    private FiniteDuration connectTime() {
        return this.connectTime;
    }

    public ActorSystem system() {
        return this.system;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public ActorRef router() {
        return this.router;
    }

    private ActorRef getRouterRef(Config config) {
        if (!config.hasPath("server.path")) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("(ProcessorClient): Configuration file must define 'server.path'");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.shutdownClient();
            throw new RuntimeException("(ProcessorClient): Configuration file must define 'server.path'");
        }
        String serverPath = config.getString("server.path");
        try {
            Future fut = this.system().actorSelection(ActorPath$.MODULE$.fromString(serverPath)).resolveOne(this.connectTime());
            ActorRef ref = (ActorRef)Await$.MODULE$.result((Awaitable)fut, (Duration)this.connectTime());
            return ref;
        }
        catch (ActorNotFound anf) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("(ProcessorClient): Unable to find or connect to the Server.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.shutdownClient();
            throw new RuntimeException("(ProcessorClient): Unable to find or connect to the Server.");
        }
    }

    private ProcessorCSMessages.ProcessorCSReply callServer(ProcessorCSMessages.ProcessorCSCommand request) {
        ActorRef x$3;
        Timeout x$2;
        ProcessorCSMessages.ProcessorCSCommand x$1;
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.router());
        Future response = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)(x$1 = request), x$2 = this.timeout(), x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1));
        Object result = Await$.MODULE$.result((Awaitable)response, (Duration)Duration$.MODULE$.Inf());
        if (result instanceof ProcessorCSMessages.ServerExceptionMsg) {
            BoxedUnit boxedUnit;
            Exception exception = ((ProcessorCSMessages.ServerExceptionMsg)result).exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(exception.getMessage());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.shutdownClient();
            throw new RuntimeException(exception);
        }
        return (ProcessorCSMessages.ProcessorCSReply)result;
    }

    @Override
    public Document annotate(String text, boolean keepText) {
        ProcessorCSMessages.ProcessorCSReply reply = this.callServer(new ProcessorCSMessages.AnnotateTextCmd(text, keepText));
        return this.serializer().load(((ProcessorCSMessages.TextMsg)reply).text(), ProcessorCSMessages$.MODULE$.SERIALIZER_ENCODING());
    }

    @Override
    public boolean annotate$default$2() {
        return false;
    }

    @Override
    public Document annotateFromSentences(Iterable<String> sentences, boolean keepText) {
        ProcessorCSMessages.ProcessorCSReply reply = this.callServer(new ProcessorCSMessages.AnnotateFromSentencesCmd(sentences, keepText));
        return this.serializer().load(((ProcessorCSMessages.TextMsg)reply).text(), ProcessorCSMessages$.MODULE$.SERIALIZER_ENCODING());
    }

    @Override
    public boolean annotateFromSentences$default$2() {
        return false;
    }

    @Override
    public Document annotateFromTokens(Iterable<Iterable<String>> sentences, boolean keepText) {
        ProcessorCSMessages.ProcessorCSReply reply = this.callServer(new ProcessorCSMessages.AnnotateFromTokensCmd(sentences, keepText));
        return this.serializer().load(((ProcessorCSMessages.TextMsg)reply).text(), ProcessorCSMessages$.MODULE$.SERIALIZER_ENCODING());
    }

    @Override
    public boolean annotateFromTokens$default$2() {
        return false;
    }

    @Override
    public String preprocessText(String origText) {
        ProcessorCSMessages.ProcessorCSReply reply = this.callServer(new ProcessorCSMessages.PreprocessTextCmd(origText));
        return ((ProcessorCSMessages.TextMsg)reply).text();
    }

    @Override
    public Iterable<String> preprocessSentences(Iterable<String> origSentences) {
        ProcessorCSMessages.ProcessorCSReply reply = this.callServer(new ProcessorCSMessages.PreprocessSentencesCmd(origSentences));
        return ((ProcessorCSMessages.SentencesMsg)reply).sentences();
    }

    @Override
    public Iterable<Iterable<String>> preprocessTokens(Iterable<Iterable<String>> origSentences) {
        ProcessorCSMessages.ProcessorCSReply reply = this.callServer(new ProcessorCSMessages.PreprocessTokensCmd(origSentences));
        return ((ProcessorCSMessages.TokensMsg)reply).tokens();
    }

    @Override
    public void shutdownClient() {
        this.system().terminate();
    }

    @Override
    public void shutdownClientServer() {
        this.shutdownServer();
        this.shutdownClient();
    }

    @Override
    public void shutdownServer() {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.router());
        Broadcast x$4 = new Broadcast((Object)PoisonPill$.MODULE$);
        ActorRef x$5 = qual$2.$bang$default$2((Object)x$4);
        qual$2.$bang((Object)x$4, x$5);
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.router());
        PoisonPill$ x$6 = PoisonPill$.MODULE$;
        ActorRef x$7 = qual$3.$bang$default$2((Object)x$6);
        qual$3.$bang((Object)x$6, x$7);
    }

    public ProcessorClient(Config config) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        this.config = config;
        ProcessorCSController.$init$(this);
        ProcessorAnnotator.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.serializer = new DocumentSerializer();
        this.connectTime = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("(ProcessorClient): config={}", new Object[]{config});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.system = ActorSystem$.MODULE$.apply("procClient", config);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("(ProcessorClient): system={}", new Object[]{this.system()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(8)).hours());
        this.router = this.getRouterRef(config);
    }
}

