/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.processors.clu;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.io.StringReader;
import org.clulab.processors.Document;
import org.clulab.processors.Processor;
import org.clulab.processors.Processor$;
import org.clulab.processors.ProcessorAnnotator;
import org.clulab.processors.Sentence;
import org.clulab.processors.clu.CluProcessor$;
import org.clulab.processors.clu.SentencePostProcessor;
import org.clulab.processors.clu.TokenizerPostProcessor;
import org.clulab.processors.clu.TokenizerPreProcessor;
import org.clulab.processors.clu.bio.BioLexicalVariations;
import org.clulab.processors.clu.bio.BioLexiconEntityValidator;
import org.clulab.processors.clu.bio.BioNERPostProcessor;
import org.clulab.processors.clu.bio.BioPOSPostProcessor;
import org.clulab.processors.clu.bio.BioTokenizerPostProcessor;
import org.clulab.processors.clu.bio.BioTokenizerPreProcessor;
import org.clulab.processors.clu.bio.PostProcessorToken;
import org.clulab.processors.clu.sequences.Chunker;
import org.clulab.processors.clu.sequences.Chunker$;
import org.clulab.processors.clu.sequences.NamedEntityRecognizer$;
import org.clulab.processors.clu.sequences.PartOfSpeechTagger;
import org.clulab.processors.clu.sequences.PartOfSpeechTagger$;
import org.clulab.processors.clu.syntax.EnhancedDependencies$;
import org.clulab.processors.clu.syntax.EnsembleMaltParser;
import org.clulab.processors.clu.syntax.EnsembleMaltParser$;
import org.clulab.processors.clu.syntax.Parser;
import org.clulab.processors.clu.tokenizer.OpenDomainEnglishTokenizer;
import org.clulab.processors.clu.tokenizer.Tokenizer;
import org.clulab.processors.csshare.ProcessorCSController;
import org.clulab.sequences.LexiconNER$;
import org.clulab.sequences.Tagger;
import org.clulab.struct.DirectedGraph;
import org.clulab.struct.GraphMap$;
import org.clulab.utils.Configured;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;
import uk.ac.susx.informatics.Morpha;

@ScalaSignature(bytes="\u0006\u0001\t\u0015f\u0001B\u0001\u0003\u0001-\u0011Ab\u00117v!J|7-Z:t_JT!a\u0001\u0003\u0002\u0007\rdWO\u0003\u0002\u0006\r\u0005Q\u0001O]8dKN\u001cxN]:\u000b\u0005\u001dA\u0011AB2mk2\f'MC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001AB\u0005\f\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019B#D\u0001\u0005\u0013\t)BAA\u0005Qe>\u001cWm]:peB\u0011qCG\u0007\u00021)\u0011\u0011DB\u0001\u0006kRLGn]\u0005\u00037a\u0011!bQ8oM&<WO]3e\u0011!i\u0002A!b\u0001\n\u0003q\u0012AB2p]\u001aLw-F\u0001 !\t\u0001c%D\u0001\"\u0015\ti\"E\u0003\u0002$I\u0005AA/\u001f9fg\u00064WMC\u0001&\u0003\r\u0019w.\\\u0005\u0003O\u0005\u0012aaQ8oM&<\u0007\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u000f\r|gNZ5hA!)1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"\"!L\u0018\u0011\u00059\u0002Q\"\u0001\u0002\t\u000fuQ\u0003\u0013!a\u0001?!)\u0011\u0007\u0001C!=\u00059q-\u001a;D_:4\u0007bB\u001a\u0001\u0005\u0004%\t\u0001N\u0001\u000eS:$XM\u001d8TiJLgnZ:\u0016\u0003U\u0002\"!\u0004\u001c\n\u0005]r!a\u0002\"p_2,\u0017M\u001c\u0005\u0007s\u0001\u0001\u000b\u0011B\u001b\u0002\u001d%tG/\u001a:o'R\u0014\u0018N\\4tA!A1\b\u0001EC\u0002\u0013\u0005A(A\u000bu_.,g.\u001b>feB\u0013X\r\u0015:pG\u0016\u001c8o\u001c:\u0016\u0003u\u00022!\u0004 A\u0013\tydB\u0001\u0004PaRLwN\u001c\t\u0003]\u0005K!A\u0011\u0002\u0003+Q{7.\u001a8ju\u0016\u0014\bK]3Qe>\u001cWm]:pe\"AA\t\u0001EC\u0002\u0013\u0005Q)A\u0005u_.,g.\u001b>feV\ta\t\u0005\u0002H\u00136\t\u0001J\u0003\u0002E\u0005%\u0011!\n\u0013\u0002\n)>\\WM\\5{KJD\u0001\u0002\u0014\u0001\t\u0006\u0004%\t!T\u0001\u0017i>\\WM\\5{KJ\u0004vn\u001d;Qe>\u001cWm]:peV\ta\nE\u0002\u000e}=\u0003\"A\f)\n\u0005E\u0013!A\u0006+pW\u0016t\u0017N_3s!>\u001cH\u000f\u0015:pG\u0016\u001c8o\u001c:\t\u0011M\u0003\u0001R1A\u0005\u0002Q\u000b\u0011\u0002]8t)\u0006<w-\u001a:\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001\u0017\u0002\u0002\u0013M,\u0017/^3oG\u0016\u001c\u0018B\u0001.X\u0005I\u0001\u0016M\u001d;PMN\u0003X-Z2i)\u0006<w-\u001a:\t\u0011q\u0003\u0001R1A\u0005\u0002u\u000b\u0001\u0003]8t!>\u001cH\u000f\u0015:pG\u0016\u001c8o\u001c:\u0016\u0003y\u00032!\u0004 `!\tq\u0003-\u0003\u0002b\u0005\t)2+\u001a8uK:\u001cW\rU8tiB\u0013xnY3tg>\u0014\b\u0002C2\u0001\u0011\u000b\u0007I\u0011\u00013\u0002\u00079,'/F\u0001f!\riaH\u001a\t\u0004O&\\W\"\u00015\u000b\u0005a3\u0011B\u00016i\u0005\u0019!\u0016mZ4feB\u0011An\u001d\b\u0003[F\u0004\"A\u001c\b\u000e\u0003=T!\u0001\u001d\u0006\u0002\rq\u0012xn\u001c;?\u0013\t\u0011h\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:\u000f\u0011!9\b\u0001#b\u0001\n\u0003i\u0016\u0001\u00058feB{7\u000f\u001e)s_\u000e,7o]8s\u0011!I\b\u0001#b\u0001\n\u0003Q\u0018aB2ik:\\WM]\u000b\u0002wB\u0011a\u000b`\u0005\u0003{^\u0013qa\u00115v].,'\u000fC\u0004\u0000\u0001\t\u0007I\u0011\u0001\u001b\u00021U\u001cX-\u00168jm\u0016\u00148/\u00197EKB,g\u000eZ3oG&,7\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011B\u001b\u00023U\u001cX-\u00168jm\u0016\u00148/\u00197EKB,g\u000eZ3oG&,7\u000f\t\u0005\u000b\u0003\u000f\u0001\u0001R1A\u0005\u0002\u0005%\u0011!\u00033faB\u000b'o]3s+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tBA\u0001\u0007gftG/\u0019=\n\t\u0005U\u0011q\u0002\u0002\u0007!\u0006\u00148/\u001a:\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c\u0005A\u0011M\u001c8pi\u0006$X\r\u0006\u0003\u0002\u001e\u0005\r\u0002cA\n\u0002 %\u0019\u0011\u0011\u0005\u0003\u0003\u0011\u0011{7-^7f]RD\u0001\"!\n\u0002\u0018\u0001\u0007\u0011QD\u0001\u0004I>\u001c\u0007bBA\u0015\u0001\u0011\u0005\u00131F\u0001\u000faJ,\u0007O]8dKN\u001cH+\u001a=u)\rY\u0017Q\u0006\u0005\b\u0003_\t9\u00031\u0001l\u0003!y'/[4UKb$\bbBA\u001a\u0001\u0011%\u0011QG\u0001\fa>\u001cH\u000f\u0015:pG\u0016\u001c8\u000f\u0006\u0003\u0002\u001e\u0005]\u0002\u0002CA\u001d\u0003c\u0001\r!!\b\u0002\u0011\u0011|7-^7f]RDq!!\u0010\u0001\t\u0013\ty$A\u000bnWB{7\u000f\u001e)s_\u000e,7o]8s)>\\WM\\:\u0015\t\u0005\u0005\u00131\u000b\t\u0006\u001b\u0005\r\u0013qI\u0005\u0004\u0003\u000br!!B!se\u0006L\b\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055#!A\u0002cS>LA!!\u0015\u0002L\t\u0011\u0002k\\:u!J|7-Z:t_J$vn[3o\u0011!\t)&a\u000fA\u0002\u0005]\u0013\u0001C:f]R,gnY3\u0011\u0007M\tI&C\u0002\u0002\\\u0011\u0011\u0001bU3oi\u0016t7-\u001a\u0005\b\u0003?\u0002A\u0011BA1\u0003)i7nU3oi\u0016t7-\u001a\u000b\u0005\u0003/\n\u0019\u0007\u0003\u0005\u0002f\u0005u\u0003\u0019AA!\u0003\u0019!xn[3og\"9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0014AC7l\t>\u001cW/\\3oiR1\u0011QDA7\u0003cBq!a\u001c\u0002h\u0001\u00071.\u0001\u0003uKb$\b\"CA:\u0003O\u0002\n\u00111\u00016\u0003!YW-\u001a9UKb$\bbBA<\u0001\u0011\u0005\u0011\u0011P\u0001\u0018[.$unY;nK:$hI]8n'\u0016tG/\u001a8dKN$\u0002\"!\b\u0002|\u0005E\u00151\u0013\u0005\t\u0003{\n)\b1\u0001\u0002\u0000\u0005I1/\u001a8uK:\u001cWm\u001d\t\u0006\u0003\u0003\u000bYi\u001b\b\u0005\u0003\u0007\u000b9ID\u0002o\u0003\u000bK\u0011aD\u0005\u0004\u0003\u0013s\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\u000byI\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tII\u0004\u0005\n\u0003g\n)\b%AA\u0002UB!\"!&\u0002vA\u0005\t\u0019AAL\u0003i\u0019\u0007.\u0019:bGR,'o\u001d\"fi^,WM\\*f]R,gnY3t!\ri\u0011\u0011T\u0005\u0004\u00037s!aA%oi\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0016\u0001F7l\t>\u001cW/\\3oi\u001a\u0013x.\u001c+pW\u0016t7\u000f\u0006\u0006\u0002\u001e\u0005\r\u0016qUAU\u0003WC\u0001\"! \u0002\u001e\u0002\u0007\u0011Q\u0015\t\u0007\u0003\u0003\u000bY)a \t\u0013\u0005M\u0014Q\u0014I\u0001\u0002\u0004)\u0004BCAK\u0003;\u0003\n\u00111\u0001\u0002\u0018\"Q\u0011QVAO!\u0003\u0005\r!a&\u0002/\rD\u0017M]1di\u0016\u00148OQ3uo\u0016,g\u000eV8lK:\u001c\bbBAY\u0001\u0011%\u00111W\u0001\u0006[.\u001cV\r\u001d\u000b\u0004W\u0006U\u0006\u0002CA\\\u0003_\u0003\r!a&\u0002\tML'0\u001a\u0005\b\u0003w\u0003A\u0011BA_\u0003\tIg\u000eF\u0002l\u0003\u007fCq!!1\u0002:\u0002\u00071.A\u0001t\u0011\u001d\t)\r\u0001C\u0001\u0003\u000f\f\u0001\u0003^1h!\u0006\u0014Ho](g'B,Wm\u00195\u0015\t\u0005%\u0017q\u001a\t\u0004\u001b\u0005-\u0017bAAg\u001d\t!QK\\5u\u0011!\t)#a1A\u0002\u0005u\u0001bBAj\u0001\u0011\u0005\u0011Q[\u0001\u000eY\u0016lW.\u0019;ju\u0016<vN\u001d3\u0015\u0007-\f9\u000eC\u0004\u0002Z\u0006E\u0007\u0019A6\u0002\t]|'\u000f\u001a\u0005\b\u0003;\u0004A\u0011AAp\u0003%aW-\\7bi&TX\r\u0006\u0003\u0002J\u0006\u0005\b\u0002CA\u0013\u00037\u0004\r!!\b\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\u00061\"/Z2pO:L'0\u001a(b[\u0016$WI\u001c;ji&,7\u000f\u0006\u0003\u0002J\u0006%\b\u0002CA\u0013\u0003G\u0004\r!!\b\t\u000f\u00055\b\u0001\"\u0001\u0002p\u0006)\u0001/\u0019:tKR!\u0011\u0011ZAy\u0011!\t)#a;A\u0002\u0005u\u0001bBA{\u0001\u0011\u0005\u0011q_\u0001\tG\",hn[5oOR!\u0011\u0011ZA}\u0011!\t)#a=A\u0002\u0005u\u0001bBA\u007f\u0001\u0011\u0005\u0011q`\u0001\u0013e\u0016\u001cx\u000e\u001c<f\u0007>\u0014XMZ3sK:\u001cW\r\u0006\u0003\u0002J\n\u0005\u0001\u0002CA\u0013\u0003w\u0004\r!!\b\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b\u0005IA-[:d_V\u00148/\u001a\u000b\u0005\u0003\u0013\u0014I\u0001\u0003\u0005\u0002&\t\r\u0001\u0019AA\u000f\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001f\t\u0001CY1tS\u000e\u001c\u0016M\\5us\u000eCWmY6\u0015\t\u0005%'\u0011\u0003\u0005\t\u0003K\u0011Y\u00011\u0001\u0002\u001e!I!Q\u0003\u0001\u0012\u0002\u0013\u0005#qC\u0001\u0015[.$unY;nK:$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\te!fA\u001b\u0003\u001c-\u0012!Q\u0004\t\u0005\u0005?\u0011I#\u0004\u0002\u0003\")!!1\u0005B\u0013\u0003%)hn\u00195fG.,GMC\u0002\u0003(9\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YC!\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00030\u0001\t\n\u0011\"\u0011\u0003\u0018\u0005\tSn\u001b#pGVlWM\u001c;Ge>l7+\u001a8uK:\u001cWm\u001d\u0013eK\u001a\fW\u000f\u001c;%e!I!1\u0007\u0001\u0012\u0002\u0013\u0005#QG\u0001\"[.$unY;nK:$hI]8n'\u0016tG/\u001a8dKN$C-\u001a4bk2$HeM\u000b\u0003\u0005oQC!a&\u0003\u001c!I!1\b\u0001\u0012\u0002\u0013\u0005#qC\u0001\u001f[.$unY;nK:$hI]8n)>\\WM\\:%I\u00164\u0017-\u001e7uIIB\u0011Ba\u0010\u0001#\u0003%\tE!\u000e\u0002=5\\Gi\\2v[\u0016tGO\u0012:p[R{7.\u001a8tI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003B\"\u0001E\u0005I\u0011\tB\u001b\u0003yi7\u000eR8dk6,g\u000e\u001e$s_6$vn[3og\u0012\"WMZ1vYR$CgB\u0004\u0003H\tA\tA!\u0013\u0002\u0019\rcW\u000f\u0015:pG\u0016\u001c8o\u001c:\u0011\u00079\u0012YE\u0002\u0004\u0002\u0005!\u0005!QJ\n\u0004\u0005\u0017b\u0001bB\u0016\u0003L\u0011\u0005!\u0011\u000b\u000b\u0003\u0005\u0013B!B!\u0016\u0003L\t\u0007I\u0011\u0001B,\u0003\u0019awnZ4feV\u0011!\u0011\f\t\u0005\u00057\u0012\t'\u0004\u0002\u0003^)\u0019!q\f\u0005\u0002\u000bMdg\r\u000e6\n\t\t\r$Q\f\u0002\u0007\u0019><w-\u001a:\t\u0013\t\u001d$1\nQ\u0001\n\te\u0013a\u00027pO\u001e,'\u000f\t\u0005\u000b\u0005W\u0012YE1A\u0005\u0002\t5\u0014A\u00029sK\u001aL\u00070F\u0001l\u0011!\u0011\tHa\u0013!\u0002\u0013Y\u0017a\u00029sK\u001aL\u0007\u0010\t\u0005\u000b\u0005k\u0012YE1A\u0005\u0002\t]\u0014A\u0002:f[>4X-\u0006\u0002\u0003zA!!1\u0010BC\u001b\t\u0011iH\u0003\u0003\u0003\u0000\t\u0005\u0015\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\t\re\"\u0001\u0003vi&d\u0017\u0002\u0002BD\u0005{\u0012QAU3hKbD\u0011Ba#\u0003L\u0001\u0006IA!\u001f\u0002\u000fI,Wn\u001c<fA!Q!q\u0012B&\u0005\u0004%\tA!\u001c\u0002\u0017]D\u0017\u000e^3ta\u0006\u001cWm\u001d\u0005\t\u0005'\u0013Y\u0005)A\u0005W\u0006aq\u000f[5uKN\u0004\u0018mY3tA!A!q\u0013B&\t\u0003\u0011I*A\ro_Jl\u0017\r\\5{K\u001a{'\u000fT3n[\u0006$\u0018N_1uS>tGcA6\u0003\u001c\"9\u0011\u0011\u001cBK\u0001\u0004Y\u0007B\u0003BP\u0005\u0017\n\n\u0011\"\u0001\u0003\"\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"Aa)+\u0007}\u0011Y\u0002")
public class CluProcessor
implements Processor,
Configured {
    private Option<TokenizerPreProcessor> tokenizerPreProcessor;
    private Tokenizer tokenizer;
    private Option<TokenizerPostProcessor> tokenizerPostProcessor;
    private PartOfSpeechTagger posTagger;
    private Option<SentencePostProcessor> posPostProcessor;
    private Option<Tagger<String>> ner;
    private Option<SentencePostProcessor> nerPostProcessor;
    private Chunker chunker;
    private Parser depParser;
    private final Config config;
    private final boolean internStrings;
    private final boolean useUniversalDependencies;
    private volatile int bitmap$0;

    public static Config $lessinit$greater$default$1() {
        return CluProcessor$.MODULE$.$lessinit$greater$default$1();
    }

    public static String normalizeForLemmatization(String string) {
        return CluProcessor$.MODULE$.normalizeForLemmatization(string);
    }

    public static String whitespaces() {
        return CluProcessor$.MODULE$.whitespaces();
    }

    public static Regex remove() {
        return CluProcessor$.MODULE$.remove();
    }

    public static String prefix() {
        return CluProcessor$.MODULE$.prefix();
    }

    public static Logger logger() {
        return CluProcessor$.MODULE$.logger();
    }

    @Override
    public boolean getArgBoolean(String argPath, Option<Object> defaultValue) {
        return Configured.getArgBoolean$(this, argPath, defaultValue);
    }

    @Override
    public int getArgInt(String argPath, Option<Object> defaultValue) {
        return Configured.getArgInt$(this, argPath, defaultValue);
    }

    @Override
    public String getArgString(String argPath, Option<String> defaultValue) {
        return Configured.getArgString$(this, argPath, defaultValue);
    }

    @Override
    public Seq<String> getArgStrings(String argPath, Option<Seq<String>> defaultValue) {
        return Configured.getArgStrings$(this, argPath, defaultValue);
    }

    @Override
    public Document annotate(String text, boolean keepText) {
        return Processor.annotate$(this, text, keepText);
    }

    @Override
    public Document annotateFromSentences(Iterable<String> sentences, boolean keepText) {
        return Processor.annotateFromSentences$(this, sentences, keepText);
    }

    @Override
    public Document annotateFromTokens(Iterable<Iterable<String>> sentences, boolean keepText) {
        return Processor.annotateFromTokens$(this, sentences, keepText);
    }

    @Override
    public boolean annotate$default$2() {
        return Processor.annotate$default$2$(this);
    }

    @Override
    public boolean annotateFromSentences$default$2() {
        return Processor.annotateFromSentences$default$2$(this);
    }

    @Override
    public boolean annotateFromTokens$default$2() {
        return Processor.annotateFromTokens$default$2$(this);
    }

    @Override
    public Iterable<String> preprocessSentences(Iterable<String> origSentences) {
        return ProcessorAnnotator.preprocessSentences$(this, origSentences);
    }

    @Override
    public Iterable<Iterable<String>> preprocessTokens(Iterable<Iterable<String>> origSentences) {
        return ProcessorAnnotator.preprocessTokens$(this, origSentences);
    }

    @Override
    public void shutdownClient() {
        ProcessorCSController.shutdownClient$(this);
    }

    @Override
    public void shutdownClientServer() {
        ProcessorCSController.shutdownClientServer$(this);
    }

    @Override
    public void shutdownServer() {
        ProcessorCSController.shutdownServer$(this);
    }

    public Config config() {
        return this.config;
    }

    @Override
    public Config getConf() {
        return this.config();
    }

    public boolean internStrings() {
        return this.internStrings;
    }

    private Option<TokenizerPreProcessor> tokenizerPreProcessor$lzycompute() {
        CluProcessor cluProcessor = this;
        synchronized (cluProcessor) {
            if ((this.bitmap$0 & 1) == 0) {
                None$ none$;
                String string = this.getArgString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tokenizer.pre.type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<String>)new Some((Object)"none"));
                if ("bio".equals(string)) {
                    none$ = new Some((Object)new BioTokenizerPreProcessor(this.getArgBoolean(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tokenizer.pre.removeFigTabReferences"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))), this.getArgBoolean(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tokenizer.pre.removeBibReferences"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)))));
                } else if ("none".equals(string)) {
                    none$ = None$.MODULE$;
                } else {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: Unknown argument value for ", ".tokenizer.pre.type!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})));
                }
                this.tokenizerPreProcessor = none$;
                this.bitmap$0 |= 1;
            }
        }
        return this.tokenizerPreProcessor;
    }

    public Option<TokenizerPreProcessor> tokenizerPreProcessor() {
        return (this.bitmap$0 & 1) == 0 ? this.tokenizerPreProcessor$lzycompute() : this.tokenizerPreProcessor;
    }

    private Tokenizer tokenizer$lzycompute() {
        CluProcessor cluProcessor = this;
        synchronized (cluProcessor) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tokenizer = new OpenDomainEnglishTokenizer();
                this.bitmap$0 |= 2;
            }
        }
        return this.tokenizer;
    }

    public Tokenizer tokenizer() {
        return (this.bitmap$0 & 2) == 0 ? this.tokenizer$lzycompute() : this.tokenizer;
    }

    private Option<TokenizerPostProcessor> tokenizerPostProcessor$lzycompute() {
        CluProcessor cluProcessor = this;
        synchronized (cluProcessor) {
            if ((this.bitmap$0 & 4) == 0) {
                None$ none$;
                String string = this.getArgString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tokenizer.post.type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<String>)new Some((Object)"none"));
                if ("bio".equals(string)) {
                    none$ = new Some((Object)new BioTokenizerPostProcessor(this.getArgStrings(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tokenizer.post.tokensWithValidSlashes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<Seq<String>>)None$.MODULE$)));
                } else if ("none".equals(string)) {
                    none$ = None$.MODULE$;
                } else {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: Unknown argument value for ", ".tokenizer.post.type!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})));
                }
                this.tokenizerPostProcessor = none$;
                this.bitmap$0 |= 4;
            }
        }
        return this.tokenizerPostProcessor;
    }

    public Option<TokenizerPostProcessor> tokenizerPostProcessor() {
        return (this.bitmap$0 & 4) == 0 ? this.tokenizerPostProcessor$lzycompute() : this.tokenizerPostProcessor;
    }

    private PartOfSpeechTagger posTagger$lzycompute() {
        CluProcessor cluProcessor = this;
        synchronized (cluProcessor) {
            if ((this.bitmap$0 & 8) == 0) {
                this.posTagger = PartOfSpeechTagger$.MODULE$.loadFromResource(this.getArgString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".pos.model"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<String>)None$.MODULE$));
                this.bitmap$0 |= 8;
            }
        }
        return this.posTagger;
    }

    public PartOfSpeechTagger posTagger() {
        return (this.bitmap$0 & 8) == 0 ? this.posTagger$lzycompute() : this.posTagger;
    }

    private Option<SentencePostProcessor> posPostProcessor$lzycompute() {
        CluProcessor cluProcessor = this;
        synchronized (cluProcessor) {
            if ((this.bitmap$0 & 0x10) == 0) {
                Some some;
                String string = this.getArgString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".pos.post.type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<String>)new Some((Object)"none"));
                if ("bio".equals(string)) {
                    some = new Some((Object)new BioPOSPostProcessor());
                } else if ("none".equals(string)) {
                    some = None$.MODULE$;
                } else {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: Unknown argument value for ", ".pos.post.type!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})));
                }
                this.posPostProcessor = some;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.posPostProcessor;
    }

    public Option<SentencePostProcessor> posPostProcessor() {
        return (this.bitmap$0 & 0x10) == 0 ? this.posPostProcessor$lzycompute() : this.posPostProcessor;
    }

    private Option<Tagger<String>> ner$lzycompute() {
        CluProcessor cluProcessor = this;
        synchronized (cluProcessor) {
            if ((this.bitmap$0 & 0x20) == 0) {
                None$ none$;
                String string = this.getArgString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".ner.type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<String>)new Some((Object)"none"));
                if ("bio".equals(string)) {
                    none$ = new Some((Object)LexiconNER$.MODULE$.apply(this.getArgStrings(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".ner.kbs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<Seq<String>>)None$.MODULE$), (Option<Seq<String>>)new Some(this.getArgStrings(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".ner.overrides"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<Seq<String>>)None$.MODULE$)), new BioLexiconEntityValidator(), new BioLexicalVariations(), false, true));
                } else if ("conll".equals(string)) {
                    none$ = new Some((Object)NamedEntityRecognizer$.MODULE$.loadFromResource(this.getArgString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".ner.model"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<String>)None$.MODULE$)));
                } else if ("none".equals(string)) {
                    none$ = None$.MODULE$;
                } else {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: Unknown argument value for ", ".ner.type!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})));
                }
                this.ner = none$;
                this.bitmap$0 |= 0x20;
            }
        }
        return this.ner;
    }

    public Option<Tagger<String>> ner() {
        return (this.bitmap$0 & 0x20) == 0 ? this.ner$lzycompute() : this.ner;
    }

    private Option<SentencePostProcessor> nerPostProcessor$lzycompute() {
        CluProcessor cluProcessor = this;
        synchronized (cluProcessor) {
            if ((this.bitmap$0 & 0x40) == 0) {
                None$ none$;
                String string = this.getArgString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".ner.post.type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<String>)new Some((Object)"none"));
                if ("bio".equals(string)) {
                    none$ = new Some((Object)new BioNERPostProcessor(this.getArgString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".ner.post.stopListFile"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<String>)None$.MODULE$)));
                } else if ("none".equals(string)) {
                    none$ = None$.MODULE$;
                } else {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: Unknown argument value for ", ".ner.post.stopListFile!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})));
                }
                this.nerPostProcessor = none$;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.nerPostProcessor;
    }

    public Option<SentencePostProcessor> nerPostProcessor() {
        return (this.bitmap$0 & 0x40) == 0 ? this.nerPostProcessor$lzycompute() : this.nerPostProcessor;
    }

    private Chunker chunker$lzycompute() {
        CluProcessor cluProcessor = this;
        synchronized (cluProcessor) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.chunker = Chunker$.MODULE$.loadFromResource(this.getArgString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".chunker.model"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<String>)None$.MODULE$));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.chunker;
    }

    public Chunker chunker() {
        return (this.bitmap$0 & 0x80) == 0 ? this.chunker$lzycompute() : this.chunker;
    }

    public boolean useUniversalDependencies() {
        return this.useUniversalDependencies;
    }

    private Parser depParser$lzycompute() {
        CluProcessor cluProcessor = this;
        synchronized (cluProcessor) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.depParser = this.useUniversalDependencies() ? new EnsembleMaltParser(this.getArgStrings(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".parser.models-universal"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<Seq<String>>)None$.MODULE$), EnsembleMaltParser$.MODULE$.$lessinit$greater$default$2()) : new EnsembleMaltParser(this.getArgStrings(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".parser.models-stanford"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<Seq<String>>)None$.MODULE$), EnsembleMaltParser$.MODULE$.$lessinit$greater$default$2());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.depParser;
    }

    public Parser depParser() {
        return (this.bitmap$0 & 0x100) == 0 ? this.depParser$lzycompute() : this.depParser;
    }

    @Override
    public Document annotate(Document doc) {
        this.lemmatize(doc);
        this.tagPartsOfSpeech(doc);
        this.recognizeNamedEntities(doc);
        this.parse(doc);
        this.chunking(doc);
        this.resolveCoreference(doc);
        this.discourse(doc);
        doc.clear();
        return doc;
    }

    @Override
    public String preprocessText(String origText) {
        return this.tokenizerPreProcessor().nonEmpty() ? ((TokenizerPreProcessor)this.tokenizerPreProcessor().get()).process(origText) : origText;
    }

    /*
     * WARNING - void declaration
     */
    private Document postProcess(Document document) {
        void var3_3;
        if (this.tokenizerPostProcessor().isEmpty()) {
            return document;
        }
        ArrayBuffer sentences = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])document.sentences())).foreach((Function1 & Serializable & scala.Serializable)s -> {
            Predef$.MODULE$.assert(s.tags().isEmpty());
            Predef$.MODULE$.assert(s.lemmas().isEmpty());
            Predef$.MODULE$.assert(s.entities().isEmpty());
            PostProcessorToken[] tokens = this.mkPostProcessorTokens((Sentence)s);
            PostProcessorToken[] newTokens = ((TokenizerPostProcessor)this.tokenizerPostProcessor().get()).process(tokens);
            return sentences.$plus$eq((Object)this.mkSentence(newTokens));
        });
        Predef$.MODULE$.assert(document.coreferenceChains().isEmpty());
        Predef$.MODULE$.assert(document.discourseTree().isEmpty());
        Document d = new Document((Sentence[])sentences.toArray(ClassTag$.MODULE$.apply(Sentence.class)));
        d.text_$eq(document.text());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private PostProcessorToken[] mkPostProcessorTokens(Sentence sentence) {
        void var2_2;
        PostProcessorToken[] tokens = new PostProcessorToken[sentence.size()];
        sentence.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            tokens$2[i] = new PostProcessorToken(sentence.words()[i], sentence.startOffsets()[i], sentence.endOffsets()[i]);
        });
        return var2_2;
    }

    private Sentence mkSentence(PostProcessorToken[] tokens) {
        String[] words = new String[tokens.length];
        int[] startOffsets = new int[tokens.length];
        int[] endOffsets = new int[tokens.length];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            words$1[i] = tokens[i].word();
            startOffsets$1[i] = tokens[i].beginPosition();
            endOffsets$1[i] = tokens[i].endPosition();
        });
        return new Sentence(words, startOffsets, endOffsets);
    }

    @Override
    public Document mkDocument(String text, boolean keepText) {
        Document doc;
        block0: {
            Sentence[] sents = this.tokenizer().tokenize(text, this.tokenizer().tokenize$default$2());
            doc = new Document(sents);
            if (!keepText) break block0;
            doc.text_$eq((Option<String>)new Some((Object)text));
        }
        return this.postProcess(doc);
    }

    @Override
    public boolean mkDocument$default$2() {
        return false;
    }

    @Override
    public Document mkDocumentFromSentences(Iterable<String> sentences, boolean keepText, int charactersBetweenSentences) {
        Document doc;
        block0: {
            ArrayBuffer sents = new ArrayBuffer();
            sentences.foreach((Function1 & Serializable & scala.Serializable)text -> sents.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tokenizer().tokenize((String)text, false)))));
            doc = new Document((Sentence[])sents.toArray(ClassTag$.MODULE$.apply(Sentence.class)));
            if (!keepText) break block0;
            doc.text_$eq((Option<String>)new Some((Object)sentences.mkString(this.mkSep(charactersBetweenSentences))));
        }
        return this.postProcess(doc);
    }

    @Override
    public boolean mkDocumentFromSentences$default$2() {
        return false;
    }

    @Override
    public int mkDocumentFromSentences$default$3() {
        return 1;
    }

    @Override
    public Document mkDocumentFromTokens(Iterable<Iterable<String>> sentences, boolean keepText, int charactersBetweenSentences, int charactersBetweenTokens) {
        Document doc;
        block0: {
            IntRef charOffset = IntRef.create((int)0);
            ObjectRef sents = ObjectRef.create((Object)new ArrayBuffer());
            StringBuilder text = new StringBuilder();
            sentences.foreach((Function1 & Serializable & scala.Serializable)sentence -> {
                BoxedUnit boxedUnit;
                ArrayBuffer startOffsets = new ArrayBuffer();
                ArrayBuffer endOffsets = new ArrayBuffer();
                sentence.foreach((Function1 & Serializable & scala.Serializable)word -> {
                    CluProcessor.$anonfun$mkDocumentFromTokens$2(charactersBetweenTokens, charOffset, startOffsets, endOffsets, word);
                    return BoxedUnit.UNIT;
                });
                ((ArrayBuffer)sents$2.elem).$plus$eq((Object)new Sentence((String[])sentence.toArray(ClassTag$.MODULE$.apply(String.class)), (int[])startOffsets.toArray(ClassTag$.MODULE$.Int()), (int[])endOffsets.toArray(ClassTag$.MODULE$.Int())));
                charOffset$1.elem += charactersBetweenSentences;
                if (keepText) {
                    text.append(sentence.mkString(this.mkSep(charactersBetweenTokens)));
                    boxedUnit = text.append(this.mkSep(charactersBetweenSentences));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            doc = new Document((Sentence[])((ArrayBuffer)sents.elem).toArray(ClassTag$.MODULE$.apply(Sentence.class)));
            if (!keepText) break block0;
            doc.text_$eq((Option<String>)new Some((Object)text.toString()));
        }
        return this.postProcess(doc);
    }

    @Override
    public boolean mkDocumentFromTokens$default$2() {
        return false;
    }

    @Override
    public int mkDocumentFromTokens$default$3() {
        return 1;
    }

    @Override
    public int mkDocumentFromTokens$default$4() {
        return 1;
    }

    private String mkSep(int size) {
        StringBuilder os = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1 & Serializable & scala.Serializable)_ -> os.append(" "));
        return os.toString();
    }

    private String in(String s) {
        return this.internStrings() ? Processor$.MODULE$.internString(s) : s;
    }

    @Override
    public void tagPartsOfSpeech(Document doc) {
        this.basicSanityCheck(doc);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sent -> {
            CluProcessor.$anonfun$tagPartsOfSpeech$1(this, sent);
            return BoxedUnit.UNIT;
        });
    }

    public String lemmatizeWord(String word) {
        String norm = CluProcessor$.MODULE$.normalizeForLemmatization(word).trim();
        if (norm.isEmpty()) {
            return "";
        }
        String[] parts = norm.split(CluProcessor$.MODULE$.whitespaces());
        StringBuilder result = new StringBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).foreach((Function1 & Serializable & scala.Serializable)part -> {
            Morpha morpha = new Morpha(new StringReader((String)part), false);
            String lemma = part;
            try {
                lemma = morpha.next();
            }
            catch (Throwable throwable) {}
            Object object = result.length() > 0 ? result.append(" ") : BoxedUnit.UNIT;
            return result.append(lemma);
        });
        return result.toString();
    }

    @Override
    public void lemmatize(Document doc) {
        this.basicSanityCheck(doc);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sent -> {
            CluProcessor.$anonfun$lemmatize$1(this, sent);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void recognizeNamedEntities(Document doc) {
        block0: {
            if (!this.ner().nonEmpty()) break block0;
            this.basicSanityCheck(doc);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sentence -> {
                CluProcessor.$anonfun$recognizeNamedEntities$1(this, sentence);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Override
    public void parse(Document doc) {
        this.basicSanityCheck(doc);
        if (((Sentence)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).head()).tags().isEmpty()) {
            throw new RuntimeException("ERROR: you have to run the POS tagger before parsing!");
        }
        if (((Sentence)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).head()).lemmas().isEmpty()) {
            throw new RuntimeException("ERROR: you have to run the lemmatizer before parsing!");
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sentence -> {
            CluProcessor.$anonfun$parse$1(this, sentence);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void chunking(Document doc) {
        this.basicSanityCheck(doc);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sent -> {
            CluProcessor.$anonfun$chunking$1(this, sent);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void resolveCoreference(Document doc) {
    }

    @Override
    public void discourse(Document doc) {
    }

    private void basicSanityCheck(Document doc) {
        if (doc.sentences() == null) {
            throw new RuntimeException("ERROR: Document.sentences == null!");
        }
        if (doc.sentences().length != 0 && doc.sentences()[0].words() == null) {
            throw new RuntimeException("ERROR: Sentence.words == null!");
        }
    }

    public static final /* synthetic */ void $anonfun$mkDocumentFromTokens$2(int charactersBetweenTokens$1, IntRef charOffset$1, ArrayBuffer startOffsets$2, ArrayBuffer endOffsets$2, String word) {
        startOffsets$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)charOffset$1.elem));
        charOffset$1.elem += word.length();
        endOffsets$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)charOffset$1.elem));
        charOffset$1.elem += charactersBetweenTokens$1;
    }

    public static final /* synthetic */ void $anonfun$tagPartsOfSpeech$1(CluProcessor $this, Sentence sent) {
        block0: {
            String[] tags = (String[])$this.posTagger().classesOf(sent);
            sent.tags_$eq((Option<String[]>)new Some((Object)tags));
            if (!$this.posPostProcessor().nonEmpty()) break block0;
            ((SentencePostProcessor)$this.posPostProcessor().get()).process(sent);
        }
    }

    public static final /* synthetic */ void $anonfun$lemmatize$1(CluProcessor $this, Sentence sent) {
        String[] lemmas = new String[sent.size()];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sent.words())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String lemma = $this.lemmatizeWord(sent.words()[i]);
            if (lemma.isEmpty()) {
                lemma = sent.words()[i].toLowerCase();
            }
            lemmas$1[i] = lemma;
        });
        sent.lemmas_$eq((Option<String[]>)new Some((Object)lemmas));
    }

    public static final /* synthetic */ void $anonfun$recognizeNamedEntities$1(CluProcessor $this, Sentence sentence) {
        block0: {
            String[] labels = (String[])((Tagger)$this.ner().get()).find(sentence);
            sentence.entities_$eq((Option<String[]>)new Some((Object)labels));
            if (!$this.nerPostProcessor().nonEmpty()) break block0;
            ((SentencePostProcessor)$this.nerPostProcessor().get()).process(sentence);
        }
    }

    public static final /* synthetic */ void $anonfun$parse$1(CluProcessor $this, Sentence sentence) {
        DirectedGraph<String> dg = $this.depParser().parseSentence(sentence);
        if ($this.useUniversalDependencies()) {
            sentence.setDependencies(GraphMap$.MODULE$.UNIVERSAL_BASIC(), dg);
            sentence.setDependencies(GraphMap$.MODULE$.UNIVERSAL_ENHANCED(), EnhancedDependencies$.MODULE$.generateUniversalEnhancedDependencies(sentence, dg));
        } else {
            sentence.setDependencies(GraphMap$.MODULE$.STANFORD_BASIC(), dg);
            sentence.setDependencies(GraphMap$.MODULE$.STANFORD_COLLAPSED(), EnhancedDependencies$.MODULE$.generateStanfordEnhancedDependencies(sentence, dg));
        }
    }

    public static final /* synthetic */ void $anonfun$chunking$1(CluProcessor $this, Sentence sent) {
        String[] chunks = (String[])$this.chunker().classesOf(sent);
        sent.chunks_$eq((Option<String[]>)new Some((Object)chunks));
    }

    public CluProcessor(Config config) {
        this.config = config;
        ProcessorCSController.$init$(this);
        ProcessorAnnotator.$init$(this);
        Processor.$init$(this);
        Configured.$init$(this);
        this.internStrings = this.getArgBoolean(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".internStrings"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        this.useUniversalDependencies = this.getArgBoolean(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".parser.universal"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CluProcessor$.MODULE$.prefix()})), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }
}

