/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.processors.clu;

import java.io.File;
import java.io.Serializable;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.clulab.processors.Document;
import org.clulab.processors.Sentence;
import org.clulab.processors.clu.CluProcessor;
import org.clulab.processors.clu.CluProcessor$;
import org.clulab.struct.DirectedGraph;
import org.clulab.struct.DirectedGraphEdgeIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class CluShell$ {
    public static CluShell$ MODULE$;
    private final ListMap<String, String> commands;

    static {
        new CluShell$();
    }

    public ListMap<String, String> commands() {
        return this.commands;
    }

    public void shell() {
        LazyRef proc$lzy = new LazyRef();
        FileHistory history = new FileHistory(new File(System.getProperty("user.home"), ".clushellhistory"));
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> history.flush());
        ConsoleReader reader = new ConsoleReader();
        reader.setHistory((History)history);
        reader.setPrompt("(clu)>>> ");
        Predef$.MODULE$.println((Object)"\nWelcome to the ProcessorShell!");
        this.printCommands();
        boolean running = true;
        while (running) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            String string = reader.readLine();
            if (":help".equals(string)) {
                this.printCommands();
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            boolean bl = ":exit".equals(string) ? true : string == null;
            if (bl) {
                running = false;
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(string.trim())).nonEmpty()) {
                try {
                    Document doc = CluShell$.proc$1(proc$lzy).annotate(string, CluShell$.proc$1(proc$lzy).annotate$default$2());
                    this.print(doc);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println((Object)"Processing failed with the following error:");
                    e.printStackTrace();
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit2 = boxedUnit;
        }
        reader.getTerminal().restore();
        reader.shutdown();
    }

    public void printCommands() {
        Predef$.MODULE$.println((Object)"\nCOMMANDS:");
        this.commands().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CluShell$.$anonfun$printCommands$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CluShell$.$anonfun$printCommands$2(x$1);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public void print(Document doc) {
        IntRef sentenceCount = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sentence -> {
            CluShell$.$anonfun$print$1(sentenceCount, sentence);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        this.shell();
    }

    private static final /* synthetic */ CluProcessor proc$lzycompute$1(LazyRef proc$lzy$1) {
        CluProcessor cluProcessor;
        LazyRef lazyRef = proc$lzy$1;
        synchronized (lazyRef) {
            cluProcessor = proc$lzy$1.initialized() ? (CluProcessor)proc$lzy$1.value() : (CluProcessor)proc$lzy$1.initialize((Object)new CluProcessor(CluProcessor$.MODULE$.$lessinit$greater$default$1()));
        }
        return cluProcessor;
    }

    private static final CluProcessor proc$1(LazyRef proc$lzy$1) {
        return proc$lzy$1.initialized() ? (CluProcessor)proc$lzy$1.value() : CluShell$.proc$lzycompute$1(proc$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$printCommands$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$printCommands$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String cmd = (String)tuple2._1();
        String msg = (String)tuple2._2();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", "\\t=> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cmd, msg})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$print$2(DirectedGraph dependencies) {
        Predef$.MODULE$.println((Object)"Basic dependencies:");
        DirectedGraphEdgeIterator iterator = new DirectedGraphEdgeIterator(dependencies);
        while (iterator.hasNext()) {
            Tuple3 dep = iterator.next();
            Predef$.MODULE$.println((Object)(" head:" + dep._1() + " modifier:" + dep._2() + " label:" + dep._3()));
        }
    }

    public static final /* synthetic */ void $anonfun$print$3(DirectedGraph dependencies) {
        Predef$.MODULE$.println((Object)"Enhanced dependencies:");
        DirectedGraphEdgeIterator iterator = new DirectedGraphEdgeIterator(dependencies);
        while (iterator.hasNext()) {
            Tuple3 dep = iterator.next();
            Predef$.MODULE$.println((Object)(" head:" + dep._1() + " modifier:" + dep._2() + " label:" + dep._3()));
        }
    }

    public static final /* synthetic */ void $anonfun$print$1(IntRef sentenceCount$1, Sentence sentence) {
        Predef$.MODULE$.println((Object)("Sentence #" + sentenceCount$1.elem + ":"));
        Range indices = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sentence.size());
        Predef$.MODULE$.println((Object)("Tokens: " + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sentence.words())).zip((GenIterable)indices, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).mkString(" ")));
        Predef$.MODULE$.println((Object)("Tags: " + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sentence.tags().get())).zip((GenIterable)indices, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).mkString(" ")));
        sentence.universalBasicDependencies().foreach((Function1 & Serializable & scala.Serializable)dependencies -> {
            CluShell$.$anonfun$print$2(dependencies);
            return BoxedUnit.UNIT;
        });
        sentence.universalEnhancedDependencies().foreach((Function1 & Serializable & scala.Serializable)dependencies -> {
            CluShell$.$anonfun$print$3(dependencies);
            return BoxedUnit.UNIT;
        });
        ++sentenceCount$1.elem;
        Predef$.MODULE$.println((Object)"\n");
    }

    private CluShell$() {
        MODULE$ = this;
        this.commands = (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":help"), (Object)"show commands"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":exit"), (Object)"exit system")}));
    }
}

