/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.processors.clu.sequences;

import org.clulab.processors.Sentence;
import org.clulab.processors.clu.sequences.FeatureExtractor$;
import org.clulab.struct.Counter;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u00015\u0011\u0001CR3biV\u0014X-\u0012=ue\u0006\u001cGo\u001c:\u000b\u0005\r!\u0011!C:fcV,gnY3t\u0015\t)a!A\u0002dYVT!a\u0002\u0005\u0002\u0015A\u0014xnY3tg>\u00148O\u0003\u0002\n\u0015\u000511\r\\;mC\nT\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011M,g\u000e^3oG\u0016,\u0012a\u0006\t\u00031ei\u0011AB\u0005\u00035\u0019\u0011\u0001bU3oi\u0016t7-\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005/\u0005I1/\u001a8uK:\u001cW\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005A\u0001o\\:ji&|g.F\u0001!!\ty\u0011%\u0003\u0002#!\t\u0019\u0011J\u001c;\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0001\n\u0011\u0002]8tSRLwN\u001c\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\n\u0001BZ3biV\u0014Xm]\u000b\u0002QA\u0019\u0011\u0006\f\u0018\u000e\u0003)R!a\u000b\u0005\u0002\rM$(/^2u\u0013\ti#FA\u0004D_VtG/\u001a:\u0011\u0005=2dB\u0001\u00195!\t\t\u0004#D\u00013\u0015\t\u0019D\"\u0001\u0004=e>|GOP\u0005\u0003kA\ta\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011Q\u0007\u0005\u0005\tu\u0001\u0011\t\u0011)A\u0005Q\u0005Ia-Z1ukJ,7\u000f\t\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\ty\u0002\u0015I\u0011\t\u0003\u007f\u0001i\u0011A\u0001\u0005\u0006+m\u0002\ra\u0006\u0005\u0006=m\u0002\r\u0001\t\u0005\u0006Mm\u0002\r\u0001\u000b\u0005\u0006\t\u0002!\t!R\u0001\u0005o>\u0014H\r\u0006\u0002G\u0013B\u0011qbR\u0005\u0003\u0011B\u0011A!\u00168ji\")!j\u0011a\u0001A\u00051qN\u001a4tKRDQ\u0001\u0014\u0001\u0005\u00025\u000b1b^8sI\nKwM]1ngR\u0019aIT(\t\u000b)[\u0005\u0019\u0001\u0011\t\u000bA[\u0005\u0019\u0001\u0011\u0002\u0013QD'/Z:i_2$\u0007\"\u0002*\u0001\t\u0003\u0019\u0016!\u00027f[6\fGC\u0001$U\u0011\u0015Q\u0015\u000b1\u0001!\u0011\u00151\u0006\u0001\"\u0001X\u0003\r!\u0018m\u001a\u000b\u0003\rbCQAS+A\u0002\u0001BQA\u0017\u0001\u0005\u0002m\u000baaY1tS:<GC\u0001$]\u0011\u0015Q\u0015\f1\u0001!\u0011\u00151\u0003\u0001\"\u0001_)\t1u\fC\u0003K;\u0002\u0007\u0001\u0005C\u0003b\u0001\u0011\u0005!-A\u0004x_J$G*\u001a8\u0015\u0005\u0019\u001b\u0007\"\u0002&a\u0001\u0004\u0001\u0003\"B3\u0001\t\u00031\u0017\u0001C:vM\u001aL\u00070Z:\u0015\t\u0019;\u0007N\u001b\u0005\u0006\u0015\u0012\u0004\r\u0001\t\u0005\u0006S\u0012\u0004\r\u0001I\u0001\u0007[&tG*\u001a8\t\u000b-$\u0007\u0019\u0001\u0011\u0002\r5\f\u0007\u0010T3o\u0011\u0015i\u0007\u0001\"\u0001o\u0003!\u0001(/\u001a4jq\u0016\u001cH\u0003\u0002$paFDQA\u00137A\u0002\u0001BQ!\u001b7A\u0002\u0001BQa\u001b7A\u0002\u0001BQa\u001d\u0001\u0005\u0002Q\fAb]3oi\u0016t7-Z%oM>$\u0012A\u0012\u0005\u0006m\u0002!Ia^\u0001\u000em\u0006d\u0017\u000e\u001a)pg&$\u0018n\u001c8\u0015\u0005a\\\bCA\bz\u0013\tQ\bCA\u0004C_>dW-\u00198\t\u000bq,\b\u0019\u0001\u0011\u0002\u0003%<QA \u0002\t\u0002}\f\u0001CR3biV\u0014X-\u0012=ue\u0006\u001cGo\u001c:\u0011\u0007}\n\tA\u0002\u0004\u0002\u0005!\u0005\u00111A\n\u0004\u0003\u0003q\u0001b\u0002\u001f\u0002\u0002\u0011\u0005\u0011q\u0001\u000b\u0002\u007f\"Q\u00111BA\u0001\u0001\u0004%\t!!\u0004\u0002\u000f\tLwM]1ngV\u0011\u0011q\u0002\t\u0005\u001f\u0005E\u0001&C\u0002\u0002\u0014A\u0011aa\u00149uS>t\u0007BCA\f\u0003\u0003\u0001\r\u0011\"\u0001\u0002\u001a\u0005Y!-[4sC6\u001cx\fJ3r)\r1\u00151\u0004\u0005\u000b\u0003;\t)\"!AA\u0002\u0005=\u0011a\u0001=%c!I\u0011\u0011EA\u0001A\u0003&\u0011qB\u0001\tE&<'/Y7tA!A\u0011QEA\u0001\t\u0003\t9#\u0001\u0007d_VtGOQ5he\u0006l7\u000fF\u0002G\u0003SA\u0001\"a\u000b\u0002$\u0001\u0007\u0011QF\u0001\ng\u0016tG/\u001a8dKN\u0004R!a\f\u0002:]qA!!\r\u000269\u0019\u0011'a\r\n\u0003EI1!a\u000e\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000f\u0002>\t\u00191+Z9\u000b\u0007\u0005]\u0002\u0003\u0003\u0005\u0002B\u0005\u0005A\u0011AA\"\u0003\u0011qwN]7\u0015\u00079\n)\u0005C\u0004\u0002H\u0005}\u0002\u0019\u0001\u0018\u0002\u0003]D\u0001\"a\u0013\u0002\u0002\u0011\u0005\u0011QJ\u0001\t[.\u0014\u0015n\u001a:b[R)a&a\u0014\u0002R!1Q#!\u0013A\u0002]Aa\u0001`A%\u0001\u0004\u0001\u0003")
public class FeatureExtractor {
    private final Sentence sentence;
    private final int position;
    private final Counter<String> features;

    public static String mkBigram(Sentence sentence, int n) {
        return FeatureExtractor$.MODULE$.mkBigram(sentence, n);
    }

    public static String norm(String string) {
        return FeatureExtractor$.MODULE$.norm(string);
    }

    public static void countBigrams(Seq<Sentence> seq) {
        FeatureExtractor$.MODULE$.countBigrams(seq);
    }

    public static void bigrams_$eq(Option<Counter<String>> option) {
        FeatureExtractor$.MODULE$.bigrams_$eq(option);
    }

    public static Option<Counter<String>> bigrams() {
        return FeatureExtractor$.MODULE$.bigrams();
    }

    public Sentence sentence() {
        return this.sentence;
    }

    public int position() {
        return this.position;
    }

    public Counter<String> features() {
        return this.features;
    }

    public void word(int offset) {
        block1: {
            int i;
            block2: {
                block0: {
                    i = this.position() + offset;
                    if (i != -1) break block0;
                    this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"w[", "]:-BOS-"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset)})));
                    break block1;
                }
                if (i != this.sentence().size()) break block2;
                this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"w[", "]:-EOS-"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset)})));
                break block1;
            }
            if (!this.validPosition(i)) break block1;
            this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"w[", "]:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset), FeatureExtractor$.MODULE$.norm(this.sentence().words()[i])})));
        }
    }

    public void wordBigrams(int offset, int threshold) {
        block1: {
            int i = this.position() + offset;
            if (!this.validPosition(i) || !this.validPosition(i - 1)) break block1;
            String bg = FeatureExtractor$.MODULE$.mkBigram(this.sentence(), i - 1);
            if (FeatureExtractor$.MODULE$.bigrams().isEmpty() || ((Counter)FeatureExtractor$.MODULE$.bigrams().get()).getCount(bg) > (double)threshold) {
                this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wb[", "]:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset), bg})));
            }
        }
    }

    public void lemma(int offset) {
        block0: {
            int i = this.position() + offset;
            if (!this.validPosition(i)) break block0;
            this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l[", "]:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset), FeatureExtractor$.MODULE$.norm(((String[])this.sentence().lemmas().get())[i])})));
        }
    }

    public void tag(int offset) {
        block0: {
            int i = this.position() + offset;
            if (!this.validPosition(i)) break block0;
            this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"l[", "]:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset), ((String[])this.sentence().tags().get())[i]})));
        }
    }

    public void casing(int offset) {
        block5: {
            int i = this.position() + offset;
            if (!this.validPosition(i)) break block5;
            IntRef uppers = IntRef.create((int)0);
            String w = this.sentence().words()[i];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), w.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)j -> {
                block0: {
                    if (!Character.isUpperCase(w.charAt(j))) break block0;
                    ++uppers$1.elem;
                }
            });
            String v = "x";
            if (uppers.elem == w.length()) {
                v = "X";
            } else if (uppers.elem == 1 && Character.isUpperCase(w.charAt(0))) {
                v = "Xx";
            } else if (uppers.elem >= 1 && !Character.isUpperCase(w.charAt(0))) {
                v = "xX";
            }
            this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c[", "]:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset), v})));
        }
    }

    public void features(int offset) {
        block1: {
            int i = this.position() + offset;
            if (!this.validPosition(i)) break block1;
            String w = this.sentence().words()[i];
            BooleanRef containsPeriod = BooleanRef.create((boolean)false);
            BooleanRef containsNumber = BooleanRef.create((boolean)false);
            BooleanRef containsHyphen = BooleanRef.create((boolean)false);
            BooleanRef containsComma = BooleanRef.create((boolean)false);
            new StringOps(Predef$.MODULE$.augmentString(w)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)j -> {
                block1: {
                    char c;
                    block3: {
                        block2: {
                            block0: {
                                c = w.charAt(j);
                                if (c != '-') break block0;
                                containsHyphen$1.elem = true;
                                break block1;
                            }
                            if (!Character.isDigit(c)) break block2;
                            containsNumber$1.elem = true;
                            break block1;
                        }
                        if (c != '.') break block3;
                        containsPeriod$1.elem = true;
                        break block1;
                    }
                    if (c != ',') break block1;
                    containsComma$1.elem = true;
                }
            });
            Object object = containsPeriod.elem ? BoxesRunTime.boxToDouble((double)this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hasPeriod[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset)})))) : BoxedUnit.UNIT;
            Object object2 = containsNumber.elem ? BoxesRunTime.boxToDouble((double)this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hasNumber[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset)})))) : BoxedUnit.UNIT;
            Object object3 = containsHyphen.elem ? BoxesRunTime.boxToDouble((double)this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hasHyphen[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset)})))) : BoxedUnit.UNIT;
            if (containsComma.elem) {
                this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hasComma[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset)})));
            }
        }
    }

    public void wordLen(int offset) {
        block0: {
            int i = this.position() + offset;
            if (!this.validPosition(i)) break block0;
            String w = this.sentence().words()[i];
            this.features().setCount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wordLen[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset)})), w.length());
        }
    }

    public void suffixes(int offset, int minLen, int maxLen) {
        block0: {
            int i = this.position() + offset;
            if (!this.validPosition(i)) break block0;
            String w = this.sentence().words()[i].toLowerCase();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(minLen), maxLen).foreach((Function1 & java.io.Serializable & Serializable)len -> FeatureExtractor.$anonfun$suffixes$1(this, offset, w, BoxesRunTime.unboxToInt((Object)len)));
        }
    }

    public void prefixes(int offset, int minLen, int maxLen) {
        block0: {
            int i = this.position() + offset;
            if (!this.validPosition(i)) break block0;
            String w = this.sentence().words()[i].toLowerCase();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(minLen), maxLen).foreach((Function1 & java.io.Serializable & Serializable)len -> FeatureExtractor.$anonfun$prefixes$1(this, offset, w, BoxesRunTime.unboxToInt((Object)len)));
        }
    }

    public void sentenceInfo() {
        String last = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sentence().words())).last();
        this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"eos:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{last})));
    }

    private boolean validPosition(int i) {
        return i >= 0 && i < this.sentence().size();
    }

    public static final /* synthetic */ Object $anonfun$suffixes$1(FeatureExtractor $this, int offset$1, String w$3, int len) {
        Object object;
        if (len <= w$3.length()) {
            String suff = w$3.substring(w$3.length() - len);
            object = BoxesRunTime.boxToDouble((double)$this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"suff[", ",", "]:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset$1), BoxesRunTime.boxToInteger((int)len), suff}))));
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public static final /* synthetic */ Object $anonfun$prefixes$1(FeatureExtractor $this, int offset$2, String w$4, int len) {
        Object object;
        if (len <= w$4.length()) {
            String prefix = w$4.substring(0, len);
            object = BoxesRunTime.boxToDouble((double)$this.features().$plus$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pref[", ",", "]:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)offset$2), BoxesRunTime.boxToInteger((int)len), prefix}))));
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public FeatureExtractor(Sentence sentence, int position, Counter<String> features) {
        this.sentence = sentence;
        this.position = position;
        this.features = features;
    }
}

