/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.processors.clu.syntax;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import org.clulab.processors.clu.syntax.EvalDependency;
import org.clulab.processors.clu.syntax.EvaluateMalt;
import org.clulab.processors.clu.syntax.MaltWrapper;
import org.clulab.processors.clu.syntax.MaltWrapper$;
import org.clulab.processors.clu.syntax.Parser;
import org.maltparser.concurrent.ConcurrentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

public final class EvaluateMalt$ {
    public static EvaluateMalt$ MODULE$;
    private final Logger logger;

    static {
        new EvaluateMalt$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        if (args.length != 2) {
            Predef$.MODULE$.println((Object)"Usage: org.clulab.processors.clulab.syntax.EvaluateMalt <model file name> <testing treebank in conllx format>");
            System.exit(1);
        }
        String modelName = args[0];
        String testFile = args[1];
        MaltWrapper maltModel = new MaltWrapper(modelName, MaltWrapper$.MODULE$.$lessinit$greater$default$2());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully created malt model from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName})));
        BufferedReader reader = new BufferedReader(new FileReader(testFile));
        this.evaluate(maltModel, reader);
        reader.close();
    }

    public Tuple2<Object, Object> evaluate(Parser maltModel, BufferedReader reader) {
        ArrayBuffer goldDeps = new ArrayBuffer();
        ArrayBuffer sysDeps = new ArrayBuffer();
        boolean done = false;
        int count = 0;
        boolean verbose = false;
        this.logger().info("Beginning parsing...");
        while (!done) {
            String[] goldTokens = ConcurrentUtils.readSentence((BufferedReader)reader);
            if (verbose) {
                Predef$.MODULE$.println((Object)"GOLD:");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])goldTokens)).foreach((Function1 & Serializable & scala.Serializable)t -> {
                    Predef$.MODULE$.println((Object)t);
                    return BoxedUnit.UNIT;
                });
            }
            goldDeps.$plus$plus$eq(this.toDeps(goldTokens));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])goldTokens)).isEmpty()) {
                done = true;
                continue;
            }
            ++count;
            String[] inputTokens = ConcurrentUtils.stripGold((String[])goldTokens, (int)4);
            if (verbose) {
                Predef$.MODULE$.println((Object)"INPUT TOKENS:");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputTokens)).foreach((Function1 & Serializable & scala.Serializable)t -> {
                    Predef$.MODULE$.println((Object)t);
                    return BoxedUnit.UNIT;
                });
            }
            String[] outputTokens = maltModel.parseSentenceConllx(inputTokens);
            if (verbose) {
                Predef$.MODULE$.println((Object)"SYS:");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputTokens)).foreach((Function1 & Serializable & scala.Serializable)t -> {
                    Predef$.MODULE$.println((Object)t);
                    return BoxedUnit.UNIT;
                });
                Predef$.MODULE$.println((Object)"\n");
            }
            sysDeps.$plus$plus$eq(this.toDeps(outputTokens));
            if (count % 100 != 0) continue;
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed ", " sentences..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
        }
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished parsing ", " sentences."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count)})));
        Predef$.MODULE$.assert(goldDeps.size() == sysDeps.size());
        Tuple2<Object, Object> tuple2 = this.score((EvalDependency[])goldDeps.toArray(ClassTag$.MODULE$.apply(EvalDependency.class)), (EvalDependency[])sysDeps.toArray(ClassTag$.MODULE$.apply(EvalDependency.class)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double las = tuple2._1$mcD$sp();
        double uas = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(las, uas);
        Tuple2.mcDD.sp sp3 = sp2;
        double las2 = sp3._1$mcD$sp();
        double uas2 = sp3._2$mcD$sp();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LAS = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)las2)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UAS = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)uas2)})));
        return new Tuple2.mcDD.sp(las2, uas2);
    }

    public Tuple2<Object, Object> score(EvalDependency[] goldDeps, EvalDependency[] sysDeps) {
        IntRef correctLabeled = IntRef.create((int)0);
        IntRef correctUnlabeled = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])goldDeps)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block1: {
                EvalDependency g = goldDeps[i];
                EvalDependency s = sysDeps[i];
                if (g.head() != s.head()) break block1;
                ++correctUnlabeled$1.elem;
                String string = g.label();
                String string2 = s.label();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    ++correctLabeled$1.elem;
                }
            }
        });
        double las = (double)correctLabeled.elem / (double)goldDeps.length;
        double uas = (double)correctUnlabeled.elem / (double)goldDeps.length;
        return new Tuple2.mcDD.sp(las, uas);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayBuffer<EvalDependency> toDeps(String[] sentence) {
        void var2_2;
        ArrayBuffer deps = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sentence)).foreach((Function1 & Serializable & scala.Serializable)line -> {
            String[] tokens = line.split("\\s+");
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).size() < 8) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: invalid output line: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})));
            }
            String label = tokens[7];
            int head = new StringOps(Predef$.MODULE$.augmentString(tokens[6])).toInt();
            return deps.$plus$eq((Object)new EvalDependency(label, head));
        });
        return var2_2;
    }

    public EvalDependency[] readDependencies(String fn) {
        ArrayBuffer deps = new ArrayBuffer();
        Source$.MODULE$.fromFile(fn, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            BoxedUnit boxedUnit;
            String content = line.trim();
            if (content.length() > 0) {
                String[] tokens = content.split("\\s+");
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).size() < 8) {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: invalid output line in file ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fn, line})));
                }
                String label = tokens[7];
                int head = new StringOps(Predef$.MODULE$.augmentString(tokens[6])).toInt();
                boxedUnit = deps.$plus$eq((Object)new EvalDependency(label, head));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return (EvalDependency[])deps.toArray(ClassTag$.MODULE$.apply(EvalDependency.class));
    }

    private EvaluateMalt$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(EvaluateMalt.class);
    }
}

