/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.sequences;

import java.io.InputStream;
import java.io.Serializable;
import org.clulab.processors.Document;
import org.clulab.processors.Processor$;
import org.clulab.processors.Sentence;
import org.clulab.processors.clu.CluProcessor;
import org.clulab.processors.clu.CluProcessor$;
import org.clulab.sequences.ColumnsToDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class ColumnsToDocument$ {
    public static ColumnsToDocument$ MODULE$;
    private final Logger logger;
    private final int WORD_POS_CONLLX;
    private final int TAG_POS_CONLLX;
    private final CluProcessor proc;

    static {
        new ColumnsToDocument$();
    }

    public Logger logger() {
        return this.logger;
    }

    public int WORD_POS_CONLLX() {
        return this.WORD_POS_CONLLX;
    }

    public int TAG_POS_CONLLX() {
        return this.TAG_POS_CONLLX;
    }

    public CluProcessor proc() {
        return this.proc;
    }

    public Document readFromFile(String fn, int wordPos, int labelPos, Function2<Sentence, String[], BoxedUnit> setLabels, Function1<Document, BoxedUnit> annotate) {
        BufferedSource source = Source$.MODULE$.fromFile(fn, Codec$.MODULE$.fallbackSystemCodec());
        return this.readFromSource((Source)source, wordPos, labelPos, setLabels, annotate);
    }

    public int readFromFile$default$2() {
        return this.WORD_POS_CONLLX();
    }

    public int readFromFile$default$3() {
        return this.TAG_POS_CONLLX();
    }

    public Document readFromStream(InputStream stream, int wordPos, int labelPos, Function2<Sentence, String[], BoxedUnit> setLabels, Function1<Document, BoxedUnit> annotate) {
        BufferedSource source = Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec());
        return this.readFromSource((Source)source, wordPos, labelPos, setLabels, annotate);
    }

    public int readFromStream$default$2() {
        return this.WORD_POS_CONLLX();
    }

    public int readFromStream$default$3() {
        return this.TAG_POS_CONLLX();
    }

    public Document readFromSource(Source source, int wordPos, int labelPos, Function2<Sentence, String[], BoxedUnit> setLabels, Function1<Document, BoxedUnit> annotate) {
        BoxedUnit boxedUnit;
        ObjectRef words = ObjectRef.create((Object)new ArrayBuffer());
        ObjectRef startOffsets = ObjectRef.create((Object)new ArrayBuffer());
        ObjectRef endOffsets = ObjectRef.create((Object)new ArrayBuffer());
        ObjectRef labels = ObjectRef.create((Object)new ArrayBuffer());
        IntRef charOffset = IntRef.create((int)0);
        ArrayBuffer sentences = new ArrayBuffer();
        source.getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            ColumnsToDocument$.$anonfun$readFromSource$1(wordPos, labelPos, setLabels, words, startOffsets, endOffsets, labels, charOffset, sentences, line);
            return BoxedUnit.UNIT;
        });
        if (((ArrayBuffer)words.elem).nonEmpty()) {
            Sentence s = new Sentence((String[])((ArrayBuffer)words.elem).toArray(ClassTag$.MODULE$.apply(String.class)), (int[])((ArrayBuffer)startOffsets.elem).toArray(ClassTag$.MODULE$.Int()), (int[])((ArrayBuffer)endOffsets.elem).toArray(ClassTag$.MODULE$.Int()));
            s.tags_$eq((Option<String[]>)new Some(((ArrayBuffer)labels.elem).toArray(ClassTag$.MODULE$.apply(String.class))));
            boxedUnit = sentences.$plus$eq((Object)s);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        source.close();
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded ", " sentences."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sentences.size())})));
        Document d = new Document((Sentence[])sentences.toArray(ClassTag$.MODULE$.apply(Sentence.class)));
        annotate.apply((Object)d);
        return d;
    }

    public void setTags(Sentence s, String[] tags) {
        s.tags_$eq((Option<String[]>)new Some((Object)tags));
    }

    public void setChunks(Sentence s, String[] chunks) {
        s.chunks_$eq((Option<String[]>)new Some((Object)chunks));
    }

    public void setEntities(Sentence s, String[] entities) {
        s.entities_$eq((Option<String[]>)new Some((Object)entities));
    }

    public void annotateLemmas(Document doc) {
        this.proc().lemmatize(doc);
    }

    public void annotateLemmmaTags(Document doc) {
        this.proc().lemmatize(doc);
        this.proc().tagPartsOfSpeech(doc);
    }

    private String in(String s) {
        return Processor$.MODULE$.internString(s);
    }

    public static final /* synthetic */ void $anonfun$readFromSource$1(int wordPos$1, int labelPos$1, Function2 setLabels$1, ObjectRef words$1, ObjectRef startOffsets$1, ObjectRef endOffsets$1, ObjectRef labels$1, IntRef charOffset$1, ArrayBuffer sentences$1, String line) {
        String l = line.trim();
        if (l.isEmpty()) {
            if (((ArrayBuffer)words$1.elem).nonEmpty()) {
                Sentence s = new Sentence((String[])((ArrayBuffer)words$1.elem).toArray(ClassTag$.MODULE$.apply(String.class)), (int[])((ArrayBuffer)startOffsets$1.elem).toArray(ClassTag$.MODULE$.Int()), (int[])((ArrayBuffer)endOffsets$1.elem).toArray(ClassTag$.MODULE$.Int()));
                setLabels$1.apply((Object)s, ((ArrayBuffer)labels$1.elem).toArray(ClassTag$.MODULE$.apply(String.class)));
                sentences$1.$plus$eq((Object)s);
                words$1.elem = new ArrayBuffer();
                startOffsets$1.elem = new ArrayBuffer();
                endOffsets$1.elem = new ArrayBuffer();
                labels$1.elem = new ArrayBuffer();
                ++charOffset$1.elem;
            }
        } else {
            String[] bits = l.split("\\s+");
            if (bits.length < 2) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: invalid line [", "]!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l})));
            }
            ((ArrayBuffer)words$1.elem).$plus$eq((Object)bits[wordPos$1]);
            ((ArrayBuffer)labels$1.elem).$plus$eq((Object)MODULE$.in(bits[labelPos$1]));
            ((ArrayBuffer)startOffsets$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)charOffset$1.elem));
            charOffset$1.elem = bits[wordPos$1].length();
            ((ArrayBuffer)endOffsets$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)charOffset$1.elem));
            ++charOffset$1.elem;
        }
    }

    private ColumnsToDocument$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(ColumnsToDocument.class);
        this.WORD_POS_CONLLX = 1;
        this.TAG_POS_CONLLX = 4;
        this.proc = new CluProcessor(CluProcessor$.MODULE$.$lessinit$greater$default$1());
    }
}

