/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.serialization;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import org.clulab.discourse.rstparser.DiscourseTree;
import org.clulab.discourse.rstparser.RelationDirection$;
import org.clulab.discourse.rstparser.TokenOffset;
import org.clulab.discourse.rstparser.TreeKind$;
import org.clulab.processors.Document;
import org.clulab.processors.Document$;
import org.clulab.processors.Sentence;
import org.clulab.processors.Sentence$;
import org.clulab.serialization.DocumentSerializer$;
import org.clulab.struct.CorefChains;
import org.clulab.struct.CorefMention;
import org.clulab.struct.DirectedGraph;
import org.clulab.struct.DirectedGraphEdgeIterator;
import org.clulab.struct.Edge;
import org.clulab.struct.GraphMap;
import org.clulab.struct.MutableNumber;
import org.clulab.struct.NonTerminal;
import org.clulab.struct.Terminal;
import org.clulab.struct.Tree;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u0001\u0003\u0001%\u0011!\u0003R8dk6,g\u000e^*fe&\fG.\u001b>fe*\u00111\u0001B\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AB2mk2\f'MC\u0001\b\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0002\u0005\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012\u0001D:dC2\fGn\\4hS:<'BA\u000b\u0017\u0003!!\u0018\u0010]3tC\u001a,'\"A\f\u0002\u0007\r|W.\u0003\u0002\u001a%\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003!\u0001\u0011\u0005\u0011%\u0001\u0003m_\u0006$GC\u0001\u0012)!\t\u0019c%D\u0001%\u0015\t)C!\u0001\u0006qe>\u001cWm]:peNL!a\n\u0013\u0003\u0011\u0011{7-^7f]RDQ!K\u0010A\u0002)\n!![:\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013AA5p\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0015\u0005?M2\u0004\b\u0005\u0002\fi%\u0011Q\u0007\u0004\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017%A\u001c\u00021RC\u0017n\u001d\u0011e_\u0016\u001chn\n;!o>\u00148\u000eI<iK:\u0004C\u000f[3sK\u0002\n'/\u001a\u0011nk2$\u0018\u000e\u001d7fA\u0011|7m\u001d\u0011tKJL\u0017\r\\5{K\u0012\u0004\u0013N\u001c\u0011uQ\u0016\u00043/Y7fA\u0019LG.\u001a\u0017!g\u0016\fX/\u001a8uS\u0006dG._\u0011\u0002s\u0005\u0019AG\f\u0019\t\u000b\u0001\u0002A\u0011A\u001e\u0015\u0005\tb\u0004\"B\u001f;\u0001\u0004q\u0014!\u0001:\u0011\u0005-z\u0014B\u0001!-\u00059\u0011UO\u001a4fe\u0016$'+Z1eKJDQA\u0011\u0001\u0005\n\r\u000bAA]3bIR\u0019AIU*\u0011\u0007-)u)\u0003\u0002G\u0019\t)\u0011I\u001d:bsB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"A\u0013\u0007\u000e\u0003-S!\u0001\u0014\u0005\u0002\rq\u0012xn\u001c;?\u0013\tqE\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(\r\u0011\u0015i\u0014\t1\u0001?\u0011\u001d!\u0016\t%AA\u0002U\u000bQ\u0002[8x\u001b\u0006t\u0017\u0010V8lK:\u001c\bCA\u0006W\u0013\t9FBA\u0002J]RDQ\u0001\t\u0001\u0005\u0002e#2A\t.]\u0011\u0015Y\u0006\f1\u0001H\u0003\u0005\u0019\bbB/Y!\u0003\u0005\raR\u0001\tK:\u001cw\u000eZ5oO\")q\f\u0001C\u0005A\u0006AAn\\1e)\u0016DH\u000fF\u0002HC\nDQ!\u00100A\u0002yBQa\u00190A\u0002U\u000b\u0011b\u00195be\u000e{WO\u001c;\t\u000b\u0015\u0004A\u0011\u00024\u0002\u00191|\u0017\rZ*f]R,gnY3\u0015\u0005\u001dT\u0007CA\u0012i\u0013\tIGE\u0001\u0005TK:$XM\\2f\u0011\u0015iD\r1\u0001?\u0011\u0015a\u0007\u0001\"\u0003n\u0003Aaw.\u00193EKB,g\u000eZ3oG&,7\u000fF\u0002oiV\u00042a\u001c:H\u001b\u0005\u0001(BA9\u0005\u0003\u0019\u0019HO];di&\u00111\u000f\u001d\u0002\u000e\t&\u0014Xm\u0019;fI\u001e\u0013\u0018\r\u001d5\t\u000buZ\u0007\u0019\u0001 \t\u000bY\\\u0007\u0019A+\u0002\u0005MT\b\"\u0002=\u0001\t\u0013I\u0018\u0001\u00042vM\u001a,'o\u00149uS>tWc\u0001>\u0002\u0006Q)10a\n\u0002<Q\u0019A0a\u0006\u0011\u0007-ix0\u0003\u0002\u007f\u0019\t1q\n\u001d;j_:\u0004BaC#\u0002\u0002A!\u00111AA\u0003\u0019\u0001!q!a\u0002x\u0005\u0004\tIAA\u0001U#\u0011\tY!!\u0005\u0011\u0007-\ti!C\u0002\u0002\u00101\u0011qAT8uQ&tw\rE\u0002\f\u0003'I1!!\u0006\r\u0005\r\te.\u001f\u0005\n\u000339\u0018\u0011!a\u0002\u00037\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\ti\"a\t\u0002\u00025\u0011\u0011q\u0004\u0006\u0004\u0003Ca\u0011a\u0002:fM2,7\r^\u0005\u0005\u0003K\tyB\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u001d\tIc\u001ea\u0001\u0003W\t\u0011A\u0019\t\u0007\u0003[\t9$!\u0001\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\tq!\\;uC\ndWMC\u0002\u000261\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI$a\f\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u0003{9\b\u0019AA \u0003\u001d\tG\u000e\u001c(jYN\u00042aCA!\u0013\r\t\u0019\u0005\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013\nAa]1wKR1\u00111JA)\u0003+\u00022aCA'\u0013\r\ty\u0005\u0004\u0002\u0005+:LG\u000fC\u0004\u0002T\u0005\u0015\u0003\u0019\u0001\u0012\u0002\u0007\u0011|7\r\u0003\u0005\u0002X\u0005\u0015\u0003\u0019AA-\u0003\ty7\u000fE\u0002,\u00037J1!!\u0018-\u0005-\u0001&/\u001b8u/JLG/\u001a:\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002bQA\u00111JA2\u0003K\n9\u0007C\u0004\u0002T\u0005}\u0003\u0019\u0001\u0012\t\u0011\u0005]\u0013q\fa\u0001\u00033B\u0001\"!\u001b\u0002`\u0001\u0007\u0011qH\u0001\tW\u0016,\u0007\u000fV3yi\"9\u0011q\t\u0001\u0005\u0002\u00055DcB$\u0002p\u0005E\u00141\u000f\u0005\b\u0003'\nY\u00071\u0001#\u0011!i\u00161\u000eI\u0001\u0002\u00049\u0005BCA5\u0003W\u0002\n\u00111\u0001\u0002@!9\u0011q\u000f\u0001\u0005\n\u0005e\u0014\u0001D:bm\u0016\u001cVM\u001c;f]\u000e,GCBA&\u0003w\ny\bC\u0004\u0002~\u0005U\u0004\u0019A4\u0002\tM,g\u000e\u001e\u0005\t\u0003/\n)\b1\u0001\u0002Z!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0015\u0001C:bm\u0016$&/Z3\u0015\r\u0005-\u0013qQAI\u0011!\tI)!!A\u0002\u0005-\u0015\u0001\u0002;sK\u0016\u00042a\\AG\u0013\r\ty\t\u001d\u0002\u0005)J,W\r\u0003\u0005\u0002X\u0005\u0005\u0005\u0019AA-\u0011\u001d\t)\n\u0001C\u0005\u0003/\u000b\u0001\u0002\\8bIR\u0013X-\u001a\u000b\u0007\u0003\u0017\u000bI*!(\t\u000f\u0005m\u00151\u0013a\u0001\t\u0006!!-\u001b;t\u0011!\ty*a%A\u0002\u0005\u0005\u0016\u0001\u00039pg&$\u0018n\u001c8\u0011\t=\f\u0019+V\u0005\u0004\u0003K\u0003(!D'vi\u0006\u0014G.\u001a(v[\n,'\u000fC\u0004\u0002*\u0002!I!a+\u0002\u0013M\fg/\u001a+pW\u0016tG\u0003CA&\u0003[\u000by+a-\t\u000f\u0005u\u0014q\u0015a\u0001O\"9\u0011\u0011WAT\u0001\u0004)\u0016AB8gMN,G\u000f\u0003\u0005\u0002X\u0005\u001d\u0006\u0019AA-\u0011\u001d\t9\f\u0001C\u0005\u0003s\u000b\u0001c]1wK\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\u0011\u0005-\u00131XA`\u0003\u0007Dq!!0\u00026\u0002\u0007a.\u0001\u0002eO\"9\u0011\u0011YA[\u0001\u00049\u0015A\u00043fa\u0016tG-\u001a8dsRK\b/\u001a\u0005\t\u0003/\n)\f1\u0001\u0002Z!9\u0011q\u0019\u0001\u0005\n\u0005%\u0017!\u00047pC\u0012$\u0015n]2pkJ\u001cX\r\u0006\u0003\u0002L\u0006m\u0007\u0003BAg\u0003/l!!a4\u000b\t\u0005E\u00171[\u0001\neN$\b/\u0019:tKJT1!!6\u0005\u0003%!\u0017n]2pkJ\u001cX-\u0003\u0003\u0002Z\u0006='!\u0004#jg\u000e|WO]:f)J,W\r\u0003\u0004>\u0003\u000b\u0004\rA\u0010\u0005\b\u0003?\u0004A\u0011BAq\u00035\u0019\u0018M^3ESN\u001cw.\u001e:tKR1\u00111JAr\u0003OD\u0001\"!:\u0002^\u0002\u0007\u00111Z\u0001\u0002I\"A\u0011qKAo\u0001\u0004\tI\u0006C\u0004\u0002l\u0002!I!!<\u0002\u0013M\fg/Z\"pe\u00164GCBA&\u0003_\fI\u0010\u0003\u0005\u0002r\u0006%\b\u0019AAz\u0003\t\u0019w\rE\u0002p\u0003kL1!a>q\u0005-\u0019uN]3g\u0007\"\f\u0017N\\:\t\u0011\u0005]\u0013\u0011\u001ea\u0001\u00033Bq!!@\u0001\t\u0013\ty0A\u0005m_\u0006$7i\u001c:fMR1\u00111\u001fB\u0001\u0005\u0007Aa!PA~\u0001\u0004q\u0004b\u0002B\u0003\u0003w\u0004\r!V\u0001\r[\u0016tG/[8o\u0007>,h\u000e\u001e\u0005\n\u0005\u0013\u0001\u0011\u0013!C\u0001\u0005\u0017\ta\u0002\\8bI\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u000e)\u001aqIa\u0004,\u0005\tE\u0001\u0003\u0002B\n\u0005;i!A!\u0006\u000b\t\t]!\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0007\r\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005?\u0011)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba\t\u0001#\u0003%IA!\n\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0005\u0016\u0004+\n=\u0001\"\u0003B\u0016\u0001E\u0005I\u0011\u0001B\u0006\u00039\u0019\u0018M^3%I\u00164\u0017-\u001e7uIIB\u0011Ba\f\u0001#\u0003%\tA!\r\u0002\u001dM\fg/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0007\u0016\u0005\u0003\u007f\u0011yaB\u0004\u00038\tA\tA!\u000f\u0002%\u0011{7-^7f]R\u001cVM]5bY&TXM\u001d\t\u0004=\tmbAB\u0001\u0003\u0011\u0003\u0011idE\u0002\u0003<)Aqa\u0007B\u001e\t\u0003\u0011\t\u0005\u0006\u0002\u0003:!Q!Q\tB\u001e\u0005\u0004%\tBa\u0012\u0002;=\u001bv,\u0013(E\u000bB+e\nR#O)~c\u0015JT#`'\u0016\u0003\u0016IU!U\u001fJ+\"A!\u0013\u0011\t\t-#\u0011K\u0007\u0003\u0005\u001bR1Aa\u0014/\u0003\u0011a\u0017M\\4\n\u0007A\u0013i\u0005C\u0005\u0003V\tm\u0002\u0015!\u0003\u0003J\u0005qrjU0J\u001d\u0012+\u0005+\u0012(E\u000b:#v\fT%O\u000b~\u001bV\tU!S\u0003R{%\u000b\t\u0005\u000b\u00053\u0012YD1A\u0005\u0002\t\u001d\u0013a\u0001(J\u0019\"I!Q\fB\u001eA\u0003%!\u0011J\u0001\u0005\u001d&c\u0005\u0005\u0003\u0006\u0003b\tm\"\u0019!C\u0001\u0005\u000f\n1aU#Q\u0011%\u0011)Ga\u000f!\u0002\u0013\u0011I%\u0001\u0003T\u000bB\u0003\u0003B\u0003B5\u0005w\u0011\r\u0011\"\u0001\u0003H\u0005y1\u000bV!S)~\u001bVI\u0014+F\u001d\u000e+5\u000bC\u0005\u0003n\tm\u0002\u0015!\u0003\u0003J\u0005\u00012\u000bV!S)~\u001bVI\u0014+F\u001d\u000e+5\u000b\t\u0005\u000b\u0005c\u0012YD1A\u0005\u0002\t\u001d\u0013AC*U\u0003J#v\fV#Y)\"I!Q\u000fB\u001eA\u0003%!\u0011J\u0001\f'R\u000b%\u000bV0U\u000bb#\u0006\u0005\u0003\u0006\u0003z\tm\"\u0019!C\u0001\u0005\u000f\nAb\u0015+B%R{FkT&F\u001dNC\u0011B! \u0003<\u0001\u0006IA!\u0013\u0002\u001bM#\u0016I\u0015+`)>[UIT*!\u0011)\u0011\tIa\u000fC\u0002\u0013\u0005!qI\u0001\f'R\u000b%\u000bV0D\u001fJ+e\tC\u0005\u0003\u0006\nm\u0002\u0015!\u0003\u0003J\u0005a1\u000bV!S)~\u001buJU#GA!Q!\u0011\u0012B\u001e\u0005\u0004%\tAa\u0012\u0002%M#\u0016I\u0015+`\t\u0016\u0003VI\u0014#F\u001d\u000eKUi\u0015\u0005\n\u0005\u001b\u0013Y\u0004)A\u0005\u0005\u0013\n1c\u0015+B%R{F)\u0012)F\u001d\u0012+ejQ%F'\u0002B!B!%\u0003<\t\u0007I\u0011\u0001B$\u0003I\u0019F+\u0011*U?\u000e{ej\u0015+J)V+e\nV*\t\u0013\tU%1\bQ\u0001\n\t%\u0013aE*U\u0003J#vlQ(O'RKE+V#O)N\u0003\u0003B\u0003BM\u0005w\u0011\r\u0011\"\u0001\u0003H\u0005y1\u000bV!S)~#\u0015jU\"P+J\u001bV\tC\u0005\u0003\u001e\nm\u0002\u0015!\u0003\u0003J\u0005\u00012\u000bV!S)~#\u0015jU\"P+J\u001bV\t\t\u0005\u000b\u0005C\u0013YD1A\u0005\u0002\t\u001d\u0013aD#O\t~{eiX*F\u001dR+ejQ#\t\u0013\t\u0015&1\bQ\u0001\n\t%\u0013\u0001E#O\t~{eiX*F\u001dR+ejQ#!\u0011)\u0011IKa\u000fC\u0002\u0013\u0005!qI\u0001\u0010\u000b:#ul\u0014$`\t>\u001bU+T#O)\"I!Q\u0016B\u001eA\u0003%!\u0011J\u0001\u0011\u000b:#ul\u0014$`\t>\u001bU+T#O)\u0002B!B!-\u0003<\t\u0007I\u0011\u0001B$\u0003M)e\nR0P\r~#U\tU#O\t\u0016s5)S#T\u0011%\u0011)La\u000f!\u0002\u0013\u0011I%\u0001\u000bF\u001d\u0012{vJR0E\u000bB+e\nR#O\u0007&+5\u000b\t")
public class DocumentSerializer
implements LazyLogging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public static String END_OF_DEPENDENCIES() {
        return DocumentSerializer$.MODULE$.END_OF_DEPENDENCIES();
    }

    public static String END_OF_DOCUMENT() {
        return DocumentSerializer$.MODULE$.END_OF_DOCUMENT();
    }

    public static String END_OF_SENTENCE() {
        return DocumentSerializer$.MODULE$.END_OF_SENTENCE();
    }

    public static String START_DISCOURSE() {
        return DocumentSerializer$.MODULE$.START_DISCOURSE();
    }

    public static String START_CONSTITUENTS() {
        return DocumentSerializer$.MODULE$.START_CONSTITUENTS();
    }

    public static String START_DEPENDENCIES() {
        return DocumentSerializer$.MODULE$.START_DEPENDENCIES();
    }

    public static String START_COREF() {
        return DocumentSerializer$.MODULE$.START_COREF();
    }

    public static String START_TOKENS() {
        return DocumentSerializer$.MODULE$.START_TOKENS();
    }

    public static String START_TEXT() {
        return DocumentSerializer$.MODULE$.START_TEXT();
    }

    public static String START_SENTENCES() {
        return DocumentSerializer$.MODULE$.START_SENTENCES();
    }

    public static String SEP() {
        return DocumentSerializer$.MODULE$.SEP();
    }

    public static String NIL() {
        return DocumentSerializer$.MODULE$.NIL();
    }

    public static String OS_INDEPENDENT_LINE_SEPARATOR() {
        return DocumentSerializer$.MODULE$.OS_INDEPENDENT_LINE_SEPARATOR();
    }

    private Logger logger$lzycompute() {
        DocumentSerializer documentSerializer = this;
        synchronized (documentSerializer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Document load(InputStream is) {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        return this.load(r);
    }

    public Document load(BufferedReader r) {
        String string;
        String string2;
        ObjectRef bits = ObjectRef.create(null);
        try {
            bits.elem = this.read(r, this.read$default$2());
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (Exception e) {
            throw e;
        }
        String string3 = ((String[])bits.elem)[0];
        String string4 = DocumentSerializer$.MODULE$.START_SENTENCES();
        Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"START_SENTENCES expected, found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((String[])bits$1.elem)[0]})));
        int sentCount = new StringOps(Predef$.MODULE$.augmentString(((String[])bits.elem)[1])).toInt();
        ArrayBuffer sents = new ArrayBuffer();
        for (int offset = 0; offset < sentCount; ++offset) {
            sents.$plus$eq((Object)this.loadSentence(r));
        }
        None$ coref = None$.MODULE$;
        do {
            bits.elem = this.read(r, this.read$default$2());
            String string5 = ((String[])bits.elem)[0];
            String string6 = DocumentSerializer$.MODULE$.START_COREF();
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                coref = new Some((Object)this.loadCoref(r, new StringOps(Predef$.MODULE$.augmentString(((String[])bits.elem)[1])).toInt()));
            }
            String string7 = ((String[])bits.elem)[0];
            String string8 = DocumentSerializer$.MODULE$.END_OF_DOCUMENT();
            if (!(string7 == null ? string8 != null : !string7.equals(string8))) break;
            String string9 = ((String[])bits.elem)[0];
            String string10 = DocumentSerializer$.MODULE$.START_DISCOURSE();
            if (!(string9 == null ? string10 != null : !string9.equals(string10))) break;
            string2 = ((String[])bits.elem)[0];
            string = DocumentSerializer$.MODULE$.START_TEXT();
        } while (string2 == null ? string != null : !string2.equals(string));
        None$ discourse = None$.MODULE$;
        String string11 = ((String[])bits.elem)[0];
        String string12 = DocumentSerializer$.MODULE$.START_DISCOURSE();
        if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
            discourse = new Some((Object)this.loadDiscourse(r));
            bits.elem = this.read(r, this.read$default$2());
        }
        None$ text = None$.MODULE$;
        String string13 = ((String[])bits.elem)[0];
        String string14 = DocumentSerializer$.MODULE$.START_TEXT();
        if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
            if (((String[])bits.elem).length != 2) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: Missing text length in start text line: "})).s((Seq)Nil$.MODULE$) + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])bits.elem))).mkString(" "));
            }
            int charCount = new StringOps(Predef$.MODULE$.augmentString(((String[])bits.elem)[1])).toInt();
            text = new Some((Object)this.loadText(r, charCount));
            bits.elem = this.read(r, this.read$default$2());
        }
        String string15 = ((String[])bits.elem)[0];
        String string16 = DocumentSerializer$.MODULE$.END_OF_DOCUMENT();
        Predef$.MODULE$.assert(!(string15 != null ? !string15.equals(string16) : string16 != null), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"END_OF_DOCUMENT expected, found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((String[])bits$1.elem)[0]})));
        Document doc = Document$.MODULE$.apply((Sentence[])sents.toArray(ClassTag$.MODULE$.apply(Sentence.class)));
        doc.coreferenceChains_$eq((Option<CorefChains>)coref);
        doc.discourseTree_$eq((Option<DiscourseTree>)discourse);
        doc.text_$eq((Option<String>)text);
        return doc;
    }

    private String[] read(BufferedReader r, int howManyTokens) {
        String line = r.readLine();
        if (line.length() == 0) {
            return new String[0];
        }
        return line.split(DocumentSerializer$.MODULE$.SEP(), howManyTokens);
    }

    private int read$default$2() {
        return 0;
    }

    public Document load(String s, String encoding) {
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes(encoding));
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        Document doc = this.load(r);
        r.close();
        return doc;
    }

    public String load$default$2() {
        return "UTF-8";
    }

    private String loadText(BufferedReader r, int charCount) {
        if (charCount < 1) {
            return "";
        }
        char[] buffer = new char[charCount];
        r.read(buffer, 0, charCount);
        r.skip(new StringOps(Predef$.MODULE$.augmentString(DocumentSerializer$.MODULE$.OS_INDEPENDENT_LINE_SEPARATOR())).size());
        return new String(buffer);
    }

    private Sentence loadSentence(BufferedReader r) {
        String string;
        String string2;
        ObjectRef bits = ObjectRef.create((Object)this.read(r, this.read$default$2()));
        String string3 = ((String[])bits.elem)[0];
        String string4 = DocumentSerializer$.MODULE$.START_TOKENS();
        Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"START_TOKENS expected, found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((String[])bits$2.elem)[0]})));
        int tokenCount = new StringOps(Predef$.MODULE$.augmentString(((String[])bits.elem)[1])).toInt();
        ArrayBuffer wordBuffer = new ArrayBuffer();
        ArrayBuffer startOffsetBuffer = new ArrayBuffer();
        ArrayBuffer endOffsetBuffer = new ArrayBuffer();
        ArrayBuffer tagBuffer = new ArrayBuffer();
        boolean nilTags = true;
        ArrayBuffer lemmaBuffer = new ArrayBuffer();
        boolean nilLemmas = true;
        ArrayBuffer entityBuffer = new ArrayBuffer();
        boolean nilEntities = true;
        ArrayBuffer normBuffer = new ArrayBuffer();
        boolean nilNorms = true;
        ArrayBuffer chunkBuffer = new ArrayBuffer();
        boolean nilChunks = true;
        for (int offset = 0; offset < tokenCount; ++offset) {
            bits.elem = this.read(r, this.read$default$2());
            if (((String[])bits.elem).length != 8) {
                throw new RuntimeException("ERROR: invalid line: " + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])bits.elem))).mkString(" "));
            }
            wordBuffer.$plus$eq((Object)((String[])bits.elem)[0]);
            startOffsetBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(((String[])bits.elem)[1])).toInt()));
            endOffsetBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(((String[])bits.elem)[2])).toInt()));
            tagBuffer.$plus$eq((Object)((String[])bits.elem)[3]);
            String string5 = ((String[])bits.elem)[3];
            String string6 = DocumentSerializer$.MODULE$.NIL();
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                nilTags = false;
            }
            lemmaBuffer.$plus$eq((Object)((String[])bits.elem)[4]);
            String string7 = ((String[])bits.elem)[4];
            String string8 = DocumentSerializer$.MODULE$.NIL();
            if (string7 == null ? string8 != null : !string7.equals(string8)) {
                nilLemmas = false;
            }
            entityBuffer.$plus$eq((Object)((String[])bits.elem)[5]);
            String string9 = ((String[])bits.elem)[5];
            String string10 = DocumentSerializer$.MODULE$.NIL();
            if (string9 == null ? string10 != null : !string9.equals(string10)) {
                nilEntities = false;
            }
            normBuffer.$plus$eq((Object)((String[])bits.elem)[6]);
            String string11 = ((String[])bits.elem)[6];
            String string12 = DocumentSerializer$.MODULE$.NIL();
            if (string11 == null ? string12 != null : !string11.equals(string12)) {
                nilNorms = false;
            }
            chunkBuffer.$plus$eq((Object)((String[])bits.elem)[7]);
            String string13 = ((String[])bits.elem)[7];
            String string14 = DocumentSerializer$.MODULE$.NIL();
            if (!(string13 == null ? string14 != null : !string13.equals(string14))) continue;
            nilChunks = false;
        }
        Predef$.MODULE$.assert(wordBuffer.size() == tokenCount);
        Predef$.MODULE$.assert(startOffsetBuffer.size() == tokenCount);
        Predef$.MODULE$.assert(endOffsetBuffer.size() == tokenCount);
        Predef$.MODULE$.assert(tagBuffer.isEmpty() || tagBuffer.size() == tokenCount);
        Predef$.MODULE$.assert(lemmaBuffer.isEmpty() || lemmaBuffer.size() == tokenCount);
        Predef$.MODULE$.assert(entityBuffer.isEmpty() || entityBuffer.size() == tokenCount);
        Predef$.MODULE$.assert(normBuffer.isEmpty() || normBuffer.size() == tokenCount);
        Predef$.MODULE$.assert(chunkBuffer.isEmpty() || chunkBuffer.size() == tokenCount);
        GraphMap deps = new GraphMap();
        None$ tree = None$.MODULE$;
        do {
            BoxedUnit boxedUnit;
            bits.elem = this.read(r, this.read$default$2());
            String string15 = ((String[])bits.elem)[0];
            String string16 = DocumentSerializer$.MODULE$.START_DEPENDENCIES();
            if (!(string15 != null ? !string15.equals(string16) : string16 != null)) {
                String dt = ((String[])bits.elem)[1];
                int sz = new StringOps(Predef$.MODULE$.augmentString(((String[])bits.elem)[2])).toInt();
                DirectedGraph<String> d = this.loadDependencies(r, sz);
                boxedUnit = deps.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dt), d));
            } else {
                String string17 = ((String[])bits.elem)[0];
                String string18 = DocumentSerializer$.MODULE$.START_CONSTITUENTS();
                if (!(string17 != null ? !string17.equals(string18) : string18 != null)) {
                    MutableNumber<Object> position = new MutableNumber<Object>(BoxesRunTime.boxToInteger((int)0));
                    bits.elem = this.read(r, this.read$default$2());
                    tree = new Some((Object)this.loadTree((String[])bits.elem, position));
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            string2 = ((String[])bits.elem)[0];
            string = DocumentSerializer$.MODULE$.END_OF_SENTENCE();
        } while (string2 == null ? string != null : !string2.equals(string));
        return Sentence$.MODULE$.apply((String[])wordBuffer.toArray(ClassTag$.MODULE$.apply(String.class)), (int[])startOffsetBuffer.toArray(ClassTag$.MODULE$.Int()), (int[])endOffsetBuffer.toArray(ClassTag$.MODULE$.Int()), this.bufferOption(tagBuffer, nilTags, ClassTag$.MODULE$.apply(String.class)), this.bufferOption(lemmaBuffer, nilLemmas, ClassTag$.MODULE$.apply(String.class)), this.bufferOption(entityBuffer, nilEntities, ClassTag$.MODULE$.apply(String.class)), this.bufferOption(normBuffer, nilNorms, ClassTag$.MODULE$.apply(String.class)), this.bufferOption(chunkBuffer, nilChunks, ClassTag$.MODULE$.apply(String.class)), (Option<Tree>)tree, deps);
    }

    private DirectedGraph<String> loadDependencies(BufferedReader r, int sz) {
        String string;
        String string2;
        ListBuffer edges = new ListBuffer();
        HashSet roots = new HashSet();
        String[] bits = this.read(r, this.read$default$2());
        for (int offset = 0; offset < bits.length; ++offset) {
            roots.add((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(bits[offset])).toInt()));
        }
        do {
            BoxedUnit boxedUnit;
            bits = this.read(r, this.read$default$2());
            String string3 = bits[0];
            String string4 = DocumentSerializer$.MODULE$.END_OF_DEPENDENCIES();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                Edge<String> edge = new Edge<String>(new StringOps(Predef$.MODULE$.augmentString(bits[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(bits[1])).toInt(), bits[2]);
                boxedUnit = edges.$plus$eq(edge);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            string2 = bits[0];
            string = DocumentSerializer$.MODULE$.END_OF_DEPENDENCIES();
        } while (string2 == null ? string != null : !string2.equals(string));
        DirectedGraph<String> dg = new DirectedGraph<String>(edges.toList(), (Set<Object>)roots.toSet());
        return dg;
    }

    private <T> Option<Object> bufferOption(ArrayBuffer<T> b, boolean allNils, ClassTag<T> evidence$1) {
        if (b.isEmpty()) {
            return None$.MODULE$;
        }
        if (allNils) {
            return None$.MODULE$;
        }
        return new Some(b.toArray(evidence$1));
    }

    public void save(Document doc, PrintWriter os) {
        this.save(doc, os, false);
    }

    public void save(Document doc, PrintWriter os, boolean keepText) {
        int txtLen;
        os.println(DocumentSerializer$.MODULE$.START_SENTENCES() + DocumentSerializer$.MODULE$.SEP() + doc.sentences().length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)s -> {
            this.saveSentence(s, os);
            return BoxedUnit.UNIT;
        });
        if (doc.coreferenceChains().nonEmpty()) {
            int mentionCount = ((CorefChains)doc.coreferenceChains().get()).getMentions().size();
            os.println(DocumentSerializer$.MODULE$.START_COREF() + DocumentSerializer$.MODULE$.SEP() + mentionCount);
            doc.coreferenceChains().foreach((Function1 & Serializable & scala.Serializable)g -> {
                this.saveCoref(g, os);
                return BoxedUnit.UNIT;
            });
        }
        if (doc.discourseTree().nonEmpty()) {
            os.println(DocumentSerializer$.MODULE$.START_DISCOURSE());
            doc.discourseTree().foreach((Function1 & Serializable & scala.Serializable)d -> {
                this.saveDiscourse(d, os);
                return BoxedUnit.UNIT;
            });
        }
        if (keepText && doc.text().nonEmpty() && (txtLen = ((String)doc.text().get()).length()) > 0) {
            os.println(DocumentSerializer$.MODULE$.START_TEXT() + DocumentSerializer$.MODULE$.SEP() + txtLen);
            os.print((String)doc.text().get());
            os.print(DocumentSerializer$.MODULE$.OS_INDEPENDENT_LINE_SEPARATOR());
        }
        os.println(DocumentSerializer$.MODULE$.END_OF_DOCUMENT());
    }

    public String save(Document doc, String encoding, boolean keepText) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        PrintWriter os = new PrintWriter(byteOutput);
        this.save(doc, os, keepText);
        os.flush();
        os.close();
        byteOutput.close();
        return byteOutput.toString(encoding);
    }

    public String save$default$2() {
        return "UTF-8";
    }

    public boolean save$default$3() {
        return false;
    }

    private void saveSentence(Sentence sent, PrintWriter os) {
        os.println(DocumentSerializer$.MODULE$.START_TOKENS() + DocumentSerializer$.MODULE$.SEP() + sent.size());
        for (int offset = 0; offset < sent.size(); ++offset) {
            this.saveToken(sent, offset, os);
        }
        if (sent.graphs().nonEmpty()) {
            sent.graphs().keySet().foreach((Function1 & Serializable & scala.Serializable)t -> {
                this.saveDependencies((DirectedGraph)sent.graphs().get(t).get(), t, os);
                return BoxedUnit.UNIT;
            });
        }
        if (sent.syntacticTree().nonEmpty()) {
            os.println(DocumentSerializer$.MODULE$.START_CONSTITUENTS() + DocumentSerializer$.MODULE$.SEP() + "1");
            sent.syntacticTree().foreach((Function1 & Serializable & scala.Serializable)t -> {
                DocumentSerializer.$anonfun$saveSentence$2(this, os, t);
                return BoxedUnit.UNIT;
            });
        }
        os.println(DocumentSerializer$.MODULE$.END_OF_SENTENCE());
    }

    private void saveTree(Tree tree, PrintWriter os) {
        block2: {
            os.print(tree.value() + DocumentSerializer$.MODULE$.SEP() + tree.head() + DocumentSerializer$.MODULE$.SEP() + tree.startOffset() + DocumentSerializer$.MODULE$.SEP() + tree.endOffset() + DocumentSerializer$.MODULE$.SEP());
            if (tree.children().isEmpty()) {
                os.print(0);
            } else {
                os.print(((Tree[])tree.children().get()).length);
            }
            if (tree.isLeaf()) break block2;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tree.children().get())).foreach((Function1 & Serializable & scala.Serializable)c -> {
                DocumentSerializer.$anonfun$saveTree$1(this, os, c);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Tree loadTree(String[] bits, MutableNumber<Object> position) {
        String value = bits[BoxesRunTime.unboxToInt((Object)position.value())];
        int head = new StringOps(Predef$.MODULE$.augmentString(bits[BoxesRunTime.unboxToInt((Object)position.value()) + 1])).toInt();
        int startOffset = new StringOps(Predef$.MODULE$.augmentString(bits[BoxesRunTime.unboxToInt((Object)position.value()) + 2])).toInt();
        int endOffset = new StringOps(Predef$.MODULE$.augmentString(bits[BoxesRunTime.unboxToInt((Object)position.value()) + 3])).toInt();
        int numChildren = new StringOps(Predef$.MODULE$.augmentString(bits[BoxesRunTime.unboxToInt((Object)position.value()) + 4])).toInt();
        position.value_$eq(BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)position.value()) + 5)));
        if (numChildren == 0) {
            Terminal t = new Terminal(value);
            t.setIndex(startOffset);
            return t;
        }
        Tree[] children = new Tree[numChildren];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numChildren).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            children$1[i] = this.loadTree(bits, position);
        });
        NonTerminal n = new NonTerminal(value, children);
        n.setStartEndIndices(startOffset, endOffset);
        n.setHead(head);
        return n;
    }

    private void saveToken(Sentence sent, int offset, PrintWriter os) {
        os.print(sent.words()[offset] + DocumentSerializer$.MODULE$.SEP() + sent.startOffsets()[offset] + DocumentSerializer$.MODULE$.SEP() + sent.endOffsets()[offset]);
        os.print(DocumentSerializer$.MODULE$.SEP());
        if (sent.tags().isDefined()) {
            os.print(((String[])sent.tags().get())[offset]);
        } else {
            os.print(DocumentSerializer$.MODULE$.NIL());
        }
        os.print(DocumentSerializer$.MODULE$.SEP());
        if (sent.lemmas().isDefined()) {
            os.print(((String[])sent.lemmas().get())[offset]);
        } else {
            os.print(DocumentSerializer$.MODULE$.NIL());
        }
        os.print(DocumentSerializer$.MODULE$.SEP());
        if (sent.entities().isDefined()) {
            os.print(((String[])sent.entities().get())[offset]);
        } else {
            os.print(DocumentSerializer$.MODULE$.NIL());
        }
        os.print(DocumentSerializer$.MODULE$.SEP());
        if (sent.norms().isDefined()) {
            os.print(((String[])sent.norms().get())[offset]);
        } else {
            os.print(DocumentSerializer$.MODULE$.NIL());
        }
        os.print(DocumentSerializer$.MODULE$.SEP());
        if (sent.chunks().isDefined()) {
            os.print(((String[])sent.chunks().get())[offset]);
        } else {
            os.print(DocumentSerializer$.MODULE$.NIL());
        }
        os.println();
    }

    private void saveDependencies(DirectedGraph<String> dg, String dependencyType, PrintWriter os) {
        os.println(DocumentSerializer$.MODULE$.START_DEPENDENCIES() + DocumentSerializer$.MODULE$.SEP() + dependencyType + DocumentSerializer$.MODULE$.SEP() + dg.size());
        os.println(dg.roots().mkString(DocumentSerializer$.MODULE$.SEP()));
        DirectedGraphEdgeIterator<String> it = new DirectedGraphEdgeIterator<String>(dg);
        while (it.hasNext()) {
            Tuple3<Object, Object, String> edge = it.next();
            os.println(BoxesRunTime.unboxToInt((Object)edge._1()) + DocumentSerializer$.MODULE$.SEP() + edge._2() + DocumentSerializer$.MODULE$.SEP() + edge._3());
        }
        os.println(DocumentSerializer$.MODULE$.END_OF_DEPENDENCIES());
    }

    private DiscourseTree loadDiscourse(BufferedReader r) {
        DiscourseTree[] discourseTreeArray;
        int childrenCount;
        Enumeration.Value value;
        String[] bits = this.read(r, 12);
        if (bits.length != 12) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: found ", " tokens in invalid discourse tree line: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bits.length)})) + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bits)).mkString(" "));
        }
        String string = bits[0];
        String string2 = "nil".equals(string) ? "" : bits[0];
        String label = string2;
        String string3 = bits[1];
        if ("LeftToRight".equals(string3)) {
            value = RelationDirection$.MODULE$.LeftToRight();
        } else if ("RightToLeft".equals(string3)) {
            value = RelationDirection$.MODULE$.RightToLeft();
        } else if ("None".equals(string3)) {
            value = RelationDirection$.MODULE$.None();
        } else {
            throw new RuntimeException("ERROR: unknown relation direction " + bits[1]);
        }
        Enumeration.Value dir = value;
        Tuple2.mcII.sp charOffsets = new Tuple2.mcII.sp(new StringOps(Predef$.MODULE$.augmentString(bits[2])).toInt(), new StringOps(Predef$.MODULE$.augmentString(bits[3])).toInt());
        TokenOffset firstToken = new TokenOffset(new StringOps(Predef$.MODULE$.augmentString(bits[4])).toInt(), new StringOps(Predef$.MODULE$.augmentString(bits[5])).toInt());
        TokenOffset lastToken = new TokenOffset(new StringOps(Predef$.MODULE$.augmentString(bits[6])).toInt(), new StringOps(Predef$.MODULE$.augmentString(bits[7])).toInt());
        int firstEDU = new StringOps(Predef$.MODULE$.augmentString(bits[8])).toInt();
        int lastEDU = new StringOps(Predef$.MODULE$.augmentString(bits[9])).toInt();
        int n = childrenCount = new StringOps(Predef$.MODULE$.augmentString(bits[10])).toInt();
        switch (n) {
            case 0: {
                discourseTreeArray = null;
                break;
            }
            default: {
                discourseTreeArray = new DiscourseTree[childrenCount];
                break;
            }
        }
        DiscourseTree[] children = discourseTreeArray;
        String string4 = bits[11];
        String string5 = "nil".equals(string4) ? null : bits[11];
        String text = string5;
        DiscourseTree d = new DiscourseTree(label, dir, children, TreeKind$.MODULE$.Nucleus(), text, (Tuple2<Object, Object>)charOffsets, firstToken, lastToken, firstEDU, lastEDU);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), childrenCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            d$1.children()[i] = this.loadDiscourse(r);
        });
        return d;
    }

    private void saveDiscourse(DiscourseTree d, PrintWriter os) {
        block3: {
            String text;
            String label;
            int childrenCount = 0;
            if (!d.isTerminal()) {
                childrenCount = d.children().length;
            }
            String string = label = d.relationLabel();
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                label = "nil";
            }
            if ((text = d.rawText()) == null) {
                text = "nil";
            }
            os.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label, d.relationDirection(), BoxesRunTime.boxToInteger((int)d.charOffsets()._1$mcI$sp()), BoxesRunTime.boxToInteger((int)d.charOffsets()._2$mcI$sp()), BoxesRunTime.boxToInteger((int)d.firstToken().sentence()), BoxesRunTime.boxToInteger((int)d.firstToken().token()), BoxesRunTime.boxToInteger((int)d.lastToken().sentence()), BoxesRunTime.boxToInteger((int)d.lastToken().token()), BoxesRunTime.boxToInteger((int)d.firstEDU()), BoxesRunTime.boxToInteger((int)d.lastEDU()), BoxesRunTime.boxToInteger((int)childrenCount), text})));
            if (childrenCount <= 0) break block3;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])d.children())).foreach((Function1 & Serializable & scala.Serializable)c -> {
                this.saveDiscourse(c, os);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void saveCoref(CorefChains cg, PrintWriter os) {
        Iterable<CorefMention> mentions = cg.getMentions();
        mentions.foreach((Function1 & Serializable & scala.Serializable)m -> {
            os.println(m.sentenceIndex() + DocumentSerializer$.MODULE$.SEP() + m.headIndex() + DocumentSerializer$.MODULE$.SEP() + m.startOffset() + DocumentSerializer$.MODULE$.SEP() + m.endOffset() + DocumentSerializer$.MODULE$.SEP() + m.chainId());
            return BoxedUnit.UNIT;
        });
    }

    private CorefChains loadCoref(BufferedReader r, int mentionCount) {
        ListBuffer mb = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mentionCount).foreach((Function1 & Serializable & scala.Serializable)i -> DocumentSerializer.$anonfun$loadCoref$1(this, r, mb, BoxesRunTime.unboxToInt((Object)i)));
        return new CorefChains((Iterable<CorefMention>)mb.toList());
    }

    public static final /* synthetic */ void $anonfun$saveSentence$2(DocumentSerializer $this, PrintWriter os$2, Tree t) {
        $this.saveTree(t, os$2);
        os$2.println();
    }

    public static final /* synthetic */ void $anonfun$saveTree$1(DocumentSerializer $this, PrintWriter os$5, Tree c) {
        os$5.print(DocumentSerializer$.MODULE$.SEP());
        $this.saveTree(c, os$5);
    }

    public static final /* synthetic */ ListBuffer $anonfun$loadCoref$1(DocumentSerializer $this, BufferedReader r$1, ListBuffer mb$1, int i) {
        String[] bits = $this.read(r$1, $this.read$default$2());
        return mb$1.$plus$eq((Object)new CorefMention(new StringOps(Predef$.MODULE$.augmentString(bits[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(bits[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(bits[2])).toInt(), new StringOps(Predef$.MODULE$.augmentString(bits[3])).toInt(), new StringOps(Predef$.MODULE$.augmentString(bits[4])).toInt()));
    }

    public DocumentSerializer() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

