/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.swirl2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import org.clulab.processors.Document;
import org.clulab.processors.Sentence;
import org.clulab.struct.DirectedGraph;
import org.clulab.struct.Edge;
import org.clulab.swirl2.ArgumentClassifier;
import org.clulab.swirl2.ArgumentClassifier$;
import org.clulab.swirl2.PredicateClassifier;
import org.clulab.swirl2.Reader;
import org.clulab.swirl2.SRL$;
import org.clulab.swirl2.ValidCandidate$;
import org.clulab.utils.Files$;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001%\u00111a\u0015*M\u0015\t\u0019A!\u0001\u0004to&\u0014HN\r\u0006\u0003\u000b\u0019\taa\u00197vY\u0006\u0014'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\rC\u0003\u0012\u0001\u0011\u0005!#\u0001\u0004=S:LGO\u0010\u000b\u0002'A\u0011A\u0003A\u0007\u0002\u0005!9a\u0003\u0001a\u0001\n\u00039\u0012A\u00049sK\u0012\u001cE.Y:tS\u001aLWM]\u000b\u00021A\u00191\"G\u000e\n\u0005ia!AB(qi&|g\u000e\u0005\u0002\u00159%\u0011QD\u0001\u0002\u0014!J,G-[2bi\u0016\u001cE.Y:tS\u001aLWM\u001d\u0005\b?\u0001\u0001\r\u0011\"\u0001!\u0003I\u0001(/\u001a3DY\u0006\u001c8/\u001b4jKJ|F%Z9\u0015\u0005\u0005\"\u0003CA\u0006#\u0013\t\u0019CB\u0001\u0003V]&$\bbB\u0013\u001f\u0003\u0003\u0005\r\u0001G\u0001\u0004q\u0012\n\u0004BB\u0014\u0001A\u0003&\u0001$A\bqe\u0016$7\t\\1tg&4\u0017.\u001a:!\u0011\u001dI\u0003\u00011A\u0005\u0002)\nQ\"\u0019:h\u00072\f7o]5gS\u0016\u0014X#A\u0016\u0011\u0007-IB\u0006\u0005\u0002\u0015[%\u0011aF\u0001\u0002\u0013\u0003J<W/\\3oi\u000ec\u0017m]:jM&,'\u000fC\u00041\u0001\u0001\u0007I\u0011A\u0019\u0002#\u0005\u0014xm\u00117bgNLg-[3s?\u0012*\u0017\u000f\u0006\u0002\"e!9QeLA\u0001\u0002\u0004Y\u0003B\u0002\u001b\u0001A\u0003&1&\u0001\bbe\u001e\u001cE.Y:tS\u001aLWM\u001d\u0011\t\u000bY\u0002A\u0011A\u001c\u0002\rM\fg/\u001a+p)\t\t\u0003\bC\u0003:k\u0001\u0007!(A\u0001x!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0002j_*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u00199&/\u001b;fe\")1\t\u0001C\u0001\t\u0006yAO]1og\u001a,'oQ8oi\u0016tG\u000fF\u0002\"\u000b*CQA\u0012\"A\u0002\u001d\u000b\u0001B\u001a:p[\u001aKG.\u001a\t\u0003w!K!!\u0013\u001f\u0003\t\u0019KG.\u001a\u0005\u0006\u0017\n\u0003\r\u0001T\u0001\u0003i>\u0004\"aO'\n\u00059c$a\u0003)sS:$xK]5uKJDQ\u0001\u0015\u0001\u0005\u0002E\u000bQ\u0001\u001e:bS:$\"!\t*\t\u000bM{\u0005\u0019\u0001+\u0002\u0013Q\u0014\u0018-\u001b8QCRD\u0007CA+]\u001d\t1&\f\u0005\u0002X\u00195\t\u0001L\u0003\u0002Z\u0011\u00051AH]8pizJ!a\u0017\u0007\u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u000372AQ\u0001\u0019\u0001\u0005\u0002\u0005\fA\u0001^3tiR\u0011\u0011E\u0019\u0005\u0006G~\u0003\r\u0001V\u0001\ti\u0016\u001cH\u000fU1uQ\")Q\r\u0001C\u0001M\u0006\u00012\r\\1tg&4\u0017pU3oi\u0016t7-\u001a\u000b\u0003O6\u00042\u0001[6U\u001b\u0005I'B\u00016\u0005\u0003\u0019\u0019HO];di&\u0011A.\u001b\u0002\u000e\t&\u0014Xm\u0019;fI\u001e\u0013\u0018\r\u001d5\t\u000b9$\u0007\u0019A8\u0002\u0011M,g\u000e^3oG\u0016\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0003\u0002\u0015A\u0014xnY3tg>\u00148/\u0003\u0002uc\nA1+\u001a8uK:\u001cW\rC\u0003w\u0001\u0011\u0005q/A\u0003tG>\u0014X\r\u0006\u0002\"q\")\u00110\u001ea\u0001u\u00061q.\u001e;qkR\u0004Ra_A\u0001\u0003\u000fq!\u0001 @\u000f\u0005]k\u0018\"A\u0007\n\u0005}d\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\t)A\u0001\u0003MSN$(BA@\r!\u0015Y\u0011\u0011B4h\u0013\r\tY\u0001\u0004\u0002\u0007)V\u0004H.\u001a\u001a\b\u000f\u0005=!\u0001#\u0001\u0002\u0012\u0005\u00191K\u0015'\u0011\u0007Q\t\u0019B\u0002\u0004\u0002\u0005!\u0005\u0011QC\n\u0004\u0003'Q\u0001bB\t\u0002\u0014\u0011\u0005\u0011\u0011\u0004\u000b\u0003\u0003#A!\"!\b\u0002\u0014\t\u0007I\u0011AA\u0010\u0003\u0019awnZ4feV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005\u0004\u0002\u000bMdg\r\u000e6\n\t\u0005-\u0012Q\u0005\u0002\u0007\u0019><w-\u001a:\t\u0013\u0005=\u00121\u0003Q\u0001\n\u0005\u0005\u0012a\u00027pO\u001e,'\u000f\t\u0005\t\u0003g\t\u0019\u0002\"\u0001\u00026\u0005!Q.Y5o)\r\t\u0013q\u0007\u0005\t\u0003s\t\t\u00041\u0001\u0002<\u0005!\u0011M]4t!\u0011Y\u0011Q\b+\n\u0007\u0005}BBA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0002D\u0005MA\u0011AA#\u0003!aw.\u00193Ge>lGcA\n\u0002H!A\u0011\u0011JA!\u0001\u0004\tY%A\u0001s!\rY\u0014QJ\u0005\u0004\u0003\u001fb$A\u0002*fC\u0012,'\u000f")
public class SRL {
    private Option<PredicateClassifier> predClassifier = None$.MODULE$;
    private Option<ArgumentClassifier> argClassifier = None$.MODULE$;

    public static SRL loadFrom(java.io.Reader reader) {
        return SRL$.MODULE$.loadFrom(reader);
    }

    public static void main(String[] stringArray) {
        SRL$.MODULE$.main(stringArray);
    }

    public static Logger logger() {
        return SRL$.MODULE$.logger();
    }

    public Option<PredicateClassifier> predClassifier() {
        return this.predClassifier;
    }

    public void predClassifier_$eq(Option<PredicateClassifier> x$1) {
        this.predClassifier = x$1;
    }

    public Option<ArgumentClassifier> argClassifier() {
        return this.argClassifier;
    }

    public void argClassifier_$eq(Option<ArgumentClassifier> x$1) {
        this.argClassifier = x$1;
    }

    public void saveTo(Writer w) {
        PrintWriter pw = Files$.MODULE$.toPrintWriter(w);
        File predFile = File.createTempFile("tmp_pc", ".dat");
        SRL$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Saving the predicate classifier to ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{predFile.getAbsolutePath()})));
        PrintWriter predWriter = new PrintWriter(new BufferedWriter(new FileWriter(predFile)));
        this.predClassifier().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.saveTo(predWriter);
            return BoxedUnit.UNIT;
        });
        predWriter.close();
        this.transferContent(predFile, pw);
        predFile.delete();
        File argFile = File.createTempFile("tmp_ac", ".dat");
        SRL$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Saving the argument classifier to ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{argFile.getAbsolutePath()})));
        PrintWriter argWriter = new PrintWriter(new BufferedWriter(new FileWriter(argFile)));
        this.argClassifier().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.saveTo(argWriter);
            return BoxedUnit.UNIT;
        });
        argWriter.close();
        this.transferContent(argFile, pw);
        argFile.delete();
    }

    public void transferContent(File fromFile, PrintWriter to) {
        BufferedSource source = Source$.MODULE$.fromFile(fromFile, Codec$.MODULE$.fallbackSystemCodec());
        source.getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            to.println(line);
            return BoxedUnit.UNIT;
        });
        source.close();
    }

    public void train(String trainPath) {
        SRL$.MODULE$.logger().info("Training the predicate classifier...");
        this.predClassifier_$eq((Option<PredicateClassifier>)new Some((Object)new PredicateClassifier()));
        ((PredicateClassifier)this.predClassifier().get()).train(trainPath);
        SRL$.MODULE$.logger().info("Completed training the predicate classifier.");
        SRL$.MODULE$.logger().info("Training the argument classifier...");
        this.argClassifier_$eq((Option<ArgumentClassifier>)new Some((Object)new ArgumentClassifier()));
        ((ArgumentClassifier)this.argClassifier().get()).train(trainPath);
        SRL$.MODULE$.logger().info("Completed training the argument classifier.");
    }

    public void test(String testPath) {
        Reader reader = new Reader();
        Document doc = reader.load(testPath);
        ListBuffer output = new ListBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)s -> {
            DirectedGraph<String> frames = this.classifySentence((Sentence)s);
            return output.$plus$eq((Object)new Tuple2(s.semanticRoles().get(), frames));
        });
        this.score((List<Tuple2<DirectedGraph<String>, DirectedGraph<String>>>)output.toList());
    }

    public DirectedGraph<String> classifySentence(Sentence sentence) {
        HashSet roots = new HashSet();
        ListBuffer edges = new ListBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sentence.words())).indices().foreach((Function1 & Serializable & scala.Serializable)i -> SRL.$anonfun$classifySentence$1(this, sentence, roots, BoxesRunTime.unboxToInt((Object)i)));
        roots.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pred -> {
            ArrayBuffer history = new ArrayBuffer();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sentence.words())).indices().foreach((Function1 & Serializable & scala.Serializable)arg -> SRL.$anonfun$classifySentence$3(this, sentence, edges, history, pred, BoxesRunTime.unboxToInt((Object)arg)));
        });
        return new DirectedGraph<String>(edges.toList(), (Set<Object>)roots.toSet());
    }

    public void score(List<Tuple2<DirectedGraph<String>, DirectedGraph<String>>> output) {
        IntRef total = IntRef.create((int)0);
        IntRef predicted = IntRef.create((int)0);
        IntRef correctUnlabeled = IntRef.create((int)0);
        output.foreach((Function1 & Serializable & scala.Serializable)o -> {
            SRL.$anonfun$score$1(total, predicted, correctUnlabeled, o);
            return BoxedUnit.UNIT;
        });
        double p = (double)correctUnlabeled.elem / (double)predicted.elem;
        double r = (double)correctUnlabeled.elem / (double)total.elem;
        double f1 = 2.0 * p * r / (p + r);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unlabeled precision: ", " (", "/", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)p), BoxesRunTime.boxToInteger((int)correctUnlabeled.elem), BoxesRunTime.boxToInteger((int)predicted.elem)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unlabeled recall: ", " (", "/", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)r), BoxesRunTime.boxToInteger((int)correctUnlabeled.elem), BoxesRunTime.boxToInteger((int)total.elem)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unlabeled F1: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)f1)})));
    }

    public static final /* synthetic */ Object $anonfun$classifySentence$1(SRL $this, Sentence sentence$1, HashSet roots$1, int i) {
        return ((ArgumentClassifier)$this.argClassifier().get()).isPred(i, sentence$1) ? roots$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$classifySentence$3(SRL $this, Sentence sentence$1, ListBuffer edges$1, ArrayBuffer history$1, int pred$1, int arg) {
        BoxedUnit boxedUnit;
        String predLabel = ArgumentClassifier$.MODULE$.NEG_LABEL();
        if (ValidCandidate$.MODULE$.isValid(sentence$1, arg, pred$1)) {
            List<Tuple2<String, Object>> scores = ((ArgumentClassifier)$this.argClassifier().get()).classify(sentence$1, arg, pred$1, (ArrayBuffer<Tuple2<Object, String>>)history$1).sorted();
            String string = predLabel = (String)((Tuple2)scores.head())._1();
            String string2 = ArgumentClassifier$.MODULE$.NEG_LABEL();
            if (string == null ? string2 != null : !string.equals(string2)) {
                history$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)arg), (Object)predLabel));
                boxedUnit = edges$1.$plus$eq(new Edge<String>(pred$1, arg, predLabel));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$score$3(BooleanRef found$1, Tuple3 g) {
        return !found$1.elem;
    }

    public static final /* synthetic */ void $anonfun$score$4(IntRef correctUnlabeled$1, BooleanRef found$1, Tuple3 p$1, Tuple3 g) {
        block0: {
            if (BoxesRunTime.unboxToInt((Object)p$1._1()) != BoxesRunTime.unboxToInt((Object)g._1()) || BoxesRunTime.unboxToInt((Object)p$1._2()) != BoxesRunTime.unboxToInt((Object)g._2())) break block0;
            ++correctUnlabeled$1.elem;
            found$1.elem = true;
        }
    }

    public static final /* synthetic */ void $anonfun$score$2(IntRef correctUnlabeled$1, List gold$1, Tuple3 p) {
        BooleanRef found = BooleanRef.create((boolean)false);
        gold$1.withFilter((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean((boolean)SRL.$anonfun$score$3(found, g))).foreach((Function1 & Serializable & scala.Serializable)g -> {
            SRL.$anonfun$score$4(correctUnlabeled$1, found, p, g);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$score$1(IntRef total$1, IntRef predicted$1, IntRef correctUnlabeled$1, Tuple2 o) {
        List gold = ((DirectedGraph)o._1()).allEdges();
        List pred = ((DirectedGraph)o._2()).allEdges();
        total$1.elem += gold.size();
        predicted$1.elem += pred.size();
        pred.foreach((Function1 & Serializable & scala.Serializable)p -> {
            SRL.$anonfun$score$2(correctUnlabeled$1, gold, p);
            return BoxedUnit.UNIT;
        });
    }
}

