/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.swirl2;

import java.io.Serializable;
import java.util.Properties;
import org.clulab.processors.Document;
import org.clulab.processors.Sentence;
import org.clulab.struct.DirectedGraph;
import org.clulab.swirl2.ArgumentClassifier;
import org.clulab.swirl2.Reader;
import org.clulab.utils.StringUtils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class ValidCandidate$ {
    public static ValidCandidate$ MODULE$;
    private final Logger logger;
    private final Regex VALID_ARG_POS;
    private final int MAX_TOKENS_BETWEEN_PRED_AND_ARG;
    private final int MAX_PATH_LEN_BETWEEN_PRED_AND_ARG;

    static {
        new ValidCandidate$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Regex VALID_ARG_POS() {
        return this.VALID_ARG_POS;
    }

    public int MAX_TOKENS_BETWEEN_PRED_AND_ARG() {
        return this.MAX_TOKENS_BETWEEN_PRED_AND_ARG;
    }

    public int MAX_PATH_LEN_BETWEEN_PRED_AND_ARG() {
        return this.MAX_PATH_LEN_BETWEEN_PRED_AND_ARG;
    }

    public boolean isValid(Sentence sent, int arg, int pred) {
        DirectedGraph deps = (DirectedGraph)sent.universalBasicDependencies().get();
        Seq paths = deps.shortestPathEdges(pred, arg, true);
        BooleanRef validPath = BooleanRef.create((boolean)false);
        paths.foreach((Function1 & Serializable & scala.Serializable)p -> {
            ValidCandidate$.$anonfun$isValid$1(validPath, p);
            return BoxedUnit.UNIT;
        });
        return validPath.elem;
    }

    public Seq<Tuple4<Object, Object, String, String>> argSubpath(Seq<Tuple4<Object, Object, String, String>> path) {
        ListBuffer subpath = new ListBuffer();
        BooleanRef foundAncestor = BooleanRef.create((boolean)false);
        ((TraversableLike)path.reverse()).withFilter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ValidCandidate$.$anonfun$argSubpath$1(foundAncestor, p))).foreach((Function1 & Serializable & scala.Serializable)p -> {
            ValidCandidate$.$anonfun$argSubpath$2(subpath, foundAncestor, p);
            return BoxedUnit.UNIT;
        });
        return subpath.toList();
    }

    public Seq<Tuple4<Object, Object, String, String>> predSubpath(Seq<Tuple4<Object, Object, String, String>> path) {
        ListBuffer subpath = new ListBuffer();
        BooleanRef foundAncestor = BooleanRef.create((boolean)false);
        path.withFilter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ValidCandidate$.$anonfun$predSubpath$1(foundAncestor, p))).foreach((Function1 & Serializable & scala.Serializable)p -> {
            ListBuffer listBuffer;
            Object object = p._4();
            String string = "<";
            if (!(object != null ? !object.equals(string) : string != null)) {
                listBuffer = subpath.$plus$eq(p);
            } else {
                foundAncestor$2.elem = true;
                listBuffer = BoxedUnit.UNIT;
            }
            return listBuffer;
        });
        return subpath.toList();
    }

    public void main(String[] args) {
        Properties props = StringUtils$.MODULE$.argsToProperties(args, StringUtils$.MODULE$.argsToProperties$default$2());
        String path = props.getProperty("path");
        Reader reader = new Reader();
        Document doc = reader.load(path);
        this.logger().debug("Started analysis...");
        IntRef totalCands = IntRef.create((int)0);
        IntRef totalPositives = IntRef.create((int)0);
        IntRef coveredPositives = IntRef.create((int)0);
        IntRef totalCovered = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)s -> {
            ValidCandidate$.$anonfun$main$1(totalCands, totalPositives, coveredPositives, totalCovered, s);
            return BoxedUnit.UNIT;
        });
        this.logger().debug("Analysis complete.");
        double recall = (double)coveredPositives.elem / (double)totalPositives.elem;
        double cov = (double)totalCovered.elem / (double)totalCands.elem;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recall = ", "/", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)coveredPositives.elem), BoxesRunTime.boxToInteger((int)totalPositives.elem), BoxesRunTime.boxToDouble((double)recall)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total candidates = ", "/", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)totalCovered.elem), BoxesRunTime.boxToInteger((int)totalCands.elem), BoxesRunTime.boxToDouble((double)cov)})));
    }

    public boolean isPred(int position, Sentence s) {
        Tuple2<Object, E>[][] oes = ((DirectedGraph)s.semanticRoles().get()).outgoingEdges();
        return position < oes.length && oes[position] != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])oes[position])).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$isValid$1(BooleanRef validPath$1, Seq p) {
        block0: {
            if (p.size() >= MODULE$.MAX_PATH_LEN_BETWEEN_PRED_AND_ARG()) break block0;
            validPath$1.elem = true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$argSubpath$1(BooleanRef foundAncestor$1, Tuple4 p) {
        return !foundAncestor$1.elem;
    }

    public static final /* synthetic */ void $anonfun$argSubpath$2(ListBuffer subpath$1, BooleanRef foundAncestor$1, Tuple4 p) {
        Object object = p._4();
        String string = ">";
        if (!(object != null ? !object.equals(string) : string != null)) {
            subpath$1.insert(0, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{p}));
        } else {
            foundAncestor$1.elem = true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$predSubpath$1(BooleanRef foundAncestor$2, Tuple4 p) {
        return !foundAncestor$2.elem;
    }

    public static final /* synthetic */ void $anonfun$main$1(IntRef totalCands$1, IntRef totalPositives$1, IntRef coveredPositives$1, IntRef totalCovered$1, Sentence s) {
        Tuple2<Object, E>[][] outEdges = ((DirectedGraph)s.semanticRoles().get()).outgoingEdges();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.words())).indices().withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)pred -> MODULE$.isPred(pred, s)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pred -> {
            Set args = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outEdges[pred])).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSet();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.words())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)arg -> {
                block1: {
                    block0: {
                        ++totalCands$1.elem;
                        if (!args.contains((Object)BoxesRunTime.boxToInteger((int)arg))) break block0;
                        ++totalPositives$1.elem;
                        if (!MODULE$.isValid(s, arg, pred)) break block1;
                        ++coveredPositives$1.elem;
                        ++totalCovered$1.elem;
                        break block1;
                    }
                    if (!MODULE$.isValid(s, arg, pred)) break block1;
                    ++totalCovered$1.elem;
                }
            });
        });
    }

    private ValidCandidate$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(ArgumentClassifier.class);
        this.VALID_ARG_POS = new StringOps(Predef$.MODULE$.augmentString("NN|IN|PR|JJ|TO|RB|VB|MD|WD|CD|\\$|WP|DT")).r();
        this.MAX_TOKENS_BETWEEN_PRED_AND_ARG = 25;
        this.MAX_PATH_LEN_BETWEEN_PRED_AND_ARG = 6;
    }
}

