/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.utils;

import java.io.Serializable;
import java.util.Arrays;
import org.clulab.utils.EvaluationStatistics;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class EvaluationStatistics$ {
    public static EvaluationStatistics$ MODULE$;

    static {
        new EvaluationStatistics$();
    }

    public <A> EvaluationStatistics.Table makeTables(A outcome, Seq<A> predicted, Seq<A> actual) {
        Predef$.MODULE$.require(predicted.size() == actual.size(), (Function0 & Serializable & scala.Serializable)() -> "predicted and actual labels must be same size");
        EvaluationStatistics.Table counts = new EvaluationStatistics.Table(0, 0, 0, 0);
        ((TraversableLike)predicted.zip(actual, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)EvaluationStatistics$.$anonfun$makeTables$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            EvaluationStatistics$.$anonfun$makeTables$3(outcome, counts, x$1);
            return BoxedUnit.UNIT;
        });
        return counts;
    }

    public <A> Map<A, EvaluationStatistics.Table> makeTables(Seq<A> predicted, Seq<A> actual) {
        Set vals = ((TraversableOnce)predicted.$plus$plus(actual, Seq$.MODULE$.canBuildFrom())).toSet();
        return ((TraversableOnce)vals.toSeq().map((Function1 & Serializable & scala.Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v), (Object)MODULE$.makeTables(v, predicted, actual)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public <A> double microAverage(Map<A, EvaluationStatistics.Table> tables, Function1<EvaluationStatistics.Table, Object> accessor) {
        return BoxesRunTime.unboxToDouble((Object)accessor.apply(tables.values().reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus((EvaluationStatistics.Table)x$3))));
    }

    public <A> double macroAverage(Map<A, EvaluationStatistics.Table> tables, Function1<EvaluationStatistics.Table, Object> accessor) {
        int N_classes = tables.size();
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)tables.values().map(accessor, scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)N_classes;
    }

    public <A> double weightedAverage(Map<A, EvaluationStatistics.Table> tables, Function1<EvaluationStatistics.Table, Object> accessor) {
        Map trueCounts = tables.mapValues((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.trueCount()));
        int N_data = ((EvaluationStatistics.Table)tables.values().head()).total();
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)tables.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)EvaluationStatistics$.$anonfun$weightedAverage$2(accessor, trueCounts, N_data, x0$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public <A> double classificationSignificance(Function1<EvaluationStatistics<A>, Object> stat, Seq<A> predicted, Seq<A> baseline, Seq<A> actual, int N_samples) {
        Predef$.MODULE$.require(predicted.size() == baseline.size() && baseline.size() == actual.size(), (Function0 & Serializable & scala.Serializable)() -> "label arrays must be same size");
        int N_labels = predicted.size();
        Tuple3[] zipped = new Tuple3[predicted.size()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), N_labels).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            zipped$1[i] = new Tuple3(predicted.apply(i), baseline.apply(i), actual.apply(i));
        });
        double[] sampledDifferences = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), N_samples).toArray(ClassTag$.MODULE$.Int()))).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)sampleIx -> EvaluationStatistics$.bootstrapDifference$1(stat, N_labels, zipped), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sorted((Ordering)Ordering.Double$.MODULE$);
        int i2 = Arrays.binarySearch(sampledDifferences, 0.0);
        int indexOfZero = i2 >= 0 ? i2 : -(i2 + 1);
        return (double)indexOfZero / (double)N_samples;
    }

    public <A> int classificationSignificance$default$5(Function1<EvaluationStatistics<A>, Object> stat) {
        return 10000;
    }

    public <A> double classificationAccuracySignificance(Seq<A> predicted, Seq<A> baseline, Seq<A> actual, int N_samples) {
        return this.classificationSignificance((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.accuracy()), predicted, baseline, actual, N_samples);
    }

    public <A> int classificationAccuracySignificance$default$4() {
        return 10000;
    }

    public static final /* synthetic */ boolean $anonfun$makeTables$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$makeTables$3(Object outcome$1, EvaluationStatistics.Table counts$1, Tuple2 x$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Object p = tuple2._1();
            Object a = tuple2._2();
            if (BoxesRunTime.equals((Object)p, (Object)outcome$1)) {
                if (BoxesRunTime.equals((Object)a, (Object)outcome$1)) {
                    counts$1.tp_$eq(counts$1.tp() + 1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    counts$1.fp_$eq(counts$1.fp() + 1);
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else if (BoxesRunTime.equals((Object)a, (Object)outcome$1)) {
                counts$1.fn_$eq(counts$1.fn() + 1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                counts$1.tn_$eq(counts$1.tn() + 1);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ double $anonfun$weightedAverage$2(Function1 accessor$1, Map trueCounts$1, int N_data$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object a = tuple2._1();
        EvaluationStatistics.Table table = (EvaluationStatistics.Table)tuple2._2();
        double d = BoxesRunTime.unboxToDouble((Object)accessor$1.apply((Object)table)) * (double)BoxesRunTime.unboxToInt((Object)trueCounts$1.apply(a)) / (double)N_data$1;
        return d;
    }

    public static final /* synthetic */ Tuple3 $anonfun$classificationSignificance$4(Tuple3[] zipped$1, int x$6) {
        return zipped$1[x$6];
    }

    private static final double bootstrapDifference$1(Function1 stat$1, int N_labels$1, Tuple3[] zipped$1) {
        IndexedSeq indices = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), N_labels$1).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$5 -> Random$.MODULE$.nextInt(N_labels$1), IndexedSeq$.MODULE$.canBuildFrom());
        Tuple3 tuple3 = ((GenericTraversableTemplate)indices.map((Function1 & Serializable & scala.Serializable)x$6 -> EvaluationStatistics$.$anonfun$classificationSignificance$4(zipped$1, BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom())).unzip3((Function1)Predef$.MODULE$.$conforms());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        IndexedSeq predSampled = (IndexedSeq)tuple3._1();
        IndexedSeq baseSampled = (IndexedSeq)tuple3._2();
        IndexedSeq actSampled = (IndexedSeq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)predSampled, (Object)baseSampled, (Object)actSampled);
        Tuple3 tuple33 = tuple32;
        IndexedSeq predSampled2 = (IndexedSeq)tuple33._1();
        IndexedSeq baseSampled2 = (IndexedSeq)tuple33._2();
        IndexedSeq actSampled2 = (IndexedSeq)tuple33._3();
        EvaluationStatistics predictedEval = new EvaluationStatistics(predSampled2, actSampled2);
        EvaluationStatistics baselineEval = new EvaluationStatistics(baseSampled2, actSampled2);
        return BoxesRunTime.unboxToDouble((Object)stat$1.apply(predictedEval)) - BoxesRunTime.unboxToDouble((Object)stat$1.apply(baselineEval));
    }

    private EvaluationStatistics$() {
        MODULE$ = this;
    }
}

