/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.jar.JarFile;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Files$ {
    public static Files$ MODULE$;
    private final int TEMP_DIR_ATTEMPTS;
    private final Charset FILE_CHARSET;

    static {
        new Files$();
    }

    public int TEMP_DIR_ATTEMPTS() {
        return this.TEMP_DIR_ATTEMPTS;
    }

    public String mkTmpDir(String prefix, boolean deleteOnExit) {
        Object object = new Object();
        try {
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            String baseName = prefix + "-" + ((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).toString() + "-" + Thread.currentThread().getId() + "-";
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.TEMP_DIR_ATTEMPTS()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
                File tempDir = new File(baseDir, baseName + ((Object)BoxesRunTime.boxToInteger((int)counter)).toString());
                if (tempDir.mkdir()) {
                    if (deleteOnExit) {
                        tempDir.deleteOnExit();
                    }
                    throw new NonLocalReturnControl(object, (Object)tempDir.getAbsolutePath());
                }
            });
            throw new IllegalStateException("ERROR: Failed to create directory within " + this.TEMP_DIR_ATTEMPTS() + " attempts (tried " + baseName + "0 to " + baseName + (this.TEMP_DIR_ATTEMPTS() - 1) + ')');
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (String)ex.value();
        }
    }

    public boolean mkTmpDir$default$2() {
        return true;
    }

    public Charset FILE_CHARSET() {
        return this.FILE_CHARSET;
    }

    public PrintWriter toPrintWriter(Writer w) {
        PrintWriter printWriter;
        Writer writer = w;
        if (writer instanceof PrintWriter) {
            PrintWriter printWriter2;
            printWriter = printWriter2 = (PrintWriter)writer;
        } else if (writer instanceof BufferedWriter) {
            BufferedWriter bufferedWriter = (BufferedWriter)writer;
            printWriter = new PrintWriter(bufferedWriter);
        } else {
            printWriter = new PrintWriter(new BufferedWriter(w));
        }
        return printWriter;
    }

    public BufferedReader toBufferedReader(Reader r) {
        BufferedReader bufferedReader;
        Reader reader = r;
        BufferedReader bufferedReader2 = reader instanceof BufferedReader ? (bufferedReader = (BufferedReader)reader) : new BufferedReader(r);
        return bufferedReader2;
    }

    public List<File> findFiles(String dir, String ext) {
        ListBuffer files = new ListBuffer();
        FilenameFilter fileNameFilter = new FilenameFilter(ext){
            private final String ext$1;

            public boolean accept(File file, String name) {
                return name.toLowerCase().endsWith("." + this.ext$1);
            }
            {
                this.ext$1 = ext$1;
            }
        };
        files.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(dir).listFiles(fileNameFilter))).toList());
        FilenameFilter dirNameFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir.getAbsolutePath() + File.separator + name);
                return file.isDirectory();
            }
        };
        File[] subdirs = new File(dir).listFiles(dirNameFilter);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subdirs)).foreach((Function1 & Serializable & scala.Serializable)subdir -> files.$plus$plus$eq(MODULE$.findFiles(subdir.getAbsolutePath(), ext)));
        return files.toList();
    }

    public void extractEntry(String jarFileName, String entryName, String outFileName, boolean deleteOnExit, int bufSize) {
        block2: {
            JarFile jar = new JarFile(jarFileName);
            ZipEntry entry = jar.getEntry(entryName);
            InputStream is = jar.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(outFileName);
            byte[] buffer = new byte[bufSize];
            boolean done = false;
            while (!done) {
                int num = is.read(buffer, 0, bufSize);
                if (num > 0) {
                    fos.write(buffer, 0, num);
                    continue;
                }
                done = true;
            }
            fos.close();
            is.close();
            if (!deleteOnExit) break block2;
            new File(outFileName).deleteOnExit();
        }
    }

    public boolean extractEntry$default$4() {
        return true;
    }

    public int extractEntry$default$5() {
        return 131072;
    }

    public BufferedReader loadStreamFromClasspath(String path) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: cannot find resource ", " in classpath!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        return path.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(is)))) : new BufferedReader(new InputStreamReader(new BufferedInputStream(is)));
    }

    public ObjectInputStream loadObjectStreamFromClasspath(String path) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: cannot find resource ", " in classpath!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        return path.endsWith(".gz") ? new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(is))) : new ObjectInputStream(new BufferedInputStream(is));
    }

    private Files$() {
        MODULE$ = this;
        this.TEMP_DIR_ATTEMPTS = 100;
        this.FILE_CHARSET = Charset.forName("UTF-8");
    }
}

