/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.utils;

import java.io.Serializable;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.RichDouble;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random;
import scala.util.Random$;

public final class MathUtils$ {
    public static MathUtils$ MODULE$;
    private final double LogTolerance;
    private final float LogToleranceFloat;

    static {
        new MathUtils$();
    }

    public List<Object> softmax(Iterable<Object> scores, double gamma) {
        ArrayBuffer scoreArrayBuffer = new ArrayBuffer();
        scores.foreach((Function1 & Serializable & scala.Serializable)s -> scoreArrayBuffer.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)s) * gamma))));
        double[] scoreArray = (double[])scoreArrayBuffer.toArray(ClassTag$.MODULE$.Double());
        ListBuffer softmaxes = new ListBuffer();
        double logSumStatic = this.logSum(scoreArray);
        scores.foreach((Function1 & Serializable & scala.Serializable)s -> MathUtils$.$anonfun$softmax$2(gamma, softmaxes, logSumStatic, BoxesRunTime.unboxToDouble((Object)s)));
        return softmaxes.toList();
    }

    public double softmax$default$2() {
        return 1.0;
    }

    public List<Object> softmaxFloat(Iterable<Object> scores, float gamma) {
        ArrayBuffer scoreArrayBuffer = new ArrayBuffer();
        scores.foreach((Function1 & Serializable & scala.Serializable)s -> scoreArrayBuffer.$plus$eq((Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)s) * gamma))));
        float[] scoreArray = (float[])scoreArrayBuffer.toArray(ClassTag$.MODULE$.Float());
        ListBuffer softmaxes = new ListBuffer();
        float logSumStatic = this.logSum(scoreArray);
        scores.foreach((Function1 & Serializable & scala.Serializable)s -> MathUtils$.$anonfun$softmaxFloat$2(gamma, softmaxes, logSumStatic, BoxesRunTime.unboxToFloat((Object)s)));
        return softmaxes.toList();
    }

    public float softmaxFloat$default$2() {
        return 1.0f;
    }

    public double[] denseSoftmax(double[] vector, double gamma) {
        double[] scoreArray = gamma != 1.0 ? (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> gamma * v, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : vector;
        double logSumStatic = this.logSum(scoreArray);
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)s -> package$.MODULE$.exp(gamma * s - logSumStatic), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double denseSoftmax$default$2() {
        return 1.0;
    }

    public float[] denseSoftmaxFloat(float[] vector, float gamma) {
        float[] scoreArray = gamma != 1.0f ? (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vector)).map((Function1)(JFunction1.mcFF.sp & Serializable & scala.Serializable)v -> gamma * v, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())) : vector;
        float logSumStatic = this.logSum(scoreArray);
        return (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vector)).map((Function1)(JFunction1.mcFF.sp & Serializable & scala.Serializable)s -> (float)package$.MODULE$.exp((double)(gamma * s - logSumStatic)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
    }

    public float denseSoftmaxFloat$default$2() {
        return 1.0f;
    }

    public double logSum(double[] logInputs) {
        return this.logSum(logInputs, 0, logInputs.length);
    }

    public float logSum(float[] logInputs) {
        return this.logSum(logInputs, 0, logInputs.length);
    }

    public double logSum(double[] logInputs, int fromIndex, int toIndex) {
        if (logInputs.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fromIndex >= 0 && toIndex < logInputs.length && fromIndex >= toIndex) {
            return Double.NEGATIVE_INFINITY;
        }
        IntRef maxIdx = IntRef.create((int)fromIndex);
        DoubleRef max = DoubleRef.create((double)logInputs[fromIndex]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(fromIndex + 1), toIndex).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (!(logInputs[i] > max$1.elem)) break block0;
                maxIdx$1.elem = i;
                max$1.elem = logInputs[i];
            }
        });
        BooleanRef haveTerms = BooleanRef.create((boolean)false);
        DoubleRef intermediate = DoubleRef.create((double)0.0);
        DoubleRef cutoff = DoubleRef.create((double)(max.elem - this.LogTolerance()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(fromIndex), toIndex).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (i == maxIdx$1.elem || !(logInputs[i] > cutoff$1.elem)) break block0;
                haveTerms$1.elem = true;
                intermediate$1.elem += package$.MODULE$.exp(logInputs[i] - max$1.elem);
            }
        });
        if (haveTerms.elem) {
            return max.elem + package$.MODULE$.log(1.0 + intermediate.elem);
        }
        return max.elem;
    }

    public float logSum(float[] logInputs, int fromIndex, int toIndex) {
        if (logInputs.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fromIndex >= 0 && toIndex < logInputs.length && fromIndex >= toIndex) {
            return Float.NEGATIVE_INFINITY;
        }
        IntRef maxIdx = IntRef.create((int)fromIndex);
        FloatRef max = FloatRef.create((float)logInputs[fromIndex]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(fromIndex + 1), toIndex).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (!(logInputs[i] > max$2.elem)) break block0;
                maxIdx$2.elem = i;
                max$2.elem = logInputs[i];
            }
        });
        BooleanRef haveTerms = BooleanRef.create((boolean)false);
        FloatRef intermediate = FloatRef.create((float)0.0f);
        DoubleRef cutoff = DoubleRef.create((double)((double)max.elem - this.LogTolerance()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(fromIndex), toIndex).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (i == maxIdx$2.elem || !((double)logInputs[i] > cutoff$2.elem)) break block0;
                haveTerms$2.elem = true;
                intermediate$2.elem += (float)package$.MODULE$.exp((double)(logInputs[i] - max$2.elem));
            }
        });
        if (haveTerms.elem) {
            return max.elem + (float)package$.MODULE$.log(1.0 + (double)intermediate.elem);
        }
        return max.elem;
    }

    public double LogTolerance() {
        return this.LogTolerance;
    }

    public float LogToleranceFloat() {
        return this.LogToleranceFloat;
    }

    public <T> Object randomize(Object l, Random rand) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(l) - 1), 1).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int j = rand.nextInt(i);
            Object tmp = ScalaRunTime$.MODULE$.array_apply(l, j);
            ScalaRunTime$.MODULE$.array_update(l, j, ScalaRunTime$.MODULE$.array_apply(l, i));
            ScalaRunTime$.MODULE$.array_update(l, i, tmp);
        });
        return l;
    }

    public <T> List<Tuple2<T, Object>> nBest(Function1<T, Object> scoringFunction, Iterable<T> xs, int howMany, Manifest<T> evidence$1) {
        double[] bestd = new double[howMany];
        Object bestw = evidence$1.newArray(howMany);
        IntRef i = IntRef.create((int)0);
        while (i.elem < howMany) {
            bestd[i.elem] = Double$.MODULE$.MinValue();
            ++i.elem;
        }
        xs.foreach((Function1 & Serializable & scala.Serializable)x -> {
            MathUtils$.$anonfun$nBest$1(scoringFunction, howMany, bestd, bestw, i, x);
            return BoxedUnit.UNIT;
        });
        List l = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(bestw).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(bestd), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toList();
        return xs.size() < l.size() ? l.take(xs.size()) : l;
    }

    public <T> List<T> sampleStream(Iterable<T> xs, int howMany, Manifest<T> evidence$2) {
        return (List)this.nBest((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)Random$.MODULE$.nextDouble()), xs, howMany, evidence$2).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1._1(), List$.MODULE$.canBuildFrom());
    }

    public Map<Tuple2<Object, Object>, Object> histogram(Traversable<Object> xs, Seq<Object> boundaries) {
        Predef$.MODULE$.require(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(boundaries, boundaries.tail())), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2)(JFunction2.mcZDD.sp & Serializable & scala.Serializable)(x$2, x$3) -> x$2 < x$3), (Function0 & Serializable & scala.Serializable)() -> "boundaries must be an ascending sequence");
        double d = BoxesRunTime.unboxToDouble((Object)xs.min((Ordering)Ordering.Double$.MODULE$));
        Seq extendedBounds = (Seq)((SeqLike)boundaries.$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Seq$.MODULE$.canBuildFrom())).$colon$plus(xs.max((Ordering)Ordering.Double$.MODULE$), Seq$.MODULE$.canBuildFrom());
        Map countsByBucket = xs.groupBy((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x -> MathUtils$.getBucket$1(x, boundaries)).mapValues((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size())).toMap(Predef$.MODULE$.$conforms());
        return ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), boundaries.size()).map((Function1 & Serializable & scala.Serializable)bucket -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MathUtils$.getRange$1(BoxesRunTime.unboxToInt((Object)bucket), extendedBounds)), countsByBucket.getOrElse((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)bucket)), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<Tuple2<Object, Object>, Object> histogram(Traversable<Object> xs, int numBuckets) {
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)xs.min((Ordering)Ordering.Double$.MODULE$)), BoxesRunTime.unboxToDouble((Object)xs.max((Ordering)Ordering.Double$.MODULE$)));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double min = sp2._1$mcD$sp();
        double max = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(min, max);
        Tuple2.mcDD.sp sp4 = sp3;
        double min2 = sp4._1$mcD$sp();
        double max2 = sp4._2$mcD$sp();
        double step = (max2 - min2) / (double)numBuckets;
        Predef$.MODULE$.require(step != 0.0, (Function0 & Serializable & scala.Serializable)() -> "xs has all same values");
        NumericRange divisions = (NumericRange)Range.Partial$.MODULE$.by$extension(new RichDouble(Predef$.MODULE$.doubleWrapper(min2 + step)).to((Object)BoxesRunTime.boxToDouble((double)(max2 - step / (double)2))), (Object)BoxesRunTime.boxToDouble((double)step));
        return this.histogram(xs, (Seq<Object>)divisions);
    }

    public static final /* synthetic */ ListBuffer $anonfun$softmax$2(double gamma$1, ListBuffer softmaxes$1, double logSumStatic$1, double s) {
        double logSoftmax = gamma$1 * s - logSumStatic$1;
        return softmaxes$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.exp(logSoftmax)));
    }

    public static final /* synthetic */ ListBuffer $anonfun$softmaxFloat$2(float gamma$2, ListBuffer softmaxes$2, float logSumStatic$2, float s) {
        float logSoftmax = gamma$2 * s - logSumStatic$2;
        return softmaxes$2.$plus$eq((Object)BoxesRunTime.boxToFloat((float)((float)package$.MODULE$.exp((double)logSoftmax))));
    }

    public static final /* synthetic */ void $anonfun$nBest$1(Function1 scoringFunction$1, int howMany$1, double[] bestd$1, Object bestw$1, IntRef i$1, Object x) {
        double score = BoxesRunTime.unboxToDouble((Object)scoringFunction$1.apply(x));
        if (score > bestd$1[howMany$1 - 1]) {
            i$1.elem = 0;
            boolean found = false;
            while (i$1.elem < howMany$1 && !found) {
                if (score > bestd$1[i$1.elem]) {
                    for (int j = howMany$1 - 1; j > i$1.elem; --j) {
                        bestd$1[j] = bestd$1[j - 1];
                        ScalaRunTime$.MODULE$.array_update(bestw$1, j, ScalaRunTime$.MODULE$.array_apply(bestw$1, j - 1));
                    }
                    bestd$1[i$1.elem] = score;
                    ScalaRunTime$.MODULE$.array_update(bestw$1, i$1.elem, x);
                    found = true;
                }
                ++i$1.elem;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$histogram$3(double x$8, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double b = tuple2._1$mcD$sp();
        boolean bl = b >= x$8;
        return bl;
    }

    private static final int getBucket$1(double x, Seq boundaries$1) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)boundaries$1.zipWithIndex(Seq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MathUtils$.$anonfun$histogram$3(x, x0$1))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._2$mcI$sp())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> boundaries$1.size()));
    }

    private static final Tuple2 getRange$1(int bucket, Seq extendedBounds$1) {
        Seq zipped = (Seq)extendedBounds$1.zip((GenIterable)extendedBounds$1.tail(), Seq$.MODULE$.canBuildFrom());
        return (Tuple2)zipped.apply(bucket);
    }

    private MathUtils$() {
        MODULE$ = this;
        this.LogTolerance = 30.0;
        this.LogToleranceFloat = 20.0f;
    }
}

