/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.discourse.rstparser;

import java.io.InputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.clulab.discourse.rstparser.ConnectiveMatcher;
import org.clulab.discourse.rstparser.RSTParser$;
import org.clulab.processors.Document;
import org.clulab.processors.Sentence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ConnectiveMatcher$ {
    public static ConnectiveMatcher$ MODULE$;
    private Iterable<String[]> CONNECTIVES;
    private final Logger logger;
    private final String DEFAULT_CONNECTIVE_FILE;
    private final String NO_CONNECTIVE;
    private final String BEGIN_CONNECTIVE;
    private final String INSIDE_CONNECTIVE;
    private volatile boolean bitmap$0;

    static {
        new ConnectiveMatcher$();
    }

    public Logger logger() {
        return this.logger;
    }

    public String DEFAULT_CONNECTIVE_FILE() {
        return this.DEFAULT_CONNECTIVE_FILE;
    }

    private Iterable<String[]> CONNECTIVES$lzycompute() {
        ConnectiveMatcher$ connectiveMatcher$ = this;
        synchronized (connectiveMatcher$) {
            if (!this.bitmap$0) {
                this.CONNECTIVES = this.loadConnectives(this.DEFAULT_CONNECTIVE_FILE());
                this.bitmap$0 = true;
            }
        }
        return this.CONNECTIVES;
    }

    public Iterable<String[]> CONNECTIVES() {
        return !this.bitmap$0 ? this.CONNECTIVES$lzycompute() : this.CONNECTIVES;
    }

    public String NO_CONNECTIVE() {
        return this.NO_CONNECTIVE;
    }

    public String BEGIN_CONNECTIVE() {
        return this.BEGIN_CONNECTIVE;
    }

    public String INSIDE_CONNECTIVE() {
        return this.INSIDE_CONNECTIVE;
    }

    public Iterable<String[]> loadConnectives(String path) {
        InputStream is = RSTParser$.MODULE$.getClass().getClassLoader().getResourceAsStream(path);
        List lines = (List)Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).getLines().toList().sortWith((Function2 & Serializable & scala.Serializable)(s1, s2) -> BoxesRunTime.boxToBoolean((boolean)ConnectiveMatcher$.MODULE$.desc(s1, s2)));
        this.logger().debug("Loaded " + lines.length() + " discourse connectives.");
        is.close();
        ArrayBuffer connectives = new ArrayBuffer();
        lines.foreach((Function1 & Serializable & scala.Serializable)line -> {
            String l = line.trim();
            return l.length() > 0 ? connectives.$plus$eq((Object)l.toLowerCase().split("\\s+")) : BoxedUnit.UNIT;
        });
        return connectives.toList();
    }

    public boolean desc(String s1, String s2) {
        return this.countSpaces(s1) > this.countSpaces(s2);
    }

    public int countSpaces(String s) {
        Pattern SPACE_PATTERN = Pattern.compile("\\s+", 2);
        Matcher m = SPACE_PATTERN.matcher(s);
        int offset = 0;
        int count = 0;
        while (m.find(offset)) {
            ++count;
            offset = m.end();
        }
        return count;
    }

    public String[][] matchConnectives(Document doc) {
        ArrayBuffer sents = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)s -> sents.$plus$eq((Object)MODULE$.matchConnectivesInSentence((Sentence)s)));
        return (String[][])sents.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
    }

    /*
     * WARNING - void declaration
     */
    public String[] matchConnectivesInSentence(Sentence sent) {
        void var2_2;
        String[] cs = new String[sent.size()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cs.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            cs$1[i] = MODULE$.NO_CONNECTIVE();
        });
        IntRef offset = IntRef.create((int)0);
        while (offset.elem < cs.length) {
            String[] conn = this.matchesConnective(sent.words(), offset.elem);
            if (conn != null) {
                int len = conn.length;
                cs[offset.elem] = this.BEGIN_CONNECTIVE();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    cs$1[offset$1.elem + i] = MODULE$.INSIDE_CONNECTIVE();
                });
                offset.elem += len;
                continue;
            }
            ++offset.elem;
        }
        return var2_2;
    }

    public String[] matchesConnective(String[] words, int offset) {
        String[] stringArray;
        Object object = new Object();
        try {
            this.CONNECTIVES().foreach((Function1 & Serializable & scala.Serializable)pattern -> {
                ConnectiveMatcher$.$anonfun$matchesConnective$1(words, offset, object, pattern);
                return BoxedUnit.UNIT;
            });
            stringArray = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                stringArray = (String[])ex.value();
            }
            throw ex;
        }
        return stringArray;
    }

    public static final /* synthetic */ void $anonfun$matchesConnective$1(String[] words$1, int offset$2, Object nonLocalReturnKey1$1, String[] pattern) {
        BooleanRef found = BooleanRef.create((boolean)true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.length).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> found$1.elem).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block1: {
                block0: {
                    if (i + offset$2 < new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])words$1)).size()) break block0;
                    found$1.elem = false;
                    break block1;
                }
                if (pattern[i].equalsIgnoreCase(words$1[i + offset$2])) break block1;
                found$1.elem = false;
            }
        });
        if (found.elem) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)pattern);
        }
    }

    private ConnectiveMatcher$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(ConnectiveMatcher.class);
        this.DEFAULT_CONNECTIVE_FILE = "org/clulab/discourse/rstparser/discourse_connectives.txt";
        this.NO_CONNECTIVE = "O";
        this.BEGIN_CONNECTIVE = "B";
        this.INSIDE_CONNECTIVE = "I";
    }
}

