/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.discourse.rstparser;

import java.io.Serializable;
import org.clulab.discourse.rstparser.CorpusStats;
import org.clulab.discourse.rstparser.DiscourseTree;
import org.clulab.discourse.rstparser.RelationFeatureExtractor$;
import org.clulab.discourse.rstparser.Utils$;
import org.clulab.processors.Document;
import org.clulab.struct.CorefChains;
import org.clulab.struct.CorefMention;
import org.clulab.struct.Counter;
import org.clulab.struct.DirectedGraph;
import org.clulab.struct.Tree;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u0017\tA\"+\u001a7bi&|gNR3biV\u0014X-\u0012=ue\u0006\u001cGo\u001c:\u000b\u0005\r!\u0011!\u0003:tiB\f'o]3s\u0015\t)a!A\u0005eSN\u001cw.\u001e:tK*\u0011q\u0001C\u0001\u0007G2,H.\u00192\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011!\u0019\u0002A!b\u0001\n\u0003!\u0012A\u00024jYR,'/F\u0001\u0016!\r1R\u0004\t\b\u0003/m\u0001\"\u0001\u0007\b\u000e\u0003eQ!A\u0007\u0006\u0002\rq\u0012xn\u001c;?\u0013\tab\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003=}\u00111aU3u\u0015\tab\u0002\u0005\u0002\u0017C%\u0011!e\b\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0011\u0002!\u0011!Q\u0001\nU\tqAZ5mi\u0016\u0014\b\u0005C\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0003Q)\u0002\"!\u000b\u0001\u000e\u0003\tAqaE\u0013\u0011\u0002\u0003\u0007Q\u0003C\u0004-\u0001\u0001\u0007I\u0011A\u0017\u0002\u000fY,'OY8tKV\ta\u0006\u0005\u0002\u000e_%\u0011\u0001G\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011\u0004\u00011A\u0005\u0002M\n1B^3sE>\u001cXm\u0018\u0013fcR\u0011Ag\u000e\t\u0003\u001bUJ!A\u000e\b\u0003\tUs\u0017\u000e\u001e\u0005\bqE\n\t\u00111\u0001/\u0003\rAH%\r\u0005\u0007u\u0001\u0001\u000b\u0015\u0002\u0018\u0002\u0011Y,'OY8tK\u0002BQ\u0001\u0010\u0001\u0005\u0002u\n!\"\\6GK\u0006$XO]3t)\u001dqD)S&T?\u0012\u00042a\u0010\"!\u001b\u0005\u0001%BA!\u0007\u0003\u0019\u0019HO];di&\u00111\t\u0011\u0002\b\u0007>,h\u000e^3s\u0011\u0015)5\b1\u0001G\u0003\u0011aWM\u001a;\u0011\u0005%:\u0015B\u0001%\u0003\u00055!\u0015n]2pkJ\u001cX\r\u0016:fK\")!j\u000fa\u0001\r\u0006)!/[4ii\")Aj\u000fa\u0001\u001b\u0006\u0019Am\\2\u0011\u00059\u000bV\"A(\u000b\u0005A3\u0011A\u00039s_\u000e,7o]8sg&\u0011!k\u0014\u0002\t\t>\u001cW/\\3oi\")Ak\u000fa\u0001+\u0006!Q\rZ;t!\ria\u000bW\u0005\u0003/:\u0011Q!\u0011:sCf\u00042!\u0004,Z!\u0011i!\f\u0018/\n\u0005ms!A\u0002+va2,'\u0007\u0005\u0002\u000e;&\u0011aL\u0004\u0002\u0004\u0013:$\b\"\u00021<\u0001\u0004\t\u0017aC2peB,8o\u0015;biN\u0004\"!\u000b2\n\u0005\r\u0014!aC\"peB,8o\u0015;biNDQ!Z\u001eA\u0002\u0001\nQ\u0001\\1cK2<qa\u001a\u0002\u0002\u0002#\u0005\u0001.\u0001\rSK2\fG/[8o\r\u0016\fG/\u001e:f\u000bb$(/Y2u_J\u0004\"!K5\u0007\u000f\u0005\u0011\u0011\u0011!E\u0001UN\u0011\u0011\u000e\u0004\u0005\u0006M%$\t\u0001\u001c\u000b\u0002Q\"9a.[I\u0001\n\u0003y\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'F\u0001qU\t)\u0012oK\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/A\u0005v]\u000eDWmY6fI*\u0011qOD\u0001\u000bC:tw\u000e^1uS>t\u0017BA=u\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class RelationFeatureExtractor {
    private final Set<String> filter;
    private boolean verbose;

    public static Set<String> $lessinit$greater$default$1() {
        return RelationFeatureExtractor$.MODULE$.$lessinit$greater$default$1();
    }

    public Set<String> filter() {
        return this.filter;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    public Counter<String> mkFeatures(DiscourseTree left, DiscourseTree right, Document doc, Tuple2<Object, Object>[][] edus, CorpusStats corpusStats, String label) {
        Counter<String> features;
        block1: {
            features = new Counter<String>();
            if (this.verbose()) {
                Predef$.MODULE$.println((Object)("Creating features for label " + label + "\nLEFT:\n" + left + "RIGHT:\n" + right));
            }
            this.writeBaselineFeatures$1(left, right, doc, edus, features);
            this.writeWordPairFeatures$1(left, right, doc, edus, corpusStats, features);
            this.writePrefixSuffixFeatures$1(left, doc, corpusStats, "L", features);
            this.writePrefixSuffixFeatures$1(right, doc, corpusStats, "R", features);
            this.writeDomSetFeatures$1(left, right, doc, edus, corpusStats, features);
            this.writeProdRuleFeatures$1(left, doc, 1, "L", features);
            this.writeProdRuleFeatures$1(right, doc, 1, "R", features);
            this.writeJointProdRuleFeatures$1(left, right, doc, features);
            this.writeCorefFeatures$1(left, right, doc, features);
            if (!this.verbose()) break block1;
            RelationFeatureExtractor.printFeatures$1(features);
        }
        return features;
    }

    private final void f$1(String fn, double fv, Counter features$1) {
        block0: {
            if (this.filter() != null && !this.filter().contains((Object)Utils$.MODULE$.prefix(fn, ":"))) break block0;
            features$1.incrementCount(fn, fv);
        }
    }

    private static final double f$default$2$1() {
        return 1.0;
    }

    public static final /* synthetic */ void $anonfun$mkFeatures$1(Counter features$1, String k) {
        double v = features$1.getCount(k);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, BoxesRunTime.boxToDouble((double)v)})));
    }

    private static final void printFeatures$1(Counter features$1) {
        features$1.keySet().foreach((Function1 & Serializable & scala.Serializable)k -> {
            RelationFeatureExtractor.$anonfun$mkFeatures$1(features$1, k);
            return BoxedUnit.UNIT;
        });
    }

    private final void writeBaselineFeatures$1(DiscourseTree left, DiscourseTree right, Document doc, Tuple2[][] edus, Counter features$1) {
        Tree leftSubtree = Utils$.MODULE$.findSubtree(left, doc);
        Tree rightSubtree = Utils$.MODULE$.findSubtree(right, doc);
        this.f$1("Len_L", left.tokenCount(), features$1);
        this.f$1("Len_R", right.tokenCount(), features$1);
        this.f$1("Num_edus_L", left.eduCount(), features$1);
        this.f$1("Num_edus_R", right.eduCount(), features$1);
        this.f$1("num_edus_diff", left.eduCount() - right.eduCount(), features$1);
        this.f$1("num_tokens_diff", left.tokenCount() - right.tokenCount(), features$1);
        this.writePositionFeatures$1(left, doc, edus, leftSubtree, "L", features$1);
        this.writePositionFeatures$1(right, doc, edus, rightSubtree, "R", features$1);
        if (left.firstSentence() == right.lastSentence()) {
            if (Utils$.MODULE$.sameSubtree(leftSubtree, rightSubtree)) {
                this.f$1("embedded", 3.0, features$1);
            } else {
                this.f$1("embedded", 2.0, features$1);
            }
        } else {
            this.f$1("embedded", 0.0, features$1);
        }
    }

    private final void writeDomSetWithDepsFeatures$1(DiscourseTree left, DiscourseTree right, Document doc, Tuple2[][] edus, CorpusStats corpusStats, Counter features$1) {
        if (!Utils$.MODULE$.hasDeps(doc.sentences()[left.firstSentence()])) {
            return;
        }
        if (left.firstToken().sentence() == right.lastToken().sentence()) {
            String[] words = doc.sentences()[left.firstSentence()].words();
            String[] tags = (String[])doc.sentences()[left.firstSentence()].tags().get();
            DirectedGraph<String> dependencies = Utils$.MODULE$.deps(doc.sentences()[left.firstSentence()]);
            Tuple3<Object, Object, String> tuple3 = Utils$.MODULE$.findSyntacticHeadFromDependencies(dependencies, left.firstToken().token(), left.lastToken().token());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int leftHead = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int leftHeadParent = BoxesRunTime.unboxToInt((Object)tuple3._2());
            String leftParentRel = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)leftHead), (Object)BoxesRunTime.boxToInteger((int)leftHeadParent), (Object)leftParentRel);
            Tuple3 tuple33 = tuple32;
            int leftHead2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
            int leftHeadParent2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            String leftParentRel2 = (String)tuple33._3();
            Tuple3<Object, Object, String> tuple34 = Utils$.MODULE$.findSyntacticHeadFromDependencies(dependencies, right.firstToken().token(), right.lastToken().token());
            if (tuple34 == null) {
                throw new MatchError(tuple34);
            }
            int rightHead = BoxesRunTime.unboxToInt((Object)tuple34._1());
            int rightHeadParent = BoxesRunTime.unboxToInt((Object)tuple34._2());
            String rightParentRel = (String)tuple34._3();
            Tuple3 tuple35 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)rightHead), (Object)BoxesRunTime.boxToInteger((int)rightHeadParent), (Object)rightParentRel);
            Tuple3 tuple36 = tuple35;
            int rightHead2 = BoxesRunTime.unboxToInt((Object)tuple36._1());
            int rightHeadParent2 = BoxesRunTime.unboxToInt((Object)tuple36._2());
            String rightParentRel2 = (String)tuple36._3();
            Iterable<Object> commonAncestors = Utils$.MODULE$.findCommonAncestorsFromDependencies(dependencies, left.firstToken().token(), right.lastToken().token());
            if (leftHead2 != -1 && rightHead2 != -1) {
                int dominating = -1;
                int dominated = -1;
                String domRel = "";
                boolean leftDominates = true;
                if (rightHeadParent2 != -1 && rightHeadParent2 >= left.firstToken().token() && rightHeadParent2 <= left.lastToken().token()) {
                    leftDominates = true;
                    dominating = rightHeadParent2;
                    dominated = rightHead2;
                    domRel = rightParentRel2;
                } else if (leftHeadParent2 != -1 && leftHeadParent2 >= right.firstToken().token() && leftHeadParent2 <= right.lastToken().token()) {
                    leftDominates = false;
                    dominating = leftHeadParent2;
                    dominated = leftHead2;
                    domRel = leftParentRel2;
                }
                if (leftHead2 != -1) {
                    double leftHeadPos = (double)leftHead2 / (double)words.length;
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-leftheadpos"})).s((Seq)Nil$.MODULE$), leftHeadPos, features$1);
                }
                if (rightHead2 != -1) {
                    double rightHeadPos = (double)rightHead2 / (double)words.length;
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-rightheadpos"})).s((Seq)Nil$.MODULE$), rightHeadPos, features$1);
                }
                if (dominating != -1 && dominated != -1) {
                    this.f$1("deps-dominates-" + leftDominates, RelationFeatureExtractor.f$default$2$1(), features$1);
                    commonAncestors.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ancestor -> {
                        if (ancestor == -1) {
                            this.f$1("deps-ancestorisroot", RelationFeatureExtractor.f$default$2$1(), features$1);
                        } else {
                            String aw = words[ancestor];
                            this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-ancestorword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aw})), RelationFeatureExtractor.f$default$2$1(), features$1);
                            String at = tags[ancestor];
                            this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-ancestortag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{at})), RelationFeatureExtractor.f$default$2$1(), features$1);
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dependencies.incomingEdges()[ancestor])).foreach((Function1 & Serializable & scala.Serializable)d -> {
                                this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-ancestor-inc:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d._2()})), RelationFeatureExtractor.f$default$2$1(), features$1);
                                return BoxedUnit.UNIT;
                            });
                        }
                    });
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-dominatingword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{words[dominating]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-dominatedword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{words[dominated]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-dominatingtag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tags[dominating]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-dominatedtag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tags[dominated]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deps-domrel:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{domRel})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-deps-dominatingword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), words[dominating]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-deps-dominatedword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), words[dominated]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-deps-dominatingtag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), tags[dominating]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-deps-dominatedtag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), tags[dominated]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-deps-domrel:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), domRel})), RelationFeatureExtractor.f$default$2$1(), features$1);
                } else {
                    this.f$1("deps-samesent-dominates-unk", RelationFeatureExtractor.f$default$2$1(), features$1);
                }
            }
        } else {
            this.f$1("dominates-unk", RelationFeatureExtractor.f$default$2$1(), features$1);
        }
    }

    private final void writeDomSetFeatures$1(DiscourseTree left, DiscourseTree right, Document doc, Tuple2[][] edus, CorpusStats corpusStats, Counter features$1) {
        if (doc.sentences()[left.firstSentence()].syntacticTree().isEmpty()) {
            if (Utils$.MODULE$.hasDeps(doc.sentences()[left.firstSentence()])) {
                this.writeDomSetWithDepsFeatures$1(left, right, doc, edus, corpusStats, features$1);
                return;
            }
            throw new RuntimeException("ERROR: you need either constituent or dependency-based available for discourse parsing!");
        }
        if (left.firstToken().sentence() == right.lastToken().sentence()) {
            String[] words = doc.sentences()[left.firstSentence()].words();
            String[] tags = (String[])doc.sentences()[left.firstSentence()].tags().get();
            Tree tree = (Tree)doc.sentences()[left.firstSentence()].syntacticTree().get();
            Tuple2<Tree, Tree> tuple2 = Utils$.MODULE$.findSyntacticHead(tree, null, left.firstToken().token(), left.lastToken().token());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Tree leftHead = (Tree)tuple2._1();
            Tree leftHeadParent = (Tree)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)leftHead, (Object)leftHeadParent);
            Tuple2 tuple23 = tuple22;
            Tree leftHead2 = (Tree)tuple23._1();
            Tree leftHeadParent2 = (Tree)tuple23._2();
            Tuple2<Tree, Tree> tuple24 = Utils$.MODULE$.findSyntacticHead(tree, null, right.firstToken().token(), right.lastToken().token());
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            Tree rightHead = (Tree)tuple24._1();
            Tree rightHeadParent = (Tree)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)rightHead, (Object)rightHeadParent);
            Tuple2 tuple26 = tuple25;
            Tree rightHead2 = (Tree)tuple26._1();
            Tree rightHeadParent2 = (Tree)tuple26._2();
            Tree commonAncestor = Utils$.MODULE$.findSmallestCommonAncestor(tree, left.firstToken().token(), right.lastToken().token());
            Predef$.MODULE$.assert(commonAncestor != null);
            if (leftHead2 != null && rightHead2 != null) {
                Tree dominating = null;
                Tree dominated = null;
                boolean leftDominates = true;
                if (rightHeadParent2 != null && rightHeadParent2.headOffset() >= leftHead2.startOffset() && rightHeadParent2.headOffset() < leftHead2.endOffset()) {
                    leftDominates = true;
                    dominating = rightHeadParent2;
                    dominated = rightHead2;
                } else if (leftHeadParent2 != null && leftHeadParent2.headOffset() >= rightHead2.startOffset() && leftHeadParent2.headOffset() < rightHead2.endOffset()) {
                    leftDominates = false;
                    dominating = leftHeadParent2;
                    dominated = leftHead2;
                }
                double leftHeadPos = (double)leftHead2.headOffset() / (double)words.length;
                double rightHeadPos = (double)rightHead2.headOffset() / (double)words.length;
                this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leftheadpos"})).s((Seq)Nil$.MODULE$), leftHeadPos, features$1);
                this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rightheadpos"})).s((Seq)Nil$.MODULE$), rightHeadPos, features$1);
                if (dominating != null && dominated != null) {
                    this.f$1("dominates-" + leftDominates, RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-dominatinglabel:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), dominating.value()})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-dominatedlabel:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), dominated.value()})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-ancestorlabel:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), commonAncestor.value()})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-dominatingword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), words[dominating.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-dominatedword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), words[dominated.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-ancestorword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), words[commonAncestor.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-dominatingtag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), tags[dominating.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-dominatedtag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), tags[dominated.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-ancestortag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)leftDominates), tags[commonAncestor.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dominatinglabel:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dominating.value()})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dominatedlabel:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dominated.value()})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ancestorlabel:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commonAncestor.value()})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dominatingword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{words[dominating.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dominatedword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{words[dominated.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ancestorword:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{words[commonAncestor.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dominatingtag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tags[dominating.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dominatedtag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tags[dominated.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                    this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ancestortag:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tags[commonAncestor.headOffset()]})), RelationFeatureExtractor.f$default$2$1(), features$1);
                } else {
                    this.f$1("samesent-dominates-unk", RelationFeatureExtractor.f$default$2$1(), features$1);
                }
            }
        } else {
            this.f$1("dominates-unk", RelationFeatureExtractor.f$default$2$1(), features$1);
        }
    }

    private final void writePrefixSuffixFeatures$1(DiscourseTree tree, Document doc, CorpusStats corpusStats, String suffix, Counter features$1) {
        String[] words = Utils$.MODULE$.extractWords(tree, doc, Utils$.MODULE$.extractWords$default$3(), Utils$.MODULE$.extractWords$default$4());
        String[] tags = Utils$.MODULE$.extractTags(tree, doc);
        this.f$1("prefix_" + suffix + ":" + Utils$.MODULE$.mkNgram(words, 0, 3), 1.0, features$1);
        this.f$1("prefix_" + suffix + ":" + Utils$.MODULE$.mkNgram(words, 0, 2), 1.0, features$1);
        this.f$1("prefix_" + suffix + ":" + Utils$.MODULE$.mkNgram(words, 0, 1), 1.0, features$1);
        this.f$1("tprefix_" + suffix + ":" + Utils$.MODULE$.mkNgram(tags, 0, 3), 1.0, features$1);
        this.f$1("tprefix_" + suffix + ":" + Utils$.MODULE$.mkNgram(tags, 0, 2), 1.0, features$1);
        this.f$1("tprefix_" + suffix + ":" + Utils$.MODULE$.mkNgram(tags, 0, 1), 1.0, features$1);
        this.f$1("suffix_" + suffix + ":" + Utils$.MODULE$.mkNgram(words, words.length - 3, words.length), 1.0, features$1);
        this.f$1("suffix_" + suffix + ":" + Utils$.MODULE$.mkNgram(words, words.length - 2, words.length), 1.0, features$1);
        this.f$1("suffix_" + suffix + ":" + Utils$.MODULE$.mkNgram(words, words.length - 1, words.length), 1.0, features$1);
        this.f$1("tsuffix_" + suffix + ":" + Utils$.MODULE$.mkNgram(tags, tags.length - 3, tags.length), 1.0, features$1);
        this.f$1("tsuffix_" + suffix + ":" + Utils$.MODULE$.mkNgram(tags, tags.length - 2, tags.length), 1.0, features$1);
        this.f$1("tsuffix_" + suffix + ":" + Utils$.MODULE$.mkNgram(tags, tags.length - 1, tags.length), 1.0, features$1);
    }

    private final void writeUnigrams$1(DiscourseTree tree, Document doc, CorpusStats corpusStats, String suffix, Counter features$1) {
        String[] words = Utils$.MODULE$.extractWords(tree, doc, corpusStats.knownWords(), 10);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])words)).foreach((Function1 & Serializable & scala.Serializable)w -> {
            this.f$1("unigram:" + w, RelationFeatureExtractor.f$default$2$1(), features$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void writePositionFeatures$1(DiscourseTree tree, Document doc, Tuple2[][] edus, Tree subtree, String suffix, Counter features$1) {
        if (tree.firstToken().sentence() == tree.lastToken().sentence()) {
            this.f$1("Inside_sentence_" + suffix, 1.0, features$1);
            this.f$1("Sentence_EDUs_cover_" + suffix, (double)(tree.lastEDU() - tree.firstEDU()) / (double)edus[tree.firstSentence()].length, features$1);
            this.f$1("Sentence_tokens_cover_" + suffix, (double)(tree.lastToken().token() - tree.firstToken().token()) / (double)doc.sentences()[tree.firstSentence()].size(), features$1);
            if (subtree != null && (subtree.startOffset() < tree.firstToken().token() || subtree.endOffset() > tree.lastToken().token() + 1)) {
                this.f$1("Embedded_in_subtree_with_other_EDU" + suffix, 1.0, features$1);
            } else {
                this.f$1("Embedded_in_subtree_with_other_EDU" + suffix, 0.0, features$1);
            }
        } else {
            this.f$1("Inside_sentence_" + suffix, 0.0, features$1);
            this.f$1("Sentence_EDUs_cover_" + suffix, 0.0, features$1);
            this.f$1("Sentence_tokens_cover_" + suffix, 0.0, features$1);
            this.f$1("Embedded_in_subtree_with_other_EDU_" + suffix, 0.0, features$1);
        }
        this.f$1("Sentence_span_" + suffix, tree.lastToken().sentence() - tree.firstToken().sentence(), features$1);
    }

    public static final /* synthetic */ void $anonfun$mkFeatures$5(RelationFeatureExtractor $this, Counter features$1, String[] rightWords$1, String l) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightWords$1)).foreach((Function1 & Serializable & scala.Serializable)r -> {
            $this.f$1("wordpair:" + l + "_" + r, 1.0, features$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void writeWordPairFeatures$1(DiscourseTree left, DiscourseTree right, Document doc, Tuple2[][] edus, CorpusStats corpusStats, Counter features$1) {
        int t = 100;
        Predef$.MODULE$.assert(corpusStats != null);
        String[] leftWords = Utils$.MODULE$.extractWords(left, doc, corpusStats.knownWords(), t);
        String[] rightWords = Utils$.MODULE$.extractWords(right, doc, corpusStats.knownWords(), t);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftWords)).foreach((Function1 & Serializable & scala.Serializable)l -> {
            RelationFeatureExtractor.$anonfun$mkFeatures$5(this, features$1, rightWords, l);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$mkFeatures$8(RelationFeatureExtractor $this, Counter features$1, Counter rightConnectives$1, double lv$1, String l$2, String r) {
        double rv = rightConnectives$1.getCount(r);
        $this.f$1("connpair:" + l$2 + "_" + r, lv$1 * rv, features$1);
    }

    public static final /* synthetic */ void $anonfun$mkFeatures$7(RelationFeatureExtractor $this, Counter features$1, Counter leftConnectives$1, Counter rightConnectives$1, String l) {
        double lv = leftConnectives$1.getCount(l);
        rightConnectives$1.keySet().foreach((Function1 & Serializable & scala.Serializable)r -> {
            RelationFeatureExtractor.$anonfun$mkFeatures$8($this, features$1, rightConnectives$1, lv, l, r);
            return BoxedUnit.UNIT;
        });
    }

    private final void writeConnectiveFeatures$1(DiscourseTree left, DiscourseTree right, Document doc, Tuple2[][] edus, Counter features$1) {
        Counter<String> leftConnectives = Utils$.MODULE$.extractConnectives(left, doc);
        Counter<String> rightConnectives = Utils$.MODULE$.extractConnectives(right, doc);
        leftConnectives.keySet().foreach((Function1 & Serializable & scala.Serializable)l -> {
            RelationFeatureExtractor.$anonfun$mkFeatures$7(this, features$1, leftConnectives, rightConnectives, l);
            return BoxedUnit.UNIT;
        });
    }

    private final void writeProdRuleFeatures$1(DiscourseTree tree, Document doc, int depth, String suffix, Counter features$1) {
        if (depth > 1) {
            return;
        }
        if (tree.isTerminal()) {
            this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rule-", "-d", ":NO-REL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix, BoxesRunTime.boxToInteger((int)depth)})), RelationFeatureExtractor.f$default$2$1(), features$1);
        } else {
            this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rule-", "-d", ":", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix, BoxesRunTime.boxToInteger((int)depth), tree.children()[0].relationLabel(), tree.children()[1].relationLabel()})), RelationFeatureExtractor.f$default$2$1(), features$1);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tree.children())).foreach((Function1 & Serializable & scala.Serializable)c -> {
                this.writeProdRuleFeatures$1(c, doc, depth + 1, suffix, features$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$mkFeatures$10(DiscourseTree left$1, DiscourseTree right$1, IntRef linkCount$1, Iterable chain) {
        int leftMentions = RelationFeatureExtractor.countMentions$1(chain, left$1);
        int rightMentions = RelationFeatureExtractor.countMentions$1(chain, right$1);
        linkCount$1.elem += leftMentions * rightMentions;
    }

    private final void writeCorefFeatures$1(DiscourseTree left, DiscourseTree right, Document doc, Counter features$1) {
        if (doc.coreferenceChains().isEmpty()) {
            return;
        }
        IntRef linkCount = IntRef.create((int)0);
        ((CorefChains)doc.coreferenceChains().get()).getChains().foreach((Function1 & Serializable & scala.Serializable)chain -> {
            RelationFeatureExtractor.$anonfun$mkFeatures$10(left, right, linkCount, chain);
            return BoxedUnit.UNIT;
        });
        this.f$1("coreflinks", linkCount.elem, features$1);
    }

    public static final /* synthetic */ void $anonfun$mkFeatures$11(DiscourseTree tree$1, IntRef count$1, CorefMention m) {
        block0: {
            if (m.sentenceIndex() < tree$1.firstSentence() || m.sentenceIndex() > tree$1.lastSentence() || m.headIndex() < tree$1.firstToken().token() || m.headIndex() > tree$1.lastToken().token()) break block0;
            ++count$1.elem;
        }
    }

    private static final int countMentions$1(Iterable chain, DiscourseTree tree) {
        IntRef count = IntRef.create((int)0);
        chain.foreach((Function1 & Serializable & scala.Serializable)m -> {
            RelationFeatureExtractor.$anonfun$mkFeatures$11(tree, count, m);
            return BoxedUnit.UNIT;
        });
        return count.elem;
    }

    private final void writeJointProdRuleFeatures$1(DiscourseTree left, DiscourseTree right, Document doc, Counter features$1) {
        this.f$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"toprule:", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left.relationLabel(), right.relationLabel()})), RelationFeatureExtractor.f$default$2$1(), features$1);
    }

    public RelationFeatureExtractor(Set<String> filter) {
        this.filter = filter;
        this.verbose = false;
    }
}

