/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.discourse.rstparser;

import java.io.Serializable;
import org.clulab.discourse.rstparser.ConnectiveMatcher$;
import org.clulab.discourse.rstparser.DiscourseTree;
import org.clulab.learning.Classifier;
import org.clulab.learning.LiblinearClassifier;
import org.clulab.learning.LinearSVMClassifier;
import org.clulab.learning.LinearSVMClassifier$;
import org.clulab.learning.LogisticRegressionClassifier;
import org.clulab.learning.LogisticRegressionClassifier$;
import org.clulab.learning.PerceptronClassifier;
import org.clulab.learning.PerceptronClassifier$;
import org.clulab.processors.Document;
import org.clulab.processors.Sentence;
import org.clulab.struct.Counter;
import org.clulab.struct.DirectedGraph;
import org.clulab.struct.Lexicon;
import org.clulab.struct.Tree;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public DirectedGraph<String> deps(Sentence s) {
        return (DirectedGraph)s.universalBasicDependencies().get();
    }

    public boolean hasDeps(Sentence s) {
        return s.universalBasicDependencies().isDefined();
    }

    public int tokenCount(Document doc) {
        IntRef sum = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)s -> {
            Utils$.$anonfun$tokenCount$1(sum, s);
            return BoxedUnit.UNIT;
        });
        return sum.elem;
    }

    public Counter<String> extractConnectives(DiscourseTree tree, Document doc) {
        String[] words = this.extractWords(tree, doc, null, this.extractWords$default$4());
        Counter<String> c = new Counter<String>();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])words)).size()).foreach((Function1 & Serializable & scala.Serializable)offset -> Utils$.$anonfun$extractConnectives$1(words, c, BoxesRunTime.unboxToInt((Object)offset)));
        return c;
    }

    public String mkDiscretePosition(int offset, int total) {
        if ((double)offset < (double)total * 1.0 / 3.0) {
            return "B";
        }
        if ((double)offset < (double)total * 2.0 / 3.0) {
            return "M";
        }
        return "E";
    }

    public boolean sameSubtree(Tree t1, Tree t2) {
        return t1 != null && t2 != null && t1.startOffset() == t2.startOffset() && t1.endOffset() == t2.endOffset();
    }

    public Tree findSubtree(DiscourseTree tree, Document doc) {
        if (tree.firstSentence() != tree.lastSentence()) {
            return null;
        }
        if (!doc.sentences()[tree.firstSentence()].syntacticTree().isDefined()) {
            return null;
        }
        int start = tree.firstToken().token();
        int end = tree.lastToken().token() + 1;
        Tree subtree = this.findSubtree((Tree)doc.sentences()[tree.firstSentence()].syntacticTree().get(), start, end);
        return subtree;
    }

    public Tree findSubtree(Tree tree, int start, int end) {
        if (!tree.isLeaf()) {
            ObjectRef m = ObjectRef.create(null);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tree.children().get())).withFilter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findSubtree$1(m, c))).foreach((Function1 & Serializable & scala.Serializable)c -> {
                m.elem = Utils$.MODULE$.findSubtree(c, start, end);
                return BoxedUnit.UNIT;
            });
            if ((Tree)m.elem != null) {
                return (Tree)m.elem;
            }
        }
        return !tree.isLeaf() && tree.value().startsWith("S") && tree.startOffset() <= start && tree.endOffset() >= end ? tree : null;
    }

    public String[] extractWords(DiscourseTree tree, Document doc, Counter<String> words, int threshold) {
        ListBuffer b = new ListBuffer();
        int t = tree.firstToken().token();
        for (int s = tree.firstSentence(); s <= tree.lastSentence(); ++s) {
            while (s < tree.lastSentence() && t < doc.sentences()[s].size() || s == tree.lastSentence() && t <= tree.lastToken().token()) {
                String w = doc.sentences()[s].words()[t];
                Object object = words == null || words.getCount(w) > (double)threshold ? b.$plus$eq((Object)w) : BoxedUnit.UNIT;
                ++t;
            }
            t = 0;
        }
        return (String[])b.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Counter<String> extractWords$default$3() {
        return null;
    }

    public int extractWords$default$4() {
        return 1000;
    }

    public String[] extractTags(DiscourseTree tree, Document doc) {
        ListBuffer b = new ListBuffer();
        int t = tree.firstToken().token();
        for (int s = tree.firstSentence(); s <= tree.lastSentence(); ++s) {
            while (s < tree.lastSentence() && t < doc.sentences()[s].size() || s == tree.lastSentence() && t <= tree.lastToken().token()) {
                String tag = ((String[])doc.sentences()[s].tags().get())[t];
                b.$plus$eq((Object)tag);
                ++t;
            }
            t = 0;
        }
        return (String[])b.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public void extractRightMost(DiscourseTree t, ArrayBuffer<DiscourseTree> nodes) {
        while (true) {
            nodes.$plus$eq((Object)t);
            if (t.isTerminal()) break;
            t = (DiscourseTree)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.children())).last();
        }
    }

    public void extractLeftMost(DiscourseTree t, ArrayBuffer<DiscourseTree> nodes) {
        while (true) {
            nodes.$plus$eq((Object)t);
            if (t.isTerminal()) break;
            t = (DiscourseTree)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.children())).head();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Counter<String> countWords(List<Tuple2<DiscourseTree, Document>> trees) {
        void var2_2;
        Counter c = new Counter();
        trees.foreach((Function1 & Serializable & scala.Serializable)td -> {
            Utils$.$anonfun$countWords$1(c, td);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Counter<String> countNgrams(List<Tuple2<DiscourseTree, Document>> trees) {
        void var2_2;
        Counter c = new Counter();
        trees.foreach((Function1 & Serializable & scala.Serializable)td -> BoxesRunTime.boxToDouble((double)Utils$.$anonfun$countNgrams$1(c, td)));
        return var2_2;
    }

    public String mkNgram(String[] words, int start, int end) {
        StringBuilder b = new StringBuilder();
        BooleanRef first = BooleanRef.create((boolean)true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(package$.MODULE$.max(start, 0)), package$.MODULE$.min(end, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])words)).size())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Object object = !first$5.elem ? b.append("-") : BoxedUnit.UNIT;
            b.append(words[i]);
            first$5.elem = false;
        });
        return b.toString();
    }

    public Tuple3<Tree, Tree, Tree> findSyntacticParentWithRightSibling(Tree root, int position, Tree parent, Tree right) {
        Tuple3 tuple3;
        Object object = new Object();
        try {
            if (root.headOffset() == position && right != null) {
                return new Tuple3((Object)root, (Object)parent, (Object)right);
            }
            if (!root.isLeaf()) {
                Predef$.MODULE$.assert(root.children().isDefined());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((Tree[])root.children().get()).length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    Tuple3<Tree, Tree, Tree> v;
                    Tree c = ((Tree[])root.children().get())[i];
                    Tree r = null;
                    if (i < ((Tree[])root.children().get()).length - 1) {
                        r = ((Tree[])root.children().get())[i + 1];
                    }
                    if ((v = MODULE$.findSyntacticParentWithRightSibling(c, position, root, r))._1() != null) {
                        throw new NonLocalReturnControl(object, v);
                    }
                });
            }
            tuple3 = new Tuple3(null, null, null);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple3 = (Tuple3)ex.value();
            }
            throw ex;
        }
        return tuple3;
    }

    public Tuple2<Tree, Tree> findSyntacticParent(Tree root, int position, Tree parent) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            if (root.headOffset() == position) {
                return new Tuple2((Object)root, (Object)parent);
            }
            if (!root.isLeaf()) {
                Predef$.MODULE$.assert(root.children().isDefined());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((Tree[])root.children().get()).length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    Tree c = ((Tree[])root.children().get())[i];
                    Tuple2<Tree, Tree> v = MODULE$.findSyntacticParent(c, position, root);
                    if (v._1() != null) {
                        throw new NonLocalReturnControl(object, v);
                    }
                });
            }
            tuple2 = new Tuple2(null, null);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tree findSyntacticParentWithRightSibling$default$3() {
        return null;
    }

    public Tree findSyntacticParentWithRightSibling$default$4() {
        return null;
    }

    public Tree findSyntacticParent$default$3() {
        return null;
    }

    public Tuple3<Object, Object, String> findSyntacticHeadFromDependencies(DirectedGraph<String> deps, int first, int last) {
        Tuple3 tuple3;
        Object object = new Object();
        try {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(first), last).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (deps.roots().contains((Object)BoxesRunTime.boxToInteger((int)i))) {
                    throw new NonLocalReturnControl(object, (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)""));
                }
                Tuple2<Object, E>[] heads = deps.incomingEdges()[i];
                BooleanRef outside = BooleanRef.create((boolean)false);
                IntRef p = IntRef.create((int)-1);
                ObjectRef l = ObjectRef.create((Object)"");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])heads)).withFilter((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findSyntacticHeadFromDependencies$2(outside, h))).foreach((Function1 & Serializable & scala.Serializable)h -> {
                    Utils$.$anonfun$findSyntacticHeadFromDependencies$3(first, last, outside, p, l, h);
                    return BoxedUnit.UNIT;
                });
                if (outside.elem) {
                    throw new NonLocalReturnControl(object, (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)p.elem), (Object)((String)l.elem)));
                }
            });
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)"");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple3 = (Tuple3)ex.value();
            }
            throw ex;
        }
        return tuple3;
    }

    public Tuple2<Tree, Tree> findSyntacticHead(Tree root, Tree parent, int first, int last) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            if (root.headOffset() >= first && root.headOffset() <= last) {
                return new Tuple2((Object)root, (Object)parent);
            }
            if (!root.isLeaf()) {
                Predef$.MODULE$.assert(root.children().isDefined());
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.children().get())).foreach((Function1 & Serializable & scala.Serializable)c -> {
                    Utils$.$anonfun$findSyntacticHead$1(root, first, last, object, c);
                    return BoxedUnit.UNIT;
                });
            }
            tuple2 = new Tuple2(null, null);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tree findSmallestCommonAncestor(Tree root, int first, int last) {
        Tree tree;
        Object object = new Object();
        try {
            if (!root.isLeaf()) {
                Predef$.MODULE$.assert(root.children().isDefined());
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.children().get())).foreach((Function1 & Serializable & scala.Serializable)c -> {
                    Utils$.$anonfun$findSmallestCommonAncestor$1(first, last, object, c);
                    return BoxedUnit.UNIT;
                });
            }
            if (root.startOffset() <= first && root.endOffset() >= last) {
                return root;
            }
            tree = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tree = (Tree)ex.value();
            }
            throw ex;
        }
        return tree;
    }

    public Iterable<Object> findCommonAncestorsFromDependencies(DirectedGraph<String> deps, int first, int last) {
        ListBuffer ancestors = new ListBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(first), last).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                Tuple2<Object, E>[] heads;
                Object object = deps.roots().contains((Object)BoxesRunTime.boxToInteger((int)i)) ? ancestors.$plus$eq((Object)BoxesRunTime.boxToInteger((int)-1)) : BoxedUnit.UNIT;
                Predef$.MODULE$.assert(i >= 0);
                if (i >= new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deps.incomingEdges())).size() || (heads = deps.incomingEdges()[i]) == null) break block0;
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])heads)).foreach((Function1 & Serializable & scala.Serializable)h -> h._1$mcI$sp() < first || h._1$mcI$sp() > last ? ancestors.$plus$eq((Object)BoxesRunTime.boxToInteger((int)h._1$mcI$sp())) : BoxedUnit.UNIT);
            }
        });
        return ancestors.toList();
    }

    public int toDecile(int v, int max) {
        int n;
        Object object = new Object();
        try {
            double dec = 10.0 * (double)v / (double)max;
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (dec < (double)i) {
                    throw new NonLocalReturnControl.mcI.sp(object, i);
                }
            });
            n = 1;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public String prefix(String f, String sep) {
        void var3_3;
        block0: {
            String pref = f;
            int i = f.indexOf(sep);
            if (i <= 0) break block0;
            pref = f.substring(0, i);
        }
        return var3_3;
    }

    public Map<String, Set<Object>> findFeatureGroups(String sep, Lexicon<String> lexicon) {
        HashMap groups = new HashMap();
        lexicon.keySet().foreach((Function1 & Serializable & scala.Serializable)f -> {
            String pref = MODULE$.prefix((String)f, sep);
            Object object = !groups.contains((Object)pref) ? groups.put((Object)pref, (Object)new HashSet()) : BoxedUnit.UNIT;
            return ((HashSet)groups.get((Object)pref).get()).$plus$eq(lexicon.get((String)f).get());
        });
        HashMap img = new HashMap();
        groups.keySet().foreach((Function1 & Serializable & scala.Serializable)k -> img.put(k, (Object)((TraversableOnce)groups.get(k).get()).toSet()));
        return img.toMap(Predef$.MODULE$.$conforms());
    }

    public Classifier<String, String> svmFactory() {
        return new LinearSVMClassifier<String, String>(LinearSVMClassifier$.MODULE$.$lessinit$greater$default$1(), LinearSVMClassifier$.MODULE$.$lessinit$greater$default$2(), LinearSVMClassifier$.MODULE$.$lessinit$greater$default$3(), (Option<Tuple2<L, Object>[]>)LinearSVMClassifier$.MODULE$.$lessinit$greater$default$4());
    }

    public Classifier<String, String> lrFactory() {
        return new LogisticRegressionClassifier<String, String>(LogisticRegressionClassifier$.MODULE$.$lessinit$greater$default$1(), LogisticRegressionClassifier$.MODULE$.$lessinit$greater$default$2(), LogisticRegressionClassifier$.MODULE$.$lessinit$greater$default$3(), (Option<Tuple2<L, Object>[]>)LogisticRegressionClassifier$.MODULE$.$lessinit$greater$default$4());
    }

    public Classifier<String, String> perceptronFactory() {
        return new PerceptronClassifier<String, String>(PerceptronClassifier$.MODULE$.$lessinit$greater$default$1(), PerceptronClassifier$.MODULE$.$lessinit$greater$default$2(), PerceptronClassifier$.MODULE$.$lessinit$greater$default$3());
    }

    public void printTopWeights(LiblinearClassifier<String, String> c) {
        Map<String, Counter<String>> ws = c.getWeights(c.getWeights$default$1());
        ws.keySet().foreach((Function1 & Serializable & scala.Serializable)l -> {
            Utils$.$anonfun$printTopWeights$1(ws, l);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<Object, Object>[][] mkGoldEDUs(DiscourseTree tree, Document doc) {
        ArrayBuffer[] eduBuffer = new ArrayBuffer[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).size()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])eduBuffer)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            eduBuffer$1[i] = new ArrayBuffer();
        });
        this.addGoldEDUs(tree, eduBuffer);
        Tuple2[][] edus = new Tuple2[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).size()][];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])eduBuffer)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            edus$1[i] = (Tuple2[])eduBuffer[i].toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        });
        return edus;
    }

    private void addGoldEDUs(DiscourseTree tree, ArrayBuffer<Tuple2<Object, Object>>[] edus) {
        if (tree.isTerminal()) {
            Predef$.MODULE$.assert(tree.firstSentence() == tree.lastSentence());
            int s = tree.firstSentence();
            int f = tree.firstToken().token();
            int l = tree.lastToken().token();
            edus[s].$plus$eq((Object)new Tuple2.mcII.sp(f, l));
            tree.firstEDU_$eq(edus[s].size() - 1);
            tree.lastEDU_$eq(edus[s].size() - 1);
        } else {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tree.children())).foreach((Function1 & Serializable & scala.Serializable)c -> {
                Utils$.MODULE$.addGoldEDUs(c, edus);
                return BoxedUnit.UNIT;
            });
            tree.firstEDU_$eq(((DiscourseTree)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tree.children())).head()).firstEDU());
            tree.lastEDU_$eq(((DiscourseTree)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tree.children())).last()).lastEDU());
        }
    }

    public static final /* synthetic */ void $anonfun$tokenCount$1(IntRef sum$1, Sentence s) {
        sum$1.elem += s.size();
    }

    public static final /* synthetic */ Object $anonfun$extractConnectives$1(String[] words$2, Counter c$1, int offset) {
        String[] conn = ConnectiveMatcher$.MODULE$.matchesConnective(words$2, offset);
        return conn != null ? BoxesRunTime.boxToDouble((double)c$1.incrementCount(MODULE$.mkDiscretePosition(offset, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])words$2)).size()) + ":" + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conn)).mkString("_"), c$1.incrementCount$default$2())) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$findSubtree$1(ObjectRef m$1, Tree c) {
        return (Tree)m$1.elem == null;
    }

    public static final /* synthetic */ void $anonfun$countWords$2(Counter c$2, Sentence s) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.words())).foreach((Function1 & Serializable & scala.Serializable)w -> BoxesRunTime.boxToDouble((double)c$2.incrementCount(w, c$2.incrementCount$default$2())));
    }

    public static final /* synthetic */ void $anonfun$countWords$1(Counter c$2, Tuple2 td) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Document)td._2()).sentences())).foreach((Function1 & Serializable & scala.Serializable)s -> {
            Utils$.$anonfun$countWords$2(c$2, s);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ double $anonfun$countNgrams$1(Counter c$3, Tuple2 td) {
        String[] words = MODULE$.extractWords((DiscourseTree)td._1(), (Document)td._2(), MODULE$.extractWords$default$3(), MODULE$.extractWords$default$4());
        c$3.incrementCount(MODULE$.mkNgram(words, 0, 3), c$3.incrementCount$default$2());
        return c$3.incrementCount(MODULE$.mkNgram(words, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])words)).size() - 3, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])words)).size()), c$3.incrementCount$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$findSyntacticHeadFromDependencies$2(BooleanRef outside$1, Tuple2 h) {
        return !outside$1.elem;
    }

    public static final /* synthetic */ void $anonfun$findSyntacticHeadFromDependencies$3(int first$1, int last$1, BooleanRef outside$1, IntRef p$1, ObjectRef l$1, Tuple2 h) {
        block0: {
            if (h._1$mcI$sp() >= first$1 && h._1$mcI$sp() <= last$1) break block0;
            outside$1.elem = true;
            p$1.elem = h._1$mcI$sp();
            l$1.elem = (String)h._2();
        }
    }

    public static final /* synthetic */ void $anonfun$findSyntacticHead$1(Tree root$3, int first$3, int last$3, Object nonLocalReturnKey4$1, Tree c) {
        Tuple2<Tree, Tree> r = MODULE$.findSyntacticHead(c, root$3, first$3, last$3);
        if (r._1() != null) {
            throw new NonLocalReturnControl(nonLocalReturnKey4$1, r);
        }
    }

    public static final /* synthetic */ void $anonfun$findSmallestCommonAncestor$1(int first$4, int last$4, Object nonLocalReturnKey5$1, Tree c) {
        Tree r = MODULE$.findSmallestCommonAncestor(c, first$4, last$4);
        if (r != null) {
            throw new NonLocalReturnControl(nonLocalReturnKey5$1, (Object)r);
        }
    }

    public static final /* synthetic */ void $anonfun$printTopWeights$1(Map ws$1, String l) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Top weights for label ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l})));
        Tuple2[] w = (Tuple2[])((Counter)ws$1.get((Object)l).get()).sorted().toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])w)).size(), 10)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{w[i]._1(), BoxesRunTime.boxToDouble((double)w[i]._2$mcD$sp())}))));
    }

    private Utils$() {
        MODULE$ = this;
    }
}

