/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.dynet;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import org.clulab.dynet.CoNLLSRLToMetal;
import org.clulab.dynet.Utils$;
import org.clulab.processors.Document;
import org.clulab.processors.Sentence;
import org.clulab.processors.clu.CluProcessor;
import org.clulab.processors.clu.CluProcessor$;
import org.clulab.struct.Counter;
import org.clulab.struct.DirectedGraph;
import org.clulab.struct.Edge;
import org.clulab.struct.GraphMap$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class CoNLLSRLToMetal$ {
    public static CoNLLSRLToMetal$ MODULE$;
    private final Logger logger;
    private final boolean USE_CONLL_TOKENIZATION;
    private final boolean SIMPLIFY_ARG_LABELS;
    private final boolean REMOVE_SELF_LOOPS;

    static {
        new CoNLLSRLToMetal$();
    }

    public Logger logger() {
        return this.logger;
    }

    public boolean USE_CONLL_TOKENIZATION() {
        return this.USE_CONLL_TOKENIZATION;
    }

    public boolean SIMPLIFY_ARG_LABELS() {
        return this.SIMPLIFY_ARG_LABELS;
    }

    public boolean REMOVE_SELF_LOOPS() {
        return this.REMOVE_SELF_LOOPS;
    }

    public void main(String[] args) {
        Predef$.MODULE$.assert(args.length == 2);
        Utils$.MODULE$.initializeDyNet(Utils$.MODULE$.initializeDyNet$default$1(), Utils$.MODULE$.initializeDyNet$default$2());
        File file = new File(args[0]);
        CoNLLSRLToMetal reader = new CoNLLSRLToMetal();
        CluProcessor proc = new CluProcessor(CluProcessor$.MODULE$.$lessinit$greater$default$1());
        Document doc = reader.read(file, proc, true);
        this.labelStats(doc);
        this.moreStats(doc);
        String predsFile = args[1] + ".preds";
        String argsFile = args[1] + ".args";
        this.saveMetalFull(doc, predsFile, argsFile);
    }

    public void moreStats(Document document) {
        IntRef moreThanTwoPreds = IntRef.create((int)0);
        IntRef edgeCount = IntRef.create((int)0);
        IntRef multPreds = IntRef.create((int)0);
        IntRef multPredPerArgSents = IntRef.create((int)0);
        Counter argPredHisto = new Counter();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])document.sentences())).foreach((Function1 & Serializable & scala.Serializable)s -> {
            CoNLLSRLToMetal$.$anonfun$moreStats$1(moreThanTwoPreds, edgeCount, multPreds, multPredPerArgSents, argPredHisto, s);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", "/", " sentences with more than two predicates."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)moreThanTwoPreds.elem), BoxesRunTime.boxToInteger((int)document.sentences().length)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", "/", " sentences where at least 1 arg has more than 1 predicate."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)multPredPerArgSents.elem), BoxesRunTime.boxToInteger((int)document.sentences().length)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of ", " (pred, arg) pairs, found ", " arguments with more than 1 predicate."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)edgeCount.elem), BoxesRunTime.boxToInteger((int)multPreds.elem)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"argPredHisto: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{argPredHisto.sorted(true).mkString(", ")})));
    }

    public void saveMetal(Document doc, String predsFile, String argsFile) {
        block0: {
            PrintWriter predsPw = new PrintWriter(predsFile);
            PrintWriter argsPw = new PrintWriter(argsFile);
            IntRef selfLoopCount = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sent -> {
                CoNLLSRLToMetal$.$anonfun$saveMetal$1(predsPw, argsPw, selfLoopCount, sent);
                return BoxedUnit.UNIT;
            });
            predsPw.close();
            argsPw.close();
            if (!this.REMOVE_SELF_LOOPS()) break block0;
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " self-argument loops."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)selfLoopCount.elem)})));
        }
    }

    public void saveMetalFull(Document doc, String predsFile, String argsFile) {
        block0: {
            PrintWriter predsPw = new PrintWriter(predsFile);
            PrintWriter argsPw = new PrintWriter(argsFile);
            IntRef selfLoopCount = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sent -> {
                CoNLLSRLToMetal$.$anonfun$saveMetalFull$1(predsPw, argsPw, selfLoopCount, sent);
                return BoxedUnit.UNIT;
            });
            predsPw.close();
            argsPw.close();
            if (!this.REMOVE_SELF_LOOPS()) break block0;
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " self-argument loops."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)selfLoopCount.elem)})));
        }
    }

    public void saveSimplified(Document doc, String outputFileName) {
        block0: {
            PrintWriter pw = new PrintWriter(outputFileName);
            IntRef selfLoopCount = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sent -> {
                CoNLLSRLToMetal$.$anonfun$saveSimplified$1(pw, selfLoopCount, sent);
                return BoxedUnit.UNIT;
            });
            pw.close();
            if (!this.REMOVE_SELF_LOOPS()) break block0;
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " self-argument loops."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)selfLoopCount.elem)})));
        }
    }

    public void labelStats(Document doc) {
        Counter labels = new Counter();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])doc.sentences())).foreach((Function1 & Serializable & scala.Serializable)sent -> {
            CoNLLSRLToMetal$.$anonfun$labelStats$1(labels, sent);
            return BoxedUnit.UNIT;
        });
        PrintWriter pw = new PrintWriter("labels.tsv");
        labels.sorted().foreach((Function1 & Serializable & scala.Serializable)l -> {
            pw.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l._1(), BoxesRunTime.boxToDouble((double)l._2$mcD$sp())})));
            return BoxedUnit.UNIT;
        });
        pw.close();
    }

    public static final /* synthetic */ double $anonfun$moreStats$2(IntRef edgeCount$1, Counter headCounts$1, Tuple3 edge) {
        ++edgeCount$1.elem;
        return headCounts$1.incrementCount(edge._2(), headCounts$1.incrementCount$default$2());
    }

    public static final /* synthetic */ void $anonfun$moreStats$1(IntRef moreThanTwoPreds$1, IntRef edgeCount$1, IntRef multPreds$1, IntRef multPredPerArgSents$1, Counter argPredHisto$1, Sentence s) {
        block1: {
            if (((DirectedGraph)s.semanticRoles().get()).roots().size() <= 1) break block1;
            ++moreThanTwoPreds$1.elem;
            BooleanRef isMultPredArg = BooleanRef.create((boolean)false);
            Counter headCounts = new Counter();
            ((DirectedGraph)s.semanticRoles().get()).allEdges().foreach((Function1 & Serializable & scala.Serializable)edge -> BoxesRunTime.boxToDouble((double)CoNLLSRLToMetal$.$anonfun$moreStats$2(edgeCount$1, headCounts, edge)));
            headCounts.keySet().foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)arg -> {
                block0: {
                    if (!(headCounts.getCount(BoxesRunTime.boxToInteger((int)arg)) > 1.0)) break block0;
                    ++multPreds$1.elem;
                    isMultPredArg$1.elem = true;
                }
                return argPredHisto$1.incrementCount(BoxesRunTime.boxToInteger((int)((int)headCounts.getCount(BoxesRunTime.boxToInteger((int)arg)))), argPredHisto$1.incrementCount$default$2());
            });
            if (isMultPredArg.elem) {
                ++multPredPerArgSents$1.elem;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$saveMetal$3(String[] heads$2, ObjectRef headPositions$1, Edge e) {
        ((HashSet)headPositions$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)e.source()));
        heads$2[e.source()] = "B-P";
    }

    public static final /* synthetic */ void $anonfun$saveMetal$7(IntRef selfLoopCount$1, Map headMap$1, String[][] args$1, Edge e) {
        block0: {
            args$1[BoxesRunTime.unboxToInt((Object)headMap$1.apply((Object)BoxesRunTime.boxToInteger((int)e.source())))][e.destination()] = (String)e.relation();
            if (!MODULE$.REMOVE_SELF_LOOPS() || e.source() != e.destination()) break block0;
            args$1[BoxesRunTime.unboxToInt((Object)headMap$1.apply((Object)BoxesRunTime.boxToInteger((int)e.source())))][e.destination()] = "O";
            ++selfLoopCount$1.elem;
        }
    }

    public static final /* synthetic */ void $anonfun$saveMetal$1(PrintWriter predsPw$1, PrintWriter argsPw$1, IntRef selfLoopCount$1, Sentence sent) {
        DirectedGraph g = (DirectedGraph)sent.graphs().apply(GraphMap$.MODULE$.SEMANTIC_ROLES());
        String[] heads = new String[sent.words().length];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])heads)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            heads$2[i] = "O";
        });
        ObjectRef headPositions = ObjectRef.create((Object)new HashSet());
        g.edges().foreach((Function1 & Serializable & scala.Serializable)e -> {
            CoNLLSRLToMetal$.$anonfun$saveMetal$3(heads, headPositions, e);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(heads.length == sent.words().length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])heads)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> predsPw$1.println(sent.words()[i] + "\t" + heads[i] + "\t0\t" + ((String[])sent.tags().get())[i] + "\t" + ((String[])sent.entities().get())[i]));
        List sortedHeadPositions = (List)((HashSet)headPositions.elem).toList().sorted((Ordering)Ordering.Int$.MODULE$);
        Map headMap = ((TraversableOnce)sortedHeadPositions.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        String[][] args = new String[headMap.size()][];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            args$1[i] = new String[sent.size()];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args[i])).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                args$1[i$1][j] = "O";
            });
        });
        g.edges().foreach((Function1 & Serializable & scala.Serializable)e -> {
            CoNLLSRLToMetal$.$anonfun$saveMetal$7(selfLoopCount$1, headMap, args, e);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(headMap.size() == args.length);
        Predef$.MODULE$.assert(sortedHeadPositions.size() == args.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fi -> {
            int predPosition = BoxesRunTime.unboxToInt((Object)sortedHeadPositions.apply(fi));
            String[] frame = args[fi];
            Predef$.MODULE$.assert(frame.length == sent.words().length);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frame)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> argsPw$1.println(sent.words()[i] + "\t" + frame[i] + "\t" + predPosition + "\t" + ((String[])sent.tags().get())[i] + "\t" + ((String[])sent.entities().get())[i]));
            argsPw$1.println();
        });
        predsPw$1.println();
    }

    public static final /* synthetic */ void $anonfun$saveMetalFull$3(String[] heads$3, ObjectRef headPositions$2, Edge e) {
        ((HashSet)headPositions$2.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)e.source()));
        heads$3[e.source()] = "B-P";
    }

    public static final /* synthetic */ void $anonfun$saveMetalFull$7(IntRef selfLoopCount$2, Map headMap$2, String[][] args$2, Edge e) {
        block0: {
            args$2[BoxesRunTime.unboxToInt((Object)headMap$2.apply((Object)BoxesRunTime.boxToInteger((int)e.source())))][e.destination()] = (String)e.relation();
            if (!MODULE$.REMOVE_SELF_LOOPS() || e.source() != e.destination()) break block0;
            args$2[BoxesRunTime.unboxToInt((Object)headMap$2.apply((Object)BoxesRunTime.boxToInteger((int)e.source())))][e.destination()] = "O";
            ++selfLoopCount$2.elem;
        }
    }

    public static final /* synthetic */ void $anonfun$saveMetalFull$1(PrintWriter predsPw$2, PrintWriter argsPw$2, IntRef selfLoopCount$2, Sentence sent) {
        block0: {
            DirectedGraph g = (DirectedGraph)sent.graphs().apply(GraphMap$.MODULE$.SEMANTIC_ROLES());
            String[] heads = new String[sent.words().length];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])heads)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                heads$3[i] = "O";
            });
            ObjectRef headPositions = ObjectRef.create((Object)new HashSet());
            g.edges().foreach((Function1 & Serializable & scala.Serializable)e -> {
                CoNLLSRLToMetal$.$anonfun$saveMetalFull$3(heads, headPositions, e);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.assert(heads.length == sent.words().length);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])heads)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> predsPw$2.println(sent.words()[i] + "\t" + ((String[])sent.tags().get())[i] + "\t" + ((String[])sent.entities().get())[i] + "\t" + heads[i]));
            predsPw$2.println();
            if (!((HashSet)headPositions.elem).nonEmpty()) break block0;
            List sortedHeadPositions = (List)((HashSet)headPositions.elem).toList().sorted((Ordering)Ordering.Int$.MODULE$);
            Map headMap = ((TraversableOnce)sortedHeadPositions.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            String[][] args = new String[headMap.size()][];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                args$2[i] = new String[sent.size()];
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args[i])).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                    args$2[i$2][j] = "O";
                });
            });
            g.edges().foreach((Function1 & Serializable & scala.Serializable)e -> {
                CoNLLSRLToMetal$.$anonfun$saveMetalFull$7(selfLoopCount$2, headMap, args, e);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.assert(headMap.size() == args.length);
            Predef$.MODULE$.assert(sortedHeadPositions.size() == args.length);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sent.words())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                argsPw$2.print(sent.words()[i] + "\t" + ((String[])sent.tags().get())[i] + "\t" + ((String[])sent.entities().get())[i]);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fi -> {
                    int predPosition = BoxesRunTime.unboxToInt((Object)sortedHeadPositions.apply(fi));
                    String[] frame = args[fi];
                    argsPw$2.print("\t" + frame[i] + "\t" + predPosition);
                });
                argsPw$2.println();
            });
            argsPw$2.println();
        }
    }

    public static final /* synthetic */ void $anonfun$saveSimplified$2(boolean[] heads$4, ObjectRef headPositions$3, Edge e) {
        ((HashSet)headPositions$3.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)e.source()));
        heads$4[e.source()] = true;
    }

    public static final /* synthetic */ void $anonfun$saveSimplified$5(IntRef selfLoopCount$3, Map headMap$3, String[][] args$3, Edge e) {
        block0: {
            args$3[BoxesRunTime.unboxToInt((Object)headMap$3.apply((Object)BoxesRunTime.boxToInteger((int)e.source())))][e.destination()] = (String)e.relation();
            if (!MODULE$.REMOVE_SELF_LOOPS() || e.source() != e.destination()) break block0;
            args$3[BoxesRunTime.unboxToInt((Object)headMap$3.apply((Object)BoxesRunTime.boxToInteger((int)e.source())))][e.destination()] = "O";
            ++selfLoopCount$3.elem;
        }
    }

    public static final /* synthetic */ void $anonfun$saveSimplified$1(PrintWriter pw$1, IntRef selfLoopCount$3, Sentence sent) {
        DirectedGraph g = (DirectedGraph)sent.graphs().apply(GraphMap$.MODULE$.SEMANTIC_ROLES());
        boolean[] heads = new boolean[sent.words().length];
        ObjectRef headPositions = ObjectRef.create((Object)new HashSet());
        g.edges().foreach((Function1 & Serializable & scala.Serializable)e -> {
            CoNLLSRLToMetal$.$anonfun$saveSimplified$2(heads, headPositions, e);
            return BoxedUnit.UNIT;
        });
        Map headMap = ((TraversableOnce)((IterableLike)((HashSet)headPositions.elem).toList().sorted((Ordering)Ordering.Int$.MODULE$)).zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        String[][] args = new String[headMap.size()][];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            args$3[i] = new String[sent.size()];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args[i])).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                args$3[i$4][j] = "O";
            });
        });
        g.edges().foreach((Function1 & Serializable & scala.Serializable)e -> {
            CoNLLSRLToMetal$.$anonfun$saveSimplified$5(selfLoopCount$3, headMap, args, e);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sent.words())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            pw$1.print(sent.words()[i] + "\t" + (heads[i] ? "B-P" : "O"));
            pw$1.print("\t" + ((String[])sent.tags().get())[i] + "\t" + ((String[])sent.entities().get())[i]);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> pw$1.print("\t" + args[j][i]));
            pw$1.println();
        });
        pw$1.println();
    }

    public static final /* synthetic */ double $anonfun$labelStats$2(Counter labels$1, Tuple3 e) {
        String l = (String)e._3();
        return labels$1.$plus$eq(l);
    }

    public static final /* synthetic */ void $anonfun$labelStats$1(Counter labels$1, Sentence sent) {
        DirectedGraph g = (DirectedGraph)sent.graphs().apply(GraphMap$.MODULE$.SEMANTIC_ROLES());
        g.allEdges().foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)CoNLLSRLToMetal$.$anonfun$labelStats$2(labels$1, e)));
    }

    private CoNLLSRLToMetal$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(CoNLLSRLToMetal.class);
        this.USE_CONLL_TOKENIZATION = false;
        this.SIMPLIFY_ARG_LABELS = true;
        this.REMOVE_SELF_LOOPS = true;
    }
}

