/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.dynet;

import edu.cmu.dynet.Dim$;
import edu.cmu.dynet.LookupParameter;
import edu.cmu.dynet.LstmBuilder;
import edu.cmu.dynet.LstmBuilder$;
import edu.cmu.dynet.ParameterCollection;
import edu.cmu.dynet.RnnBuilder;
import java.io.Serializable;
import org.clulab.dynet.EmbeddingLayer;
import org.clulab.dynet.InitialLayer;
import org.clulab.dynet.Utils;
import org.clulab.dynet.Utils$;
import org.clulab.struct.Counter;
import org.clulab.utils.Configured;
import org.clulab.utils.Serializer$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class EmbeddingLayer$ {
    public static EmbeddingLayer$ MODULE$;
    private final Logger logger;
    private final Random RANDOM;
    private final float DEFAULT_DROPOUT_PROB;
    private final int DEFAULT_LEARNED_WORD_EMBEDDING_SIZE;
    private final int DEFAULT_CHAR_EMBEDDING_SIZE;
    private final int DEFAULT_CHAR_RNN_STATE_SIZE;
    private final int DEFAULT_POS_TAG_EMBEDDING_SIZE;
    private final int DEFAULT_NE_TAG_EMBEDDING_SIZE;
    private final int DEFAULT_DISTANCE_EMBEDDING_SIZE;
    private final int DEFAULT_POSITION_EMBEDDING_SIZE;
    private final int DEFAULT_DISTANCE_WINDOW_SIZE;
    private final int DEFAULT_USE_IS_PREDICATE;

    static {
        new EmbeddingLayer$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Random RANDOM() {
        return this.RANDOM;
    }

    public float DEFAULT_DROPOUT_PROB() {
        return this.DEFAULT_DROPOUT_PROB;
    }

    public int DEFAULT_LEARNED_WORD_EMBEDDING_SIZE() {
        return this.DEFAULT_LEARNED_WORD_EMBEDDING_SIZE;
    }

    public int DEFAULT_CHAR_EMBEDDING_SIZE() {
        return this.DEFAULT_CHAR_EMBEDDING_SIZE;
    }

    public int DEFAULT_CHAR_RNN_STATE_SIZE() {
        return this.DEFAULT_CHAR_RNN_STATE_SIZE;
    }

    public int DEFAULT_POS_TAG_EMBEDDING_SIZE() {
        return this.DEFAULT_POS_TAG_EMBEDDING_SIZE;
    }

    public int DEFAULT_NE_TAG_EMBEDDING_SIZE() {
        return this.DEFAULT_NE_TAG_EMBEDDING_SIZE;
    }

    public int DEFAULT_DISTANCE_EMBEDDING_SIZE() {
        return this.DEFAULT_DISTANCE_EMBEDDING_SIZE;
    }

    public int DEFAULT_POSITION_EMBEDDING_SIZE() {
        return this.DEFAULT_POSITION_EMBEDDING_SIZE;
    }

    public int DEFAULT_DISTANCE_WINDOW_SIZE() {
        return this.DEFAULT_DISTANCE_WINDOW_SIZE;
    }

    public int DEFAULT_USE_IS_PREDICATE() {
        return this.DEFAULT_USE_IS_PREDICATE;
    }

    public EmbeddingLayer load(ParameterCollection parameters, BufferedIterator<String> x2iIterator) {
        None$ none$;
        None$ posTagLookupParameters;
        None$ none$2;
        Utils.ByLineCharIntMapBuilder byLineCharMapBuilder = new Utils.ByLineCharIntMapBuilder();
        Utils.ByLineStringCounterBuilder byLineCounterBuilder = new Utils.ByLineStringCounterBuilder();
        Utils.ByLineStringMapBuilder byLineStringMapBuilder = new Utils.ByLineStringMapBuilder();
        Utils.ByLineIntBuilder byLineIntBuilder = new Utils.ByLineIntBuilder();
        Utils.ByLineFloatBuilder byLineFloatBuilder = new Utils.ByLineFloatBuilder();
        Map w2i = (Map)byLineStringMapBuilder.build(x2iIterator, "w2i");
        Counter w2f = (Counter)byLineCounterBuilder.build(x2iIterator, "w2f");
        Map c2i = (Map)byLineCharMapBuilder.build(x2iIterator, "c2i");
        int hasTag2i = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "hasTag2i", BoxesRunTime.boxToInteger((int)0)));
        None$ tag2i = hasTag2i == 1 ? new Some(byLineStringMapBuilder.build(x2iIterator)) : None$.MODULE$;
        int hasNe2i = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "hasNe2i", BoxesRunTime.boxToInteger((int)0)));
        None$ ne2i = hasNe2i == 1 ? new Some(byLineStringMapBuilder.build(x2iIterator)) : None$.MODULE$;
        int learnedWordEmbeddingSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "learnedWordEmbeddingSize", BoxesRunTime.boxToInteger((int)this.DEFAULT_LEARNED_WORD_EMBEDDING_SIZE())));
        int charEmbeddingSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "charEmbeddingSize", BoxesRunTime.boxToInteger((int)this.DEFAULT_CHAR_EMBEDDING_SIZE())));
        int charRnnStateSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "charRnnStateSize", BoxesRunTime.boxToInteger((int)this.DEFAULT_CHAR_RNN_STATE_SIZE())));
        int posTagEmbeddingSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "posTagEmbeddingSize", BoxesRunTime.boxToInteger((int)this.DEFAULT_POS_TAG_EMBEDDING_SIZE())));
        int neTagEmbeddingSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "neTagEmbeddingSize", BoxesRunTime.boxToInteger((int)this.DEFAULT_NE_TAG_EMBEDDING_SIZE())));
        int distanceEmbeddingSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "distanceEmbeddingSize", BoxesRunTime.boxToInteger((int)this.DEFAULT_DISTANCE_EMBEDDING_SIZE())));
        int distanceWindowSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "distanceWindowSize", BoxesRunTime.boxToInteger((int)this.DEFAULT_DISTANCE_WINDOW_SIZE())));
        int useIsPredicateAsInt = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "useIsPredicate", BoxesRunTime.boxToInteger((int)this.DEFAULT_USE_IS_PREDICATE())));
        boolean useIsPredicate = useIsPredicateAsInt == 1;
        int positionEmbeddingSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "positionEmbeddingSize", BoxesRunTime.boxToInteger((int)this.DEFAULT_POSITION_EMBEDDING_SIZE())));
        float dropoutProb = BoxesRunTime.unboxToFloat(byLineFloatBuilder.build(x2iIterator, "dropoutProb", BoxesRunTime.boxToFloat((float)this.DEFAULT_DROPOUT_PROB())));
        LookupParameter wordLookupParameters = parameters.addLookupParameters((long)w2i.size(), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{learnedWordEmbeddingSize})));
        LookupParameter charLookupParameters = parameters.addLookupParameters((long)c2i.size(), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{charEmbeddingSize})));
        LstmBuilder charFwRnnBuilder = new LstmBuilder(1L, (long)charEmbeddingSize, (long)charRnnStateSize, parameters, LstmBuilder$.MODULE$.$lessinit$greater$default$5());
        LstmBuilder charBwRnnBuilder = new LstmBuilder(1L, (long)charEmbeddingSize, (long)charRnnStateSize, parameters, LstmBuilder$.MODULE$.$lessinit$greater$default$5());
        if (hasTag2i == 1) {
            Predef$.MODULE$.assert(tag2i.nonEmpty());
            none$2 = new Some((Object)parameters.addLookupParameters((long)((TraversableOnce)tag2i.get()).size(), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{posTagEmbeddingSize}))));
        } else {
            none$2 = posTagLookupParameters = None$.MODULE$;
        }
        if (hasNe2i == 1) {
            Predef$.MODULE$.assert(ne2i.nonEmpty());
            none$ = new Some((Object)parameters.addLookupParameters((long)((TraversableOnce)ne2i.get()).size(), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{neTagEmbeddingSize}))));
        } else {
            none$ = None$.MODULE$;
        }
        None$ neTagLookupParameters = none$;
        None$ distanceLookupParameters = distanceEmbeddingSize > 0 ? new Some((Object)parameters.addLookupParameters((long)(distanceWindowSize * 2 + 3), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{distanceEmbeddingSize})))) : None$.MODULE$;
        None$ positionLookupParameters = positionEmbeddingSize > 0 ? new Some((Object)parameters.addLookupParameters(101L, Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{positionEmbeddingSize})))) : None$.MODULE$;
        return new EmbeddingLayer(parameters, (Map<String, Object>)w2i, w2f, (Map<Object, Object>)c2i, (Option<Map<String, Object>>)tag2i, (Option<Map<String, Object>>)ne2i, learnedWordEmbeddingSize, charEmbeddingSize, charRnnStateSize, posTagEmbeddingSize, neTagEmbeddingSize, distanceEmbeddingSize, distanceWindowSize, positionEmbeddingSize, useIsPredicate, wordLookupParameters, charLookupParameters, (RnnBuilder)charFwRnnBuilder, (RnnBuilder)charBwRnnBuilder, (Option<LookupParameter>)posTagLookupParameters, (Option<LookupParameter>)neTagLookupParameters, (Option<LookupParameter>)distanceLookupParameters, (Option<LookupParameter>)positionLookupParameters, dropoutProb);
    }

    public Option<InitialLayer> initialize(Configured config, String paramPrefix, ParameterCollection parameters, Counter<String> wordCounter) {
        None$ none$;
        None$ distanceLookupParameters;
        None$ none$2;
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2 tuple23;
        Tuple2 tuple24;
        if (!config.contains(paramPrefix)) {
            return None$.MODULE$;
        }
        int learnedWordEmbeddingSize = config.getArgInt(paramPrefix + ".learnedWordEmbeddingSize", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.DEFAULT_LEARNED_WORD_EMBEDDING_SIZE())));
        int charEmbeddingSize = config.getArgInt(paramPrefix + ".charEmbeddingSize", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.DEFAULT_CHAR_EMBEDDING_SIZE())));
        int charRnnStateSize = config.getArgInt(paramPrefix + ".charRnnStateSize", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.DEFAULT_CHAR_RNN_STATE_SIZE())));
        int posTagEmbeddingSize = config.getArgInt(paramPrefix + ".posTagEmbeddingSize", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.DEFAULT_POS_TAG_EMBEDDING_SIZE())));
        int neTagEmbeddingSize = config.getArgInt(paramPrefix + ".neTagEmbeddingSize", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.DEFAULT_NE_TAG_EMBEDDING_SIZE())));
        int distanceEmbeddingSize = config.getArgInt(paramPrefix + ".distanceEmbeddingSize", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.DEFAULT_DISTANCE_EMBEDDING_SIZE())));
        int distanceWindowSize = config.getArgInt(paramPrefix + ".distanceWindowSize", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.DEFAULT_DISTANCE_WINDOW_SIZE())));
        boolean useIsPredicate = config.getArgBoolean(paramPrefix + ".useIsPredicate", (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((this.DEFAULT_USE_IS_PREDICATE() == 1 ? 1 : 0) != 0)));
        int positionEmbeddingSize = config.getArgInt(paramPrefix + ".positionEmbeddingSize", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.DEFAULT_POSITION_EMBEDDING_SIZE())));
        float dropoutProb = config.getArgFloat(paramPrefix + ".dropoutProb", (Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)this.DEFAULT_DROPOUT_PROB())));
        List wordList = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Utils$.MODULE$.UNK_WORD()})).$plus$plus((GenTraversableOnce)wordCounter.keySet().toList().sorted((Ordering)Ordering.String$.MODULE$), List$.MODULE$.canBuildFrom());
        Map w2i = ((TraversableOnce)wordList.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        LookupParameter wordLookupParameters = parameters.addLookupParameters((long)w2i.size(), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{learnedWordEmbeddingSize})));
        String c2iFilename = config.getArgString(paramPrefix + ".c2i", (Option<String>)new Some((Object)"org/clulab/c2i-en.txt"));
        Map c2i = (Map)Serializer$.MODULE$.using(Utils$.MODULE$.newSource(c2iFilename), (Function1 & Serializable & scala.Serializable)source -> {
            void var3_3;
            Utils.ByLineCharIntMapBuilder byLineCharMapBuilder = new Utils.ByLineCharIntMapBuilder();
            BufferedIterator lines = source.getLines().buffered();
            Map c2i = (Map)byLineCharMapBuilder.build((BufferedIterator<String>)lines);
            return var3_3;
        });
        LookupParameter charLookupParameters = parameters.addLookupParameters((long)c2i.size(), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{charEmbeddingSize})));
        LstmBuilder charFwRnnBuilder = new LstmBuilder(1L, (long)charEmbeddingSize, (long)charRnnStateSize, parameters, LstmBuilder$.MODULE$.$lessinit$greater$default$5());
        LstmBuilder charBwRnnBuilder = new LstmBuilder(1L, (long)charEmbeddingSize, (long)charRnnStateSize, parameters, LstmBuilder$.MODULE$.$lessinit$greater$default$5());
        if (posTagEmbeddingSize > 0) {
            Map<String, Object> tag2i = Utils$.MODULE$.readString2Ids(config.getArgString(paramPrefix + ".tag2i", (Option<String>)new Some((Object)"org/clulab/tag2i-en.txt")));
            LookupParameter posTagLookupParameters = parameters.addLookupParameters((long)tag2i.size(), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{posTagEmbeddingSize})));
            tuple24 = new Tuple2((Object)new Some(tag2i), (Object)new Some((Object)posTagLookupParameters));
        } else {
            tuple24 = tuple23 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Option tag2i = (Option)tuple23._1();
        Option posTagLookupParameters = (Option)tuple23._2();
        Tuple2 tuple25 = new Tuple2((Object)tag2i, (Object)posTagLookupParameters);
        Tuple2 tuple26 = tuple25;
        Option tag2i2 = (Option)tuple26._1();
        Option posTagLookupParameters2 = (Option)tuple26._2();
        if (neTagEmbeddingSize > 0) {
            Map<String, Object> ne2i = Utils$.MODULE$.readString2Ids(config.getArgString(paramPrefix + ".ne2i", (Option<String>)new Some((Object)"org/clulab/ne2i-en.txt")));
            LookupParameter neTagLookupParameters = parameters.addLookupParameters((long)ne2i.size(), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{neTagEmbeddingSize})));
            tuple22 = new Tuple2((Object)new Some(ne2i), (Object)new Some((Object)neTagLookupParameters));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option ne2i = (Option)tuple2._1();
        Option neTagLookupParameters = (Option)tuple2._2();
        Tuple2 tuple27 = new Tuple2((Object)ne2i, (Object)neTagLookupParameters);
        Tuple2 tuple28 = tuple27;
        Option ne2i2 = (Option)tuple28._1();
        Option neTagLookupParameters2 = (Option)tuple28._2();
        if (distanceEmbeddingSize > 0) {
            LookupParameter distanceLookupParameters2 = parameters.addLookupParameters((long)(distanceWindowSize * 2 + 3), Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{distanceEmbeddingSize})));
            none$2 = new Some((Object)distanceLookupParameters2);
        } else {
            none$2 = distanceLookupParameters = None$.MODULE$;
        }
        if (positionEmbeddingSize > 0) {
            LookupParameter positionLookupParameters = parameters.addLookupParameters(101L, Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{positionEmbeddingSize})));
            none$ = new Some((Object)positionLookupParameters);
        } else {
            none$ = None$.MODULE$;
        }
        None$ positionLookupParameters = none$;
        EmbeddingLayer layer = new EmbeddingLayer(parameters, (Map<String, Object>)w2i, wordCounter, (Map<Object, Object>)c2i, (Option<Map<String, Object>>)tag2i2, (Option<Map<String, Object>>)ne2i2, learnedWordEmbeddingSize, charEmbeddingSize, charRnnStateSize, posTagEmbeddingSize, neTagEmbeddingSize, distanceEmbeddingSize, distanceWindowSize, positionEmbeddingSize, useIsPredicate, wordLookupParameters, charLookupParameters, (RnnBuilder)charFwRnnBuilder, (RnnBuilder)charBwRnnBuilder, (Option<LookupParameter>)posTagLookupParameters2, (Option<LookupParameter>)neTagLookupParameters2, (Option<LookupParameter>)distanceLookupParameters, (Option<LookupParameter>)positionLookupParameters, dropoutProb);
        return new Some((Object)layer);
    }

    private EmbeddingLayer$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(EmbeddingLayer.class);
        this.RANDOM = new Random(Utils$.MODULE$.RANDOM_SEED());
        this.DEFAULT_DROPOUT_PROB = Utils$.MODULE$.DEFAULT_DROPOUT_PROBABILITY();
        this.DEFAULT_LEARNED_WORD_EMBEDDING_SIZE = 128;
        this.DEFAULT_CHAR_EMBEDDING_SIZE = 32;
        this.DEFAULT_CHAR_RNN_STATE_SIZE = 16;
        this.DEFAULT_POS_TAG_EMBEDDING_SIZE = -1;
        this.DEFAULT_NE_TAG_EMBEDDING_SIZE = -1;
        this.DEFAULT_DISTANCE_EMBEDDING_SIZE = -1;
        this.DEFAULT_POSITION_EMBEDDING_SIZE = -1;
        this.DEFAULT_DISTANCE_WINDOW_SIZE = -1;
        this.DEFAULT_USE_IS_PREDICATE = -1;
    }
}

