/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.dynet;

import edu.cmu.dynet.Dim$;
import edu.cmu.dynet.LookupParameter;
import edu.cmu.dynet.Parameter;
import edu.cmu.dynet.ParameterCollection;
import org.clulab.dynet.ForwardLayer;
import org.clulab.dynet.GreedyForwardLayer;
import org.clulab.dynet.GreedyForwardLayer$;
import org.clulab.dynet.Utils;
import org.clulab.dynet.Utils$;
import org.clulab.dynet.ViterbiForwardLayer;
import org.clulab.dynet.ViterbiForwardLayer$;
import org.clulab.struct.Counter;
import org.clulab.utils.Configured;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.BufferedIterator;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class ForwardLayer$ {
    public static ForwardLayer$ MODULE$;
    private final Logger logger;
    private final float DEFAULT_DROPOUT_PROB;
    private final int TYPE_VITERBI;
    private final int TYPE_GREEDY;
    private final int NONLIN_NONE;
    private final int NONLIN_RELU;
    private final int NONLIN_TANH;
    private final String TYPE_GREEDY_STRING;
    private final String TYPE_VITERBI_STRING;
    private final int DEFAULT_IS_DUAL;

    static {
        new ForwardLayer$();
    }

    public Logger logger() {
        return this.logger;
    }

    public float DEFAULT_DROPOUT_PROB() {
        return this.DEFAULT_DROPOUT_PROB;
    }

    public int TYPE_VITERBI() {
        return this.TYPE_VITERBI;
    }

    public int TYPE_GREEDY() {
        return this.TYPE_GREEDY;
    }

    public int NONLIN_NONE() {
        return this.NONLIN_NONE;
    }

    public int NONLIN_RELU() {
        return this.NONLIN_RELU;
    }

    public int NONLIN_TANH() {
        return this.NONLIN_TANH;
    }

    public String TYPE_GREEDY_STRING() {
        return this.TYPE_GREEDY_STRING;
    }

    public String TYPE_VITERBI_STRING() {
        return this.TYPE_VITERBI_STRING;
    }

    public int DEFAULT_IS_DUAL() {
        return this.DEFAULT_IS_DUAL;
    }

    public ForwardLayer load(ParameterCollection parameters, BufferedIterator<String> x2iIterator) {
        ForwardLayer forwardLayer;
        int inferenceType;
        int n = inferenceType = BoxesRunTime.unboxToInt(new Utils.ByLineIntBuilder().build(x2iIterator, "inferenceType"));
        if (this.TYPE_VITERBI() == n) {
            forwardLayer = ViterbiForwardLayer$.MODULE$.load(parameters, x2iIterator);
        } else if (this.TYPE_GREEDY() == n) {
            forwardLayer = GreedyForwardLayer$.MODULE$.load(parameters, x2iIterator);
        } else {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: unknown forward layer type ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)inferenceType)})));
        }
        return forwardLayer;
    }

    public Option<ForwardLayer> initialize(Configured config, String paramPrefix, ParameterCollection parameters, Counter<String> labelCounter, boolean isDual, int inputSize) {
        Some some;
        int n;
        if (!config.contains(paramPrefix)) {
            return None$.MODULE$;
        }
        String inferenceType = config.getArgString(paramPrefix + ".inference", (Option<String>)new Some((Object)"greedy"));
        float dropoutProb = config.getArgFloat(paramPrefix + ".dropoutProb", (Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)this.DEFAULT_DROPOUT_PROB())));
        String nonlinAsString = config.getArgString(paramPrefix + ".nonlinearity", (Option<String>)new Some((Object)""));
        String string = nonlinAsString;
        if ("relu".equals(string)) {
            n = this.NONLIN_RELU();
        } else if ("tanh".equals(string)) {
            n = this.NONLIN_TANH();
        } else if ("".equals(string)) {
            n = this.NONLIN_NONE();
        } else {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: unknown non-linearity ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nonlinAsString})));
        }
        int nonlin = n;
        Map t2i = ((TraversableOnce)((IterableLike)labelCounter.keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        String[] i2t = Utils$.MODULE$.fromIndexToString((Map<String, Object>)t2i);
        int actualInputSize = isDual ? 2 * inputSize : inputSize;
        Parameter H = parameters.addParameters(Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{t2i.size(), actualInputSize})), parameters.addParameters$default$2());
        Parameter rootParam = parameters.addParameters(Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{inputSize})), parameters.addParameters$default$2());
        String string2 = inferenceType;
        String string3 = this.TYPE_GREEDY_STRING();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            some = new Some((Object)new GreedyForwardLayer(parameters, inputSize, isDual, (Map<String, Object>)t2i, i2t, H, rootParam, nonlin, dropoutProb));
        } else {
            String string5 = this.TYPE_VITERBI_STRING();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                LookupParameter T = Utils$.MODULE$.mkTransitionMatrix(parameters, (Map<String, Object>)t2i);
                ViterbiForwardLayer layer = new ViterbiForwardLayer(parameters, inputSize, isDual, (Map<String, Object>)t2i, i2t, H, T, rootParam, nonlin, dropoutProb);
                layer.initializeTransitions();
                some = new Some((Object)layer);
            } else {
                new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: unknown inference type ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inferenceType})));
                some = None$.MODULE$;
            }
        }
        return some;
    }

    private ForwardLayer$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(ViterbiForwardLayer.class);
        this.DEFAULT_DROPOUT_PROB = Utils$.MODULE$.DEFAULT_DROPOUT_PROBABILITY();
        this.TYPE_VITERBI = 1;
        this.TYPE_GREEDY = 2;
        this.NONLIN_NONE = 0;
        this.NONLIN_RELU = 1;
        this.NONLIN_TANH = 2;
        this.TYPE_GREEDY_STRING = "greedy";
        this.TYPE_VITERBI_STRING = "viterbi";
        this.DEFAULT_IS_DUAL = 0;
    }
}

