/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.dynet;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import edu.cmu.dynet.ParameterCollection;
import java.io.Serializable;
import java.util.Properties;
import org.clulab.dynet.Layers;
import org.clulab.dynet.Layers$;
import org.clulab.dynet.Metal;
import org.clulab.dynet.MetalShell;
import org.clulab.dynet.TaskManager;
import org.clulab.dynet.Utils;
import org.clulab.dynet.Utils$;
import org.clulab.utils.Serializer$;
import org.clulab.utils.StringUtils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.BufferedIterator;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Metal$ {
    public static Metal$ MODULE$;
    private final Logger logger;

    static {
        new Metal$();
    }

    public Logger logger() {
        return this.logger;
    }

    public IndexedSeq<Layers> load(ParameterCollection parameters, String modelFilenamePrefix) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading MTL model from ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelFilenamePrefix})));
        String dynetFilename = Utils$.MODULE$.mkDynetFilename(modelFilenamePrefix);
        String x2iFilename = Utils$.MODULE$.mkX2iFilename(modelFilenamePrefix);
        scala.collection.immutable.IndexedSeq layersSeq = (scala.collection.immutable.IndexedSeq)Serializer$.MODULE$.using(Utils$.MODULE$.newSource(x2iFilename), (Function1 & Serializable & scala.Serializable)source -> {
            ArrayBuffer layersSeq = new ArrayBuffer();
            BufferedIterator lines = source.getLines().buffered();
            int layersCount = BoxesRunTime.unboxToInt(new Utils.ByLineIntBuilder().build((BufferedIterator<String>)lines));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), layersCount).foreach((Function1 & Serializable & scala.Serializable)i -> Metal$.$anonfun$load$2(parameters, layersSeq, lines, BoxesRunTime.unboxToInt((Object)i)));
            return layersSeq.toIndexedSeq();
        });
        Utils$.MODULE$.loadParameters(dynetFilename, parameters, Utils$.MODULE$.loadParameters$default$3());
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading MTL model from ", " complete."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelFilenamePrefix})));
        return layersSeq;
    }

    public Metal apply(String modelFilenamePrefix, TaskManager taskManager) {
        ParameterCollection parameters = new ParameterCollection();
        IndexedSeq<Layers> model = this.load(parameters, modelFilenamePrefix);
        Metal mtl = new Metal((Option<TaskManager>)new Some((Object)taskManager), parameters, (Option<IndexedSeq<Layers>>)new Some(model));
        return mtl;
    }

    public Metal apply(String modelFilenamePrefix) {
        ParameterCollection parameters = new ParameterCollection();
        IndexedSeq<Layers> model = this.load(parameters, modelFilenamePrefix);
        Metal mtl = new Metal((Option<TaskManager>)None$.MODULE$, parameters, (Option<IndexedSeq<Layers>>)new Some(model));
        return mtl;
    }

    public void main(String[] args) {
        block1: {
            Properties props;
            block2: {
                block0: {
                    props = StringUtils$.MODULE$.argsToProperties(args, StringUtils$.MODULE$.argsToProperties$default$2());
                    Utils$.MODULE$.initializeDyNet(Utils$.MODULE$.initializeDyNet$default$1(), Utils$.MODULE$.initializeDyNet$default$2());
                    if (!props.containsKey("train")) break block0;
                    Predef$.MODULE$.assert(props.containsKey("conf"));
                    String configName = props.getProperty("conf");
                    Config config = ConfigFactory.load((String)configName);
                    ParameterCollection parameters = new ParameterCollection();
                    TaskManager taskManager = new TaskManager(config);
                    String modelName = props.getProperty("train");
                    Metal mtl = new Metal((Option<TaskManager>)new Some((Object)taskManager), parameters, (Option<IndexedSeq<Layers>>)None$.MODULE$);
                    mtl.train(modelName);
                    break block1;
                }
                if (!props.containsKey("test")) break block2;
                Predef$.MODULE$.assert(props.containsKey("conf"));
                String configName = props.getProperty("conf");
                Config config = ConfigFactory.load((String)configName);
                TaskManager taskManager = new TaskManager(config);
                String modelName = props.getProperty("test");
                Metal mtl = this.apply(modelName, taskManager);
                mtl.test();
                break block1;
            }
            if (!props.containsKey("shell")) break block1;
            String modelName = props.getProperty("shell");
            Metal mtl = this.apply(modelName);
            MetalShell shell = new MetalShell(mtl);
            shell.shell();
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$load$2(ParameterCollection parameters$1, ArrayBuffer layersSeq$1, BufferedIterator lines$1, int i) {
        Layers layers = Layers$.MODULE$.loadX2i(parameters$1, (BufferedIterator<String>)lines$1);
        return layersSeq$1.$plus$eq((Object)layers);
    }

    private Metal$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(Metal.class);
    }
}

