/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.dynet;

import edu.cmu.dynet.AdamTrainer;
import edu.cmu.dynet.AdamTrainer$;
import edu.cmu.dynet.ComputationGraph$;
import edu.cmu.dynet.Expression;
import edu.cmu.dynet.Expression$;
import edu.cmu.dynet.ExpressionVector;
import edu.cmu.dynet.ExpressionVector$;
import edu.cmu.dynet.ParameterCollection;
import edu.cmu.dynet.RMSPropTrainer;
import edu.cmu.dynet.RMSPropTrainer$;
import edu.cmu.dynet.SimpleSGDTrainer;
import edu.cmu.dynet.Trainer;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import org.clulab.dynet.AnnotatedSentence;
import org.clulab.dynet.Layers;
import org.clulab.dynet.Layers$;
import org.clulab.dynet.Metal$;
import org.clulab.dynet.MetalRowReader;
import org.clulab.dynet.SafeTrainer;
import org.clulab.dynet.SafeTrainer$;
import org.clulab.dynet.ScoreCounts;
import org.clulab.dynet.ScoreCountsByLabel;
import org.clulab.dynet.SeqScorer$;
import org.clulab.dynet.TaskManager;
import org.clulab.dynet.Utils$;
import org.clulab.fatdynet.utils.CloseableModelSaver;
import org.clulab.fatdynet.utils.Closer$;
import org.clulab.sequences.Row;
import org.clulab.struct.Counter;
import org.clulab.utils.Serializer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001%\u0011Q!T3uC2T!a\u0001\u0003\u0002\u000b\u0011Lh.\u001a;\u000b\u0005\u00151\u0011AB2mk2\f'MC\u0001\b\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\t#\u0001\u0011)\u0019!C\u0001%\u0005qA/Y:l\u001b\u0006t\u0017mZ3s\u001fB$X#A\n\u0011\u0007-!b#\u0003\u0002\u0016\u0019\t1q\n\u001d;j_:\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u0017Q\u000b7o['b]\u0006<WM\u001d\u0005\t7\u0001\u0011\t\u0011)A\u0005'\u0005yA/Y:l\u001b\u0006t\u0017mZ3s\u001fB$\b\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0002?A\u0011\u0001EJ\u0007\u0002C)\u00111A\t\u0006\u0003G\u0011\n1aY7v\u0015\u0005)\u0013aA3ek&\u0011q%\t\u0002\u0014!\u0006\u0014\u0018-\\3uKJ\u001cu\u000e\u001c7fGRLwN\u001c\u0005\tS\u0001\u0011\t\u0011)A\u0005?\u0005Y\u0001/\u0019:b[\u0016$XM]:!\u0011!Y\u0003A!A!\u0002\u0013a\u0013\u0001C7pI\u0016dw\n\u001d;\u0011\u0007-!R\u0006E\u0002/mer!a\f\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0005IB\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\t)D\"A\u0004qC\u000e\\\u0017mZ3\n\u0005]B$AC%oI\u0016DX\rZ*fc*\u0011Q\u0007\u0004\t\u0003/iJ!a\u000f\u0002\u0003\r1\u000b\u00170\u001a:t\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q!q\bQ!C!\t9\u0002\u0001C\u0003\u0012y\u0001\u00071\u0003C\u0003\u001ey\u0001\u0007q\u0004C\u0003,y\u0001\u0007A\u0006\u0003\u0005E\u0001!\u0015\r\u0011\"\u0005F\u0003\u0015iw\u000eZ3m+\u0005i\u0003\"B$\u0001\t\u0003A\u0015a\u0003;bg.l\u0015M\\1hKJ,\u0012A\u0006\u0005\u0006\u0015\u0002!\tbS\u0001\u000bS:LG/[1mSj,G#\u0001'\u0011\u0007-i\u0015(\u0003\u0002O\u0019\t)\u0011I\u001d:bs\")\u0001\u000b\u0001C\t#\u0006qQn\u001b,pG\u0006\u0014W\u000f\\1sS\u0016\u001cH#\u0001*\u0011\t-\u0019V+V\u0005\u0003)2\u0011a\u0001V;qY\u0016\u0014\u0004cA\u0006N-B\u0019qK\u0017/\u000e\u0003aS!!\u0017\u0003\u0002\rM$(/^2u\u0013\tY\u0006LA\u0004D_VtG/\u001a:\u0011\u0005u\u000bgB\u00010`!\t\u0001D\"\u0003\u0002a\u0019\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001G\u0002C\u0003f\u0001\u0011\u0005a-A\u0003ue\u0006Lg\u000e\u0006\u0002hUB\u00111\u0002[\u0005\u0003S2\u0011A!\u00168ji\")1\u000e\u001aa\u00019\u0006yQn\u001c3fY:\u000bW.\u001a)sK\u001aL\u0007\u0010C\u0003n\u0001\u0011%a.\u0001\u0006iCN\u001cuN\u001c;f]R$\"a\u001c:\u0011\u0005-\u0001\u0018BA9\r\u0005\u001d\u0011un\u001c7fC:DQa\u001d7A\u0002Q\fa\u0001\\1cK2\u001c\bc\u0001\u001879\")a\u000f\u0001C\u0001o\u0006i!-\u0019;dQ\n\u000b7m\u001b9s_B$B\u0001_>\u0002\u0002A\u00111\"_\u0005\u0003u2\u0011QA\u00127pCRDQ\u0001`;A\u0002u\f1BY1uG\"dun]:fgB\u0011\u0001E`\u0005\u0003\u007f\u0006\u0012\u0001#\u0012=qe\u0016\u001c8/[8o-\u0016\u001cGo\u001c:\t\u000f\u0005\rQ\u000f1\u0001\u0002\u0006\u00059AO]1j]\u0016\u0014\bcA\f\u0002\b%\u0019\u0011\u0011\u0002\u0002\u0003\u0017M\u000bg-\u001a+sC&tWM\u001d\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003!)g/\u00197vCR,GCCA\t\u0003;\t9#a\u000b\u0002@AY1\"a\u0005\u0002\u0018\u0005]\u0011qCA\f\u0013\r\t)\u0002\u0004\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u0007-\tI\"C\u0002\u0002\u001c1\u0011a\u0001R8vE2,\u0007\u0002CA\u0010\u0003\u0017\u0001\r!!\t\u0002\rQ\f7o[%e!\rY\u00111E\u0005\u0004\u0003Ka!aA%oi\"9\u0011\u0011FA\u0006\u0001\u0004a\u0016\u0001\u0003;bg.t\u0015-\\3\t\u0011\u00055\u00121\u0002a\u0001\u0003_\t\u0011b]3oi\u0016t7-Z:\u0011\t-i\u0015\u0011\u0007\t\u0005\u00175\u000b\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI\u0004B\u0001\ng\u0016\fX/\u001a8dKNLA!!\u0010\u00028\t\u0019!k\\<\t\u0011\u0005\u0005\u00131\u0002a\u0001\u0003C\tQ!\u001a9pG\"Dq!!\u0004\u0001\t\u0003\t)\u0005\u0006\u0005\u0002\u0012\u0005\u001d\u0013\u0011JA&\u0011!\ty\"a\u0011A\u0002\u0005\u0005\u0002bBA\u0015\u0003\u0007\u0002\r\u0001\u0018\u0005\t\u0003[\t\u0019\u00051\u0001\u00020!9\u0011Q\u0002\u0001\u0005\u0002\u0005=C\u0003DA\t\u0003#\n\u0019&!\u0016\u0002X\u0005m\u0003\u0002CA\u0010\u0003\u001b\u0002\r!!\t\t\u000f\u0005%\u0012Q\na\u00019\"A\u0011QFA'\u0001\u0004\ty\u0003C\u0004\u0002Z\u00055\u0003\u0019\u0001/\u0002\t9\fW.\u001a\u0005\t\u0003\u0003\ni\u00051\u0001\u0002\"!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014A\u00049sK\u0012L7\r\u001e&pS:$H.\u001f\u000b\u0005\u0003G\n)\u0007E\u0002/mQD\u0001\"a\u001a\u0002^\u0001\u0007\u0011\u0011N\u0001\tg\u0016tG/\u001a8dKB\u0019q#a\u001b\n\u0007\u00055$AA\tB]:|G/\u0019;fIN+g\u000e^3oG\u0016Dq!!\u001d\u0001\t\u0003\t\u0019(A\u0004qe\u0016$\u0017n\u0019;\u0015\u000bQ\f)(a\u001e\t\u0011\u0005}\u0011q\u000ea\u0001\u0003CA\u0001\"a\u001a\u0002p\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003w\u0002A\u0011AA?\u0003E\u0001(/\u001a3jGR<\u0016\u000e\u001e5TG>\u0014Xm\u001d\u000b\u0007\u0003\u007f\n))a\"\u0011\t92\u0014\u0011\u0011\t\u0005]Y\n\u0019\t\u0005\u0003\f'rC\b\u0002CA\u0010\u0003s\u0002\r!!\t\t\u0011\u0005\u001d\u0014\u0011\u0010a\u0001\u0003SBq!a#\u0001\t\u0003\ti)\u0001\u0003uKN$H#A4\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\u0006!1/\u0019<f)\r9\u0017Q\u0013\u0005\b\u0003/\u000by\t1\u0001]\u00031\u0011\u0017m]3GS2,g.Y7f\u000f\u001d\tYJ\u0001E\u0001\u0003;\u000bQ!T3uC2\u00042aFAP\r\u0019\t!\u0001#\u0001\u0002\"N\u0019\u0011q\u0014\u0006\t\u000fu\ny\n\"\u0001\u0002&R\u0011\u0011Q\u0014\u0005\u000b\u0003S\u000byJ1A\u0005\u0002\u0005-\u0016A\u00027pO\u001e,'/\u0006\u0002\u0002.B!\u0011qVA[\u001b\t\t\tLC\u0002\u00024\u001a\tQa\u001d7gi)LA!a.\u00022\n1Aj\\4hKJD\u0011\"a/\u0002 \u0002\u0006I!!,\u0002\u000f1|wmZ3sA!A\u0011qXAP\t#\t\t-\u0001\u0003m_\u0006$G#B\u0017\u0002D\u0006\u0015\u0007BB\u000f\u0002>\u0002\u0007q\u0004C\u0004\u0002H\u0006u\u0006\u0019\u0001/\u0002'5|G-\u001a7GS2,g.Y7f!J,g-\u001b=\t\u0011\u0005-\u0017q\u0014C\u0001\u0003\u001b\fQ!\u00199qYf$RaPAh\u0003#Dq!a2\u0002J\u0002\u0007A\f\u0003\u0004H\u0003\u0013\u0004\rA\u0006\u0005\t\u0003\u0017\fy\n\"\u0001\u0002VR\u0019q(a6\t\u000f\u0005\u001d\u00171\u001ba\u00019\"A\u00111\\AP\t\u0003\ti.\u0001\u0003nC&tGcA4\u0002`\"A\u0011\u0011]Am\u0001\u0004\t\u0019/\u0001\u0003be\u001e\u001c\bcA\u0006N9\u0002")
public class Metal {
    private IndexedSeq<Layers> model;
    private final Option<TaskManager> taskManagerOpt;
    private final ParameterCollection parameters;
    private final Option<IndexedSeq<Layers>> modelOpt;
    private volatile boolean bitmap$0;

    public static void main(String[] stringArray) {
        Metal$.MODULE$.main(stringArray);
    }

    public static Metal apply(String string) {
        return Metal$.MODULE$.apply(string);
    }

    public static Metal apply(String string, TaskManager taskManager) {
        return Metal$.MODULE$.apply(string, taskManager);
    }

    public static Logger logger() {
        return Metal$.MODULE$.logger();
    }

    public Option<TaskManager> taskManagerOpt() {
        return this.taskManagerOpt;
    }

    public ParameterCollection parameters() {
        return this.parameters;
    }

    private IndexedSeq<Layers> model$lzycompute() {
        Metal metal = this;
        synchronized (metal) {
            if (!this.bitmap$0) {
                this.model = (IndexedSeq)this.modelOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.wrapRefArray((Object[])this.initialize()));
                this.bitmap$0 = true;
            }
        }
        this.modelOpt = null;
        return this.model;
    }

    public IndexedSeq<Layers> model() {
        return !this.bitmap$0 ? this.model$lzycompute() : this.model;
    }

    public TaskManager taskManager() {
        Predef$.MODULE$.assert(this.taskManagerOpt().isDefined());
        return (TaskManager)this.taskManagerOpt().get();
    }

    public Layers[] initialize() {
        Predef$.MODULE$.require(this.taskManagerOpt().isDefined());
        Tuple2<Counter<String>[], Counter<String>[]> tuple2 = this.mkVocabularies();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Counter[] taskWords = (Counter[])tuple2._1();
        Counter[] taskLabels = (Counter[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)taskWords, (Object)taskLabels);
        Tuple2 tuple23 = tuple22;
        Counter[] taskWords2 = (Counter[])tuple23._1();
        Counter[] taskLabels2 = (Counter[])tuple23._2();
        Layers[] layersPerTask = new Layers[this.taskManager().taskCount() + 1];
        layersPerTask[0] = Layers$.MODULE$.apply(this.taskManager(), "mtl.layers", this.parameters(), taskWords2[0], (Option<Counter<String>>)None$.MODULE$, false, (Option<Object>)None$.MODULE$);
        Option<Object> inputSize = layersPerTask[0].outDim();
        this.taskManager().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            layersPerTask$1[i + 1] = Layers$.MODULE$.apply(this.taskManager(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mtl.task", ".layers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1))})), this.parameters(), taskWords2[i + 1], (Option<Counter<String>>)new Some((Object)taskLabels2[i + 1]), this.taskManager().tasks()[i].isDual(), inputSize);
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])layersPerTask)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Metal$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Summary of layersPerTask(", "):"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            Metal$.MODULE$.logger().debug(layersPerTask[i].toString());
        });
        return layersPerTask;
    }

    public Tuple2<Counter<String>[], Counter<String>[]> mkVocabularies() {
        Counter[] labels = new Counter[this.taskManager().taskCount() + 1];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), labels.length).foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            labels$1[i] = new Counter();
            labels[i].$plus$eq(Utils$.MODULE$.START_TAG());
            return labels[i].$plus$eq(Utils$.MODULE$.STOP_TAG());
        });
        Counter[] words = new Counter[this.taskManager().taskCount() + 1];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])words)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            words$1[i] = new Counter();
        });
        MetalRowReader reader = new MetalRowReader();
        this.taskManager().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tid -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.taskManager().tasks()[tid].trainSentences())).foreach((Function1 & Serializable & scala.Serializable)sentence -> {
            Metal.$anonfun$mkVocabularies$4(labels, words, reader, tid, sentence);
            return BoxedUnit.UNIT;
        }));
        return new Tuple2((Object)words, (Object)labels);
    }

    public void train(String modelNamePrefix) {
        SafeTrainer safeTrainer;
        Predef$.MODULE$.require(this.taskManagerOpt().isDefined());
        float learningRate = this.taskManager().getArgFloat("mtl.learningRate", (Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)0.001f)));
        String trainerType = this.taskManager().getArgString("mtl.trainer", (Option<String>)new Some((Object)"adam"));
        int batchSize = this.taskManager().getArgInt("mtl.batchSize", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
        Predef$.MODULE$.assert(batchSize > 0);
        String string = trainerType;
        if ("adam".equals(string)) {
            safeTrainer = SafeTrainer$.MODULE$.apply((Trainer)new AdamTrainer(this.parameters(), learningRate, AdamTrainer$.MODULE$.$lessinit$greater$default$3(), AdamTrainer$.MODULE$.$lessinit$greater$default$4(), AdamTrainer$.MODULE$.$lessinit$greater$default$5()), SafeTrainer$.MODULE$.apply$default$2());
        } else if ("rmsprop".equals(string)) {
            safeTrainer = SafeTrainer$.MODULE$.apply((Trainer)new RMSPropTrainer(this.parameters(), learningRate, RMSPropTrainer$.MODULE$.$lessinit$greater$default$3(), RMSPropTrainer$.MODULE$.$lessinit$greater$default$4()), SafeTrainer$.MODULE$.apply$default$2());
        } else if ("sgd".equals(string)) {
            safeTrainer = SafeTrainer$.MODULE$.apply((Trainer)new SimpleSGDTrainer(this.parameters(), learningRate), SafeTrainer$.MODULE$.apply$default$2());
        } else {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: unknown trainer ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trainerType})));
        }
        SafeTrainer trainer = safeTrainer;
        MetalRowReader reader = new MetalRowReader();
        DoubleRef cummulativeLoss = DoubleRef.create((double)0.0);
        IntRef numTagged = IntRef.create((int)0);
        Random rand = new Random(Utils$.MODULE$.RANDOM_SEED());
        DoubleRef maxAvgAcc = DoubleRef.create((double)0.0);
        DoubleRef maxAvgF1 = DoubleRef.create((double)0.0);
        IntRef bestEpoch = IntRef.create((int)0);
        IntRef epochPatience = IntRef.create((int)this.taskManager().epochPatience());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.taskManager().maxEpochs()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)epoch -> epochPatience$1.elem > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)epoch -> {
            Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started epoch ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epoch)})));
            Iterator<Tuple2<Object, Row[]>> sentenceIterator = this.taskManager().getSentences(rand);
            IntRef sentCount = IntRef.create((int)0);
            ComputationGraph$.MODULE$.renew();
            ObjectRef batchLosses = ObjectRef.create((Object)new ExpressionVector(ExpressionVector$.MODULE$.$lessinit$greater$default$1()));
            sentenceIterator.foreach((Function1 & Serializable & scala.Serializable)metaSentence -> {
                Metal.$anonfun$train$3(this, batchSize, trainer, reader, cummulativeLoss, numTagged, sentCount, batchLosses, metaSentence);
                return BoxedUnit.UNIT;
            });
            if (((ExpressionVector)batchLosses.elem).nonEmpty()) {
                cummulativeLoss$1.elem += (double)this.batchBackprop((ExpressionVector)batchLosses.elem, trainer);
            }
            DoubleRef totalAcc = DoubleRef.create((double)0.0);
            DoubleRef totalPrec = DoubleRef.create((double)0.0);
            DoubleRef totalRec = DoubleRef.create((double)0.0);
            DoubleRef totalF1 = DoubleRef.create((double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.taskManager().taskCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)taskId -> {
                block1: {
                    String taskName = this.taskManager().tasks()[taskId].taskName();
                    Option<Row[][]> devSentences = this.taskManager().tasks()[taskId].devSentences();
                    if (!devSentences.nonEmpty()) break block1;
                    Tuple4<Object, Object, Object, Object> tuple4 = this.evaluate(taskId, taskName, (Row[][])devSentences.get(), epoch);
                    if (tuple4 == null) {
                        throw new MatchError(tuple4);
                    }
                    double acc = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double prec = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    double rec = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                    double f1 = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                    Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)acc), (Object)BoxesRunTime.boxToDouble((double)prec), (Object)BoxesRunTime.boxToDouble((double)rec), (Object)BoxesRunTime.boxToDouble((double)f1));
                    Tuple4 tuple43 = tuple42;
                    double acc2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
                    double prec2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
                    double rec2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
                    double f12 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
                    totalAcc$1.elem += acc2;
                    totalPrec$1.elem += prec2;
                    totalRec$1.elem += rec2;
                    totalF1$1.elem += f12;
                }
            });
            double avgAcc = totalAcc.elem / (double)this.taskManager().taskCount();
            double avgPrec = totalPrec.elem / (double)this.taskManager().taskCount();
            double avgRec = totalRec.elem / (double)this.taskManager().taskCount();
            double avgF1 = totalF1.elem / (double)this.taskManager().taskCount();
            Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Average accuracy across ", " tasks in epoch ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.taskManager().taskCount()), BoxesRunTime.boxToInteger((int)epoch), BoxesRunTime.boxToDouble((double)avgAcc)})));
            Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Average P/R/F1 across ", " tasks in epoch ", ": ", " / ", " / ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.taskManager().taskCount()), BoxesRunTime.boxToInteger((int)epoch), BoxesRunTime.boxToDouble((double)avgPrec), BoxesRunTime.boxToDouble((double)avgRec), BoxesRunTime.boxToDouble((double)avgF1)})));
            if (avgF1 > maxAvgF1$1.elem) {
                maxAvgF1$1.elem = avgF1;
                maxAvgAcc$1.elem = avgAcc;
                bestEpoch$1.elem = epoch;
                epochPatience$1.elem = this.taskManager().epochPatience();
            } else {
                --epochPatience$1.elem;
            }
            Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Best epoch so far is epoch ", " with an average F1 of ", ", and average accuracy of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bestEpoch$1.elem), BoxesRunTime.boxToDouble((double)maxAvgF1$1.elem), BoxesRunTime.boxToDouble((double)maxAvgAcc$1.elem)})));
            if (epochPatience$1.elem < this.taskManager().epochPatience()) {
                Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Epoch patience is at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epochPatience$1.elem)})));
            }
            this.save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-epoch", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelNamePrefix, BoxesRunTime.boxToInteger((int)epoch)})));
        });
    }

    private boolean hasContent(IndexedSeq<String> labels) {
        return labels.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Metal.$anonfun$hasContent$1(x$3)));
    }

    public float batchBackprop(ExpressionVector batchLosses, SafeTrainer trainer) {
        Expression batchLoss = Expression$.MODULE$.sum(batchLosses);
        float batchLossAsFloat = batchLoss.value().toFloat();
        ComputationGraph$.MODULE$.backward(batchLoss);
        trainer.update(this.parameters());
        return batchLossAsFloat;
    }

    public Tuple4<Object, Object, Object, Object> evaluate(int taskId, String taskName, Row[][] sentences, int epoch) {
        return this.evaluate(taskId, taskName, sentences, "development", epoch);
    }

    public Tuple4<Object, Object, Object, Object> evaluate(int taskId, String taskName, Row[][] sentences) {
        return this.evaluate(taskId, taskName, sentences, "testing", -1);
    }

    public Tuple4<Object, Object, Object, Object> evaluate(int taskId, String taskName, Row[][] sentences, String name, int epoch) {
        ScoreCountsByLabel scoreCountsByLabel = new ScoreCountsByLabel();
        int taskNumber = taskId + 1;
        IntRef sentCount = IntRef.create((int)0);
        Metal$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started evaluation on the ", " dataset for task ", " (", ")..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)taskNumber), taskName})));
        PrintWriter pw = epoch >= 0 ? new PrintWriter(new FileWriter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"task", ".dev.output.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskNumber), BoxesRunTime.boxToInteger((int)epoch)})))) : new PrintWriter(new FileWriter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"task", ".test.output"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskNumber)}))));
        MetalRowReader reader = new MetalRowReader();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sentences)).foreach((Function1 & Serializable & scala.Serializable)sent -> {
            Metal.$anonfun$evaluate$1(this, taskId, scoreCountsByLabel, sentCount, pw, reader, sent);
            return BoxedUnit.UNIT;
        });
        pw.close();
        Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accuracy on ", " ", " sentences for task ", " (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sentences.length), name, BoxesRunTime.boxToInteger((int)taskNumber), taskName, BoxesRunTime.boxToDouble((double)scoreCountsByLabel.accuracy(scoreCountsByLabel.accuracy$default$1()))})));
        Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Precision on ", " ", " sentences for task ", " (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sentences.length), name, BoxesRunTime.boxToInteger((int)taskNumber), taskName, BoxesRunTime.boxToDouble((double)scoreCountsByLabel.precision(scoreCountsByLabel.precision$default$1(), scoreCountsByLabel.precision$default$2()))})));
        Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recall on ", " ", " sentences for task ", " (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sentences.length), name, BoxesRunTime.boxToInteger((int)taskNumber), taskName, BoxesRunTime.boxToDouble((double)scoreCountsByLabel.recall(scoreCountsByLabel.recall$default$1(), scoreCountsByLabel.recall$default$2()))})));
        Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Micro F1 on ", " ", " sentences for task ", " (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sentences.length), name, BoxesRunTime.boxToInteger((int)taskNumber), taskName, BoxesRunTime.boxToDouble((double)scoreCountsByLabel.f1(scoreCountsByLabel.f1$default$1(), scoreCountsByLabel.f1$default$2()))})));
        scoreCountsByLabel.labels().foreach((Function1 & Serializable & scala.Serializable)label -> {
            Metal.$anonfun$evaluate$3(scoreCountsByLabel, label);
            return BoxedUnit.UNIT;
        });
        return new Tuple4((Object)BoxesRunTime.boxToDouble((double)scoreCountsByLabel.accuracy(scoreCountsByLabel.accuracy$default$1())), (Object)BoxesRunTime.boxToDouble((double)scoreCountsByLabel.precision(scoreCountsByLabel.precision$default$1(), scoreCountsByLabel.precision$default$2())), (Object)BoxesRunTime.boxToDouble((double)scoreCountsByLabel.recall(scoreCountsByLabel.recall$default$1(), scoreCountsByLabel.recall$default$2())), (Object)BoxesRunTime.boxToDouble((double)scoreCountsByLabel.f1(scoreCountsByLabel.f1$default$1(), scoreCountsByLabel.f1$default$2())));
    }

    public IndexedSeq<IndexedSeq<String>> predictJointly(AnnotatedSentence sentence) {
        return Layers$.MODULE$.predictJointly(this.model(), sentence);
    }

    public IndexedSeq<String> predict(int taskId, AnnotatedSentence sentence) {
        return Layers$.MODULE$.predict(this.model(), taskId, sentence);
    }

    public IndexedSeq<IndexedSeq<Tuple2<String, Object>>> predictWithScores(int taskId, AnnotatedSentence sentence) {
        return Layers$.MODULE$.predictWithScores(this.model(), taskId, sentence);
    }

    public void test() {
        Predef$.MODULE$.require(this.taskManagerOpt().isDefined());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.taskManager().taskCount()).foreach((Function1 & Serializable & scala.Serializable)taskId -> Metal.$anonfun$test$1(this, BoxesRunTime.unboxToInt((Object)taskId)));
    }

    public void save(String baseFilename) {
        String dynetFilename = Utils$.MODULE$.mkDynetFilename(baseFilename);
        String x2iFilename = Utils$.MODULE$.mkX2iFilename(baseFilename);
        Closer$.MODULE$.AutoCloser((Object)new CloseableModelSaver(dynetFilename)).autoClose((Function1 & Serializable & scala.Serializable)modelSaver -> {
            modelSaver.addModel(this.parameters(), "/all");
            return BoxedUnit.UNIT;
        });
        Serializer$.MODULE$.using(Utils$.MODULE$.newPrintWriter(x2iFilename), (Function1 & Serializable & scala.Serializable)printWriter -> {
            Metal.$anonfun$save$2(this, printWriter);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$mkVocabularies$5(Counter[] labels$1, Counter[] words$1, int tid$1, Tuple2 as) {
        AnnotatedSentence annotatedSentence = (AnnotatedSentence)as._1();
        IndexedSeq sentenceLabels = (IndexedSeq)as._2();
        annotatedSentence.indices().foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            words$1[tid$1 + 1].$plus$eq(annotatedSentence.words().apply(i));
            words$1[0].$plus$eq(annotatedSentence.words().apply(i));
            return labels$1[tid$1 + 1].$plus$eq(sentenceLabels.apply(i));
        });
    }

    public static final /* synthetic */ void $anonfun$mkVocabularies$4(Counter[] labels$1, Counter[] words$1, MetalRowReader reader$1, int tid$1, Row[] sentence) {
        IndexedSeq<Tuple2<AnnotatedSentence, IndexedSeq<String>>> annotatedSentences = reader$1.toAnnotatedSentences((IndexedSeq<Row>)Predef$.MODULE$.wrapRefArray((Object[])sentence));
        annotatedSentences.foreach((Function1 & Serializable & scala.Serializable)as -> {
            Metal.$anonfun$mkVocabularies$5(labels$1, words$1, tid$1, as);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$train$4(Metal $this, int taskId$1, ExpressionVector lossSum$1, Tuple2 as) {
        AnnotatedSentence annotatedSentence = (AnnotatedSentence)as._1();
        IndexedSeq sentenceLabels = (IndexedSeq)as._2();
        Expression sentenceLoss = Layers$.MODULE$.loss($this.model(), taskId$1, annotatedSentence, (IndexedSeq<String>)sentenceLabels);
        lossSum$1.add(sentenceLoss);
    }

    public static final /* synthetic */ void $anonfun$train$3(Metal $this, int batchSize$1, SafeTrainer trainer$1, MetalRowReader reader$2, DoubleRef cummulativeLoss$1, IntRef numTagged$1, IntRef sentCount$1, ObjectRef batchLosses$1, Tuple2 metaSentence) {
        block1: {
            int taskId = metaSentence._1$mcI$sp();
            Row[] sentence = (Row[])metaSentence._2();
            ++sentCount$1.elem;
            IndexedSeq<Tuple2<AnnotatedSentence, IndexedSeq<String>>> annotatedSentences = reader$2.toAnnotatedSentences((IndexedSeq<Row>)Predef$.MODULE$.wrapRefArray((Object[])sentence));
            Predef$.MODULE$.assert(annotatedSentences.nonEmpty());
            ExpressionVector lossSum = new ExpressionVector(ExpressionVector$.MODULE$.$lessinit$greater$default$1());
            annotatedSentences.foreach((Function1 & Serializable & scala.Serializable)as -> {
                Metal.$anonfun$train$4($this, taskId, lossSum, as);
                return BoxedUnit.UNIT;
            });
            Expression unweightedLoss = Expression$.MODULE$.sum(lossSum);
            Expression loss = (double)$this.taskManager().tasks()[taskId].taskWeight() != 1.0 ? unweightedLoss.$times(Expression$.MODULE$.input($this.taskManager().tasks()[taskId].taskWeight())) : unweightedLoss;
            ((ExpressionVector)batchLosses$1.elem).add(loss);
            if (((ExpressionVector)batchLosses$1.elem).size() >= batchSize$1) {
                cummulativeLoss$1.elem += (double)$this.batchBackprop((ExpressionVector)batchLosses$1.elem, trainer$1);
                ComputationGraph$.MODULE$.renew();
                batchLosses$1.elem = new ExpressionVector(ExpressionVector$.MODULE$.$lessinit$greater$default$1());
            }
            numTagged$1.elem += sentence.length;
            if (sentCount$1.elem % 1000 != 0) break block1;
            Metal$.MODULE$.logger().info("Cummulative loss: " + cummulativeLoss$1.elem / (double)numTagged$1.elem + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (", " sentences)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sentCount$1.elem)})));
            cummulativeLoss$1.elem = 0.0;
            numTagged$1.elem = 0;
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasContent$1(String x$3) {
        String string = x$3;
        String string2 = "O";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$evaluate$2(Metal $this, int taskId$2, ScoreCountsByLabel scoreCountsByLabel$1, PrintWriter pw$1, Tuple2 as) {
        AnnotatedSentence sentence = (AnnotatedSentence)as._1();
        IndexedSeq goldLabels = (IndexedSeq)as._2();
        IndexedSeq<String> preds = Layers$.MODULE$.predict($this.model(), taskId$2, sentence);
        ScoreCountsByLabel sc = SeqScorer$.MODULE$.f1((IndexedSeq<String>)goldLabels, preds);
        scoreCountsByLabel$1.incAll(sc);
        Utils$.MODULE$.printCoNLLOutput(pw$1, sentence.words(), (IndexedSeq<String>)goldLabels, preds);
    }

    public static final /* synthetic */ void $anonfun$evaluate$1(Metal $this, int taskId$2, ScoreCountsByLabel scoreCountsByLabel$1, IntRef sentCount$2, PrintWriter pw$1, MetalRowReader reader$3, Row[] sent) {
        ++sentCount$2.elem;
        IndexedSeq<Tuple2<AnnotatedSentence, IndexedSeq<String>>> annotatedSentences = reader$3.toAnnotatedSentences((IndexedSeq<Row>)Predef$.MODULE$.wrapRefArray((Object[])sent));
        annotatedSentences.foreach((Function1 & Serializable & scala.Serializable)as -> {
            Metal.$anonfun$evaluate$2($this, taskId$2, scoreCountsByLabel$1, pw$1, as);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$evaluate$3(ScoreCountsByLabel scoreCountsByLabel$1, String label) {
        Metal$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tP/R/F1 for label ", " (", "): ", " / ", " / ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label, BoxesRunTime.boxToInteger((int)((ScoreCounts)scoreCountsByLabel$1.map().apply((Object)label)).gold()), BoxesRunTime.boxToDouble((double)scoreCountsByLabel$1.precision(label, scoreCountsByLabel$1.precision$default$2())), BoxesRunTime.boxToDouble((double)scoreCountsByLabel$1.recall(label, scoreCountsByLabel$1.recall$default$2())), BoxesRunTime.boxToDouble((double)scoreCountsByLabel$1.f1(label, scoreCountsByLabel$1.f1$default$2()))})));
    }

    public static final /* synthetic */ Object $anonfun$test$1(Metal $this, int taskId) {
        String taskName = $this.taskManager().tasks()[taskId].taskName();
        Option<Row[][]> testSentences = $this.taskManager().tasks()[taskId].testSentences();
        return testSentences.nonEmpty() ? $this.evaluate(taskId, taskName, (Row[][])testSentences.get()) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$save$2(Metal $this, PrintWriter printWriter) {
        Utils$.MODULE$.save(printWriter, $this.model().length(), "layerCount");
        $this.model().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((Layers)$this.model().apply(i)).saveX2i(printWriter));
    }

    public Metal(Option<TaskManager> taskManagerOpt, ParameterCollection parameters, Option<IndexedSeq<Layers>> modelOpt) {
        this.taskManagerOpt = taskManagerOpt;
        this.parameters = parameters;
        this.modelOpt = modelOpt;
    }
}

