/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.dynet;

import edu.cmu.dynet.GruBuilder;
import edu.cmu.dynet.LstmBuilder;
import edu.cmu.dynet.LstmBuilder$;
import edu.cmu.dynet.ParameterCollection;
import edu.cmu.dynet.RnnBuilder;
import org.clulab.dynet.IntermediateLayer;
import org.clulab.dynet.RnnLayer;
import org.clulab.dynet.Utils;
import org.clulab.dynet.Utils$;
import org.clulab.utils.Configured;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.BufferedIterator;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class RnnLayer$ {
    public static RnnLayer$ MODULE$;
    private final Logger logger;
    private final float DEFAULT_DROPOUT_PROB;

    static {
        new RnnLayer$();
    }

    public Logger logger() {
        return this.logger;
    }

    public float DEFAULT_DROPOUT_PROB() {
        return this.DEFAULT_DROPOUT_PROB;
    }

    public RnnLayer load(ParameterCollection parameters, BufferedIterator<String> x2iIterator) {
        Utils.ByLineIntBuilder byLineIntBuilder = new Utils.ByLineIntBuilder();
        Utils.ByLineFloatBuilder byLineFloatBuilder = new Utils.ByLineFloatBuilder();
        Utils.ByLineStringBuilder byLineStringBuilder = new Utils.ByLineStringBuilder();
        int inputSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "inputSize"));
        int numLayers = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "numLayers"));
        int rnnStateSize = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "rnnStateSize"));
        int useHighwayConnectionsAsInt = BoxesRunTime.unboxToInt(byLineIntBuilder.build(x2iIterator, "useHighwayConnections"));
        boolean useHighwayConnections = useHighwayConnectionsAsInt == 1;
        String rnnType = (String)byLineStringBuilder.build(x2iIterator, "rnnType", "lstm");
        float dropoutProb = BoxesRunTime.unboxToFloat(byLineFloatBuilder.build(x2iIterator, "dropoutProb"));
        RnnBuilder fwBuilder = this.mkBuilder(rnnType, numLayers, inputSize, rnnStateSize, parameters);
        RnnBuilder bwBuilder = this.mkBuilder(rnnType, numLayers, inputSize, rnnStateSize, parameters);
        return new RnnLayer(parameters, inputSize, numLayers, rnnStateSize, useHighwayConnections, rnnType, fwBuilder, bwBuilder, dropoutProb);
    }

    private RnnBuilder mkBuilder(String rnnType, int numLayers, int inputSize, int rnnStateSize, ParameterCollection parameters) {
        GruBuilder gruBuilder;
        String string = rnnType;
        if ("gru".equals(string)) {
            gruBuilder = new GruBuilder((long)numLayers, (long)inputSize, (long)rnnStateSize, parameters);
        } else if ("lstm".equals(string)) {
            gruBuilder = new LstmBuilder((long)numLayers, (long)inputSize, (long)rnnStateSize, parameters, LstmBuilder$.MODULE$.$lessinit$greater$default$5());
        } else {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: unknown rnnType \"", "\"!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rnnType})));
        }
        return gruBuilder;
    }

    public Option<IntermediateLayer> initialize(Configured config, String paramPrefix, ParameterCollection parameters, int inputSize) {
        if (!config.contains(paramPrefix)) {
            return None$.MODULE$;
        }
        int numLayers = config.getArgInt(paramPrefix + ".numLayers", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
        int rnnStateSize = config.getArgInt(paramPrefix + ".rnnStateSize", (Option<Object>)None$.MODULE$);
        boolean useHighwayConnections = config.getArgBoolean(paramPrefix + ".useHighwayConnections", (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        String rnnType = config.getArgString(paramPrefix + ".type", (Option<String>)new Some((Object)"lstm"));
        float dropoutProb = config.getArgFloat(paramPrefix + ".dropoutProb", (Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)this.DEFAULT_DROPOUT_PROB())));
        RnnBuilder wordFwRnnBuilder = this.mkBuilder(rnnType, numLayers, inputSize, rnnStateSize, parameters);
        RnnBuilder wordBwRnnBuilder = this.mkBuilder(rnnType, numLayers, inputSize, rnnStateSize, parameters);
        RnnLayer layer = new RnnLayer(parameters, inputSize, numLayers, rnnStateSize, useHighwayConnections, rnnType, wordFwRnnBuilder, wordBwRnnBuilder, dropoutProb);
        return new Some((Object)layer);
    }

    private RnnLayer$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(RnnLayer.class);
        this.DEFAULT_DROPOUT_PROB = Utils$.MODULE$.DEFAULT_DROPOUT_PROBABILITY();
    }
}

