/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.dynet;

import org.clulab.dynet.Shard;
import org.clulab.dynet.TaskManager$;
import org.clulab.sequences.ColumnReader$;
import org.clulab.sequences.Row;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001%\u0011A\u0001V1tW*\u00111\u0001B\u0001\u0006IftW\r\u001e\u0006\u0003\u000b\u0019\taa\u00197vY\u0006\u0014'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0003\u0005\u0012\u0001\t\u0015\r\u0011\"\u0001\u0013\u0003\u0019!\u0018m]6JIV\t1\u0003\u0005\u0002\f)%\u0011Q\u0003\u0004\u0002\u0004\u0013:$\b\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011B\n\u0002\u000fQ\f7o[%eA!A\u0011\u0004\u0001BC\u0002\u0013\u0005!$\u0001\u0005uCN\\g*Y7f+\u0005Y\u0002C\u0001\u000f$\u001d\ti\u0012\u0005\u0005\u0002\u001f\u00195\tqD\u0003\u0002!\u0011\u00051AH]8pizJ!A\t\u0007\u0002\rA\u0013X\rZ3g\u0013\t!SE\u0001\u0004TiJLgn\u001a\u0006\u0003E1A\u0001b\n\u0001\u0003\u0002\u0003\u0006IaG\u0001\ni\u0006\u001c8NT1nK\u0002B\u0001\"\u000b\u0001\u0003\u0006\u0004%\tAG\u0001\u000eiJ\f\u0017N\u001c$jY\u0016t\u0015-\\3\t\u0011-\u0002!\u0011!Q\u0001\nm\ta\u0002\u001e:bS:4\u0015\u000e\\3OC6,\u0007\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u0003-!WM\u001e$jY\u0016t\u0015-\\3\u0016\u0003=\u00022a\u0003\u0019\u001c\u0013\t\tDB\u0001\u0004PaRLwN\u001c\u0005\tg\u0001\u0011\t\u0011)A\u0005_\u0005aA-\u001a<GS2,g*Y7fA!AQ\u0007\u0001BC\u0002\u0013\u0005a&\u0001\u0007uKN$h)\u001b7f\u001d\u0006lW\r\u0003\u00058\u0001\t\u0005\t\u0015!\u00030\u00035!Xm\u001d;GS2,g*Y7fA!A\u0011\b\u0001BC\u0002\u0013\u0005!#\u0001\u0005uCN\\G+\u001f9f\u0011!Y\u0004A!A!\u0002\u0013\u0019\u0012!\u0003;bg.$\u0016\u0010]3!\u0011!i\u0004A!b\u0001\n\u0003\u0011\u0012AD:iCJ$7\u000fU3s\u000bB|7\r\u001b\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005'\u0005y1\u000f[1sIN\u0004VM]#q_\u000eD\u0007\u0005\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0001C\u0003)!\u0018m]6XK&<\u0007\u000e^\u000b\u0002\u0007B\u00111\u0002R\u0005\u0003\u000b2\u0011QA\u00127pCRD\u0001b\u0012\u0001\u0003\u0002\u0003\u0006IaQ\u0001\fi\u0006\u001c8nV3jO\"$\b\u0005C\u0003J\u0001\u0011\u0005!*\u0001\u0004=S:LGO\u0010\u000b\n\u00176su\nU)S'R\u0003\"\u0001\u0014\u0001\u000e\u0003\tAQ!\u0005%A\u0002MAQ!\u0007%A\u0002mAQ!\u000b%A\u0002mAQ!\f%A\u0002=BQ!\u000e%A\u0002=BQ!\u000f%A\u0002MAQ!\u0010%A\u0002MAQ!\u0011%A\u0002\rCqA\u0016\u0001C\u0002\u0013\u0005q+\u0001\bue\u0006LgnU3oi\u0016t7-Z:\u0016\u0003a\u00032aC-\\\u0013\tQFBA\u0003BeJ\f\u0017\u0010E\u0002\f3r\u0003\"!\u00181\u000e\u0003yS!a\u0018\u0003\u0002\u0013M,\u0017/^3oG\u0016\u001c\u0018BA1_\u0005\r\u0011vn\u001e\u0005\u0007G\u0002\u0001\u000b\u0011\u0002-\u0002\u001fQ\u0014\u0018-\u001b8TK:$XM\\2fg\u0002Bq!\u001a\u0001C\u0002\u0013\u0005a-\u0001\u0007eKZ\u001cVM\u001c;f]\u000e,7/F\u0001h!\rY\u0001\u0007\u0017\u0005\u0007S\u0002\u0001\u000b\u0011B4\u0002\u001b\u0011,goU3oi\u0016t7-Z:!\u0011\u001dY\u0007A1A\u0005\u0002\u0019\fQ\u0002^3tiN+g\u000e^3oG\u0016\u001c\bBB7\u0001A\u0003%q-\u0001\buKN$8+\u001a8uK:\u001cWm\u001d\u0011\t\u000f=\u0004!\u0019!C\u0001a\u00069\u0011n\u001d\"bg&\u001cW#A9\u0011\u0005-\u0011\u0018BA:\r\u0005\u001d\u0011un\u001c7fC:Da!\u001e\u0001!\u0002\u0013\t\u0018\u0001C5t\u0005\u0006\u001c\u0018n\u0019\u0011\t\u000f]\u0004!\u0019!C\u0001a\u00061\u0011n\u001d#vC2Da!\u001f\u0001!\u0002\u0013\t\u0018aB5t\tV\fG\u000e\t\u0005\u0006w\u0002!\tAG\u0001\u000baJ,G\u000f^=UsB,\u0007bB?\u0001\u0005\u0004%\tAE\u0001\ng\"\f'\u000fZ*ju\u0016Daa \u0001!\u0002\u0013\u0019\u0012AC:iCJ$7+\u001b>fA!A\u00111\u0001\u0001A\u0002\u0013\u0005!#A\u0010dkJ\u0014XM\u001c;Ue\u0006Lg.\u001b8h'\u0016tG/\u001a8dKB{7/\u001b;j_:D\u0011\"a\u0002\u0001\u0001\u0004%\t!!\u0003\u0002G\r,(O]3oiR\u0013\u0018-\u001b8j]\u001e\u001cVM\u001c;f]\u000e,\u0007k\\:ji&|gn\u0018\u0013fcR!\u00111BA\t!\rY\u0011QB\u0005\u0004\u0003\u001fa!\u0001B+oSRD\u0011\"a\u0005\u0002\u0006\u0005\u0005\t\u0019A\n\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0018\u0001\u0001\u000b\u0015B\n\u0002A\r,(O]3oiR\u0013\u0018-\u001b8j]\u001e\u001cVM\u001c;f]\u000e,\u0007k\\:ji&|g\u000e\t\u0005\b\u00037\u0001A\u0011AA\u000f\u0003!i7n\u00155be\u0012\u001cHCAA\u0010!\u0011Y\u0011,!\t\u0011\u00071\u000b\u0019#C\u0002\u0002&\t\u0011Qa\u00155be\u0012Da!!\u000b\u0001\t\u0003\u0011\u0012A\u0003;bg.tU/\u001c2fe\u0002")
public class Task {
    private final int taskId;
    private final String taskName;
    private final String trainFileName;
    private final Option<String> devFileName;
    private final Option<String> testFileName;
    private final int taskType;
    private final int shardsPerEpoch;
    private final float taskWeight;
    private final Row[][] trainSentences;
    private final Option<Row[][]> devSentences;
    private final Option<Row[][]> testSentences;
    private final boolean isBasic;
    private final boolean isDual;
    private final int shardSize;
    private int currentTrainingSentencePosition;

    public int taskId() {
        return this.taskId;
    }

    public String taskName() {
        return this.taskName;
    }

    public String trainFileName() {
        return this.trainFileName;
    }

    public Option<String> devFileName() {
        return this.devFileName;
    }

    public Option<String> testFileName() {
        return this.testFileName;
    }

    public int taskType() {
        return this.taskType;
    }

    public int shardsPerEpoch() {
        return this.shardsPerEpoch;
    }

    public float taskWeight() {
        return this.taskWeight;
    }

    public Row[][] trainSentences() {
        return this.trainSentences;
    }

    public Option<Row[][]> devSentences() {
        return this.devSentences;
    }

    public Option<Row[][]> testSentences() {
        return this.testSentences;
    }

    public boolean isBasic() {
        return this.isBasic;
    }

    public boolean isDual() {
        return this.isDual;
    }

    public String prettyType() {
        int n = this.taskType();
        String string = TaskManager$.MODULE$.TYPE_BASIC() == n ? "basic" : (TaskManager$.MODULE$.TYPE_DUAL() == n ? "dual" : "unknown");
        return string;
    }

    public int shardSize() {
        return this.shardSize;
    }

    public int currentTrainingSentencePosition() {
        return this.currentTrainingSentencePosition;
    }

    public void currentTrainingSentencePosition_$eq(int x$1) {
        this.currentTrainingSentencePosition = x$1;
    }

    public Shard[] mkShards() {
        ArrayBuffer shards = new ArrayBuffer();
        int crtPos = 0;
        while (crtPos < this.trainSentences().length) {
            int endPos = package$.MODULE$.min(crtPos + this.shardSize(), this.trainSentences().length);
            shards.$plus$eq((Object)new Shard(this.taskId(), crtPos, endPos));
            crtPos = endPos;
        }
        return (Shard[])shards.toArray(ClassTag$.MODULE$.apply(Shard.class));
    }

    public int taskNumber() {
        return this.taskId() + 1;
    }

    public Task(int taskId, String taskName, String trainFileName, Option<String> devFileName, Option<String> testFileName, int taskType, int shardsPerEpoch, float taskWeight) {
        this.taskId = taskId;
        this.taskName = taskName;
        this.trainFileName = trainFileName;
        this.devFileName = devFileName;
        this.testFileName = testFileName;
        this.taskType = taskType;
        this.shardsPerEpoch = shardsPerEpoch;
        this.taskWeight = taskWeight;
        TaskManager$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading task ", " (", ")..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.taskNumber()), taskName})));
        this.trainSentences = ColumnReader$.MODULE$.readColumns(trainFileName);
        this.devSentences = devFileName.isDefined() ? new Some((Object)ColumnReader$.MODULE$.readColumns((String)devFileName.get())) : None$.MODULE$;
        this.testSentences = testFileName.isDefined() ? new Some((Object)ColumnReader$.MODULE$.readColumns((String)testFileName.get())) : None$.MODULE$;
        this.isBasic = taskType == TaskManager$.MODULE$.TYPE_BASIC();
        this.isDual = taskType == TaskManager$.MODULE$.TYPE_DUAL();
        this.shardSize = (int)package$.MODULE$.ceil((double)this.trainSentences().length / (double)shardsPerEpoch);
        this.currentTrainingSentencePosition = 0;
        TaskManager$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"============ starting task ", " ============"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.taskNumber())})));
        TaskManager$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read ", " training sentences for task ", ", with shard size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.trainSentences().length), BoxesRunTime.boxToInteger((int)this.taskNumber()), BoxesRunTime.boxToInteger((int)this.shardSize())})));
        if (this.devSentences().isDefined()) {
            TaskManager$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read ", " development sentences for task ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((Row[][])this.devSentences().get()).length), BoxesRunTime.boxToInteger((int)this.taskNumber())})));
        }
        if (this.testSentences().isDefined()) {
            TaskManager$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read ", " testing sentences for task ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((Row[][])this.testSentences().get()).length), BoxesRunTime.boxToInteger((int)this.taskNumber())})));
        }
        TaskManager$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using taskWeight = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)taskWeight)})));
        TaskManager$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task type = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyType()})));
        TaskManager$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"============ completed task ", " ============"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.taskNumber())})));
    }
}

