/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.dynet;

import edu.cmu.dynet.Dim$;
import edu.cmu.dynet.Expression;
import edu.cmu.dynet.Expression$;
import edu.cmu.dynet.ExpressionVector;
import edu.cmu.dynet.ExpressionVector$;
import edu.cmu.dynet.FloatVector;
import edu.cmu.dynet.LookupParameter;
import edu.cmu.dynet.ParameterCollection;
import edu.cmu.dynet.RnnBuilder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import org.clulab.dynet.ArrayMath$;
import org.clulab.dynet.Utils;
import org.clulab.embeddings.WordEmbeddingMap;
import org.clulab.fatdynet.utils.BaseTextLoader;
import org.clulab.fatdynet.utils.BaseTextLoader$;
import org.clulab.fatdynet.utils.BaseTextModelLoader;
import org.clulab.fatdynet.utils.Initializer$;
import org.clulab.struct.Counter;
import org.clulab.utils.Serializer$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.ResizableArray;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class Utils$ {
    public static Utils$ MODULE$;
    private final Logger org$clulab$dynet$Utils$$logger;
    private int concatenateCount;
    private final String UNK_WORD;
    private final String EOS_WORD;
    private final int UNK_EMBEDDING;
    private final String START_TAG;
    private final String STOP_TAG;
    private final long RANDOM_SEED;
    private final float WEIGHT_DECAY;
    private final float LOG_MIN_VALUE;
    private final float DEFAULT_DROPOUT_PROBABILITY;
    private boolean IS_DYNET_INITIALIZED;

    static {
        new Utils$();
    }

    public Logger org$clulab$dynet$Utils$$logger() {
        return this.org$clulab$dynet$Utils$$logger;
    }

    public int concatenateCount() {
        return this.concatenateCount;
    }

    public void concatenateCount_$eq(int x$1) {
        this.concatenateCount = x$1;
    }

    public String UNK_WORD() {
        return this.UNK_WORD;
    }

    public String EOS_WORD() {
        return this.EOS_WORD;
    }

    public int UNK_EMBEDDING() {
        return this.UNK_EMBEDDING;
    }

    public String START_TAG() {
        return this.START_TAG;
    }

    public String STOP_TAG() {
        return this.STOP_TAG;
    }

    public long RANDOM_SEED() {
        return this.RANDOM_SEED;
    }

    public float WEIGHT_DECAY() {
        return this.WEIGHT_DECAY;
    }

    public float LOG_MIN_VALUE() {
        return this.LOG_MIN_VALUE;
    }

    public float DEFAULT_DROPOUT_PROBABILITY() {
        return this.DEFAULT_DROPOUT_PROBABILITY;
    }

    private boolean IS_DYNET_INITIALIZED() {
        return this.IS_DYNET_INITIALIZED;
    }

    private void IS_DYNET_INITIALIZED_$eq(boolean x$1) {
        this.IS_DYNET_INITIALIZED = x$1;
    }

    public void initializeDyNet(boolean autoBatch, String mem) {
        block2: {
            BoxedUnit boxedUnit;
            if (this.IS_DYNET_INITIALIZED()) break block2;
            this.org$clulab$dynet$Utils$$logger().debug("Initializing DyNet...");
            HashMap params = new HashMap();
            params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"random-seed"), (Object)BoxesRunTime.boxToLong((long)this.RANDOM_SEED())));
            params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"weight-decay"), (Object)BoxesRunTime.boxToFloat((float)this.WEIGHT_DECAY())));
            if (autoBatch) {
                params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"autobatch"), (Object)BoxesRunTime.boxToInteger((int)1)));
                boxedUnit = params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dynet-mem"), (Object)mem));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Initializer$.MODULE$.initialize(params.toMap(Predef$.MODULE$.$conforms()));
            this.org$clulab$dynet$Utils$$logger().debug("DyNet initialization complete.");
            this.IS_DYNET_INITIALIZED_$eq(true);
        }
    }

    public boolean initializeDyNet$default$1() {
        return false;
    }

    public String initializeDyNet$default$2() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public String[] fromIndexToString(Map<String, Object> s2i) {
        void var3_3;
        IntRef max = IntRef.create((int)Integer.MIN_VALUE);
        s2i.values().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)v -> {
            block0: {
                if (v <= max$1.elem) break block0;
                max$1.elem = v;
            }
        });
        Predef$.MODULE$.assert(max.elem > 0);
        String[] i2s = new String[max.elem + 1];
        s2i.keySet().foreach((Function1 & Serializable & scala.Serializable)k -> {
            i2s[BoxesRunTime.unboxToInt((Object)s2i.apply((Object)k))] = k;
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public char[] fromIndexToChar(Map<Object, Object> s2i) {
        void var3_3;
        IntRef max = IntRef.create((int)Integer.MIN_VALUE);
        s2i.values().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)v -> {
            block0: {
                if (v <= max$2.elem) break block0;
                max$2.elem = v;
            }
        });
        Predef$.MODULE$.assert(max.elem > 0);
        char[] i2s = new char[max.elem + 1];
        s2i.keySet().foreach((Function1 & Serializable & scala.Serializable)k -> {
            i2s[BoxesRunTime.unboxToInt((Object)s2i.apply((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)k))))] = BoxesRunTime.unboxToChar((Object)k);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public LookupParameter mkTransitionMatrix(ParameterCollection parameters, Map<String, Object> t2i) {
        int size = t2i.size();
        LookupParameter rows = parameters.addLookupParameters((long)size, Dim$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{size})));
        return rows;
    }

    public int[] viterbi(float[][] emissionScores, float[][] transitionMatrix, int tagCount, int startTagIdx, int stopTagIdx) {
        float[] initScores = new float[tagCount];
        new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(initScores)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            initScores$1[i] = MODULE$.LOG_MIN_VALUE();
        });
        initScores[startTagIdx] = 0.0f;
        ObjectRef forwardVar = ObjectRef.create((Object)initScores);
        ArrayBuffer backPointers = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])emissionScores)).indices().foreach((Function1 & Serializable & scala.Serializable)t -> Utils$.$anonfun$viterbi$2(emissionScores, transitionMatrix, forwardVar, backPointers, BoxesRunTime.unboxToInt((Object)t)));
        Predef$.MODULE$.assert(emissionScores.length == backPointers.length());
        forwardVar.elem = ArrayMath$.MODULE$.sum((float[])forwardVar.elem, transitionMatrix[stopTagIdx]);
        IntRef bestLastTag = IntRef.create((int)ArrayMath$.MODULE$.argmax((float[])forwardVar.elem));
        float pathScore = ((float[])forwardVar.elem)[bestLastTag.elem];
        ListBuffer bestPathReversed = new ListBuffer();
        bestPathReversed.$plus$eq((Object)BoxesRunTime.boxToInteger((int)bestLastTag.elem));
        ((ResizableArray)backPointers.reverse()).foreach((Function1 & Serializable & scala.Serializable)backPointersAtT -> {
            bestLastTag$1.elem = backPointersAtT[bestLastTag$1.elem];
            return bestPathReversed.$plus$eq((Object)BoxesRunTime.boxToInteger((int)bestLastTag$1.elem));
        });
        Predef$.MODULE$.assert(BoxesRunTime.unboxToInt((Object)bestPathReversed.last()) == startTagIdx);
        int[] bestPath = (int[])((TraversableForwarder)((SeqLike)bestPathReversed.slice(0, bestPathReversed.size() - 1)).reverse()).toArray(ClassTag$.MODULE$.Int());
        return bestPath;
    }

    public Expression mkPartitionScore(ExpressionVector emissionScoresForSeq, ExpressionVector transitionMatrix, int startTag, int stopTag) {
        int tagCount = transitionMatrix.size();
        ObjectRef forward = ObjectRef.create((Object)new ExpressionVector(ExpressionVector$.MODULE$.$lessinit$greater$default$1()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tagCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)t -> {
            float alphaAtT0 = t == startTag ? 0.0f : MODULE$.LOG_MIN_VALUE();
            ((ExpressionVector)forward$1.elem).add(Expression$.MODULE$.input(alphaAtT0));
        });
        emissionScoresForSeq.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)t -> {
            ExpressionVector alphasAtT = new ExpressionVector(ExpressionVector$.MODULE$.$lessinit$greater$default$1());
            Expression emitScores = emissionScoresForSeq.apply(t);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tagCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)nextTag -> {
                ExpressionVector alphasForTag = new ExpressionVector(ExpressionVector$.MODULE$.$lessinit$greater$default$1());
                Expression emitScore = Expression$.MODULE$.pick(emitScores, (long)nextTag, Expression$.MODULE$.pick$default$3());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tagCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)srcTag -> {
                    Expression transScore = MODULE$.pick2D(transitionMatrix, nextTag, srcTag);
                    Expression alphaToTagFromSrc = ((ExpressionVector)forward$1.elem).apply(srcTag).$plus(transScore).$plus(emitScore);
                    alphasForTag.add(alphaToTagFromSrc);
                });
                alphasAtT.add(Expression$.MODULE$.logSumExp(alphasForTag));
            });
            forward$1.elem = alphasAtT;
        });
        ExpressionVector terminalVars = new ExpressionVector(ExpressionVector$.MODULE$.$lessinit$greater$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tagCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)t -> terminalVars.add(((ExpressionVector)forward$1.elem).apply(t).$plus(MODULE$.pick2D(transitionMatrix, stopTag, t))));
        Expression total = Expression$.MODULE$.logSumExp(terminalVars);
        return total;
    }

    /*
     * WARNING - void declaration
     */
    public <T> IndexedSeq<Object> toIds(IndexedSeq<T> tags, Map<T, Object> t2i) {
        void var3_3;
        ArrayBuffer ids = new ArrayBuffer();
        tags.foreach((Function1 & Serializable & scala.Serializable)tag -> ids.$plus$eq(t2i.apply(tag)));
        return var3_3;
    }

    public void printCoNLLOutput(PrintWriter pw, IndexedSeq<String> words, IndexedSeq<String> golds, IndexedSeq<String> preds) {
        Predef$.MODULE$.assert(words.length() == golds.length());
        Predef$.MODULE$.assert(words.length() == preds.length());
        words.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> pw.println((String)words.apply(i) + " " + golds.apply(i) + " " + preds.apply(i)));
        pw.println();
    }

    public int[] greedyPredict(float[][] lattice) {
        ArrayBuffer tagIds = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lattice)).foreach((Function1 & Serializable & scala.Serializable)probs -> {
            FloatRef max = FloatRef.create((float)Float$.MODULE$.MinValue());
            IntRef tid = IntRef.create((int)-1);
            new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(probs)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                block0: {
                    if (!(probs[i] > max$3.elem)) break block0;
                    max$3.elem = probs[i];
                    tid$1.elem = i;
                }
            });
            Predef$.MODULE$.assert(tid.elem > -1);
            return tagIds.$plus$eq((Object)BoxesRunTime.boxToInteger((int)tid.elem));
        });
        return (int[])tagIds.toArray(ClassTag$.MODULE$.Int());
    }

    public int[] srlPredict(float[][] lattice, int predPosition, int oId) {
        int[] tagIds = new int[lattice.length];
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(tagIds)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            tagIds$2[i] = oId;
        });
        ArrayBuffer tags = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lattice)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(lattice[i])).indices().foreach((Function1 & Serializable & scala.Serializable)j -> tags.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)j)), (Object)BoxesRunTime.boxToFloat((float)lattice[i][BoxesRunTime.unboxToInt((Object)j)])))));
        ArrayBuffer sortedTags = (ArrayBuffer)tags.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToFloat((float)Utils$.$anonfun$srlPredict$4(x$1)), (Ordering)Ordering.Float$.MODULE$);
        HashSet usedPositions = new HashSet();
        usedPositions.$plus$eq((Object)BoxesRunTime.boxToInteger((int)predPosition));
        tagIds[predPosition] = oId;
        HashSet usedArgs = new HashSet();
        sortedTags.foreach((Function1 & Serializable & scala.Serializable)t3 -> {
            Object object;
            int position = BoxesRunTime.unboxToInt((Object)t3._1());
            int tagId = BoxesRunTime.unboxToInt((Object)t3._2());
            if (!(usedPositions.contains((Object)BoxesRunTime.boxToInteger((int)position)) || tagId != oId && usedArgs.contains((Object)BoxesRunTime.boxToInteger((int)tagId)))) {
                tagIds$2[position] = tagId;
                usedPositions.$plus$eq((Object)BoxesRunTime.boxToInteger((int)position));
                object = tagId != oId ? usedArgs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)tagId)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return tagIds;
    }

    public void printTagScores(String header, float[] scores, String[] i2t) {
        Predef$.MODULE$.print((Object)header);
        new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(scores)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            String tag = i2t[j];
            Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" {", ", ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tag, BoxesRunTime.boxToFloat((float)scores[j])})));
        });
        Predef$.MODULE$.println();
    }

    public Expression pick2D(ExpressionVector matrix, int row, int column) {
        return Expression$.MODULE$.pick(matrix.apply(row), (long)column, Expression$.MODULE$.pick$default$3());
    }

    public Expression sentenceScore(ExpressionVector emissionScoresForSeq, ExpressionVector transitionMatrix, int tagCount, IndexedSeq<Object> tagSeq, int startTag, int stopTag) {
        ObjectRef score = ObjectRef.create((Object)this.pick2D(transitionMatrix, BoxesRunTime.unboxToInt((Object)tagSeq.head()), startTag));
        tagSeq.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            if (i > 0) {
                score$1.elem = ((Expression)score$1.elem).$plus(MODULE$.pick2D(transitionMatrix, BoxesRunTime.unboxToInt((Object)tagSeq.apply(i)), BoxesRunTime.unboxToInt((Object)tagSeq.apply(i - 1))));
            }
            score$1.elem = ((Expression)score$1.elem).$plus(Expression$.MODULE$.pick(emissionScoresForSeq.apply(i), (long)BoxesRunTime.unboxToInt((Object)tagSeq.apply(i)), Expression$.MODULE$.pick$default$3()));
        });
        score.elem = ((Expression)score.elem).$plus(this.pick2D(transitionMatrix, stopTag, BoxesRunTime.unboxToInt((Object)tagSeq.last())));
        return (Expression)score.elem;
    }

    public Iterable<Expression> concatenateStates(Iterable<Expression> l1, Iterable<Expression> l2) {
        return (Iterable)((TraversableLike)l1.zip(l2, Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression left = (Expression)tuple2._1();
            Expression right = (Expression)tuple2._2();
            Expression expression = Expression$.MODULE$.concatenate((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{left, right}));
            return expression;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Expression mkCharacterEmbedding(String word, Map<Object, Object> c2i, LookupParameter charLookupParameters, RnnBuilder charFwRnnBuilder, RnnBuilder charBwRnnBuilder) {
        scala.collection.immutable.IndexedSeq charEmbeddings = (scala.collection.immutable.IndexedSeq)new StringOps(Predef$.MODULE$.augmentString(word)).map((Function1 & Serializable & scala.Serializable)c -> Expression$.MODULE$.lookup(charLookupParameters, (long)BoxesRunTime.unboxToInt((Object)c2i.getOrElse((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)c)), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.UNK_EMBEDDING()))), Predef$.MODULE$.fallbackStringCanBuildFrom());
        Expression fwOutsLast = this.safelyTransduceLast1$1((Seq)charEmbeddings, charFwRnnBuilder, word, charLookupParameters);
        Expression bwOutsLast = this.safelyTransduceLast1$1((Seq)charEmbeddings.reverse(), charBwRnnBuilder, word, charLookupParameters);
        Expression result = Expression$.MODULE$.concatenate((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{fwOutsLast, bwOutsLast}));
        return result;
    }

    public Option<Expression> transduceLastOpt(Iterable<Expression> embeddings, RnnBuilder builder) {
        None$ none$;
        if (embeddings.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            builder.newGraph(builder.newGraph$default$1());
            builder.startNewSequence();
            ((IterableLike)embeddings.dropRight(1)).foreach((Function1 & Serializable & scala.Serializable)embedding -> builder.addInput(embedding));
            none$ = new Some((Object)builder.addInput((Expression)embeddings.last()));
        }
        return none$;
    }

    public ExpressionVector transduce(Iterable<Expression> embeddings, RnnBuilder builder) {
        return Utils$.transduceItr$1(embeddings, builder);
    }

    public Expression sentenceLossGreedy(ExpressionVector emissionScoresForSeq, IndexedSeq<Object> golds) {
        ExpressionVector goldLosses = new ExpressionVector(ExpressionVector$.MODULE$.$lessinit$greater$default$1());
        Predef$.MODULE$.assert(emissionScoresForSeq.length() == golds.length());
        emissionScoresForSeq.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int goldTid = BoxesRunTime.unboxToInt((Object)golds.apply(i));
            goldLosses.add(Expression$.MODULE$.pickNegLogSoftmax(emissionScoresForSeq.apply(i), (long)goldTid));
        });
        return Expression$.MODULE$.sum(goldLosses);
    }

    public Expression sentenceLossCrf(ExpressionVector emissionScoresForSeq, ExpressionVector transitionMatrix, IndexedSeq<Object> golds, Map<String, Object> t2i) {
        int startTag = BoxesRunTime.unboxToInt((Object)t2i.apply((Object)this.START_TAG()));
        int stopTag = BoxesRunTime.unboxToInt((Object)t2i.apply((Object)this.STOP_TAG()));
        Expression scoreOfGoldSeq = this.sentenceScore(emissionScoresForSeq, transitionMatrix, t2i.size(), golds, startTag, stopTag);
        Expression partitionScore = this.mkPartitionScore(emissionScoresForSeq, transitionMatrix, startTag, stopTag);
        return partitionScore.$minus(scoreOfGoldSeq);
    }

    public float[][] emissionScoresToArrays(Iterable<Expression> expressions) {
        ArrayBuffer lattice = new ArrayBuffer();
        expressions.foreach((Function1 & Serializable & scala.Serializable)expression -> {
            float[] probs = (float[])expression.value().toVector().toArray(ClassTag$.MODULE$.Float());
            return lattice.$plus$eq((Object)probs);
        });
        return (float[][])lattice.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
    }

    /*
     * WARNING - void declaration
     */
    public float[][][] emissionScoresToArraysAllTasks(ExpressionVector[] expressions) {
        void var2_2;
        float[][][] latticesAllTasks = new float[expressions.length][][];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])latticesAllTasks)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tid -> {
            ArrayBuffer lattice = new ArrayBuffer();
            expressions[tid].foreach((Function1 & Serializable & scala.Serializable)expression -> {
                float[] probs = (float[])expression.value().toVector().toArray(ClassTag$.MODULE$.Float());
                return lattice.$plus$eq((Object)probs);
            });
            latticesAllTasks$1[tid] = (float[][])lattice.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        });
        return var2_2;
    }

    public float[][] transitionMatrixToArrays(LookupParameter trans, int size) {
        ArrayBuffer transitionMatrix = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1 & Serializable & scala.Serializable)i -> transitionMatrix.$plus$eq(Expression$.MODULE$.lookup(trans, (long)BoxesRunTime.unboxToInt((Object)i)).value().toVector().toArray(ClassTag$.MODULE$.Float())));
        return (float[][])transitionMatrix.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
    }

    public <T> void save(PrintWriter printWriter, Map<T, Object> values, String comment, Function1<T, Ordered<T>> evidence$1) {
        printWriter.println("# " + comment);
        ((IterableLike)values.toSeq().sorted(Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered(evidence$1), (Ordering)Ordering.Int$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Utils$.$anonfun$save$1(printWriter, x0$2);
            return BoxedUnit.UNIT;
        });
        printWriter.println();
    }

    public <T> void save(PrintWriter printWriter, Counter<T> values, String comment, Function1<T, Ordered<T>> evidence$2) {
        printWriter.println("# " + comment);
        List keys = (List)values.keySet().toList().sorted(Ordering$.MODULE$.ordered(evidence$2));
        keys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            Utils$.$anonfun$save$2(printWriter, values, key);
            return BoxedUnit.UNIT;
        });
        printWriter.println();
    }

    public void saveCharMap(PrintWriter printWriter, Map<Object, Object> values, String comment) {
        printWriter.println("# " + comment);
        ((IterableLike)values.toSeq().sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Char$.MODULE$, (Ordering)Ordering.Int$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Utils$.$anonfun$saveCharMap$1(printWriter, x0$3);
            return BoxedUnit.UNIT;
        });
        printWriter.println();
    }

    public <T> void save(PrintWriter printWriter, Object values, String comment) {
        printWriter.println("# " + comment);
        Predef$.MODULE$.genericArrayOps(values).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            printWriter.println(x$1);
            return BoxedUnit.UNIT;
        });
        printWriter.println();
    }

    public void save(PrintWriter printWriter, long value, String comment) {
        printWriter.println("# " + comment);
        printWriter.println(value);
        printWriter.println();
    }

    public void save(PrintWriter printWriter, float value, String comment) {
        printWriter.println("# " + comment);
        printWriter.println(value);
        printWriter.println();
    }

    public void save(PrintWriter printWriter, String value, String comment) {
        printWriter.println("# " + comment);
        printWriter.println(value);
        printWriter.println();
    }

    public String stringToString(String string) {
        return string;
    }

    public char stringToChar(String string) {
        return string.charAt(0);
    }

    public char stringToCharInt(String string) {
        return (char)new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
    }

    public PrintWriter newPrintWriter(String filename) {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(filename)), "UTF-8"));
    }

    public Source newSource(String filename) {
        File f = new File(filename);
        return f.exists() ? Source$.MODULE$.fromFile(filename, "UTF-8") : Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/" + filename), Codec$.MODULE$.fallbackSystemCodec());
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> readString2Ids(String s2iFilename) {
        void var2_2;
        Map s2i = (Map)Serializer$.MODULE$.using(this.newSource(s2iFilename), (Function1 & Serializable & scala.Serializable)source -> {
            void var3_3;
            Utils.ByLineStringMapBuilder byLineStringMapBuilder = new Utils.ByLineStringMapBuilder();
            BufferedIterator lines = source.getLines().buffered();
            Map s2i = (Map)byLineStringMapBuilder.build((BufferedIterator<String>)lines);
            return var3_3;
        });
        return var2_2;
    }

    public void loadParameters(String dynetFilename, ParameterCollection modelParameters, String key) {
        BaseTextLoader textLoader = BaseTextLoader$.MODULE$.newTextLoader(dynetFilename);
        BaseTextModelLoader textModelLoader = textLoader.newTextModelLoader();
        textModelLoader.populateModel(modelParameters, key);
    }

    public String loadParameters$default$3() {
        return "/all";
    }

    public String mkDynetFilename(String baseFilename) {
        return baseFilename + ".rnn";
    }

    public String mkX2iFilename(String baseFilename) {
        return baseFilename + ".x2i";
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> mkWordVocab(WordEmbeddingMap w2v) {
        void var3_3;
        ListBuffer commonWords = new ListBuffer();
        commonWords.$plus$eq((Object)this.UNK_WORD());
        ((List)w2v.matrix().keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)w -> commonWords.$plus$eq(w));
        Map w2i = ((TraversableForwarder)commonWords.zipWithIndex(ListBuffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return var3_3;
    }

    public void initializeEmbeddings(WordEmbeddingMap w2v, Map<String, Object> w2i, LookupParameter lookupParameters) {
        this.org$clulab$dynet$Utils$$logger().debug("Initializing DyNet embedding parameters...");
        w2v.matrix().keySet().foreach((Function1 & Serializable & scala.Serializable)word -> {
            lookupParameters.initialize((long)BoxesRunTime.unboxToInt((Object)w2i.apply((Object)word)), new FloatVector((Seq)Predef$.MODULE$.wrapFloatArray(ArrayMath$.MODULE$.toFloatArray((double[])w2v.matrix().apply((Object)word)))));
            return BoxedUnit.UNIT;
        });
        this.org$clulab$dynet$Utils$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed initializing embedding parameters for a vocabulary of size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)w2v.matrix().size())})));
    }

    public void setRnnDropout(RnnBuilder rnnBuilder, float dropoutProb, boolean doDropout) {
        if (doDropout && dropoutProb > 0.0f) {
            rnnBuilder.setDropout(dropoutProb);
        } else {
            rnnBuilder.disableDropout();
        }
    }

    public Expression expressionDropout(Expression expression, float dropoutProb, boolean doDropout) {
        return doDropout && dropoutProb > 0.0f ? Expression$.MODULE$.dropout(expression, dropoutProb) : expression;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$viterbi$2(float[][] emissionScores$1, float[][] transitionMatrix$1, ObjectRef forwardVar$1, ArrayBuffer backPointers$1, int t) {
        float[] scoresAtT = new float[emissionScores$1[t].length];
        int[] backPointersAtT = new int[emissionScores$1[t].length];
        new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(emissionScores$1[t])).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)nextTag -> {
            int bestPrevTag;
            float[] transitionIntoNextTag = ArrayMath$.MODULE$.sum((float[])forwardVar$1.elem, transitionMatrix$1[nextTag]);
            backPointersAtT$1[nextTag] = bestPrevTag = ArrayMath$.MODULE$.argmax(transitionIntoNextTag);
            scoresAtT$1[nextTag] = transitionIntoNextTag[bestPrevTag];
        });
        forwardVar$1.elem = ArrayMath$.MODULE$.sum(scoresAtT, emissionScores$1[t]);
        return backPointers$1.$plus$eq((Object)backPointersAtT);
    }

    public static final /* synthetic */ float $anonfun$srlPredict$4(Tuple3 x$1) {
        return 0.0f - BoxesRunTime.unboxToFloat((Object)x$1._3());
    }

    private final Expression safelyTransduceLast1$1(Seq charEmbeddings, RnnBuilder rnnBuilder, String word$1, LookupParameter charLookupParameters$1) {
        Option<Expression> outsOpt = this.transduceLastOpt((Iterable<Expression>)charEmbeddings, rnnBuilder);
        Expression nonEmptyOuts = (Expression)outsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            MODULE$.org$clulab$dynet$Utils$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A strange character was encountered in word '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word$1})));
            Expression[] safeCharEmbeddings = (Expression[])((Object[])new Expression[]{Expression$.MODULE$.lookup(charLookupParameters$1, (long)MODULE$.UNK_EMBEDDING())});
            return (Expression)MODULE$.transduceLastOpt((Iterable<Expression>)Predef$.MODULE$.wrapRefArray((Object[])safeCharEmbeddings), rnnBuilder).get();
        });
        return nonEmptyOuts;
    }

    private final Expression safelyTransduceLast2$1(Seq charEmbeddings, RnnBuilder rnnBuilder, String word$1, LookupParameter charLookupParameters$1) {
        ExpressionVector expressionVector;
        ExpressionVector outs = this.transduce((Iterable<Expression>)charEmbeddings, rnnBuilder);
        if (outs.length() != 0) {
            expressionVector = outs;
        } else {
            this.org$clulab$dynet$Utils$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A strange character was encountered in word '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word$1})));
            Expression[] safeCharEmbeddings = (Expression[])((Object[])new Expression[]{Expression$.MODULE$.lookup(charLookupParameters$1, (long)this.UNK_EMBEDDING())});
            expressionVector = this.transduce((Iterable<Expression>)Predef$.MODULE$.wrapRefArray((Object[])safeCharEmbeddings), rnnBuilder);
        }
        ExpressionVector nonEmptyOuts = expressionVector;
        return nonEmptyOuts.apply(nonEmptyOuts.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private static final ExpressionVector transduceEV$1(Iterable embeddings, RnnBuilder builder) {
        void var2_2;
        builder.newGraph(builder.newGraph$default$1());
        builder.startNewSequence();
        ExpressionVector ev = new ExpressionVector(ExpressionVector$.MODULE$.$lessinit$greater$default$1());
        embeddings.foreach((Function1 & Serializable & scala.Serializable)e -> {
            ev.add(builder.addInput(e));
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    private static final ExpressionVector transduceItr$1(Iterable embeddings, RnnBuilder builder) {
        builder.newGraph(builder.newGraph$default$1());
        builder.startNewSequence();
        Seq expressions = ((TraversableOnce)embeddings.map((Function1 & Serializable & scala.Serializable)x -> builder.addInput(x), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return ExpressionVector$.MODULE$.Seq2ExpressionVector(expressions);
    }

    public static final /* synthetic */ void $anonfun$save$1(PrintWriter printWriter$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        int value = tuple2._2$mcI$sp();
        printWriter$3.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToInteger((int)value)})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$save$2(PrintWriter printWriter$2, Counter values$1, Object key) {
        double value = values$1.getCount(key);
        printWriter$2.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToDouble((double)value)})));
    }

    public static final /* synthetic */ void $anonfun$saveCharMap$1(PrintWriter printWriter$4, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        char key = tuple2._1$mcC$sp();
        int value = tuple2._2$mcI$sp();
        printWriter$4.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)key), BoxesRunTime.boxToInteger((int)value)})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Utils$() {
        MODULE$ = this;
        this.org$clulab$dynet$Utils$$logger = LoggerFactory.getLogger(Utils.class);
        this.concatenateCount = 0;
        this.UNK_WORD = "<UNK>";
        this.EOS_WORD = "<EOS>";
        this.UNK_EMBEDDING = 0;
        this.START_TAG = "<START>";
        this.STOP_TAG = "<STOP>";
        this.RANDOM_SEED = 2522620396L;
        this.WEIGHT_DECAY = 1.0E-5f;
        this.LOG_MIN_VALUE = -10000.0f;
        this.DEFAULT_DROPOUT_PROBABILITY = 0.0f;
        this.IS_DYNET_INITIALIZED = false;
    }
}

