/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.embeddings;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.Serializable;
import org.clulab.embeddings.CompactWordEmbeddingMap;
import org.clulab.utils.ClassLoaderObjectInputStream;
import org.clulab.utils.Closer$;
import org.clulab.utils.Sourcer$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class CompactWordEmbeddingMap$ {
    public static CompactWordEmbeddingMap$ MODULE$;
    private final Logger logger;

    static {
        new CompactWordEmbeddingMap$();
    }

    public Logger logger() {
        return this.logger;
    }

    public CompactWordEmbeddingMap apply(String filename, boolean resource, boolean cached) {
        this.logger().trace("Started to load embedding matrix from file " + filename + "...");
        Tuple2<Map<String, Object>, float[]> buildType = cached ? this.loadBin(filename) : this.loadTxt(filename, resource);
        this.logger().trace("Completed embedding matrix loading.");
        return new CompactWordEmbeddingMap(buildType);
    }

    public boolean apply$default$2() {
        return true;
    }

    public boolean apply$default$3() {
        return false;
    }

    public Tuple2<Map<String, Object>, float[]> loadTxt(String filename, boolean resource) {
        return (Tuple2)Closer$.MODULE$.AutoCloser(resource ? Sourcer$.MODULE$.sourceFromResource(filename) : Sourcer$.MODULE$.sourceFromFile(filename)).autoClose((Function1 & Serializable & scala.Serializable)source -> {
            Iterator lines = source.getLines();
            return MODULE$.buildMatrix((Iterator<String>)lines);
        });
    }

    public Tuple2<Map<String, Object>, float[]> loadBin(String filename) {
        return (Tuple2)Closer$.MODULE$.AutoCloser(new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), new BufferedInputStream(new FileInputStream(filename)))).autoClose((Function1 & Serializable & scala.Serializable)objectInputStream -> {
            HashMap map = new HashMap();
            String text = (String)objectInputStream.readObject();
            StringBuilder stringBuilder = new StringBuilder();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), text.length()).foreach(arg_0 -> CompactWordEmbeddingMap$.$anonfun$loadBin$2$adapted((Map)map, text, stringBuilder, arg_0));
            map.$plus$eq(new Tuple2((Object)stringBuilder.result(), (Object)BoxesRunTime.boxToInteger((int)map.size())));
            float[] array = (float[])objectInputStream.readObject();
            return new Tuple2((Object)map, (Object)array);
        });
    }

    public Tuple2<Map<String, Object>, float[]> buildMatrix(Iterator<String> lines) {
        Tuple2.mcII.sp sp2;
        Tuple2.mcII.sp sp3;
        Iterator linesZipWithIndex = lines.zipWithIndex();
        if (linesZipWithIndex.hasNext()) {
            String[] bits = new StringOps(Predef$.MODULE$.augmentString((String)((Tuple2)linesZipWithIndex.next())._1())).split(' ');
            Predef$.MODULE$.assert(bits.length == 2, (Function0 & Serializable & scala.Serializable)() -> "The first line must specify wordCount and dimension.");
            sp3 = new Tuple2.mcII.sp(new StringOps(Predef$.MODULE$.augmentString(bits[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(bits[1])).toInt());
        } else {
            sp3 = sp2 = new Tuple2.mcII.sp(0, 0);
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int wordCount = sp2._1$mcI$sp();
        int columns = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(wordCount, columns);
        Tuple2.mcII.sp sp5 = sp4;
        int wordCount2 = sp5._1$mcI$sp();
        int columns2 = sp5._2$mcI$sp();
        ObjectRef map = ObjectRef.create((Object)new HashMap());
        float[] array = new float[wordCount2 * columns2];
        linesZipWithIndex.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CompactWordEmbeddingMap$.$anonfun$buildMatrix$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            CompactWordEmbeddingMap$.$anonfun$buildMatrix$3(wordCount2, columns2, map, array, x$6);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(((HashMap)map.elem).size() == wordCount2, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The file should have had ", " words."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((HashMap)map$2.elem).size())})));
        return new Tuple2((Object)((HashMap)map.elem), (Object)array);
    }

    public static final /* synthetic */ Object $anonfun$loadBin$2(Map map$1, String text$1, StringBuilder stringBuilder$1, int i) {
        StringBuilder stringBuilder;
        char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text$1), i);
        if (c == '\n') {
            map$1.$plus$eq(new Tuple2((Object)stringBuilder$1.result(), (Object)BoxesRunTime.boxToInteger((int)map$1.size())));
            stringBuilder$1.clear();
            stringBuilder = BoxedUnit.UNIT;
        } else {
            stringBuilder = stringBuilder$1.append(c);
        }
        return stringBuilder;
    }

    private static final void norm$1(float[] array, int rowIndex, int columns) {
        int i;
        int offset = rowIndex * columns;
        float len = 0.0f;
        for (i = 0; i < columns; ++i) {
            len += array[offset + i] * array[offset + i];
        }
        if ((len = (float)package$.MODULE$.sqrt((double)len)) != 0.0f) {
            for (i = 0; i < columns; ++i) {
                int n = offset + i;
                array[n] = array[n] / len;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildMatrix$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$buildMatrix$3(int wordCount$1, int columns$1, ObjectRef map$2, float[] array$1, Tuple2 x$6) {
        int row;
        Tuple2 tuple2 = x$6;
        if (tuple2 != null) {
            int n;
            String line = (String)tuple2._1();
            int lineIndex = tuple2._2$mcI$sp();
            String[] bits = new StringOps(Predef$.MODULE$.augmentString(line)).split(' ');
            Predef$.MODULE$.assert(bits.length == columns$1 + 1, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " != ", " found on line ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bits.length), BoxesRunTime.boxToInteger((int)(columns$1 + 1)), BoxesRunTime.boxToInteger((int)(lineIndex + 1))})));
            String word = bits[0];
            if (((HashMap)map$2.elem).contains((Object)word)) {
                MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is duplicated in the vector file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word})));
                ((HashMap)map$2.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)(" " + ((HashMap)map$2.elem).size())), (Object)BoxesRunTime.boxToInteger((int)((HashMap)map$2.elem).size())));
                n = BoxesRunTime.unboxToInt((Object)((HashMap)map$2.elem).apply((Object)word));
            } else {
                n = ((HashMap)map$2.elem).size();
            }
            row = n;
            Predef$.MODULE$.assert(row < wordCount$1);
            ((HashMap)map$2.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)word), (Object)BoxesRunTime.boxToInteger((int)row)));
            int offset = row * columns$1;
            for (int i = 0; i < columns$1; ++i) {
                array$1[offset + i] = (float)new StringOps(Predef$.MODULE$.augmentString(bits[i + 1])).toDouble();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        CompactWordEmbeddingMap$.norm$1(array$1, row, columns$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private CompactWordEmbeddingMap$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(CompactWordEmbeddingMap.class);
    }

    public static final /* synthetic */ Object $anonfun$loadBin$2$adapted(Map map$1, String text$1, StringBuilder stringBuilder$1, Object i) {
        return CompactWordEmbeddingMap$.$anonfun$loadBin$2(map$1, text$1, stringBuilder$1, BoxesRunTime.unboxToInt((Object)i));
    }
}

