/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.embeddings;

import java.io.Serializable;
import org.clulab.embeddings.LemmatizeEmbeddings$;
import org.clulab.embeddings.WordEmbeddingMap$;
import org.clulab.processors.clu.tokenizer.EnglishLemmatizer;
import org.clulab.struct.Counter;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u0013\t\u0019B*Z7nCRL'0Z#nE\u0016$G-\u001b8hg*\u00111\u0001B\u0001\u000bK6\u0014W\r\u001a3j]\u001e\u001c(BA\u0003\u0007\u0003\u0019\u0019G.\u001e7bE*\tq!A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0006\u0004%\tAE\u0001\u000eMJ,\u0017/^3oGf4\u0015\u000e\\3\u0016\u0003M\u0001\"\u0001F\u000e\u000f\u0005UI\u0002C\u0001\f\r\u001b\u00059\"B\u0001\r\t\u0003\u0019a$o\\8u}%\u0011!\u0004D\u0001\u0007!J,G-\u001a4\n\u0005qi\"AB*ue&twM\u0003\u0002\u001b\u0019!Aq\u0004\u0001B\u0001B\u0003%1#\u0001\bge\u0016\fX/\u001a8ds\u001aKG.\u001a\u0011\t\u0011\u0005\u0002!Q1A\u0005\u0002I\tQ\"Z7cK\u0012$\u0017N\\4GS2,\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\n\u0002\u001d\u0015l'-\u001a3eS:<g)\u001b7fA!)Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"2aJ\u0015+!\tA\u0003!D\u0001\u0003\u0011\u0015\tB\u00051\u0001\u0014\u0011\u0015\tC\u00051\u0001\u0014\u0011\u001da\u0003A1A\u0005\u00025\n1B\u001a:fcV,gnY5fgV\ta\u0006\u0005\u0003\u0015_M\t\u0014B\u0001\u0019\u001e\u0005\ri\u0015\r\u001d\t\u0003\u0017IJ!a\r\u0007\u0003\r\u0011{WO\u00197f\u0011\u0019)\u0004\u0001)A\u0005]\u0005aaM]3rk\u0016t7-[3tA!9q\u0007\u0001b\u0001\n\u0003A\u0014AD<pe\u0012,UNY3eI&twm]\u000b\u0002sA!AcL\n;!\rY1(M\u0005\u0003y1\u0011Q!\u0011:sCfDaA\u0010\u0001!\u0002\u0013I\u0014aD<pe\u0012,UNY3eI&twm\u001d\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\u00191|\u0017\r\u001a$sKF4\u0015\u000e\\3\u0015\u00039BQa\u0011\u0001\u0005\u0002\u0011\u000ba\u0002\\8bI\u0016k'-\u001a3eS:<7\u000fF\u0001:\u0011\u00151\u0005\u0001\"\u0001E\u0003%aW-\\7bi&TX\rC\u0003I\u0001\u0011\u0005\u0011*\u0001\u0005nk2$\u0018\u000e\u001d7z)\rQUj\u0014\t\u0003\u0017-K!\u0001\u0014\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001d\u001e\u0003\rAO\u0001\u0002m\")\u0001k\u0012a\u0001c\u0005\t1\u000fC\u0003S\u0001\u0011\u00051+\u0001\u0004eSZLG-\u001a\u000b\u0004\u0015R+\u0006\"\u0002(R\u0001\u0004Q\u0004\"\u0002)R\u0001\u0004\t\u0004\"B,\u0001\t\u0003A\u0016aA1eIR!!*W2f\u0011\u0015Qf\u000b1\u0001\\\u0003\u0005)\u0007\u0003\u0002/b'ij\u0011!\u0018\u0006\u0003=~\u000bq!\\;uC\ndWM\u0003\u0002a\u0019\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\tl&a\u0002%bg\"l\u0015\r\u001d\u0005\u0006IZ\u0003\raE\u0001\u0006Y\u0016lW.\u0019\u0005\u0006\u001dZ\u0003\rAO\u0004\u0006O\nA\t\u0001[\u0001\u0014\u0019\u0016lW.\u0019;ju\u0016,UNY3eI&twm\u001d\t\u0003Q%4Q!\u0001\u0002\t\u0002)\u001c\"!\u001b\u0006\t\u000b\u0015JG\u0011\u00017\u0015\u0003!DQA\\5\u0005\u0002=\fA!\\1j]R\u0011!\n\u001d\u0005\u0006c6\u0004\rA]\u0001\u0005CJ<7\u000fE\u0002\fwM\u0001")
public class LemmatizeEmbeddings {
    private final String frequencyFile;
    private final String embeddingFile;
    private final Map<String, Object> frequencies;
    private final Map<String, double[]> wordEmbeddings;

    public static void main(String[] stringArray) {
        LemmatizeEmbeddings$.MODULE$.main(stringArray);
    }

    public String frequencyFile() {
        return this.frequencyFile;
    }

    public String embeddingFile() {
        return this.embeddingFile;
    }

    public Map<String, Object> frequencies() {
        return this.frequencies;
    }

    public Map<String, double[]> wordEmbeddings() {
        return this.wordEmbeddings;
    }

    public Map<String, Object> loadFreqFile() {
        HashMap f = new HashMap();
        Source$.MODULE$.fromFile(this.frequencyFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            String[] toks = line.split("\\s+");
            Predef$.MODULE$.assert(toks.length == 2);
            String word = toks[0];
            double freq = new StringOps(Predef$.MODULE$.augmentString(toks[1])).toDouble();
            return f.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)word), (Object)BoxesRunTime.boxToDouble((double)freq)));
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded frequencies for ", " words."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)f.keySet().size())})));
        return f.toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, double[]> loadEmbeddings() {
        HashMap e = new HashMap();
        Source$.MODULE$.fromFile(this.embeddingFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            String[] toks = line.split("\\s+");
            Predef$.MODULE$.assert(toks.length > 2);
            String word = toks[0];
            double[] vector = new double[toks.length - 1];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), toks.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                vector$1[i - 1] = new StringOps(Predef$.MODULE$.augmentString(toks[i])).toDouble();
            });
            return e.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)word), (Object)vector));
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded embeddings for ", " words."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)e.keySet().size())})));
        return e.toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, double[]> lemmatize() {
        EnglishLemmatizer lemmatizer = new EnglishLemmatizer();
        HashMap ne = new HashMap();
        Counter totalWeights = new Counter();
        int totalUnk = 0;
        this.wordEmbeddings().keySet().foreach((Function1 & Serializable & scala.Serializable)word -> {
            LemmatizeEmbeddings.$anonfun$lemmatize$1(this, lemmatizer, ne, totalWeights, word);
            return BoxedUnit.UNIT;
        });
        ne.keySet().foreach((Function1 & Serializable & scala.Serializable)lemma -> {
            LemmatizeEmbeddings.$anonfun$lemmatize$2(this, ne, totalWeights, lemma);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed ", " words, and found ", " unknown words."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.wordEmbeddings().keySet().size()), BoxesRunTime.boxToInteger((int)totalUnk)})));
        return ne.toMap(Predef$.MODULE$.$conforms());
    }

    public void multiply(double[] v, double s) {
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(v)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            v$1[i] = v[i] * s;
        });
    }

    public void divide(double[] v, double s) {
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(v)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            v$3[i] = v[i] / s;
        });
    }

    public void add(HashMap<String, double[]> e, String lemma, double[] v) {
        if (e.contains((Object)lemma)) {
            double[] ev = (double[])e.apply((Object)lemma);
            Predef$.MODULE$.assert(ev.length == v.length);
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(ev)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                ev$1[i] = ev[i] + v[i];
            });
        } else {
            double[] nv = new double[v.length];
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(v)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                nv$1[i] = v[i];
            });
            e.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)lemma), (Object)nv));
        }
    }

    public static final /* synthetic */ void $anonfun$lemmatize$1(LemmatizeEmbeddings $this, EnglishLemmatizer lemmatizer$1, HashMap ne$1, Counter totalWeights$1, String word) {
        String lemma = lemmatizer$1.lemmatizeWord(word, lemmatizer$1.lemmatizeWord$default$2());
        String lowerCaseWord = word.toLowerCase();
        double[] vector = (double[])$this.wordEmbeddings().apply((Object)word);
        if ($this.frequencies().contains((Object)lowerCaseWord)) {
            double weight = BoxesRunTime.unboxToDouble((Object)$this.frequencies().apply((Object)lowerCaseWord));
            $this.multiply(vector, weight);
            totalWeights$1.incrementCount(lemma, weight);
            $this.add((HashMap<String, double[]>)ne$1, lemma, vector);
        } else {
            totalWeights$1.incrementCount(WordEmbeddingMap$.MODULE$.UNK(), totalWeights$1.incrementCount$default$2());
            $this.add((HashMap<String, double[]>)ne$1, WordEmbeddingMap$.MODULE$.UNK(), vector);
        }
    }

    public static final /* synthetic */ void $anonfun$lemmatize$2(LemmatizeEmbeddings $this, HashMap ne$1, Counter totalWeights$1, String lemma) {
        double totalWeight = totalWeights$1.getCount(lemma);
        double[] vector = (double[])ne$1.apply((Object)lemma);
        $this.divide(vector, totalWeight);
    }

    public LemmatizeEmbeddings(String frequencyFile, String embeddingFile) {
        this.frequencyFile = frequencyFile;
        this.embeddingFile = embeddingFile;
        this.frequencies = this.loadFreqFile();
        this.wordEmbeddings = this.loadEmbeddings();
    }
}

