/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.embeddings;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.clulab.embeddings.EmbeddingUtils$;
import org.clulab.embeddings.WordEmbeddingMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.io.BufferedSource;
import scala.io.Source;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class WordEmbeddingMap$ {
    public static WordEmbeddingMap$ MODULE$;
    private final Logger logger;
    private final String UNK;

    static {
        new WordEmbeddingMap$();
    }

    public Option<Set<String>> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$3() {
        return false;
    }

    public Logger logger() {
        return this.logger;
    }

    public String UNK() {
        return this.UNK;
    }

    public String sanitizeWord(String uw, boolean keepNumbers) {
        return EmbeddingUtils$.MODULE$.sanitizeWord(uw, keepNumbers);
    }

    public boolean sanitizeWord$default$2() {
        return true;
    }

    public boolean isNumber(String w) {
        return EmbeddingUtils$.MODULE$.isNumber(w);
    }

    public void norm(double[] weights) {
        int i;
        double len = 0.0;
        for (i = 0; i < weights.length; ++i) {
            len += weights[i] * weights[i];
        }
        len = package$.MODULE$.sqrt(len);
        i = 0;
        if (len != 0.0) {
            while (i < weights.length) {
                int n = i++;
                weights[n] = weights[n] / len;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public double dotProduct(double[] v1, double[] v2) {
        void var3_3;
        Predef$.MODULE$.assert(v1.length == v2.length);
        double sum = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            sum += v1[i] * v2[i];
        }
        return (double)var3_3;
    }

    public Tuple2<Map<String, double[]>, Object> org$clulab$embeddings$WordEmbeddingMap$$loadMatrix(String mf, Option<Set<String>> wordsToUse, boolean caseInsensitiveWordsToUse) {
        this.logger().debug("Started to load embedding matrix from file " + mf + "...");
        BufferedSource src = Source$.MODULE$.fromFile(mf, "iso-8859-1");
        Iterator lines = src.getLines();
        Tuple2<Map<String, double[]>, Object> matrix = this.buildMatrix((Iterator<String>)lines, wordsToUse, caseInsensitiveWordsToUse);
        src.close();
        this.logger().debug("Completed matrix loading.");
        return matrix;
    }

    public Tuple2<Map<String, double[]>, Object> org$clulab$embeddings$WordEmbeddingMap$$loadMatrixFromStream(InputStream is, Option<Set<String>> wordsToUse, boolean caseInsensitiveWordsToUse) {
        this.logger().debug("Started to load embedding matrix from stream ...");
        BufferedSource src = Source$.MODULE$.fromInputStream(is, "iso-8859-1");
        Iterator lines = src.getLines();
        Tuple2<Map<String, double[]>, Object> matrix = this.buildMatrix((Iterator<String>)lines, wordsToUse, caseInsensitiveWordsToUse);
        src.close();
        this.logger().debug("Completed matrix loading.");
        return matrix;
    }

    public Tuple2<Map<String, double[]>, Object> org$clulab$embeddings$WordEmbeddingMap$$loadMatrixFromSource(Source src, Option<Set<String>> wordsToUse, boolean caseInsensitiveWordsToUse) {
        this.logger().debug("Started to load embedding matrix from source ...");
        Iterator lines = src.getLines();
        Tuple2<Map<String, double[]>, Object> matrix = this.buildMatrix((Iterator<String>)lines, wordsToUse, caseInsensitiveWordsToUse);
        this.logger().debug("Completed matrix loading.");
        return matrix;
    }

    private Tuple2<Map<String, double[]>, Object> buildMatrix(Iterator<String> lines, Option<Set<String>> wordsToUse, boolean caseInsensitiveWordsToUse) {
        HashMap m = new HashMap();
        BooleanRef first = BooleanRef.create((boolean)true);
        IntRef dims = IntRef.create((int)0);
        IntRef total = IntRef.create((int)0);
        IntRef kept = IntRef.create((int)0);
        lines.zipWithIndex().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)WordEmbeddingMap$.$anonfun$buildMatrix$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$22 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x$22;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                ++total$1.elem;
                String[] bits = line.split("\\s+");
                if (first$1.elem) {
                    dims$1.elem = new StringOps(Predef$.MODULE$.augmentString(bits[1])).toInt();
                    first$1.elem = false;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (bits.length != dims$1.elem + 1) {
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " != ", " found on line ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bits.length), BoxesRunTime.boxToInteger((int)(dims$1.elem + 1)), BoxesRunTime.boxToInteger((int)(index + 1))})));
                    }
                    Predef$.MODULE$.assert(bits.length == dims$1.elem + 1);
                    String w = bits[0];
                    if (wordsToUse.isEmpty() || ((SetLike)wordsToUse.get()).contains((Object)(caseInsensitiveWordsToUse ? w.toLowerCase() : w))) {
                        ++kept$1.elem;
                        double[] weights = new double[dims$1.elem];
                        for (int i = 0; i < dims$1.elem; ++i) {
                            weights[i] = new StringOps(Predef$.MODULE$.augmentString(bits[i + 1])).toDouble();
                        }
                        MODULE$.norm(weights);
                        boxedUnit = m.put((Object)w, (Object)weights);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed matrix loading. Kept ", " words out of a total of ", " words."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)kept.elem), BoxesRunTime.boxToInteger((int)total.elem)})));
        return new Tuple2((Object)m.toMap(Predef$.MODULE$.$conforms()), (Object)BoxesRunTime.boxToInteger((int)dims.elem));
    }

    public WordEmbeddingMap fromBinary(String filename) {
        return this.fromBinary(new File(filename));
    }

    public WordEmbeddingMap fromBinary(File file) {
        return new WordEmbeddingMap((Function0<Map<String, double[]>>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.readBinaryMatrix(FileUtils.readFileToByteArray((File)file)));
    }

    public WordEmbeddingMap fromBinary(InputStream inputStream) {
        return new WordEmbeddingMap((Function0<Map<String, double[]>>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.readBinaryMatrix(IOUtils.toByteArray((InputStream)inputStream)));
    }

    public WordEmbeddingMap fromBinary(byte[] bytes) {
        return new WordEmbeddingMap((Function0<Map<String, double[]>>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.readBinaryMatrix(bytes));
    }

    private String readNonSpace(ByteBuffer bb) {
        ArrayBuffer buffer = new ArrayBuffer();
        byte by = bb.get();
        while (by != (byte)32 && by != (byte)10) {
            buffer.$plus$eq((Object)BoxesRunTime.boxToByte((byte)by));
            by = bb.get();
        }
        return new String((byte[])buffer.toArray(ClassTag$.MODULE$.Byte()));
    }

    private Map<String, double[]> readBinaryMatrix(byte[] bytes) {
        HashMap m = new HashMap();
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.nativeOrder());
        long words = new StringOps(Predef$.MODULE$.augmentString(this.readNonSpace(bb))).toLong();
        long size = new StringOps(Predef$.MODULE$.augmentString(this.readNonSpace(bb))).toLong();
        byte by = bb.get();
        while (by == (byte)32 || by == (byte)10) {
            by = bb.get();
        }
        bb.position(bb.position() - 1);
        long w = 0L;
        while (w < words) {
            Object object;
            ++w;
            String word = this.readNonSpace(bb);
            double[] embedding = new double[(int)size];
            int s = 0;
            while ((long)s < size) {
                embedding[s] = bb.getFloat();
                ++s;
            }
            this.norm(embedding);
            m.put((Object)word, (Object)embedding);
            if (bb.hasRemaining()) {
                by = bb.get();
                while (by == (byte)32 || by == (byte)10) {
                    by = bb.get();
                }
                object = bb.position(bb.position() - 1);
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return m.toMap(Predef$.MODULE$.$conforms());
    }

    public void main(String[] args) {
        WordEmbeddingMap w2v = new WordEmbeddingMap(args[0], (Option<Set<String>>)None$.MODULE$, this.$lessinit$greater$default$3());
        Predef$.MODULE$.println((Object)"Words most similar to \"house\":");
        w2v.mostSimilarWords((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"house"}))), 40).foreach((Function1 & Serializable & scala.Serializable)t -> {
            Predef$.MODULE$.println((Object)((String)t._1() + " " + t._2$mcD$sp()));
            return BoxedUnit.UNIT;
        });
        List t1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "delicious", "apple"}));
        List t2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the", "tasty", "pear"}));
        List t3 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"computer", "oxygen"}));
        Predef$.MODULE$.println((Object)("Text similarity: " + w2v.sanitizedTextSimilarity((Iterable<String>)t1, (Iterable<String>)t2)));
        Predef$.MODULE$.println((Object)("Text similarity: " + w2v.sanitizedTextSimilarity((Iterable<String>)t1, (Iterable<String>)t3)));
        Predef$.MODULE$.println((Object)("Max similarity: " + w2v.sanitizedMaxSimilarity((Iterable<String>)t1, (Iterable<String>)t2)));
        Predef$.MODULE$.println((Object)("Avg similarity: " + w2v.sanitizedAvgSimilarity((Iterable<String>)t1, (Iterable<String>)t2)));
    }

    public static final /* synthetic */ boolean $anonfun$buildMatrix$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    private WordEmbeddingMap$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(WordEmbeddingMap.class);
        this.UNK = "*UNK*";
    }
}

