/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.learning;

import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import org.clulab.learning.Datum;
import org.clulab.learning.RVFDatum;
import org.clulab.learning.RVFRankingDataset;
import org.clulab.struct.Counter;
import org.clulab.struct.Lexicon;
import org.clulab.utils.Files$;
import org.clulab.utils.Serializer$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class RVFRankingDataset$ {
    public static RVFRankingDataset$ MODULE$;
    private final Logger logger;

    static {
        new RVFRankingDataset$();
    }

    public Logger logger() {
        return this.logger;
    }

    public RVFRankingDataset<String> mkDatasetFromSvmRankResource(String path) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        BufferedSource source = path.endsWith(".gz") ? Source$.MODULE$.fromInputStream((InputStream)new GZIPInputStream(stream), Codec$.MODULE$.fallbackSystemCodec()) : Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec());
        return this.mkDatasetFromSvmRankFormat(source);
    }

    public RVFRankingDataset<String> mkDatasetFromSvmRankFormat(String filename) {
        BufferedSource bufferedSource;
        if (filename.endsWith(".gz")) {
            GZIPInputStream stream = Files$.MODULE$.newGZIPInputStream(filename);
            bufferedSource = Source$.MODULE$.fromInputStream((InputStream)stream, Codec$.MODULE$.fallbackSystemCodec());
        } else {
            bufferedSource = Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec());
        }
        BufferedSource source = bufferedSource;
        return this.mkDatasetFromSvmRankFormat(source);
    }

    /*
     * WARNING - void declaration
     */
    public RVFRankingDataset<String> mkDatasetFromSvmRankFormat(BufferedSource source) {
        void var2_2;
        RVFRankingDataset dataset = new RVFRankingDataset();
        ObjectRef crtQid = ObjectRef.create((Object)"");
        ObjectRef crtBlock = ObjectRef.create(null);
        IntRef blockCount = IntRef.create((int)0);
        IntRef datumCount = IntRef.create((int)0);
        source.getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            ArrayBuffer arrayBuffer;
            int pound = line.indexOf("#");
            String content = line;
            if (pound > 0) {
                content = line.substring(0, pound);
            }
            String[] bits = content.split("\\s+");
            int label = new StringOps(Predef$.MODULE$.augmentString(bits[0])).toInt();
            Predef$.MODULE$.assert(bits[1].startsWith("qid:") && bits[1].length() > 4);
            String qid = bits[1].substring(4);
            Counter features = new Counter();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), bits.length).foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
                String[] fbits = bits[i].split(":");
                if (fbits.length != 2) {
                    throw new RuntimeException("ERROR: invalid feature format: " + bits[i]);
                }
                String f = fbits[0];
                double v = new StringOps(Predef$.MODULE$.augmentString(fbits[1])).toDouble();
                return features.incrementCount(f, v);
            });
            RVFDatum datum = new RVFDatum(BoxesRunTime.boxToInteger((int)label), features);
            ++datumCount$1.elem;
            String string = qid;
            String string2 = (String)crtQid$1.elem;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                arrayBuffer = ((ArrayBuffer)crtBlock$1.elem).$plus$eq(datum);
            } else {
                Predef$.MODULE$.assert((ArrayBuffer)crtBlock$1.elem == null || ((ArrayBuffer)crtBlock$1.elem).size() > 0);
                if ((ArrayBuffer)crtBlock$1.elem != null) {
                    dataset.$plus$eq((ArrayBuffer)crtBlock$1.elem);
                    ++blockCount$1.elem;
                }
                crtBlock$1.elem = new ArrayBuffer();
                crtQid$1.elem = qid;
                arrayBuffer = ((ArrayBuffer)crtBlock$1.elem).$plus$eq(datum);
            }
            return arrayBuffer;
        });
        if (((ArrayBuffer)crtBlock.elem).size() > 0) {
            dataset.$plus$eq((ArrayBuffer)crtBlock.elem);
            ++blockCount.elem;
        }
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded ", " blocks with ", " datums."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blockCount.elem), BoxesRunTime.boxToInteger((int)datumCount.elem)})));
        return var2_2;
    }

    public Iterable<Iterable<Datum<Object, String>>> mkDatumsFromSvmRankResource(String path) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        BufferedSource source = path.endsWith(".gz") ? Source$.MODULE$.fromInputStream((InputStream)new GZIPInputStream(stream), Codec$.MODULE$.fallbackSystemCodec()) : Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec());
        return this.mkDatumsFromSvmRankFormat(source);
    }

    public Iterable<Iterable<Datum<Object, String>>> mkDatumsFromSvmRankFormat(String filename) {
        BufferedSource bufferedSource;
        if (filename.endsWith(".gz")) {
            GZIPInputStream stream = Files$.MODULE$.newGZIPInputStream(filename);
            bufferedSource = Source$.MODULE$.fromInputStream((InputStream)stream, Codec$.MODULE$.fallbackSystemCodec());
        } else {
            bufferedSource = Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec());
        }
        BufferedSource source = bufferedSource;
        return this.mkDatumsFromSvmRankFormat(source);
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Iterable<Datum<Object, String>>> mkDatumsFromSvmRankFormat(BufferedSource source) {
        void var2_2;
        ArrayBuffer queries = new ArrayBuffer();
        ObjectRef crtQid = ObjectRef.create((Object)"");
        ObjectRef crtBlock = ObjectRef.create(null);
        IntRef blockCount = IntRef.create((int)0);
        IntRef datumCount = IntRef.create((int)0);
        source.getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            ArrayBuffer arrayBuffer;
            int pound = line.indexOf("#");
            String content = line;
            if (pound > 0) {
                content = line.substring(0, pound);
            }
            String[] bits = content.split("\\s+");
            int label = new StringOps(Predef$.MODULE$.augmentString(bits[0])).toInt();
            Predef$.MODULE$.assert(bits[1].startsWith("qid:") && bits[1].length() > 4);
            String qid = bits[1].substring(4);
            Counter features = new Counter();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), bits.length).foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
                String[] fbits = bits[i].split(":");
                if (fbits.length != 2) {
                    throw new RuntimeException("ERROR: invalid feature format: " + bits[i]);
                }
                String f = fbits[0];
                double v = new StringOps(Predef$.MODULE$.augmentString(fbits[1])).toDouble();
                return features.incrementCount(f, v);
            });
            RVFDatum datum = new RVFDatum(BoxesRunTime.boxToInteger((int)label), features);
            ++datumCount$2.elem;
            String string = qid;
            String string2 = (String)crtQid$2.elem;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                arrayBuffer = ((ArrayBuffer)crtBlock$2.elem).$plus$eq(datum);
            } else {
                Predef$.MODULE$.assert((ArrayBuffer)crtBlock$2.elem == null || ((ArrayBuffer)crtBlock$2.elem).size() > 0);
                if ((ArrayBuffer)crtBlock$2.elem != null) {
                    queries.$plus$eq((Object)((ArrayBuffer)crtBlock$2.elem));
                    ++blockCount$2.elem;
                }
                crtBlock$2.elem = new ArrayBuffer();
                crtQid$2.elem = qid;
                arrayBuffer = ((ArrayBuffer)crtBlock$2.elem).$plus$eq(datum);
            }
            return arrayBuffer;
        });
        if (((ArrayBuffer)crtBlock.elem).size() > 0) {
            queries.$plus$eq((Object)((ArrayBuffer)crtBlock.elem));
            ++blockCount.elem;
        }
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded ", " blocks with ", " datums."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blockCount.elem), BoxesRunTime.boxToInteger((int)datumCount.elem)})));
        return var2_2;
    }

    public void saveToSvmRankFormat(Iterable<Iterable<Datum<Object, String>>> queries, Lexicon<String> featureLexicon, String fn) {
        IntRef qid = IntRef.create((int)0);
        PrintWriter os = new PrintWriter(new FileWriter(fn));
        queries.foreach((Function1 & Serializable & scala.Serializable)query -> {
            RVFRankingDataset$.$anonfun$saveToSvmRankFormat$1(featureLexicon, qid, os, query);
            return BoxedUnit.UNIT;
        });
        os.close();
    }

    public <F> RVFRankingDataset<F> loadFrom(String fileName) {
        return (RVFRankingDataset)Serializer$.MODULE$.load(fileName);
    }

    public static final /* synthetic */ void $anonfun$saveToSvmRankFormat$2(Lexicon featureLexicon$1, IntRef qid$1, PrintWriter os$1, Datum datum) {
        os$1.print(BoxesRunTime.unboxToInt(datum.label()));
        os$1.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" qid:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)qid$1.elem)})));
        ListBuffer fs = new ListBuffer();
        Counter c = datum.featuresCounter();
        c.keySet().foreach((Function1 & Serializable & scala.Serializable)k -> {
            Option<Object> fi = featureLexicon$1.get(k);
            return fi.isDefined() ? fs.$plus$eq((Object)new Tuple2.mcID.sp(BoxesRunTime.unboxToInt((Object)fi.get()) + 1, c.getCount(k))) : BoxedUnit.UNIT;
        });
        List fss = (List)fs.toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
        fss.foreach((Function1 & Serializable & scala.Serializable)t -> {
            os$1.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t._1$mcI$sp()), BoxesRunTime.boxToDouble((double)t._2$mcD$sp())})));
            return BoxedUnit.UNIT;
        });
        os$1.println();
    }

    public static final /* synthetic */ void $anonfun$saveToSvmRankFormat$1(Lexicon featureLexicon$1, IntRef qid$1, PrintWriter os$1, Iterable query) {
        ++qid$1.elem;
        query.foreach((Function1 & Serializable & scala.Serializable)datum -> {
            RVFRankingDataset$.$anonfun$saveToSvmRankFormat$2(featureLexicon$1, qid$1, os$1, datum);
            return BoxedUnit.UNIT;
        });
    }

    private RVFRankingDataset$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(RVFRankingDataset.class);
    }
}

