/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.learning;

import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import org.clulab.learning.Datum;
import org.clulab.learning.RVFDatum;
import org.clulab.learning.RVFRegDataset;
import org.clulab.struct.Counter;
import org.clulab.struct.Lexicon;
import org.clulab.utils.Files$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class RVFRegDataset$
implements scala.Serializable {
    public static RVFRegDataset$ MODULE$;
    private final Logger logger;

    static {
        new RVFRegDataset$();
    }

    public Logger logger() {
        return this.logger;
    }

    public RVFRegDataset<String> mkRegDatasetFromSvmLightResource(String path) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        BufferedSource source = path.endsWith(".gz") ? Source$.MODULE$.fromInputStream((InputStream)new GZIPInputStream(stream), Codec$.MODULE$.fallbackSystemCodec()) : Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec());
        return this.mkRegDatasetFromSvmLightFormat(source);
    }

    public RVFRegDataset<String> mkRegDatasetFromSvmLightFormat(String filename) {
        BufferedSource bufferedSource;
        if (filename.endsWith(".gz")) {
            GZIPInputStream stream = Files$.MODULE$.newGZIPInputStream(filename);
            bufferedSource = Source$.MODULE$.fromInputStream((InputStream)stream, Codec$.MODULE$.fallbackSystemCodec());
        } else {
            bufferedSource = Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec());
        }
        BufferedSource source = bufferedSource;
        return this.mkRegDatasetFromSvmLightFormat(source);
    }

    /*
     * WARNING - void declaration
     */
    public RVFRegDataset<String> mkRegDatasetFromSvmLightFormat(BufferedSource source) {
        void var2_2;
        RVFRegDataset dataset = new RVFRegDataset();
        IntRef datumCount = IntRef.create((int)0);
        source.getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            RVFRegDataset$.$anonfun$mkRegDatasetFromSvmLightFormat$1(dataset, datumCount, line);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public void saveToSvmLightFormat(Iterable<Datum<Object, String>> datums, Lexicon<String> featureLexicon, String fn) {
        PrintWriter os = new PrintWriter(new FileWriter(fn));
        datums.foreach((Function1 & Serializable & scala.Serializable)datum -> {
            RVFRegDataset$.$anonfun$saveToSvmLightFormat$1(featureLexicon, os, datum);
            return BoxedUnit.UNIT;
        });
        os.close();
    }

    public Iterable<Datum<Object, String>> mkDatumsFromSvmLightResource(String path) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        BufferedSource source = path.endsWith(".gz") ? Source$.MODULE$.fromInputStream((InputStream)new GZIPInputStream(stream), Codec$.MODULE$.fallbackSystemCodec()) : Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec());
        return this.mkDatumsFromSvmLightFormat(source);
    }

    public Iterable<Datum<Object, String>> mkDatumsFromSvmLightFormat(String filename) {
        BufferedSource bufferedSource;
        if (filename.endsWith(".gz")) {
            GZIPInputStream stream = Files$.MODULE$.newGZIPInputStream(filename);
            bufferedSource = Source$.MODULE$.fromInputStream((InputStream)stream, Codec$.MODULE$.fallbackSystemCodec());
        } else {
            bufferedSource = Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec());
        }
        BufferedSource source = bufferedSource;
        return this.mkDatumsFromSvmLightFormat(source);
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Datum<Object, String>> mkDatumsFromSvmLightFormat(BufferedSource source) {
        void var2_2;
        ArrayBuffer datums = new ArrayBuffer();
        IntRef datumCount = IntRef.create((int)0);
        source.getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            RVFRegDataset$.$anonfun$mkDatumsFromSvmLightFormat$1(datums, datumCount, line);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$mkRegDatasetFromSvmLightFormat$1(RVFRegDataset dataset$1, IntRef datumCount$1, String line) {
        block2: {
            int pound = line.indexOf("#");
            String content = line;
            if (pound >= 0) {
                content = line.substring(0, pound);
            }
            if ((content = content.trim()).length() <= 0) break block2;
            String[] bits = content.split("\\s+");
            String label = bits[0];
            if (label.startsWith("+")) {
                label = label.substring(1);
            }
            Counter features = new Counter();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), bits.length).foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
                String[] fbits = bits[i].split(":");
                if (fbits.length != 2) {
                    throw new RuntimeException("ERROR: invalid feature format: " + bits[i]);
                }
                String f = fbits[0];
                double v = new StringOps(Predef$.MODULE$.augmentString(fbits[1])).toDouble();
                return features.incrementCount(f, v);
            });
            RVFDatum datum = new RVFDatum(BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(label)).toDouble()), features);
            dataset$1.$plus$eq(datum);
            ++datumCount$1.elem;
        }
    }

    public static final /* synthetic */ void $anonfun$saveToSvmLightFormat$1(Lexicon featureLexicon$1, PrintWriter os$1, Datum datum) {
        os$1.print(BoxesRunTime.unboxToDouble(datum.label()));
        ListBuffer fs = new ListBuffer();
        Counter c = datum.featuresCounter();
        c.keySet().foreach((Function1 & Serializable & scala.Serializable)k -> {
            Option<Object> fi = featureLexicon$1.get(k);
            return fi.isDefined() ? fs.$plus$eq((Object)new Tuple2.mcID.sp(BoxesRunTime.unboxToInt((Object)fi.get()) + 1, c.getCount(k))) : BoxedUnit.UNIT;
        });
        List fss = (List)fs.toList().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
        fss.foreach((Function1 & Serializable & scala.Serializable)t -> {
            os$1.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t._1$mcI$sp()), BoxesRunTime.boxToDouble((double)t._2$mcD$sp())})));
            return BoxedUnit.UNIT;
        });
        os$1.println();
    }

    public static final /* synthetic */ void $anonfun$mkDatumsFromSvmLightFormat$1(ArrayBuffer datums$1, IntRef datumCount$2, String line) {
        block2: {
            int pound = line.indexOf("#");
            String content = line;
            if (pound >= 0) {
                content = line.substring(0, pound);
            }
            if ((content = content.trim()).length() <= 0) break block2;
            String[] bits = content.split("\\s+");
            String label = bits[0];
            if (label.startsWith("+")) {
                label = label.substring(1);
            }
            Counter features = new Counter();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), bits.length).foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
                String[] fbits = bits[i].split(":");
                if (fbits.length != 2) {
                    throw new RuntimeException("ERROR: invalid feature format: " + bits[i]);
                }
                String f = fbits[0];
                double v = new StringOps(Predef$.MODULE$.augmentString(fbits[1])).toDouble();
                return features.incrementCount(f, v);
            });
            RVFDatum datum = new RVFDatum(BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(label)).toDouble()), features);
            datums$1.$plus$eq(datum);
            ++datumCount$2.elem;
        }
    }

    private RVFRegDataset$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

