/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.learning;

import java.io.Serializable;
import org.clulab.learning.Answer;
import org.clulab.learning.Datum;
import org.clulab.learning.Qid;
import scala.Double$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class RankerEvaluator$ {
    public static RankerEvaluator$ MODULE$;

    static {
        new RankerEvaluator$();
    }

    public void main(String[] args) {
        if (args.length != 2) {
            Predef$.MODULE$.println((Object)"Usage: org.clulab.qa.EvalSVMRank <gold> <predictions>");
            System.exit(1);
        }
        String goldFile = args[0];
        String outputFile = args[1];
        this.scoreSVMRank(goldFile, outputFile);
    }

    public double scoreSVMRank(String goldFile, String outputFile) {
        ObjectRef scoresBuffer = ObjectRef.create((Object)new ArrayBuffer());
        Source$.MODULE$.fromFile(outputFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            String[] bits = line.split("\\s+");
            return ((ArrayBuffer)scoresBuffer$1.elem).$plus$eq((Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(bits[0])).toDouble()));
        });
        ObjectRef scores = ObjectRef.create((Object)((double[])((ArrayBuffer)scoresBuffer.elem).toArray(ClassTag$.MODULE$.Double())));
        ObjectRef crtQid = ObjectRef.create((Object)"");
        ArrayBuffer qidsBuffer = new ArrayBuffer();
        ObjectRef answers = ObjectRef.create((Object)new ArrayBuffer());
        IntRef offset = IntRef.create((int)0);
        Source$.MODULE$.fromFile(goldFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            RankerEvaluator$.$anonfun$scoreSVMRank$2(scores, crtQid, qidsBuffer, answers, offset, line);
            return BoxedUnit.UNIT;
        });
        String string = (String)crtQid.elem;
        String string2 = "";
        Object object = (string == null ? string2 != null : !string.equals(string2)) ? qidsBuffer.$plus$eq((Object)new Qid((Answer[])((ArrayBuffer)answers.elem).toArray(ClassTag$.MODULE$.apply(Answer.class)))) : BoxedUnit.UNIT;
        Qid[] qids = (Qid[])qidsBuffer.toArray(ClassTag$.MODULE$.apply(Qid.class));
        Predef$.MODULE$.println((Object)("Found " + qids.length + " questions."));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qids)).foreach((Function1 & Serializable & scala.Serializable)qid -> {
            RankerEvaluator$.$anonfun$scoreSVMRank$3(qid);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"Baseline scores:");
        this.score(qids);
        Qid[] sortedQids = new Qid[qids.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), qids.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            sortedQids$1[i] = new Qid((Answer[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qids[i].answers())).toList().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)RankerEvaluator$.$anonfun$scoreSVMRank$6(x$1)), (Ordering)Ordering.Double$.MODULE$)).toArray(ClassTag$.MODULE$.apply(Answer.class)));
        });
        Predef$.MODULE$.println((Object)"System scores:");
        return this.score(sortedQids);
    }

    public double maxGold(Answer[] answers) {
        DoubleRef max = DoubleRef.create((double)Double$.MODULE$.MinValue());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])answers)).foreach((Function1 & Serializable & scala.Serializable)a -> {
            RankerEvaluator$.$anonfun$maxGold$1(max, a);
            return BoxedUnit.UNIT;
        });
        return max.elem;
    }

    public double score(Qid[] qids) {
        IntRef correct = IntRef.create((int)0);
        IntRef total = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qids)).foreach((Function1 & Serializable & scala.Serializable)qid -> {
            RankerEvaluator$.$anonfun$score$1(correct, total, qid);
            return BoxedUnit.UNIT;
        });
        double p = (double)correct.elem / (double)total.elem;
        Predef$.MODULE$.println((Object)("P@1: " + p));
        return p;
    }

    public <F> double score(Iterable<Iterable<Datum<Object, F>>> queries, double[][] scores) {
        double total = queries.size();
        IntRef correct = IntRef.create((int)0);
        IntRef qi = IntRef.create((int)0);
        queries.foreach((Function1 & Serializable & scala.Serializable)query -> {
            RankerEvaluator$.$anonfun$score$2(scores, correct, qi, query);
            return BoxedUnit.UNIT;
        });
        double p = (double)correct.elem / total;
        return p;
    }

    public static final /* synthetic */ void $anonfun$scoreSVMRank$2(ObjectRef scores$1, ObjectRef crtQid$1, ArrayBuffer qidsBuffer$1, ObjectRef answers$1, IntRef offset$1, String line) {
        String qid;
        String[] bits = line.split("\\s+");
        String gold = bits[0];
        String string = qid = bits[1];
        String string2 = (String)crtQid$1.elem;
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = (String)crtQid$1.elem;
            String string4 = "";
            Object object = (string3 == null ? string4 != null : !string3.equals(string4)) ? qidsBuffer$1.$plus$eq((Object)new Qid((Answer[])((ArrayBuffer)answers$1.elem).toArray(ClassTag$.MODULE$.apply(Answer.class)))) : BoxedUnit.UNIT;
            crtQid$1.elem = qid;
            answers$1.elem = new ArrayBuffer();
        }
        ((ArrayBuffer)answers$1.elem).$plus$eq((Object)new Answer(new StringOps(Predef$.MODULE$.augmentString(gold)).toDouble(), ((double[])scores$1.elem)[offset$1.elem]));
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$scoreSVMRank$3(Qid qid) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qid.answers())).foreach((Function1 & Serializable & scala.Serializable)a -> {
            Predef$.MODULE$.println((Object)(a.gold() + " " + a.score()));
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ double $anonfun$scoreSVMRank$6(Answer x$1) {
        return 0.0 - x$1.score();
    }

    public static final /* synthetic */ void $anonfun$maxGold$1(DoubleRef max$1, Answer a) {
        block0: {
            if (!(a.gold() > max$1.elem)) break block0;
            max$1.elem = a.gold();
        }
    }

    public static final /* synthetic */ void $anonfun$score$1(IntRef correct$1, IntRef total$1, Qid qid) {
        if (qid.answers()[0].gold() == MODULE$.maxGold(qid.answers())) {
            ++correct$1.elem;
        }
        ++total$1.elem;
    }

    public static final /* synthetic */ void $anonfun$score$3(double[][] scores$2, IntRef qi$1, DoubleRef bestScore$1, IntRef bestLabel$1, IntRef i$1, Datum d) {
        if (scores$2[qi$1.elem][i$1.elem] > bestScore$1.elem) {
            bestScore$1.elem = scores$2[qi$1.elem][i$1.elem];
            bestLabel$1.elem = BoxesRunTime.unboxToInt(d.label());
        }
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$score$4(IntRef maxGold$1, Datum d) {
        block0: {
            if (BoxesRunTime.unboxToInt(d.label()) <= maxGold$1.elem) break block0;
            maxGold$1.elem = BoxesRunTime.unboxToInt(d.label());
        }
    }

    public static final /* synthetic */ void $anonfun$score$2(double[][] scores$2, IntRef correct$2, IntRef qi$1, Iterable query) {
        DoubleRef bestScore = DoubleRef.create((double)Double$.MODULE$.MinValue());
        IntRef bestLabel = IntRef.create((int)-1);
        IntRef i = IntRef.create((int)0);
        query.foreach((Function1 & Serializable & scala.Serializable)d -> {
            RankerEvaluator$.$anonfun$score$3(scores$2, qi$1, bestScore, bestLabel, i, d);
            return BoxedUnit.UNIT;
        });
        IntRef maxGold = IntRef.create((int)Integer.MIN_VALUE);
        query.foreach((Function1 & Serializable & scala.Serializable)d -> {
            RankerEvaluator$.$anonfun$score$4(maxGold, d);
            return BoxedUnit.UNIT;
        });
        if (bestLabel.elem == maxGold.elem) {
            ++correct$2.elem;
        }
        ++qi$1.elem;
    }

    private RankerEvaluator$() {
        MODULE$ = this;
    }
}

