/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.learning;

import java.io.Serializable;
import java.util.Properties;
import org.clulab.learning.DatasetFold;
import org.clulab.learning.Datasets$;
import org.clulab.learning.Datum;
import org.clulab.learning.PerceptronRankingClassifier;
import org.clulab.learning.RankingClassifier;
import org.clulab.learning.RankingDataset;
import org.clulab.learning.SVMRankingClassifier;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class RankingClassifier$ {
    public static RankingClassifier$ MODULE$;

    static {
        new RankingClassifier$();
    }

    public <F> double[][] crossValidate(RankingDataset<F> dataset, Properties classifierProperties, int numFolds, boolean generateProbabilities, double softmaxGamma) {
        Iterable<DatasetFold> folds = Datasets$.MODULE$.mkFolds(numFolds, dataset.size());
        double[][] scores = new double[dataset.size()][];
        IntRef foldOffset = IntRef.create((int)1);
        folds.foreach((Function1 & Serializable & scala.Serializable)fold -> {
            RankingClassifier$.$anonfun$crossValidate$1(dataset, classifierProperties, generateProbabilities, softmaxGamma, scores, foldOffset, fold);
            return BoxedUnit.UNIT;
        });
        return scores;
    }

    public <F> int crossValidate$default$3() {
        return 10;
    }

    public <F> boolean crossValidate$default$4() {
        return false;
    }

    public <F> double crossValidate$default$5() {
        return 1.0;
    }

    public <F> RankingClassifier<F> apply(Properties properties) {
        RankingClassifier rankingClassifier;
        if (!properties.containsKey("classifierClass")) {
            return new SVMRankingClassifier(properties);
        }
        String string = properties.getProperty("classifierClass");
        if ("SVMRankingClassifier".equals(string)) {
            rankingClassifier = new SVMRankingClassifier(properties);
        } else if ("PerceptronRankingClassifier".equals(string)) {
            rankingClassifier = new PerceptronRankingClassifier(properties);
        } else {
            throw new RuntimeException("ERROR: unknown ranking classifier type: " + properties.getProperty("classifierType") + "!");
        }
        return rankingClassifier;
    }

    public static final /* synthetic */ void $anonfun$crossValidate$1(RankingDataset dataset$1, Properties classifierProperties$1, boolean generateProbabilities$1, double softmaxGamma$1, double[][] scores$1, IntRef foldOffset$1, DatasetFold fold) {
        Object object;
        Properties props = new Properties(classifierProperties$1);
        String debugFile = props.getProperty("debugFile");
        if (debugFile != null && debugFile.length() > 0) {
            debugFile = debugFile + "." + foldOffset$1.elem;
            object = props.setProperty("debugFile", debugFile);
        } else {
            object = BoxedUnit.UNIT;
        }
        RankingClassifier classifier = MODULE$.apply(props);
        classifier.train(dataset$1, (Option<Iterable<Tuple2<Object, Object>>>)new Some(fold.trainFolds()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(fold.testFold()._1$mcI$sp()), fold.testFold()._2$mcI$sp()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Datum<Object, F>[] queryDatums = dataset$1.mkQueryDatums(i);
            scores$1[i] = generateProbabilities$1 ? (double[])classifier.probabilitiesOf((Iterable)Predef$.MODULE$.wrapRefArray((Object[])queryDatums), softmaxGamma$1).toArray(ClassTag$.MODULE$.Double()) : (double[])classifier.scoresOf((Iterable)Predef$.MODULE$.wrapRefArray((Object[])queryDatums)).toArray(ClassTag$.MODULE$.Double());
        });
        ++foldOffset$1.elem;
    }

    private RankingClassifier$() {
        MODULE$ = this;
    }
}

