/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.processors.clu;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.clulab.processors.Document;
import org.clulab.processors.Sentence;
import org.clulab.processors.clu.CluProcessor;
import org.clulab.processors.clu.tokenizer.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class CluProcessor$ {
    public static CluProcessor$ MODULE$;
    private final Logger logger;
    private final String prefix;
    private final String PREDICATE_ATTACHMENT_NAME;

    static {
        new CluProcessor$();
    }

    public Config $lessinit$greater$default$1() {
        return ConfigFactory.load((String)"cluprocessor");
    }

    public Logger logger() {
        return this.logger;
    }

    public String prefix() {
        return this.prefix;
    }

    public String PREDICATE_ATTACHMENT_NAME() {
        return this.PREDICATE_ATTACHMENT_NAME;
    }

    public Document mkDocument(Tokenizer tokenizer, String text, boolean keepText) {
        Document doc;
        block0: {
            Sentence[] sents = tokenizer.tokenize(text, tokenizer.tokenize$default$2());
            doc = new Document(sents);
            if (!keepText) break block0;
            doc.text_$eq((Option<String>)new Some((Object)text));
        }
        return doc;
    }

    public Document mkDocumentFromSentences(Tokenizer tokenizer, Iterable<String> sentences, boolean keepText, int charactersBetweenSentences) {
        Document doc;
        block0: {
            ArrayBuffer sents = new ArrayBuffer();
            IntRef characterOffset = IntRef.create((int)0);
            sentences.foreach((Function1 & Serializable & scala.Serializable)text -> {
                Sentence sent = (Sentence)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokenizer.tokenize((String)text, false))).head();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sent.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    sent$1.startOffsets()[i] = sent.startOffsets()[i] + characterOffset$1.elem;
                    sent$1.endOffsets()[i] = sent.endOffsets()[i] + characterOffset$1.elem;
                });
                characterOffset$1.elem = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sent.endOffsets())).last()) + charactersBetweenSentences;
                return sents.$plus$eq((Object)sent);
            });
            doc = new Document((Sentence[])sents.toArray(ClassTag$.MODULE$.apply(Sentence.class)));
            if (!keepText) break block0;
            doc.text_$eq((Option<String>)new Some((Object)sentences.mkString(this.mkSep(charactersBetweenSentences))));
        }
        return doc;
    }

    public Document mkDocumentFromTokens(Tokenizer tokenizer, Iterable<Iterable<String>> sentences, boolean keepText, int charactersBetweenSentences, int charactersBetweenTokens) {
        Document doc;
        block0: {
            IntRef charOffset = IntRef.create((int)0);
            ObjectRef sents = ObjectRef.create((Object)new ArrayBuffer());
            StringBuilder text = new StringBuilder();
            sentences.foreach((Function1 & Serializable & scala.Serializable)sentence -> {
                BoxedUnit boxedUnit;
                ArrayBuffer startOffsets = new ArrayBuffer();
                ArrayBuffer endOffsets = new ArrayBuffer();
                sentence.foreach((Function1 & Serializable & scala.Serializable)word -> {
                    CluProcessor$.$anonfun$mkDocumentFromTokens$2(charactersBetweenTokens, charOffset, startOffsets, endOffsets, word);
                    return BoxedUnit.UNIT;
                });
                ((ArrayBuffer)sents$2.elem).$plus$eq((Object)new Sentence((String[])sentence.toArray(ClassTag$.MODULE$.apply(String.class)), (int[])startOffsets.toArray(ClassTag$.MODULE$.Int()), (int[])endOffsets.toArray(ClassTag$.MODULE$.Int()), (String[])sentence.toArray(ClassTag$.MODULE$.apply(String.class))));
                charOffset$1.elem += charactersBetweenSentences - charactersBetweenTokens;
                if (keepText) {
                    text.append(sentence.mkString(MODULE$.mkSep(charactersBetweenTokens)));
                    boxedUnit = text.append(MODULE$.mkSep(charactersBetweenSentences));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            doc = new Document((Sentence[])((ArrayBuffer)sents.elem).toArray(ClassTag$.MODULE$.apply(Sentence.class)));
            if (!keepText) break block0;
            doc.text_$eq((Option<String>)new Some((Object)text.toString()));
        }
        return doc;
    }

    private String mkSep(int size) {
        StringBuilder os = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1 & Serializable & scala.Serializable)_ -> os.append(" "));
        return os.toString();
    }

    public static final /* synthetic */ void $anonfun$mkDocumentFromTokens$2(int charactersBetweenTokens$1, IntRef charOffset$1, ArrayBuffer startOffsets$1, ArrayBuffer endOffsets$1, String word) {
        startOffsets$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)charOffset$1.elem));
        charOffset$1.elem += word.length();
        endOffsets$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)charOffset$1.elem));
        charOffset$1.elem += charactersBetweenTokens$1;
    }

    private CluProcessor$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(CluProcessor.class);
        this.prefix = "CluProcessor";
        this.PREDICATE_ATTACHMENT_NAME = "predicates";
    }
}

