/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.sequences;

import java.io.File;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.clulab.processors.Sentence;
import org.clulab.sequences.SequenceTagger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class SequenceTaggerShell$ {
    public static SequenceTaggerShell$ MODULE$;

    static {
        new SequenceTaggerShell$();
    }

    public <L, F> void shell(SequenceTagger<L, F> tagger) {
        FileHistory history = new FileHistory(new File(System.getProperty("user.home"), ".seqshellhistory"));
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> history.flush());
        ConsoleReader reader = new ConsoleReader();
        reader.setHistory((History)history);
        boolean running = true;
        while (running) {
            BoxedUnit boxedUnit;
            reader.setPrompt(">> ");
            String string = reader.readLine();
            boolean bl = ":exit".equals(string) ? true : string == null;
            if (bl) {
                running = false;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            this.parse(string, tagger);
            boxedUnit = BoxedUnit.UNIT;
        }
        reader.getTerminal().restore();
        reader.shutdown();
    }

    public <L, F> void parse(String text, SequenceTagger<L, F> tagger) {
        Sentence sent = this.mkSent(text);
        Predef$.MODULE$.println((Object)("Tokens: " + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sent.words())).mkString(", ")));
        Object labels = tagger.classesOf(sent);
        Predef$.MODULE$.println((Object)("Labels: " + Predef$.MODULE$.genericArrayOps(labels).mkString(", ")));
    }

    public Sentence mkSent(String text) {
        String[] tokens = text.split("\\s+");
        int[] startOffsets = new int[tokens.length];
        int[] endOffsets = new int[tokens.length];
        return new Sentence(tokens, startOffsets, endOffsets, tokens);
    }

    private SequenceTaggerShell$() {
        MODULE$ = this;
    }
}

