/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.utils;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Profiler$ {
    public static Profiler$ MODULE$;
    private final ArrayBuffer<BigInt> startTimes;
    private final ArrayBuffer<BigInt> deltas;
    private final ArrayBuffer<BigInt> numSamples;
    private final ArrayBuffer<String> ids;

    static {
        new Profiler$();
    }

    public ArrayBuffer<BigInt> startTimes() {
        return this.startTimes;
    }

    public ArrayBuffer<BigInt> deltas() {
        return this.deltas;
    }

    public ArrayBuffer<BigInt> numSamples() {
        return this.numSamples;
    }

    public ArrayBuffer<String> ids() {
        return this.ids;
    }

    private int findIdxFromID(String id, boolean makeNewID) {
        int n;
        Object object = new Object();
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ids().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                Object object = MODULE$.ids().apply(i);
                String string = id;
                if (!(object != null ? !object.equals(string) : string != null)) {
                    throw new NonLocalReturnControl.mcI.sp(object, i);
                }
            });
            if (makeNewID) {
                this.ids().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id}));
                this.startTimes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigInt[]{BigInt$.MODULE$.int2bigInt(0)}));
                this.deltas().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigInt[]{BigInt$.MODULE$.int2bigInt(0)}));
                this.numSamples().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigInt[]{BigInt$.MODULE$.int2bigInt(0)}));
                return this.ids().size() - 1;
            }
            n = -1;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    private boolean findIdxFromID$default$2() {
        return false;
    }

    public void start(String id) {
        int idx = this.findIdxFromID(id, true);
        this.startTimes().update(idx, (Object)BigInt$.MODULE$.long2bigInt(System.nanoTime()));
    }

    public void end(String id) {
        block0: {
            int idx = this.findIdxFromID(id, false);
            if (idx < 0) break block0;
            long endTime = System.nanoTime();
            BigInt delta = BigInt$.MODULE$.long2bigInt(endTime).$minus((BigInt)this.startTimes().apply(idx));
            this.deltas().update(idx, (Object)((BigInt)this.deltas().apply(idx)).$plus(delta));
            this.numSamples().update(idx, (Object)((BigInt)this.numSamples().apply(idx)).$plus(BigInt$.MODULE$.int2bigInt(1)));
        }
    }

    public void report() {
        Predef$.MODULE$.println((Object)" ------------------------------ ");
        Predef$.MODULE$.println((Object)" * Profiler report: ");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ids().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Predef$.MODULE$.println((Object)(" [" + i + "] id:" + MODULE$.formatFixedLength((String)MODULE$.ids().apply(i), 30) + "    \t totaltime:" + MODULE$.deltas().apply(i) + "\t samples:" + MODULE$.numSamples().apply(i) + " \tAvg time/sample:" + ((BigInt)MODULE$.deltas().apply(i)).$div((BigInt)MODULE$.numSamples().apply(i)))));
        Predef$.MODULE$.println((Object)" ------------------------------ ");
    }

    public String formatFixedLength(String in, int length) {
        ObjectRef os = ObjectRef.create((Object)in);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length - new StringOps(Predef$.MODULE$.augmentString(in)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            os$1.elem = (String)os$1.elem + " ";
        });
        return (String)os.elem;
    }

    private Profiler$() {
        MODULE$ = this;
        this.startTimes = new ArrayBuffer();
        this.deltas = new ArrayBuffer();
        this.numSamples = new ArrayBuffer();
        this.ids = new ArrayBuffer();
    }
}

