/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.clulab.utils.ClassLoaderObjectInputStream;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;

public final class Serializer$ {
    public static Serializer$ MODULE$;

    static {
        new Serializer$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("close", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public <A, B> B using(A resource, Function1<A, B> f) {
        Object object;
        try {
            object = f.apply(resource);
        }
        catch (Throwable throwable) {
            A qual1 = resource;
            try {
                Serializer$.reflMethod$Method1(qual1.getClass()).invoke(qual1, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            throw throwable;
        }
        Object object2 = object;
        A qual1 = resource;
        try {
            Serializer$.reflMethod$Method1(qual1.getClass()).invoke(qual1, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return (B)object2;
    }

    public <A> void save(A obj, OutputStream outputStream) {
        this.using(new ObjectOutputStream(outputStream), (Function1 & Serializable & scala.Serializable)oos -> {
            oos.writeObject(obj);
            return BoxedUnit.UNIT;
        });
    }

    public <A> void save(A obj, File file) {
        this.using(new BufferedOutputStream(new FileOutputStream(file)), (Function1 & Serializable & scala.Serializable)fos -> {
            Serializer$.MODULE$.save(obj, fos);
            return BoxedUnit.UNIT;
        });
    }

    public <A> void save(A obj, String filename) {
        this.using(new BufferedOutputStream(new FileOutputStream(filename)), (Function1 & Serializable & scala.Serializable)fos -> {
            Serializer$.MODULE$.save(obj, fos);
            return BoxedUnit.UNIT;
        });
    }

    public <A> byte[] save(A obj) {
        return (byte[])this.using(new ByteArrayOutputStream(), (Function1 & Serializable & scala.Serializable)baos -> {
            MODULE$.save(obj, (OutputStream)baos);
            return baos.toByteArray();
        });
    }

    public <A> A load(InputStream inputStream) {
        return this.load(inputStream, this.getClass().getClassLoader());
    }

    public <A> A load(InputStream inputStream, ClassLoader classLoader) {
        return (A)this.using(new ClassLoaderObjectInputStream(classLoader, inputStream), (Function1 & Serializable & scala.Serializable)ois -> ois.readObject());
    }

    public <A> A load(File file) {
        return this.load(file, this.getClass().getClassLoader());
    }

    public <A> A load(File file, ClassLoader classLoader) {
        return (A)this.using(new BufferedInputStream(new FileInputStream(file)), (Function1 & Serializable & scala.Serializable)fis -> MODULE$.load((InputStream)fis, classLoader));
    }

    public <A> A load(String filename) {
        return this.load(filename, this.getClass().getClassLoader());
    }

    public <A> A load(String filename, ClassLoader classLoader) {
        return (A)this.using(new BufferedInputStream(new FileInputStream(filename)), (Function1 & Serializable & scala.Serializable)fis -> MODULE$.load((InputStream)fis, classLoader));
    }

    public <A> A load(byte[] bytes) {
        return this.load(bytes, this.getClass().getClassLoader());
    }

    public <A> A load(byte[] bytes, ClassLoader classLoader) {
        return (A)this.using(new ByteArrayInputStream(bytes), (Function1 & Serializable & scala.Serializable)bais -> MODULE$.load((InputStream)bais, classLoader));
    }

    private Serializer$() {
        MODULE$ = this;
    }
}

