/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Option$;
import scala.Serializable;
import scala.io.BufferedSource;
import scala.io.Source$;

public final class Sourcer$ {
    public static Sourcer$ MODULE$;
    private final Logger logger;
    private final String utf8;

    static {
        new Sourcer$();
    }

    public Logger logger() {
        return this.logger;
    }

    public String utf8() {
        return this.utf8;
    }

    public BufferedSource sourceFromResource(String path) {
        URL url = (URL)Option$.MODULE$.apply((Object)this.getClass().getResource(path)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw MODULE$.newFileNotFoundException(path);
        });
        this.logger().info("Sourcing resource " + url.getPath());
        return Source$.MODULE$.fromURL(url, this.utf8());
    }

    public BufferedSource sourceFromFile(File file) {
        this.logger().info("Sourcing file " + file.getPath());
        return Source$.MODULE$.fromFile(file, this.utf8());
    }

    public BufferedSource sourceFromFile(String path) {
        return this.sourceFromFile(new File(path));
    }

    public FileNotFoundException newFileNotFoundException(String path) {
        String message1 = path + " (The system cannot find the path specified";
        String message2 = message1 + (path.startsWith("~") ? ".  Make sure to not use the tilde (~) character in paths in lieu of the home directory." : "");
        String message3 = message2 + ")";
        return new FileNotFoundException(message3);
    }

    private Sourcer$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.utf8 = StandardCharsets.UTF_8.toString();
    }
}

