/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.utils;

import org.clulab.processors.Sentence;
import org.clulab.struct.DirectedGraph;
import org.clulab.struct.DirectedGraphIndex;
import org.clulab.struct.Edge;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ToEnhancedSemanticRoles$ {
    public static ToEnhancedSemanticRoles$ MODULE$;

    static {
        new ToEnhancedSemanticRoles$();
    }

    public DirectedGraph<String> generateEnhancedSemanticRoles(Sentence sentence, DirectedGraph<String> basicDependencies, DirectedGraph<String> semanticRoles) {
        DirectedGraphIndex<String> rolesIndex = semanticRoles.toDirectedGraphIndex(basicDependencies.size());
        DirectedGraphIndex<String> depsIndex = basicDependencies.toDirectedGraphIndex(basicDependencies.size());
        this.collapsePrepositions(sentence, depsIndex, rolesIndex);
        this.propagateArgsInConjPredicates(sentence, depsIndex, rolesIndex);
        this.propagateConjArgs(sentence, depsIndex, rolesIndex);
        return rolesIndex.toDirectedGraph((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)basicDependencies.size())));
    }

    public void collapsePrepositions(Sentence sentence, DirectedGraphIndex<String> depsIndex, DirectedGraphIndex<String> rolesIndex) {
        ListBuffer toRemove = new ListBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rolesIndex.outgoingEdges())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)predicate -> rolesIndex.outgoingEdges()[predicate].foreach((Function1 & java.io.Serializable & Serializable)arg -> {
            BoxedUnit boxedUnit;
            int modifier = arg._1$mcI$sp();
            String label = (String)arg._2();
            Seq prepObjects = depsIndex.findByModifierAndPattern(modifier, new StringOps(Predef$.MODULE$.augmentString("case|mark")).r());
            if (prepObjects.nonEmpty()) {
                Edge prepObject = (Edge)prepObjects.head();
                int newArg = prepObject.source();
                String string = label;
                String string2 = "Ax";
                String newLabel = !(string != null ? !string.equals(string2) : string2 != null) ? label + "_" + sentence.words()[prepObject.destination()].toLowerCase() : label;
                rolesIndex.addEdge(predicate, newArg, newLabel);
                boxedUnit = toRemove.$plus$eq(new Edge<String>(predicate, modifier, label));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }));
        toRemove.foreach((Function1 & java.io.Serializable & Serializable)e -> {
            rolesIndex.removeEdge(e.source(), e.destination(), e.relation());
            return BoxedUnit.UNIT;
        });
    }

    public void propagateArgsInConjPredicates(Sentence sentence, DirectedGraphIndex<String> depsIndex, DirectedGraphIndex<String> rolesIndex) {
        Seq conjs = (Seq)depsIndex.findByName("conj").sortBy((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.source()), (Ordering)Ordering.Int$.MODULE$);
        ListBuffer toAdd = new ListBuffer();
        conjs.foreach((Function1 & java.io.Serializable & Serializable)conj -> {
            ToEnhancedSemanticRoles$.$anonfun$propagateArgsInConjPredicates$2(rolesIndex, toAdd, conj);
            return BoxedUnit.UNIT;
        });
        toAdd.foreach((Function1 & java.io.Serializable & Serializable)e -> {
            rolesIndex.addEdge(e.source(), e.destination(), e.relation());
            return BoxedUnit.UNIT;
        });
    }

    public void propagateConjArgs(Sentence sentence, DirectedGraphIndex<String> depsIndex, DirectedGraphIndex<String> rolesIndex) {
        Seq conjs = (Seq)depsIndex.findByName("conj").sortBy((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.source()), (Ordering)Ordering.Int$.MODULE$);
        ListBuffer toAdd = new ListBuffer();
        conjs.foreach((Function1 & java.io.Serializable & Serializable)conj -> {
            ToEnhancedSemanticRoles$.$anonfun$propagateConjArgs$2(rolesIndex, toAdd, conj);
            return BoxedUnit.UNIT;
        });
        toAdd.foreach((Function1 & java.io.Serializable & Serializable)e -> {
            rolesIndex.addEdge(e.source(), e.destination(), e.relation());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$propagateArgsInConjPredicates$2(DirectedGraphIndex rolesIndex$2, ListBuffer toAdd$1, Edge conj) {
        int left = package$.MODULE$.min(conj.source(), conj.destination());
        int right = package$.MODULE$.max(conj.source(), conj.destination());
        Set leftRoles = rolesIndex$2.findByHeadAndPattern(left, new StringOps(Predef$.MODULE$.augmentString("^A*")).r()).toSet();
        Set rightRoles = rolesIndex$2.findByHeadAndPattern(right, new StringOps(Predef$.MODULE$.augmentString("^A*")).r()).toSet();
        leftRoles.foreach((Function1 & java.io.Serializable & Serializable)leftRole -> {
            String label;
            Edge<String> e;
            int modifier = leftRole.destination();
            return modifier != right ? (!rightRoles.contains(e = new Edge<String>(right, modifier, label = (String)leftRole.relation())) ? toAdd$1.$plus$eq(e) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        });
        rightRoles.foreach((Function1 & java.io.Serializable & Serializable)rightRole -> {
            String label;
            Edge<String> e;
            int modifier = rightRole.destination();
            return modifier != left ? (!leftRoles.contains(e = new Edge<String>(left, modifier, label = (String)rightRole.relation())) ? toAdd$1.$plus$eq(e) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$propagateConjArgs$2(DirectedGraphIndex rolesIndex$3, ListBuffer toAdd$2, Edge conj) {
        int left = package$.MODULE$.min(conj.source(), conj.destination());
        int right = package$.MODULE$.max(conj.source(), conj.destination());
        Set leftRoles = rolesIndex$3.findByModifierAndPattern(left, new StringOps(Predef$.MODULE$.augmentString("^A*")).r()).toSet();
        Set rightRoles = rolesIndex$3.findByModifierAndPattern(right, new StringOps(Predef$.MODULE$.augmentString("^A*")).r()).toSet();
        leftRoles.foreach((Function1 & java.io.Serializable & Serializable)leftRole -> {
            String label;
            Edge<String> e;
            int predicate = leftRole.source();
            return predicate != right ? (!rightRoles.contains(e = new Edge<String>(predicate, right, label = (String)leftRole.relation())) ? toAdd$2.$plus$eq(e) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        });
        rightRoles.foreach((Function1 & java.io.Serializable & Serializable)rightRole -> {
            String label;
            Edge<String> e;
            int predicate = rightRole.source();
            return predicate != left ? (!leftRoles.contains(e = new Edge<String>(predicate, left, label = (String)rightRole.relation())) ? toAdd$2.$plus$eq(e) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        });
    }

    private ToEnhancedSemanticRoles$() {
        MODULE$ = this;
    }
}

