/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.scala_transformers.common;

import org.clulab.scala_transformers.common.Timer$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class Timer {
    private final String description;
    private long elapsedTime;
    private Option startTimeOpt;

    public static long dayDivisor() {
        return Timer$.MODULE$.dayDivisor();
    }

    public static long daysDivisor() {
        return Timer$.MODULE$.daysDivisor();
    }

    public static long hrDivisor() {
        return Timer$.MODULE$.hrDivisor();
    }

    public static long minDivisor() {
        return Timer$.MODULE$.minDivisor();
    }

    public static long msecDivisor() {
        return Timer$.MODULE$.msecDivisor();
    }

    public static long nsecDivisor() {
        return Timer$.MODULE$.nsecDivisor();
    }

    public static long secDivisor() {
        return Timer$.MODULE$.secDivisor();
    }

    public Timer(String description) {
        this.description = description;
        this.elapsedTime = 0L;
        this.startTimeOpt = None$.MODULE$;
    }

    public String description() {
        return this.description;
    }

    public long elapsedTime() {
        return this.elapsedTime;
    }

    public void elapsedTime_$eq(long x$1) {
        this.elapsedTime = x$1;
    }

    public Option<Object> startTimeOpt() {
        return this.startTimeOpt;
    }

    public void startTimeOpt_$eq(Option<Object> x$1) {
        this.startTimeOpt = x$1;
    }

    public <R> R time(Function0<R> block) {
        long startTime = System.nanoTime();
        Object result = block.apply();
        long stopTime = System.nanoTime();
        this.elapsedTime_$eq(this.elapsedTime() + (stopTime - startTime));
        return (R)result;
    }

    public void start() {
        long startTime = System.nanoTime();
        this.startTimeOpt_$eq((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)startTime)));
    }

    public void stop() {
        if (this.startTimeOpt().isDefined()) {
            long stopTime = System.nanoTime();
            this.elapsedTime_$eq(this.elapsedTime() + (stopTime - BoxesRunTime.unboxToLong((Object)this.startTimeOpt().get())));
        }
    }

    public String toString() {
        return new StringBuilder(7).append("Time\t").append(this.description()).append("\t").append(this.elapsedToString()).append("\t").append(this.elapsedTime()).toString();
    }

    public String elapsedToString() {
        long days = this.elapsedTime() / Timer$.MODULE$.dayDivisor();
        long hours = this.elapsedTime() % Timer$.MODULE$.dayDivisor() / Timer$.MODULE$.hrDivisor();
        long mins = this.elapsedTime() % Timer$.MODULE$.hrDivisor() / Timer$.MODULE$.minDivisor();
        long secs = this.elapsedTime() % Timer$.MODULE$.minDivisor() / Timer$.MODULE$.secDivisor();
        long msecs = this.elapsedTime() % Timer$.MODULE$.secDivisor() / Timer$.MODULE$.msecDivisor();
        return StringOps$.MODULE$.format$extension("%s:%02d:%02d:%02d.%03d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)days), BoxesRunTime.boxToLong((long)hours), BoxesRunTime.boxToLong((long)mins), BoxesRunTime.boxToLong((long)secs), BoxesRunTime.boxToLong((long)msecs)}));
    }
}

