/*
 * Decompiled with CFR 0.152.
 */
package org.code_house.validation.resolver;

import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.validation.ValidationProviderResolver;
import javax.validation.spi.ValidationProvider;
import org.code_house.validation.resolver.OsgiValidationProviderResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ValidationProviderHolder {
    private final BundleContext context;
    private final List<ValidationProvider<?>> providers = new CopyOnWriteArrayList();
    private ServiceRegistration registration;

    public ValidationProviderHolder(BundleContext context) {
        this.context = context;
    }

    public void add(ValidationProvider provider) {
        this.providers.add(provider);
        this.register();
    }

    private void register() {
        if (this.registration == null && !this.providers.isEmpty()) {
            OsgiValidationProviderResolver validationResolver = new OsgiValidationProviderResolver(this.providers);
            this.registration = this.context.registerService(ValidationProviderResolver.class, (Object)validationResolver, new Hashtable());
        }
        if (this.registration != null && this.providers.isEmpty()) {
            this.registration.unregister();
        }
    }

    public void remove(ValidationProvider provider) {
        this.providers.remove(provider);
        this.register();
    }
}

