/*
 * Decompiled with CFR 0.152.
 */
package org.code_house.validation.resolver;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ServiceLoader;
import javax.validation.spi.ValidationProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationResolverBundleTrackerCustomizer
implements BundleTrackerCustomizer<List<ServiceRegistration>> {
    private final Logger logger = LoggerFactory.getLogger(ValidationResolverBundleTrackerCustomizer.class);

    public List<ServiceRegistration> addingBundle(Bundle bundle, BundleEvent event) {
        Enumeration entries = bundle.findEntries("META-INF/services", ValidationProvider.class.getName(), false);
        if (entries == null) {
            this.logger.trace("No matching entries found in bundle {}", (Object)bundle.getSymbolicName());
            return null;
        }
        ArrayList<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
        if (entries.hasMoreElements()) {
            this.logger.trace("Found validation provider bundle {}", (Object)bundle.getSymbolicName());
            ClassLoader classLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            ServiceLoader<ValidationProvider> providers = ServiceLoader.load(ValidationProvider.class, classLoader);
            for (ValidationProvider provider : providers) {
                registrations.add(bundle.getBundleContext().registerService(ValidationProvider.class, (Object)provider, new Hashtable()));
            }
        }
        return registrations;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, List<ServiceRegistration> object) {
        this.removedBundle(bundle, event, object);
        this.addingBundle(bundle, event);
    }

    public void removedBundle(Bundle bundle, BundleEvent event, List<ServiceRegistration> object) {
        if (object != null) {
            for (ServiceRegistration registration : object) {
                registration.unregister();
            }
        }
    }
}

