/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.mojo.asadmin;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.n0pe.asadmin.AsAdmin;
import org.n0pe.asadmin.AsAdminCmdList;
import org.n0pe.asadmin.AsAdminException;
import org.n0pe.asadmin.IAsAdminConfig;

public abstract class AbstractAsadminMojo
extends AbstractMojo
implements IAsAdminConfig {
    private boolean skip;
    private String glassfishHome;
    private File glassfishHomeDir;
    private String user;
    private String passwordfile;
    private String host;
    private String port;
    private boolean secure;
    protected String domain;
    protected String appArchive;
    protected String appName;
    protected String contextRoot;
    protected MavenProject mavenProject;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"asadmin-maven-plugin execution is skipped");
            return;
        }
        try {
            this.checkConfig();
            AsAdmin.getInstance((IAsAdminConfig)this).run(this.getAsCommandList());
        }
        catch (AsAdminException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public final String getGlassfishHome() {
        return this.glassfishHome;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getPasswordFile() {
        return this.passwordfile;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    protected abstract AsAdminCmdList getAsCommandList() throws MojoExecutionException, MojoFailureException;

    private void checkConfig() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isEmpty((String)this.glassfishHome) || "ENV".equals(this.glassfishHome)) {
            if ((double)SystemUtils.JAVA_VERSION_FLOAT < 1.5) {
                throw new MojoExecutionException("Neither GLASSFISH_HOME, AS_HOME nor the glassfishHome configuration parameter is set! Also, to save you the trouble, environment cannot be read running maven with a VM < 1.5, so set the glassFishHome configuration parameter or use -D.");
            }
            this.glassfishHome = System.getenv("GLASSFISH_HOME");
            if (StringUtils.isEmpty((String)this.glassfishHome)) {
                this.glassfishHome = System.getenv("AS_HOME");
            }
        }
        if (StringUtils.isEmpty((String)this.glassfishHome)) {
            throw new MojoExecutionException("Neither GLASSFISH_HOME, AS_HOME nor the glassfishHome configuration parameter is set!");
        }
        this.glassfishHomeDir = new File(this.glassfishHome);
        if (!this.glassfishHomeDir.exists()) {
            throw new MojoFailureException("The specifed glassfishHome does not exist.");
        }
        if (StringUtils.isEmpty((String)this.passwordfile) || "HOME".equals(this.passwordfile)) {
            this.passwordfile = null;
            if (new File(System.getenv("HOME") + File.separator + ".asadminpass").exists()) {
                this.passwordfile = System.getenv("HOME") + File.separator + ".asadminpass";
            } else if (new File(System.getenv("HOME") + File.separator + ".asadmintruststore").exists()) {
                this.passwordfile = System.getenv("HOME") + File.separator + ".asadmintruststore";
            }
        } else if (!new File(this.passwordfile).exists()) {
            this.passwordfile = null;
        }
        if (StringUtils.isEmpty((String)this.passwordfile)) {
            throw new MojoFailureException("Given password file does not exists or cannot find an existing asadmin password file");
        }
    }
}

