package org.freedesktop.tango.actions;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class MediaRecordSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 0.15f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(0.9206969738006592f, 0.0f, 0.0f, 0.9935799837112427f, 3.6794838905334473f, 1.6412359476089478f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(22.5, 28.11604881286621), 14.537862f, new Point2D.Double(22.5, 28.11604881286621), new float[] {0.0f,1.0f}, new Color[] {new Color(239, 41, 41, 255),new Color(204, 0, 0, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(2.3655619621276855f, -4.942241900255382E-16f, 5.3597661451763E-16f, 2.2028450965881348f, -30.725170135498047f, -34.239959716796875f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.5, 22.0);
((GeneralPath)shape).curveTo(36.5, 29.1797, 30.231987, 35.0, 22.5, 35.0);
((GeneralPath)shape).curveTo(14.768014, 35.0, 8.5, 29.1797, 8.5, 22.0);
((GeneralPath)shape).curveTo(8.5, 14.820298, 14.768014, 9.0, 22.5, 9.0);
((GeneralPath)shape).curveTo(30.231987, 9.0, 36.5, 14.820298, 36.5, 22.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new LinearGradientPaint(new Point2D.Double(21.702388763427734, 8.911531448364258), new Point2D.Double(21.816015243530273, 35.54610824584961), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(255, 255, 255, 200)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(3.1366165f,2,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.5, 22.0);
((GeneralPath)shape).curveTo(36.5, 29.1797, 30.231987, 35.0, 22.5, 35.0);
((GeneralPath)shape).curveTo(14.768014, 35.0, 8.5, 29.1797, 8.5, 22.0);
((GeneralPath)shape).curveTo(8.5, 14.820298, 14.768014, 9.0, 22.5, 9.0);
((GeneralPath)shape).curveTo(30.231987, 9.0, 36.5, 14.820298, 36.5, 22.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 0.03999999f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.1505329608917236f, 0.0f, 0.0f, 0.565684974193573f, -4.576499938964844f, 16.5528507232666f));
// _0_0_1
paint = new RadialGradientPaint(new Point2D.Double(24.837125778198242, 36.42112731933594), 15.644737f, new Point2D.Double(24.837125778198242, 36.42112731933594), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.5367230176925659f, -3.241652009756263E-13f, 16.87306022644043f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(40.48186, 36.421127);
((GeneralPath)shape).curveTo(40.483814, 39.421745, 37.50237, 42.19488, 32.66107, 43.69549);
((GeneralPath)shape).curveTo(27.81977, 45.196106, 21.854479, 45.196106, 17.01318, 43.69549);
((GeneralPath)shape).curveTo(12.17188, 42.19488, 9.190436, 39.421745, 9.192389, 36.421127);
((GeneralPath)shape).curveTo(9.190436, 33.42051, 12.17188, 30.647373, 17.01318, 29.14676);
((GeneralPath)shape).curveTo(21.854479, 27.646149, 27.81977, 27.646149, 32.66107, 29.14676);
((GeneralPath)shape).curveTo(37.50237, 30.647373, 40.483814, 33.42051, 40.48186, 36.421127);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(0.8948619961738586f, 0.0f, 0.0f, 0.9656999707221985f, 3.855776071548462f, 2.6603479385375977f));
// _0_0_2
paint = new RadialGradientPaint(new Point2D.Double(22.5, 28.11604881286621), 14.537862f, new Point2D.Double(22.5, 28.11604881286621), new float[] {0.0f,1.0f}, new Color[] {new Color(239, 41, 41, 255),new Color(204, 0, 0, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(2.3655619621276855f, -4.942241900255382E-16f, 5.3597661451763E-16f, 2.2028450965881348f, -30.725170135498047f, -34.239959716796875f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.5, 22.0);
((GeneralPath)shape).curveTo(36.5, 29.1797, 30.231987, 35.0, 22.5, 35.0);
((GeneralPath)shape).curveTo(14.768014, 35.0, 8.5, 29.1797, 8.5, 22.0);
((GeneralPath)shape).curveTo(8.5, 14.820298, 14.768014, 9.0, 22.5, 9.0);
((GeneralPath)shape).curveTo(30.231987, 9.0, 36.5, 14.820298, 36.5, 22.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(204, 0, 0, 255);
stroke = new BasicStroke(1.0757246f,2,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.5, 22.0);
((GeneralPath)shape).curveTo(36.5, 29.1797, 30.231987, 35.0, 22.5, 35.0);
((GeneralPath)shape).curveTo(14.768014, 35.0, 8.5, 29.1797, 8.5, 22.0);
((GeneralPath)shape).curveTo(8.5, 14.820298, 14.768014, 9.0, 22.5, 9.0);
((GeneralPath)shape).curveTo(30.231987, 9.0, 36.5, 14.820298, 36.5, 22.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(0.8214290142059326f, 0.0f, 0.0f, 0.8214290142059326f, 4.285117149353027f, 4.191454887390137f));
// _0_0_3
paint = new Color(247, 125, 125, 255);
stroke = new BasicStroke(1.2173917f,2,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(38.0, 24.0);
((GeneralPath)shape).curveTo(38.0, 31.731987, 31.731987, 38.0, 24.0, 38.0);
((GeneralPath)shape).curveTo(16.268013, 38.0, 10.0, 31.731987, 10.0, 24.0);
((GeneralPath)shape).curveTo(10.0, 16.268013, 16.268013, 10.0, 24.0, 10.0);
((GeneralPath)shape).curveTo(31.731987, 10.0, 38.0, 16.268013, 38.0, 24.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 0.6f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_4
paint = new RadialGradientPaint(new Point2D.Double(21.92918586730957, -3.2182934284210205), 13.0f, new Point2D.Double(21.92918586730957, -3.2182934284210205), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(3.6588189601898193f, -3.133880026822246E-16f, 1.7195360428836395E-16f, 2.080781936645508f, -62.41640090942383f, 12.762040138244629f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.84315, 11.90574);
((GeneralPath)shape).curveTo(17.563618, 11.985335, 12.438727, 16.897799, 12.03065, 23.09324);
((GeneralPath)shape).curveTo(18.148474, 25.61002, 25.90107, 21.642017, 35.172653, 19.711353);
((GeneralPath)shape).curveTo(34.484245, 16.962786, 30.617935, 11.90574, 23.9994, 11.90574);
((GeneralPath)shape).curveTo(23.947693, 11.90574, 23.894703, 11.905087, 23.84315, 11.90574);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_4);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 6;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 10;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 37;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 34;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public MediaRecordSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

