package org.freedesktop.tango.actions;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class MediaSkipForwardSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 0.15f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0
paint = new LinearGradientPaint(new Point2D.Double(24.476165771484375, 13.658563613891602), new Point2D.Double(23.75040054321289, 36.0), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(255, 255, 255, 168)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 46.00033950805664f, 0.0f));
stroke = new BasicStroke(3.0f,2,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(4.5, 13.5);
((GeneralPath)shape).lineTo(4.5, 34.5);
((GeneralPath)shape).lineTo(22.0, 24.0);
((GeneralPath)shape).lineTo(4.5, 13.5);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(22.5, 13.5);
((GeneralPath)shape).lineTo(22.5, 34.5);
((GeneralPath)shape).lineTo(39.5, 24.3125);
((GeneralPath)shape).lineTo(39.5, 34.5);
((GeneralPath)shape).lineTo(44.5, 34.5);
((GeneralPath)shape).lineTo(44.5, 13.5);
((GeneralPath)shape).lineTo(39.5, 13.5);
((GeneralPath)shape).lineTo(39.5, 23.6875);
((GeneralPath)shape).lineTo(22.5, 13.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new RadialGradientPaint(new Point2D.Double(64.2270736694336, 147.99351501464844), 8.75f, new Point2D.Double(64.2270736694336, 147.99351501464844), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(211, 215, 207, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-0.22265900671482086f, -0.9962729811668396f, -2.1299920082092285f, 0.4760409891605377f, 354.9462890625f, 20.851699829101562f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(22.499943, 13.5);
((GeneralPath)shape).lineTo(39.999943, 24.0);
((GeneralPath)shape).lineTo(22.499943, 34.5);
((GeneralPath)shape).lineTo(22.499943, 13.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new RadialGradientPaint(new Point2D.Double(64.2270736694336, 147.99351501464844), 8.75f, new Point2D.Double(64.2270736694336, 147.99351501464844), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(211, 215, 207, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-0.22265900671482086f, -0.9962729811668396f, -2.1299920082092285f, 0.4760409891605377f, 336.9462890625f, 20.851699829101562f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(4.499943, 13.5);
((GeneralPath)shape).lineTo(21.999943, 24.0);
((GeneralPath)shape).lineTo(4.499943, 34.5);
((GeneralPath)shape).lineTo(4.499943, 13.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 0.07027025f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
paint = new LinearGradientPaint(new Point2D.Double(49.43040084838867, 112.94963073730469), new Point2D.Double(49.66732406616211, 115.13713073730469), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 90.99085235595703f, -97.26213073730469f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(4.499943, 13.5);
((GeneralPath)shape).lineTo(5.687443, 14.21875);
((GeneralPath)shape).lineTo(4.499943, 14.09375);
((GeneralPath)shape).lineTo(4.499943, 13.5);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(22.499943, 13.75);
((GeneralPath)shape).lineTo(22.968693, 13.78125);
((GeneralPath)shape).lineTo(26.937443, 16.15625);
((GeneralPath)shape).lineTo(22.499943, 15.75);
((GeneralPath)shape).lineTo(22.499943, 13.75);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_4
paint = new LinearGradientPaint(new Point2D.Double(55.6135139465332, 157.5660400390625), new Point2D.Double(55.771976470947266, 140.31298828125), new float[] {0.0f,1.0f}, new Color[] {new Color(173, 176, 168, 255),new Color(70, 71, 68, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 93.99993896484375f, -121.0f));
stroke = new BasicStroke(1.0000006f,2,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(22.499943, 13.5);
((GeneralPath)shape).lineTo(39.999943, 24.0);
((GeneralPath)shape).lineTo(22.499943, 34.5);
((GeneralPath)shape).lineTo(22.499943, 13.5);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(4.499943, 13.5);
((GeneralPath)shape).lineTo(21.999943, 24.0);
((GeneralPath)shape).lineTo(4.499943, 34.5);
((GeneralPath)shape).lineTo(4.499943, 13.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(22.999943, 14.375);
((GeneralPath)shape).lineTo(39.031193, 24.0);
((GeneralPath)shape).lineTo(22.999943, 33.625);
((GeneralPath)shape).lineTo(22.999943, 14.375);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(4.999943, 14.375);
((GeneralPath)shape).lineTo(21.031193, 24.0);
((GeneralPath)shape).lineTo(4.999943, 33.625);
((GeneralPath)shape).lineTo(4.999943, 14.375);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(23.999943, 16.15625);
((GeneralPath)shape).lineTo(23.999943, 31.84375);
((GeneralPath)shape).lineTo(37.093693, 24.0);
((GeneralPath)shape).lineTo(23.999943, 16.15625);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(5.999943, 16.15625);
((GeneralPath)shape).lineTo(5.999943, 31.84375);
((GeneralPath)shape).lineTo(19.093693, 24.0);
((GeneralPath)shape).lineTo(5.999943, 16.15625);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 0.5611111f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(33.58797, 21.78401);
((GeneralPath)shape).lineTo(24.062843, 16.1875);
((GeneralPath)shape).lineTo(24.062843, 22.230392);
((GeneralPath)shape).lineTo(33.58797, 21.78401);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 0.5611111f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(18.278833, 23.207108);
((GeneralPath)shape).lineTo(6.000343, 16.1875);
((GeneralPath)shape).lineTo(6.000343, 24.05882);
((GeneralPath)shape).lineTo(18.278833, 23.207108);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_8
paint = new RadialGradientPaint(new Point2D.Double(64.2270736694336, 147.99351501464844), 8.75f, new Point2D.Double(64.2270736694336, 147.99351501464844), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(211, 215, 207, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-0.22265900671482086f, -0.9962729811668396f, -2.1299920082092285f, 0.4760409891605377f, 371.9464111328125f, 20.851699829101562f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(39.5, 13.499999);
((GeneralPath)shape).lineTo(44.5, 13.499999);
((GeneralPath)shape).lineTo(44.5, 34.5);
((GeneralPath)shape).lineTo(39.5, 34.5);
((GeneralPath)shape).lineTo(39.5, 13.499999);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_8);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_9 = g.getTransform();
g.transform(new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f));
// _0_0_9
paint = new Color(255, 255, 255, 255);
stroke = new BasicStroke(1.0f,2,0,4.0f,null,0.0f);
shape = new Rectangle2D.Double(-43.500396728515625, -33.5, 3.0, 19.0);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_9);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_10 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_10
paint = new LinearGradientPaint(new Point2D.Double(54.0, 132.5), new Point2D.Double(54.0, 145.0), new float[] {0.0f,1.0f}, new Color[] {new Color(173, 176, 168, 255),new Color(70, 71, 68, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-1.0f, 4.6810428797061654E-17f, -4.6810428797061654E-17f, -1.0f, 93.00039672851562f, 169.0f));
stroke = new BasicStroke(1.0f,2,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(44.5004, 34.5);
((GeneralPath)shape).lineTo(44.5004, 13.499999);
((GeneralPath)shape).lineTo(39.5004, 13.499999);
((GeneralPath)shape).lineTo(39.5004, 34.5);
((GeneralPath)shape).lineTo(44.5004, 34.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_10);
g.setComposite(AlphaComposite.getInstance(3, 0.5611111f * origAlpha));
AffineTransform defaultTransform__0_0_11 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_11
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(41.0, 22.0);
((GeneralPath)shape).lineTo(42.956738, 21.83705);
((GeneralPath)shape).lineTo(42.956738, 15.031146);
((GeneralPath)shape).lineTo(40.923805, 15.031146);
((GeneralPath)shape).lineTo(41.0, 22.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_11);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 3;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 12;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 43;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 25;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public MediaSkipForwardSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

