package org.freedesktop.tango.apps;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class SystemInstallerSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0
paint = new Color(107, 108, 105, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(7.0663524, 9.832632);
((GeneralPath)shape).lineTo(11.142857, 5.571429);
((GeneralPath)shape).lineTo(34.714287, 5.571429);
((GeneralPath)shape).lineTo(39.034664, 9.933648);
((GeneralPath)shape).lineTo(7.0663524, 9.832632);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(96, 96, 96, 255);
stroke = new BasicStroke(1.0f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(7.0663524, 9.832632);
((GeneralPath)shape).lineTo(11.142857, 5.571429);
((GeneralPath)shape).lineTo(34.714287, 5.571429);
((GeneralPath)shape).lineTo(39.034664, 9.933648);
((GeneralPath)shape).lineTo(7.0663524, 9.832632);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(0.02018279954791069f, 0.0f, 0.0f, 0.02086758054792881f, 41.09415817260742f, 37.29644012451172f));
// _0_0_1
g.setComposite(AlphaComposite.getInstance(3, 0.40206185f * origAlpha));
AffineTransform defaultTransform__0_0_1_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1_0
paint = new LinearGradientPaint(new Point2D.Double(302.8571472167969, 366.64788818359375), new Point2D.Double(302.8571472167969, 609.5050659179688), new float[] {0.0f,0.5f,1.0f}, new Color[] {new Color(0, 0, 0, 0),new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(2.7743890285491943f, 0.0f, 0.0f, 1.9697060585021973f, -1892.178955078125f, -872.8853759765625f));
shape = new Rectangle2D.Double(-1559.2523193359375, -150.6968536376953, 1339.633544921875, 478.357177734375);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_1_0);
g.setComposite(AlphaComposite.getInstance(3, 0.40206185f * origAlpha));
AffineTransform defaultTransform__0_0_1_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1_1
paint = new RadialGradientPaint(new Point2D.Double(605.7142944335938, 486.64788818359375), 117.14286f, new Point2D.Double(605.7142944335938, 486.64788818359375), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(2.7743890285491943f, 0.0f, 0.0f, 1.9697060585021973f, -1891.633056640625f, -872.8853759765625f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-219.61876, -150.68037);
((GeneralPath)shape).curveTo(-219.61876, -150.68037, -219.61876, 327.65042, -219.61876, 327.65042);
((GeneralPath)shape).curveTo(-76.74459, 328.55087, 125.78146, 220.48074, 125.78138, 88.45424);
((GeneralPath)shape).curveTo(125.78138, -43.572304, -33.655437, -150.68036, -219.61876, -150.68037);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_1_1);
g.setComposite(AlphaComposite.getInstance(3, 0.40206185f * origAlpha));
AffineTransform defaultTransform__0_0_1_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1_2
paint = new RadialGradientPaint(new Point2D.Double(605.7142944335938, 486.64788818359375), 117.14286f, new Point2D.Double(605.7142944335938, 486.64788818359375), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-2.7743890285491943f, 0.0f, 0.0f, 1.9697060585021973f, 112.76229858398438f, -872.8853759765625f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-1559.2523, -150.68037);
((GeneralPath)shape).curveTo(-1559.2523, -150.68037, -1559.2523, 327.65042, -1559.2523, 327.65042);
((GeneralPath)shape).curveTo(-1702.1265, 328.55087, -1904.6525, 220.48074, -1904.6525, 88.45424);
((GeneralPath)shape).curveTo(-1904.6525, -43.572304, -1745.2157, -150.68036, -1559.2523, -150.68037);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_1_2);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new LinearGradientPaint(new Point2D.Double(64.57142639160156, 9.714285850524902), new Point2D.Double(72.85713958740234, 40.85714340209961), new float[] {0.0f,1.0f}, new Color[] {new Color(223, 223, 223, 255),new Color(192, 192, 192, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.008510947227478f, 0.0f, 0.0f, 1.0f, -47.595760345458984f, -0.2857140004634857f));
shape = new RoundRectangle2D.Double(6.575687408447266, 9.428571701049805, 32.8486442565918, 31.14285659790039, 2.8571441173553467, 2.857142925262451);
g.setPaint(paint);
g.fill(shape);
paint = new Color(96, 96, 96, 255);
stroke = new BasicStroke(1.0000001f,0,0,4.0f,null,0.0f);
shape = new RoundRectangle2D.Double(6.575687408447266, 9.428571701049805, 32.8486442565918, 31.14285659790039, 2.8571441173553467, 2.857142925262451);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
paint = new Color(164, 0, 0, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(38.857143, 22.756128);
((GeneralPath)shape).lineTo(38.857143, 39.1847);
((GeneralPath)shape).curveTo(38.857143, 39.659557, 38.49401, 40.041843, 38.042946, 40.041843);
((GeneralPath)shape).lineTo(15.874474, 40.041843);
((GeneralPath)shape).lineTo(15.923863, 22.756128);
((GeneralPath)shape).curveTo(15.923863, 22.756128, 38.857143, 22.756128, 38.857143, 22.756128);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_4
paint = new Color(96, 96, 96, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,new float[] {1.0f,1.0f},0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(15.379549, 11.285714);
((GeneralPath)shape).lineTo(15.379549, 39.285713);
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new Color(240, 240, 240, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(38.857143, 22.613274);
((GeneralPath)shape).lineTo(38.857143, 11.470414);
((GeneralPath)shape).curveTo(38.857143, 10.995557, 38.49401, 10.613271, 38.042946, 10.613271);
((GeneralPath)shape).lineTo(15.874474, 10.613271);
((GeneralPath)shape).lineTo(15.923863, 22.613274);
((GeneralPath)shape).curveTo(15.923863, 22.613274, 38.857143, 22.613274, 38.857143, 22.613274);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 0.62566847f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new LinearGradientPaint(new Point2D.Double(19.36253547668457, 11.31242847442627), new Point2D.Double(19.323766708374023, 0.5037946105003357), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -2.0f, 0.0f));
stroke = new BasicStroke(0.99999994f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(11.512932, 6.5274687);
((GeneralPath)shape).curveTo(11.512932, 6.5274687, 34.285046, 6.5274687, 34.285046, 6.5274687);
((GeneralPath)shape).curveTo(34.285046, 6.5274687, 38.542046, 10.784467, 38.542046, 10.784467);
((GeneralPath)shape).lineTo(38.542046, 39.215523);
((GeneralPath)shape).curveTo(38.542046, 39.50329, 38.31038, 39.73496, 38.022614, 39.73496);
((GeneralPath)shape).lineTo(7.977398, 39.73496);
((GeneralPath)shape).curveTo(7.6896315, 39.73496, 7.457964, 39.50329, 7.457964, 39.215523);
((GeneralPath)shape).lineTo(7.457964, 10.784467);
((GeneralPath)shape).curveTo(7.457964, 10.784467, 11.512932, 6.5274687, 11.512932, 6.5274687);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.9999970197677612f, -0.2857140004634857f));
// _0_0_7
g.setComposite(AlphaComposite.getInstance(3, 0.62566847f * origAlpha));
AffineTransform defaultTransform__0_0_7_0 = g.getTransform();
g.transform(new AffineTransform(0.5502399802207947f, 0.0f, 0.0f, 0.5502399802207947f, 19.897260665893555f, 20.623210906982422f));
// _0_0_7_0
paint = new RadialGradientPaint(new Point2D.Double(24.546707153320312, 37.595428466796875), 22.728432f, new Point2D.Double(24.546707153320312, 37.595428466796875), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.33333298563957214f, 1.1215640334592391E-14f, 25.06361961364746f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(47.27514, 37.59543);
((GeneralPath)shape).curveTo(47.27514, 41.779617, 37.099274, 45.171574, 24.546707, 45.171574);
((GeneralPath)shape).curveTo(11.994141, 45.171574, 1.8182755, 41.779617, 1.8182755, 37.59543);
((GeneralPath)shape).curveTo(1.8182755, 33.41124, 11.994141, 30.019283, 24.546707, 30.019283);
((GeneralPath)shape).curveTo(37.099274, 30.019283, 47.27514, 33.41124, 47.27514, 37.59543);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -1.6428569555282593f, -2.642857074737549f));
// _0_0_7_1
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7_1_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7_1_0
paint = new LinearGradientPaint(new Point2D.Double(14.996600151062012, 11.18850040435791), new Point2D.Double(32.51100158691406, 34.307498931884766), new float[] {0.0f,0.5f,1.0f}, new Color[] {new Color(235, 235, 235, 255),new Color(255, 255, 255, 255),new Color(235, 235, 235, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.6831449866294861f, 0.0f, 0.0f, 0.6831449866294861f, 18.555810928344727f, 18.128860473632812f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(34.95129, 21.954475);
((GeneralPath)shape).curveTo(28.32478, 21.954475, 22.996246, 27.283009, 22.996246, 33.909515);
((GeneralPath)shape).curveTo(22.996246, 40.536026, 28.32478, 45.86456, 34.95129, 45.86456);
((GeneralPath)shape).curveTo(41.5778, 45.86456, 46.90633, 40.536026, 46.90633, 33.909515);
((GeneralPath)shape).curveTo(46.90633, 27.283009, 41.5778, 21.954475, 34.95129, 21.954475);
((GeneralPath)shape).lineTo(34.95129, 21.954475);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(34.95129, 36.77873);
((GeneralPath)shape).curveTo(33.380054, 36.77873, 32.08208, 35.48075, 32.08208, 33.909515);
((GeneralPath)shape).curveTo(32.08208, 32.338284, 33.380054, 31.040306, 34.95129, 31.040306);
((GeneralPath)shape).curveTo(36.522522, 31.040306, 37.8205, 32.338284, 37.8205, 33.909515);
((GeneralPath)shape).curveTo(37.8205, 35.48075, 36.522522, 36.77873, 34.95129, 36.77873);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7_1_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7_1_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7_1_1
paint = new LinearGradientPaint(new Point2D.Double(12.274399757385254, 32.416500091552734), new Point2D.Double(35.39120101928711, 14.203300476074219), new float[] {0.0f,0.5f,1.0f}, new Color[] {new Color(251, 251, 251, 255),new Color(182, 182, 182, 255),new Color(228, 228, 228, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7053080201148987f, 0.0f, 0.0f, 0.7053080201148987f, 18.0239200592041f, 17.616920471191406f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(34.951305, 21.566645);
((GeneralPath)shape).curveTo(28.10982, 21.566645, 22.608418, 27.068045, 22.608418, 33.90953);
((GeneralPath)shape).curveTo(22.608418, 40.75102, 28.10982, 46.25242, 34.951305, 46.25242);
((GeneralPath)shape).curveTo(41.792793, 46.25242, 47.294193, 40.75102, 47.294193, 33.90953);
((GeneralPath)shape).curveTo(47.294193, 27.068045, 41.792793, 21.566645, 34.951305, 21.566645);
((GeneralPath)shape).lineTo(34.951305, 21.566645);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(34.951305, 36.871822);
((GeneralPath)shape).curveTo(33.329098, 36.871822, 31.989012, 35.53174, 31.989012, 33.90953);
((GeneralPath)shape).curveTo(31.989012, 32.287323, 33.329098, 30.947239, 34.951305, 30.947239);
((GeneralPath)shape).curveTo(36.573513, 30.947239, 37.913597, 32.287323, 37.913597, 33.90953);
((GeneralPath)shape).curveTo(37.913597, 35.53174, 36.573513, 36.871822, 34.951305, 36.871822);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(128, 128, 128, 255);
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(34.951305, 21.566645);
((GeneralPath)shape).curveTo(28.10982, 21.566645, 22.608418, 27.068045, 22.608418, 33.90953);
((GeneralPath)shape).curveTo(22.608418, 40.75102, 28.10982, 46.25242, 34.951305, 46.25242);
((GeneralPath)shape).curveTo(41.792793, 46.25242, 47.294193, 40.75102, 47.294193, 33.90953);
((GeneralPath)shape).curveTo(47.294193, 27.068045, 41.792793, 21.566645, 34.951305, 21.566645);
((GeneralPath)shape).lineTo(34.951305, 21.566645);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(34.951305, 36.871822);
((GeneralPath)shape).curveTo(33.329098, 36.871822, 31.989012, 35.53174, 31.989012, 33.90953);
((GeneralPath)shape).curveTo(31.989012, 32.287323, 33.329098, 30.947239, 34.951305, 30.947239);
((GeneralPath)shape).curveTo(36.573513, 30.947239, 37.913597, 32.287323, 37.913597, 33.90953);
((GeneralPath)shape).curveTo(37.913597, 35.53174, 36.573513, 36.871822, 34.951305, 36.871822);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_7_1_1);
g.setComposite(AlphaComposite.getInstance(3, 0.10999996f * origAlpha));
AffineTransform defaultTransform__0_0_7_1_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7_1_2
paint = new Color(0, 0, 0, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(34.95129, 28.111322);
((GeneralPath)shape).curveTo(31.713337, 28.111322, 29.153095, 30.746866, 29.153095, 33.909515);
((GeneralPath)shape).curveTo(29.153095, 37.147472, 31.788637, 39.70771, 34.95129, 39.70771);
((GeneralPath)shape).curveTo(38.189243, 39.70771, 40.749485, 37.07217, 40.749485, 33.909515);
((GeneralPath)shape).curveTo(40.749485, 30.671564, 38.11394, 28.111322, 34.95129, 28.111322);
((GeneralPath)shape).lineTo(34.95129, 28.111322);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(34.95129, 37.07217);
((GeneralPath)shape).curveTo(33.21936, 37.07217, 31.788637, 35.641445, 31.788637, 33.909515);
((GeneralPath)shape).curveTo(31.788637, 32.17759, 33.21936, 30.746866, 34.95129, 30.746866);
((GeneralPath)shape).curveTo(36.683216, 30.746866, 38.11394, 32.17759, 38.11394, 33.909515);
((GeneralPath)shape).curveTo(38.11394, 35.641445, 36.683216, 37.07217, 34.95129, 37.07217);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7_1_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7_1_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7_1_3
paint = new LinearGradientPaint(new Point2D.Double(21.125, 14.625), new Point2D.Double(29.0, 28.0), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 83),new Color(255, 255, 255, 154)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7173020243644714f, 0.0f, 0.0f, 0.7173020243644714f, 17.73603057861328f, 18.069089889526367f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(38.15052, 22.816711);
((GeneralPath)shape).lineTo(36.086643, 30.847437);
((GeneralPath)shape).curveTo(36.732044, 31.019312, 37.24818, 31.418678, 37.59879, 31.97133);
((GeneralPath)shape).lineTo(44.709965, 27.639233);
((GeneralPath)shape).curveTo(43.255135, 25.269428, 40.920193, 23.525894, 38.15052, 22.816711);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7_1_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7_1_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7_1_4
paint = new LinearGradientPaint(new Point2D.Double(21.125, 14.625), new Point2D.Double(29.0, 28.0), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 83),new Color(255, 255, 255, 154)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.7173020243644714f, 0.0f, 0.0f, 0.7173020243644714f, 17.73603057861328f, 18.069089889526367f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(30.911911, 44.67827);
((GeneralPath)shape).lineTo(33.6292, 36.844463);
((GeneralPath)shape).curveTo(33.00012, 36.6201, 32.51857, 36.179638, 32.214596, 35.600025);
((GeneralPath)shape).lineTo(24.771257, 39.33267);
((GeneralPath)shape).curveTo(26.026281, 41.814083, 28.209936, 43.743725, 30.911911, 44.67827);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7_1_4);
g.setComposite(AlphaComposite.getInstance(3, 0.5464481f * origAlpha));
AffineTransform defaultTransform__0_0_7_1_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7_1_5
paint = new LinearGradientPaint(new Point2D.Double(10.501720428466797, 3.610016107559204), new Point2D.Double(48.798885345458984, 54.698482513427734), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.5738419890403748f, 0.0f, 0.0f, 0.5738419890403748f, 20.979949951171875f, 19.5634708404541f));
stroke = new BasicStroke(1.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(34.951286, 22.548803);
((GeneralPath)shape).curveTo(28.654207, 22.548803, 23.590574, 27.612434, 23.590574, 33.909515);
((GeneralPath)shape).curveTo(23.590574, 40.206596, 28.654207, 45.270226, 34.951286, 45.270226);
((GeneralPath)shape).curveTo(41.248367, 45.270226, 46.312, 40.206596, 46.312, 33.909515);
((GeneralPath)shape).curveTo(46.312, 27.612434, 41.248367, 22.548803, 34.951286, 22.548803);
((GeneralPath)shape).lineTo(34.951286, 22.548803);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_7_1_5);
g.setComposite(AlphaComposite.getInstance(3, 0.6721311f * origAlpha));
AffineTransform defaultTransform__0_0_7_1_6 = g.getTransform();
g.transform(new AffineTransform(0.5738419890403748f, 0.0f, 0.0f, 0.5738419890403748f, 21.03067970275879f, 19.61418914794922f));
// _0_0_7_1_6
paint = new LinearGradientPaint(new Point2D.Double(28.702884674072266, 31.494707107543945), new Point2D.Double(17.74272918701172, 18.366575241088867), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(1.6215941f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(30.40559, 24.930641);
((GeneralPath)shape).curveTo(30.40559, 28.298914, 27.675066, 31.029438, 24.306793, 31.029438);
((GeneralPath)shape).curveTo(20.938522, 31.029438, 18.207998, 28.298914, 18.207998, 24.930641);
((GeneralPath)shape).curveTo(18.207998, 21.562368, 20.938522, 18.831844, 24.306793, 18.831844);
((GeneralPath)shape).curveTo(27.675066, 18.831844, 30.40559, 21.562368, 30.40559, 24.930641);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_7_1_6);
g.setComposite(AlphaComposite.getInstance(3, 0.11428566f * origAlpha));
AffineTransform defaultTransform__0_0_7_1_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7_1_7
paint = new RadialGradientPaint(new Point2D.Double(37.751468658447266, 27.56916618347168), 21.333334f, new Point2D.Double(37.751468658447266, 27.56916618347168), new float[] {0.0f,0.5f,1.0f}, new Color[] {new Color(255, 243, 7, 255),new Color(22, 110, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.4417459964752197f, 0.4986549913883209f, -0.4070979952812195f, 0.3606239855289459f, 32.00754928588867f, 10.213080406188965f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(34.95129, 23.065643);
((GeneralPath)shape).curveTo(28.940683, 23.065643, 24.107414, 27.898912, 24.107414, 33.909515);
((GeneralPath)shape).curveTo(24.107414, 39.92012, 28.940683, 44.75339, 34.95129, 44.75339);
((GeneralPath)shape).curveTo(40.961895, 44.75339, 45.795162, 39.92012, 45.795162, 33.909515);
((GeneralPath)shape).curveTo(45.795162, 27.898912, 40.961895, 23.065643, 34.95129, 23.065643);
((GeneralPath)shape).lineTo(34.95129, 23.065643);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(34.95129, 36.512047);
((GeneralPath)shape).curveTo(33.526093, 36.512047, 32.34876, 35.334713, 32.34876, 33.909515);
((GeneralPath)shape).curveTo(32.34876, 32.48432, 33.526093, 31.306988, 34.95129, 31.306988);
((GeneralPath)shape).curveTo(36.376484, 31.306988, 37.553818, 32.48432, 37.553818, 33.909515);
((GeneralPath)shape).curveTo(37.553818, 35.334713, 36.376484, 36.512047, 34.95129, 36.512047);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7_1_7);
g.setTransform(defaultTransform__0_0_7_1);
g.setTransform(defaultTransform__0_0_7);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 3;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 6;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 43;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 41;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public SystemInstallerSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

