package org.freedesktop.tango.categories;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class ApplicationsSystemSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.1863800287246704f, 0.0f, 0.0f, 1.1863800287246704f, -4.539687156677246f, -7.794678211212158f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(14.287617683410645, 68.87297058105469), 11.68987f, new Point2D.Double(14.287617683410645, 72.56800079345703), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 83),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.399258017539978f, -2.2344450201217114E-7f, 8.196177958552653E-8f, 0.513264000415802f, 4.365074157714844f, 4.839284896850586f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(44.285713, 38.714287);
((GeneralPath)shape).curveTo(44.287918, 42.22952, 40.490032, 45.478195, 34.323208, 47.236126);
((GeneralPath)shape).curveTo(28.156382, 48.994057, 20.557903, 48.994057, 14.391077, 47.236126);
((GeneralPath)shape).curveTo(8.224251, 45.478195, 4.4263687, 42.22952, 4.4285717, 38.714287);
((GeneralPath)shape).curveTo(4.4263687, 35.199055, 8.224251, 31.950378, 14.391077, 30.192446);
((GeneralPath)shape).curveTo(20.557903, 28.434515, 28.156382, 28.434515, 34.323208, 30.192446);
((GeneralPath)shape).curveTo(40.490032, 31.950378, 44.287918, 35.199055, 44.285713, 38.714287);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setTransform(defaultTransform__0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_1_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1_0
paint = new LinearGradientPaint(new Point2D.Double(99.77729797363281, 15.423800468444824), new Point2D.Double(153.00050354003906, 248.631103515625), new float[] {0.0f,1.0f}, new Color[] {new Color(24, 67, 117, 255),new Color(200, 189, 220, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.20068499445915222f, 0.0f, 0.0f, 0.20068499445915222f, -54.335758209228516f, -1.0507869720458984f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(22.699526, 0.94746965);
((GeneralPath)shape).curveTo(22.22635, 0.9798452, 21.766438, 1.0531317, 21.301674, 1.1063164);
((GeneralPath)shape).lineTo(21.269903, 1.1063164);
((GeneralPath)shape).lineTo(20.157974, 7.1742673);
((GeneralPath)shape).curveTo(18.345621, 7.5870047, 16.640562, 8.287457, 15.106644, 9.239277);
((GeneralPath)shape).lineTo(10.118853, 5.6493373);
((GeneralPath)shape).curveTo(8.770521, 6.6961412, 7.543552, 7.917005, 6.465374, 9.239277);
((GeneralPath)shape).lineTo(9.928236, 14.290607);
((GeneralPath)shape).curveTo(8.876814, 15.89739, 8.086153, 17.732094, 7.640841, 19.659632);
((GeneralPath)shape).curveTo(7.640765, 19.668743, 7.640779, 19.689814, 7.640841, 19.6914);
((GeneralPath)shape).lineTo(1.60466, 20.644482);
((GeneralPath)shape).curveTo(1.494303, 21.54585, 1.445813, 22.477386, 1.445813, 23.408419);
((GeneralPath)shape).curveTo(1.445813, 24.170172, 1.466846, 24.921747, 1.541121, 25.664043);
((GeneralPath)shape).lineTo(7.577303, 26.744202);
((GeneralPath)shape).curveTo(8.0066, 28.840363, 8.822112, 30.797987, 9.960006, 32.52623);
((GeneralPath)shape).lineTo(6.370066, 37.45048);
((GeneralPath)shape).curveTo(7.398201, 38.726868, 8.585171, 39.88896, 9.864698, 40.91334);
((GeneralPath)shape).lineTo(14.947798, 37.418713);
((GeneralPath)shape).curveTo(16.724274, 38.551956, 18.707342, 39.346603, 20.856901, 39.737877);
((GeneralPath)shape).lineTo(21.809982, 45.742287);
((GeneralPath)shape).curveTo(22.487238, 45.803936, 23.181759, 45.80583, 23.874992, 45.80583);
((GeneralPath)shape).curveTo(24.853678, 45.805824, 25.788511, 45.768738, 26.734236, 45.64698);
((GeneralPath)shape).lineTo(27.877934, 39.51549);
((GeneralPath)shape).curveTo(29.91886, 39.007587, 31.836111, 38.12649, 33.501114, 36.942173);
((GeneralPath)shape).lineTo(38.393597, 40.500343);
((GeneralPath)shape).curveTo(39.662365, 39.4209, 40.822582, 38.180153, 41.824688, 36.846863);
((GeneralPath)shape).lineTo(38.266518, 31.700226);
((GeneralPath)shape).curveTo(39.230125, 30.036028, 39.897816, 28.19986, 40.23622, 26.235891);
((GeneralPath)shape).lineTo(46.24063, 25.28281);
((GeneralPath)shape).curveTo(46.29329, 24.656221, 46.30417, 24.048546, 46.30417, 23.408419);
((GeneralPath)shape).curveTo(46.30417, 22.296019, 46.174873, 21.205317, 46.018246, 20.136171);
((GeneralPath)shape).lineTo(39.918526, 19.024244);
((GeneralPath)shape).curveTo(39.440517, 17.259165, 38.656216, 15.612364, 37.662903, 14.13176);
((GeneralPath)shape).lineTo(41.25284, 9.207507);
((GeneralPath)shape).curveTo(40.140076, 7.8466525, 38.870716, 6.589526, 37.472282, 5.5222597);
((GeneralPath)shape).lineTo(32.293877, 9.08043);
((GeneralPath)shape).curveTo(30.80555, 8.200202, 29.203897, 7.524816, 27.464931, 7.142498);
((GeneralPath)shape).lineTo(26.51185, 1.1063164);
((GeneralPath)shape).curveTo(25.64437, 1.0042729, 24.769749, 0.94746965, 23.874992, 0.94746965);
((GeneralPath)shape).curveTo(23.633165, 0.94746965, 23.384287, 0.93986064, 23.144297, 0.94746965);
((GeneralPath)shape).curveTo(23.027302, 0.9511791, 22.911526, 0.94066346, 22.794832, 0.94746965);
((GeneralPath)shape).curveTo(22.763227, 0.949313, 22.73107, 0.94531125, 22.699526, 0.94746965);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(23.52553, 16.387386);
((GeneralPath)shape).curveTo(23.641592, 16.381496, 23.757473, 16.387386, 23.874992, 16.387386);
((GeneralPath)shape).curveTo(27.635597, 16.387386, 30.705408, 19.457195, 30.705408, 23.217802);
((GeneralPath)shape).curveTo(30.705408, 26.978407, 27.635597, 30.016447, 23.874992, 30.016447);
((GeneralPath)shape).curveTo(20.114388, 30.016449, 17.076345, 26.978407, 17.076345, 23.217802);
((GeneralPath)shape).curveTo(17.076347, 19.574717, 19.927559, 16.569963, 23.52553, 16.387386);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(63, 69, 97, 255);
stroke = new BasicStroke(1.0f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(22.699526, 0.94746965);
((GeneralPath)shape).curveTo(22.22635, 0.9798452, 21.766438, 1.0531317, 21.301674, 1.1063164);
((GeneralPath)shape).lineTo(21.269903, 1.1063164);
((GeneralPath)shape).lineTo(20.157974, 7.1742673);
((GeneralPath)shape).curveTo(18.345621, 7.5870047, 16.640562, 8.287457, 15.106644, 9.239277);
((GeneralPath)shape).lineTo(10.118853, 5.6493373);
((GeneralPath)shape).curveTo(8.770521, 6.6961412, 7.543552, 7.917005, 6.465374, 9.239277);
((GeneralPath)shape).lineTo(9.928236, 14.290607);
((GeneralPath)shape).curveTo(8.876814, 15.89739, 8.086153, 17.732094, 7.640841, 19.659632);
((GeneralPath)shape).curveTo(7.640765, 19.668743, 7.640779, 19.689814, 7.640841, 19.6914);
((GeneralPath)shape).lineTo(1.60466, 20.644482);
((GeneralPath)shape).curveTo(1.494303, 21.54585, 1.445813, 22.477386, 1.445813, 23.408419);
((GeneralPath)shape).curveTo(1.445813, 24.170172, 1.466846, 24.921747, 1.541121, 25.664043);
((GeneralPath)shape).lineTo(7.577303, 26.744202);
((GeneralPath)shape).curveTo(8.0066, 28.840363, 8.822112, 30.797987, 9.960006, 32.52623);
((GeneralPath)shape).lineTo(6.370066, 37.45048);
((GeneralPath)shape).curveTo(7.398201, 38.726868, 8.585171, 39.88896, 9.864698, 40.91334);
((GeneralPath)shape).lineTo(14.947798, 37.418713);
((GeneralPath)shape).curveTo(16.724274, 38.551956, 18.707342, 39.346603, 20.856901, 39.737877);
((GeneralPath)shape).lineTo(21.809982, 45.742287);
((GeneralPath)shape).curveTo(22.487238, 45.803936, 23.181759, 45.80583, 23.874992, 45.80583);
((GeneralPath)shape).curveTo(24.853678, 45.805824, 25.788511, 45.768738, 26.734236, 45.64698);
((GeneralPath)shape).lineTo(27.877934, 39.51549);
((GeneralPath)shape).curveTo(29.91886, 39.007587, 31.836111, 38.12649, 33.501114, 36.942173);
((GeneralPath)shape).lineTo(38.393597, 40.500343);
((GeneralPath)shape).curveTo(39.662365, 39.4209, 40.822582, 38.180153, 41.824688, 36.846863);
((GeneralPath)shape).lineTo(38.266518, 31.700226);
((GeneralPath)shape).curveTo(39.230125, 30.036028, 39.897816, 28.19986, 40.23622, 26.235891);
((GeneralPath)shape).lineTo(46.24063, 25.28281);
((GeneralPath)shape).curveTo(46.29329, 24.656221, 46.30417, 24.048546, 46.30417, 23.408419);
((GeneralPath)shape).curveTo(46.30417, 22.296019, 46.174873, 21.205317, 46.018246, 20.136171);
((GeneralPath)shape).lineTo(39.918526, 19.024244);
((GeneralPath)shape).curveTo(39.440517, 17.259165, 38.656216, 15.612364, 37.662903, 14.13176);
((GeneralPath)shape).lineTo(41.25284, 9.207507);
((GeneralPath)shape).curveTo(40.140076, 7.8466525, 38.870716, 6.589526, 37.472282, 5.5222597);
((GeneralPath)shape).lineTo(32.293877, 9.08043);
((GeneralPath)shape).curveTo(30.80555, 8.200202, 29.203897, 7.524816, 27.464931, 7.142498);
((GeneralPath)shape).lineTo(26.51185, 1.1063164);
((GeneralPath)shape).curveTo(25.64437, 1.0042729, 24.769749, 0.94746965, 23.874992, 0.94746965);
((GeneralPath)shape).curveTo(23.633165, 0.94746965, 23.384287, 0.93986064, 23.144297, 0.94746965);
((GeneralPath)shape).curveTo(23.027302, 0.9511791, 22.911526, 0.94066346, 22.794832, 0.94746965);
((GeneralPath)shape).curveTo(22.763227, 0.949313, 22.73107, 0.94531125, 22.699526, 0.94746965);
((GeneralPath)shape).closePath();
((GeneralPath)shape).moveTo(23.52553, 16.387386);
((GeneralPath)shape).curveTo(23.641592, 16.381496, 23.757473, 16.387386, 23.874992, 16.387386);
((GeneralPath)shape).curveTo(27.635597, 16.387386, 30.705408, 19.457195, 30.705408, 23.217802);
((GeneralPath)shape).curveTo(30.705408, 26.978407, 27.635597, 30.016447, 23.874992, 30.016447);
((GeneralPath)shape).curveTo(20.114388, 30.016449, 17.076345, 26.978407, 17.076345, 23.217802);
((GeneralPath)shape).curveTo(17.076347, 19.574717, 19.927559, 16.569963, 23.52553, 16.387386);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_1_0);
g.setComposite(AlphaComposite.getInstance(3, 0.64772725f * origAlpha));
AffineTransform defaultTransform__0_1_1 = g.getTransform();
g.transform(new AffineTransform(0.6165980100631714f, 0.0f, 0.0f, 0.6165980100631714f, 9.382019996643066f, 8.539673805236816f));
// _0_1_1
paint = new Color(255, 255, 255, 255);
stroke = new BasicStroke(1.6218005f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.239223, 23.781593);
((GeneralPath)shape).curveTo(36.239223, 30.811031, 30.54074, 36.509514, 23.511301, 36.509514);
((GeneralPath)shape).curveTo(16.481863, 36.509514, 10.783379, 30.811031, 10.783379, 23.781593);
((GeneralPath)shape).curveTo(10.783379, 16.752155, 16.481863, 11.053671, 23.511301, 11.053671);
((GeneralPath)shape).curveTo(30.54074, 11.053671, 36.239223, 16.752155, 36.239223, 23.781593);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_1_1);
g.setComposite(AlphaComposite.getInstance(3, 0.34659088f * origAlpha));
AffineTransform defaultTransform__0_1_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1_2
paint = new Color(255, 255, 255, 255);
stroke = new BasicStroke(0.9999992f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(21.995808, 2.148467);
((GeneralPath)shape).lineTo(21.103024, 8.023524);
((GeneralPath)shape).curveTo(19.404255, 8.410395, 16.279442, 9.593603, 14.841657, 10.485771);
((GeneralPath)shape).lineTo(10.091975, 6.940627);
((GeneralPath)shape).curveTo(8.828145, 7.921826, 8.741474, 7.9883657, 7.730867, 9.227769);
((GeneralPath)shape).lineTo(11.165063, 14.320988);
((GeneralPath)shape).curveTo(10.179537, 15.827071, 8.995796, 18.510983, 8.570778, 20.42893);
((GeneralPath)shape).curveTo(8.570778, 20.42893, 2.552988, 21.443356, 2.552988, 21.443356);
((GeneralPath)shape).curveTo(2.449547, 22.288235, 2.49926, 24.096527, 2.56888, 24.792303);
((GeneralPath)shape).lineTo(8.317097, 25.82782);
((GeneralPath)shape).curveTo(8.71949, 27.79261, 10.225324, 30.955233, 11.291904, 32.57516);
((GeneralPath)shape).lineTo(7.656902, 37.37772);
((GeneralPath)shape).curveTo(8.620601, 38.57411, 8.813474, 38.68359, 10.01281, 39.64377);
((GeneralPath)shape).lineTo(14.873441, 36.082733);
((GeneralPath)shape).curveTo(16.538582, 37.144955, 19.84373, 38.43711, 21.85857, 38.80386);
((GeneralPath)shape).lineTo(22.6563, 44.604954);
((GeneralPath)shape).curveTo(23.29111, 44.662735, 25.044828, 44.824825, 25.931284, 44.7107);
((GeneralPath)shape).lineTo(26.824066, 38.67182);
((GeneralPath)shape).curveTo(28.737083, 38.195747, 32.042538, 36.838898, 33.60319, 35.728798);
((GeneralPath)shape).lineTo(38.458626, 39.236958);
((GeneralPath)shape).curveTo(39.647877, 38.225166, 39.65853, 38.07271, 40.597836, 36.82298);
((GeneralPath)shape).lineTo(36.999817, 31.708668);
((GeneralPath)shape).curveTo(37.90303, 30.148767, 39.070904, 27.098068, 39.388096, 25.257187);
((GeneralPath)shape).lineTo(45.279045, 24.279743);
((GeneralPath)shape).curveTo(45.3284, 23.692425, 45.330803, 22.054579, 45.18399, 21.052439);
((GeneralPath)shape).lineTo(39.18209, 20.016922);
((GeneralPath)shape).curveTo(38.73404, 18.362463, 37.19642, 15.381153, 36.265358, 13.993342);
((GeneralPath)shape).lineTo(40.080074, 9.190785);
((GeneralPath)shape).curveTo(39.037052, 7.915218, 38.64924, 7.7402005, 37.338448, 6.7398214);
((GeneralPath)shape).lineTo(32.313995, 10.337839);
((GeneralPath)shape).curveTo(30.918941, 9.512778, 28.137094, 8.255042, 26.507114, 7.896684);
((GeneralPath)shape).lineTo(25.619528, 2.148467);
((GeneralPath)shape).curveTo(24.806414, 2.0528188, 22.460487, 2.095292, 21.995808, 2.148467);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_1_2);
g.setComposite(AlphaComposite.getInstance(3, 0.5f * origAlpha));
AffineTransform defaultTransform__0_1_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1_3
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(10.102903, 6.2970657);
((GeneralPath)shape).curveTo(8.754569, 7.3438697, 8.165647, 7.971923, 7.0874686, 9.294194);
((GeneralPath)shape).lineTo(10.489927, 14.259153);
((GeneralPath)shape).curveTo(9.438507, 15.857755, 8.331628, 18.426113, 8.142386, 19.987705);
((GeneralPath)shape).curveTo(8.142386, 19.987705, 2.079886, 21.0319, 2.079886, 21.0319);
((GeneralPath)shape).curveTo(2.010913, 21.595257, 1.90625, 22.884804, 1.90625, 22.884804);
((GeneralPath)shape).lineTo(2.0830266, 24.447304);
((GeneralPath)shape).curveTo(2.5107567, 24.535639, 2.9231818, 24.617819, 3.3642766, 24.666054);
((GeneralPath)shape).lineTo(3.8642766, 23.134804);
((GeneralPath)shape).curveTo(4.2083178, 23.163279, 4.5439296, 23.197304, 4.895527, 23.197304);
((GeneralPath)shape).curveTo(5.2467346, 23.197304, 5.6139846, 23.163473, 5.958027, 23.134804);
((GeneralPath)shape).lineTo(6.426777, 24.666054);
((GeneralPath)shape).curveTo(6.868065, 24.617819, 7.3115487, 24.535639, 7.739277, 24.447304);
((GeneralPath)shape).lineTo(7.739277, 22.884804);
((GeneralPath)shape).curveTo(8.425034, 22.72518, 9.071278, 22.497046, 9.708027, 22.228554);
((GeneralPath)shape).lineTo(10.645527, 23.509804);
((GeneralPath)shape).curveTo(11.047878, 23.32771, 11.421123, 23.133984, 11.801777, 22.916054);
((GeneralPath)shape).lineTo(11.301777, 21.416054);
((GeneralPath)shape).curveTo(11.89901, 21.053802, 12.463529, 20.620707, 12.989277, 20.166054);
((GeneralPath)shape).lineTo(14.270527, 21.103554);
((GeneralPath)shape).curveTo(14.596162, 20.806973, 14.91164, 20.491692, 15.208027, 20.166054);
((GeneralPath)shape).lineTo(14.270527, 18.916054);
((GeneralPath)shape).curveTo(14.725373, 18.390305, 15.127027, 17.826172, 15.489277, 17.228554);
((GeneralPath)shape).lineTo(16.989277, 17.697304);
((GeneralPath)shape).curveTo(17.207209, 17.316456, 17.432571, 16.943209, 17.614277, 16.541054);
((GeneralPath)shape).lineTo(16.333027, 15.603553);
((GeneralPath)shape).curveTo(16.601517, 14.966804, 16.798016, 14.320561, 16.958027, 13.634803);
((GeneralPath)shape).lineTo(18.551777, 13.634803);
((GeneralPath)shape).curveTo(18.640112, 13.207076, 18.691236, 12.763591, 18.739277, 12.322303);
((GeneralPath)shape).lineTo(17.239277, 11.853553);
((GeneralPath)shape).curveTo(17.268139, 11.509705, 17.301777, 11.142456, 17.301777, 10.791053);
((GeneralPath)shape).curveTo(17.301777, 10.43965, 17.267754, 10.104039, 17.239277, 9.759804);
((GeneralPath)shape).lineTo(18.739277, 9.291054);
((GeneralPath)shape).curveTo(18.69373, 8.871166, 18.633686, 8.449055, 18.551777, 8.041054);
((GeneralPath)shape).curveTo(17.404348, 8.440354, 15.999117, 9.194173, 14.983265, 9.824524);
((GeneralPath)shape).lineTo(10.102903, 6.2970657);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_1_3);
g.setComposite(AlphaComposite.getInstance(3, 0.5f * origAlpha));
AffineTransform defaultTransform__0_1_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1_4
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(37.23664, 17.217754);
((GeneralPath)shape).curveTo(36.85286, 17.39913, 36.49, 17.60351, 36.123238, 17.813295);
((GeneralPath)shape).lineTo(36.692886, 19.548136);
((GeneralPath)shape).curveTo(35.995792, 19.970436, 35.338158, 20.467825, 34.725006, 20.998152);
((GeneralPath)shape).lineTo(33.2491, 19.910639);
((GeneralPath)shape).curveTo(32.869015, 20.256538, 32.507328, 20.618223, 32.161587, 20.998152);
((GeneralPath)shape).lineTo(33.2491, 22.474058);
((GeneralPath)shape).curveTo(32.718773, 23.087372, 32.221546, 23.745003, 31.799084, 24.441936);
((GeneralPath)shape).lineTo(31.255327, 24.260685);
((GeneralPath)shape).curveTo(31.207645, 24.960968, 31.01895, 25.62217, 30.737467, 26.228563);
((GeneralPath)shape).lineTo(30.841038, 26.306242);
((GeneralPath)shape).curveTo(30.527882, 27.048922, 30.27649, 27.83664, 30.090137, 28.636623);
((GeneralPath)shape).lineTo(28.61423, 28.636623);
((GeneralPath)shape).curveTo(28.477945, 28.722076, 28.343676, 28.821684, 28.199938, 28.895555);
((GeneralPath)shape).curveTo(28.121569, 29.310822, 28.065025, 29.712881, 28.018686, 30.138426);
((GeneralPath)shape).lineTo(29.77942, 30.708075);
((GeneralPath)shape).curveTo(29.746033, 31.10935, 29.727633, 31.515268, 29.727633, 31.925053);
((GeneralPath)shape).curveTo(29.72763, 32.33499, 29.746035, 32.740753, 29.77942, 33.14203);
((GeneralPath)shape).lineTo(28.018686, 33.711678);
((GeneralPath)shape).curveTo(28.074705, 34.226433, 28.148678, 34.74035, 28.251724, 35.239372);
((GeneralPath)shape).lineTo(30.090137, 35.213478);
((GeneralPath)shape).curveTo(30.218254, 35.763466, 30.393202, 36.32092, 30.582108, 36.844746);
((GeneralPath)shape).curveTo(31.327023, 36.557465, 32.05594, 36.21456, 32.731236, 35.80902);
((GeneralPath)shape).curveTo(32.31965, 34.59298, 32.083908, 33.279915, 32.083908, 31.925053);
((GeneralPath)shape).curveTo(32.083908, 26.72712, 35.37629, 22.288397, 39.98131, 20.58386);
((GeneralPath)shape).lineTo(38.893803, 20.402609);
((GeneralPath)shape).curveTo(38.671013, 19.579947, 38.382477, 18.774017, 38.013435, 18.020441);
((GeneralPath)shape).curveTo(38.002583, 17.998278, 37.99851, 17.96486, 37.98754, 17.94276);
((GeneralPath)shape).lineTo(37.935757, 17.890976);
((GeneralPath)shape).lineTo(37.23664, 17.217754);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_1_4);
g.setTransform(defaultTransform__0_1);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 1;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 1;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 48;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 48;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public ApplicationsSystemSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

