package org.freedesktop.tango.devices;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class AudioCardSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0
paint = new LinearGradientPaint(new Point2D.Double(5.162545204162598, 50.805511474609375), new Point2D.Double(26.171594619750977, 50.805477142333984), new float[] {0.0f,1.0f}, new Color[] {new Color(173, 173, 173, 255),new Color(116, 116, 116, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.4112639427185059f, 0.0f, 0.0f, 0.7085850238800049f, -1.517853021621704f, -5.016058921813965f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.0625, 5.5839467);
((GeneralPath)shape).curveTo(19.883144, 5.5839467, 15.987925, 6.392384, 12.75, 7.7401967);
((GeneralPath)shape).curveTo(12.091421, 7.430663, 11.40059, 7.1151967, 10.53125, 7.1151967);
((GeneralPath)shape).curveTo(8.30676, 7.1151967, 6.5, 8.3024435, 6.5, 9.771446);
((GeneralPath)shape).curveTo(6.5, 10.288319, 6.7696233, 10.76923, 7.15625, 11.177697);
((GeneralPath)shape).curveTo(4.934063, 13.221121, 3.625, 16.032282, 3.625, 18.6875);
((GeneralPath)shape).curveTo(3.625, 20.698502, 4.4230123, 22.411722, 5.75, 24.104473);
((GeneralPath)shape).curveTo(4.449857, 24.65442, 3.5625, 25.57239, 3.5625, 27.108915);
((GeneralPath)shape).curveTo(3.5625, 28.816578, 5.63286, 30.202665, 8.21875, 30.202665);
((GeneralPath)shape).curveTo(8.591862, 30.202665, 8.933265, 30.100925, 9.28125, 30.046415);
((GeneralPath)shape).curveTo(9.170531, 30.417048, 9.0625, 30.78535, 9.0625, 31.171415);
((GeneralPath)shape).curveTo(9.0625, 31.867205, 9.0625, 32.70786, 9.0625, 33.40365);
((GeneralPath)shape).curveTo(9.0625, 37.615414, 15.892816, 41.02865, 24.28125, 41.02865);
((GeneralPath)shape).curveTo(32.669685, 41.02865, 39.46875, 37.615414, 39.46875, 33.40365);
((GeneralPath)shape).curveTo(39.46875, 32.706165, 39.46875, 31.868898, 39.46875, 31.171415);
((GeneralPath)shape).curveTo(39.46875, 30.763094, 39.373062, 30.374844, 39.25, 29.983915);
((GeneralPath)shape).curveTo(39.77829, 30.120373, 40.33629, 30.202665, 40.9375, 30.202665);
((GeneralPath)shape).curveTo(43.523388, 30.202665, 45.713387, 28.816578, 45.713387, 27.108915);
((GeneralPath)shape).curveTo(45.713387, 25.260727, 44.352913, 24.237474, 42.59375, 23.791973);
((GeneralPath)shape).curveTo(43.7751, 22.177336, 44.46875, 20.577984, 44.46875, 18.6875);
((GeneralPath)shape).curveTo(44.46875, 16.24939, 43.337048, 13.647412, 41.4375, 11.708947);
((GeneralPath)shape).curveTo(42.19699, 11.224865, 42.6875, 10.523021, 42.6875, 9.771446);
((GeneralPath)shape).curveTo(42.6875, 8.3024435, 40.880737, 7.1151967, 38.65625, 7.1151967);
((GeneralPath)shape).curveTo(37.52379, 7.1151967, 36.513565, 7.4304996, 35.78125, 7.9276967);
((GeneralPath)shape).curveTo(32.45678, 6.46299, 28.436228, 5.5839467, 24.0625, 5.5839467);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(76, 76, 76, 255);
stroke = new BasicStroke(2.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.0625, 5.5839467);
((GeneralPath)shape).curveTo(19.883144, 5.5839467, 15.987925, 6.392384, 12.75, 7.7401967);
((GeneralPath)shape).curveTo(12.091421, 7.430663, 11.40059, 7.1151967, 10.53125, 7.1151967);
((GeneralPath)shape).curveTo(8.30676, 7.1151967, 6.5, 8.3024435, 6.5, 9.771446);
((GeneralPath)shape).curveTo(6.5, 10.288319, 6.7696233, 10.76923, 7.15625, 11.177697);
((GeneralPath)shape).curveTo(4.934063, 13.221121, 3.625, 16.032282, 3.625, 18.6875);
((GeneralPath)shape).curveTo(3.625, 20.698502, 4.4230123, 22.411722, 5.75, 24.104473);
((GeneralPath)shape).curveTo(4.449857, 24.65442, 3.5625, 25.57239, 3.5625, 27.108915);
((GeneralPath)shape).curveTo(3.5625, 28.816578, 5.63286, 30.202665, 8.21875, 30.202665);
((GeneralPath)shape).curveTo(8.591862, 30.202665, 8.933265, 30.100925, 9.28125, 30.046415);
((GeneralPath)shape).curveTo(9.170531, 30.417048, 9.0625, 30.78535, 9.0625, 31.171415);
((GeneralPath)shape).curveTo(9.0625, 31.867205, 9.0625, 32.70786, 9.0625, 33.40365);
((GeneralPath)shape).curveTo(9.0625, 37.615414, 15.892816, 41.02865, 24.28125, 41.02865);
((GeneralPath)shape).curveTo(32.669685, 41.02865, 39.46875, 37.615414, 39.46875, 33.40365);
((GeneralPath)shape).curveTo(39.46875, 32.706165, 39.46875, 31.868898, 39.46875, 31.171415);
((GeneralPath)shape).curveTo(39.46875, 30.763094, 39.373062, 30.374844, 39.25, 29.983915);
((GeneralPath)shape).curveTo(39.77829, 30.120373, 40.33629, 30.202665, 40.9375, 30.202665);
((GeneralPath)shape).curveTo(43.523388, 30.202665, 45.713387, 28.816578, 45.713387, 27.108915);
((GeneralPath)shape).curveTo(45.713387, 25.260727, 44.352913, 24.237474, 42.59375, 23.791973);
((GeneralPath)shape).curveTo(43.7751, 22.177336, 44.46875, 20.577984, 44.46875, 18.6875);
((GeneralPath)shape).curveTo(44.46875, 16.24939, 43.337048, 13.647412, 41.4375, 11.708947);
((GeneralPath)shape).curveTo(42.19699, 11.224865, 42.6875, 10.523021, 42.6875, 9.771446);
((GeneralPath)shape).curveTo(42.6875, 8.3024435, 40.880737, 7.1151967, 38.65625, 7.1151967);
((GeneralPath)shape).curveTo(37.52379, 7.1151967, 36.513565, 7.4304996, 35.78125, 7.9276967);
((GeneralPath)shape).curveTo(32.45678, 6.46299, 28.436228, 5.5839467, 24.0625, 5.5839467);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.33210599422454834f, -0.6464470028877258f));
// _0_0_1
paint = new RadialGradientPaint(new Point2D.Double(17.579761505126953, 47.40255355834961), 16.798437f, new Point2D.Double(17.579761505126953, 47.40255355834961), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.3575190305709839f, 0.0f, 0.0f, 0.7366380095481873f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(46.66905, 34.918526);
((GeneralPath)shape).curveTo(46.66905, 41.7527, 36.459263, 47.292892, 23.864855, 47.292892);
((GeneralPath)shape).curveTo(11.270447, 47.292892, 1.0606613, 41.7527, 1.0606613, 34.918526);
((GeneralPath)shape).curveTo(1.0606613, 28.08435, 11.270447, 22.544157, 23.864855, 22.544157);
((GeneralPath)shape).curveTo(36.459263, 22.544157, 46.66905, 28.08435, 46.66905, 34.918526);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new LinearGradientPaint(new Point2D.Double(5.162545204162598, 50.805511474609375), new Point2D.Double(26.171594619750977, 50.805477142333984), new float[] {0.0f,1.0f}, new Color[] {new Color(173, 173, 173, 255),new Color(116, 116, 116, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.4112639427185059f, 0.0f, 0.0f, 0.7085850238800049f, -1.517853021621704f, -6.8570427894592285f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.294647, 21.455458);
((GeneralPath)shape).curveTo(15.906213, 21.455458, 9.075897, 24.86869, 9.075897, 29.080458);
((GeneralPath)shape).curveTo(9.075897, 29.776245, 9.075897, 32.384666, 9.075897, 33.080456);
((GeneralPath)shape).curveTo(9.075897, 37.292225, 15.906213, 40.705456, 24.294647, 40.705456);
((GeneralPath)shape).curveTo(32.683083, 40.705456, 39.482147, 37.292225, 39.482147, 33.080456);
((GeneralPath)shape).curveTo(39.482147, 32.382973, 39.482147, 29.77794, 39.482147, 29.080458);
((GeneralPath)shape).curveTo(39.482147, 24.86869, 32.683083, 21.455458, 24.294647, 21.455458);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.48393499851226807f, -6.73473596572876f));
// _0_0_3
paint = new Color(255, 255, 255, 152);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(39.142857, 35.142857);
((GeneralPath)shape).curveTo(39.144176, 37.28682, 36.421623, 39.268158, 32.001064, 40.3403);
((GeneralPath)shape).curveTo(27.58051, 41.41244, 22.133778, 41.41244, 17.71322, 40.3403);
((GeneralPath)shape).curveTo(13.292664, 39.268158, 10.57011, 37.28682, 10.571429, 35.142857);
((GeneralPath)shape).curveTo(10.57011, 32.998894, 13.292664, 31.017553, 17.71322, 29.945412);
((GeneralPath)shape).curveTo(22.133778, 28.873272, 27.58051, 28.873272, 32.001064, 29.945412);
((GeneralPath)shape).curveTo(36.421623, 31.017553, 39.144176, 32.998894, 39.142857, 35.142857);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.6607109904289246f, -6.999899864196777f));
// _0_0_4
paint = new Color(175, 175, 175, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(39.142857, 35.142857);
((GeneralPath)shape).curveTo(39.144176, 37.28682, 36.421623, 39.268158, 32.001064, 40.3403);
((GeneralPath)shape).curveTo(27.58051, 41.41244, 22.133778, 41.41244, 17.71322, 40.3403);
((GeneralPath)shape).curveTo(13.292664, 39.268158, 10.57011, 37.28682, 10.571429, 35.142857);
((GeneralPath)shape).curveTo(10.57011, 32.998894, 13.292664, 31.017553, 17.71322, 29.945412);
((GeneralPath)shape).curveTo(22.133778, 28.873272, 27.58051, 28.873272, 32.001064, 29.945412);
((GeneralPath)shape).curveTo(36.421623, 31.017553, 39.144176, 32.998894, 39.142857, 35.142857);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_5
paint = new LinearGradientPaint(new Point2D.Double(6.88355016708374, 56.288612365722656), new Point2D.Double(16.294504165649414, 68.76666259765625), new float[] {0.0f,1.0f}, new Color[] {new Color(170, 170, 170, 255),new Color(80, 80, 80, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.7008800506591797f, 0.0f, 0.0f, 0.5879309773445129f, -1.3749959468841553f, -7.214285850524902f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.482147, 20.5);
((GeneralPath)shape).lineTo(37.76786, 30.071428);
((GeneralPath)shape).curveTo(31.910719, 34.785713, 18.33929, 35.07143, 10.910718, 30.214287);
((GeneralPath)shape).lineTo(5.1964326, 21.357143);
((GeneralPath)shape).lineTo(43.482147, 20.5);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new Color(115, 115, 115, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.0625, 6.306218);
((GeneralPath)shape).curveTo(12.785933, 6.306218, 3.625, 12.008361, 3.625, 19.056215);
((GeneralPath)shape).curveTo(3.625, 21.067217, 4.4230123, 22.957216, 5.75, 24.649965);
((GeneralPath)shape).curveTo(4.449857, 25.199915, 3.5625, 26.117882, 3.5625, 27.212465);
((GeneralPath)shape).curveTo(3.5625, 28.92013, 5.63286, 30.306217, 8.21875, 30.306215);
((GeneralPath)shape).curveTo(9.652973, 30.306215, 10.890466, 29.852324, 11.75, 29.181215);
((GeneralPath)shape).curveTo(15.181878, 30.813627, 19.420156, 31.837465, 24.0625, 31.837465);
((GeneralPath)shape).curveTo(29.019138, 31.837465, 33.49237, 30.674744, 37.03125, 28.837465);
((GeneralPath)shape).curveTo(37.860077, 29.70923, 39.264812, 30.306215, 40.9375, 30.306215);
((GeneralPath)shape).curveTo(43.523388, 30.306215, 45.625, 28.92013, 45.625, 27.212465);
((GeneralPath)shape).curveTo(45.625, 25.894608, 44.352913, 24.782967, 42.59375, 24.337465);
((GeneralPath)shape).curveTo(43.7751, 22.722828, 44.46875, 20.9467, 44.46875, 19.056215);
((GeneralPath)shape).curveTo(44.46875, 12.008362, 35.339066, 6.3062177, 24.0625, 6.306218);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -34.81182861328125f, -2.2261369228363037f));
// _0_0_7
paint = new Color(203, 203, 203, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(47.729706, 28.819729);
((GeneralPath)shape).curveTo(47.73046, 29.925295, 46.83775, 30.947094, 45.388027, 31.500021);
((GeneralPath)shape).curveTo(43.9383, 32.052948, 42.151947, 32.052948, 40.70222, 31.500021);
((GeneralPath)shape).curveTo(39.2525, 30.947094, 38.359787, 29.925295, 38.360542, 28.819729);
((GeneralPath)shape).curveTo(38.359787, 27.714163, 39.2525, 26.692364, 40.70222, 26.139437);
((GeneralPath)shape).curveTo(42.151947, 25.58651, 43.9383, 25.58651, 45.388027, 26.139437);
((GeneralPath)shape).curveTo(46.83775, 26.692364, 47.73046, 27.714163, 47.729706, 28.819729);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(0.8602420091629028f, 0.0f, 0.0f, 0.8602420091629028f, -26.510379791259766f, -14.90546989440918f));
// _0_0_8
paint = new Color(203, 203, 203, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(47.729706, 28.819729);
((GeneralPath)shape).curveTo(47.73046, 29.925295, 46.83775, 30.947094, 45.388027, 31.500021);
((GeneralPath)shape).curveTo(43.9383, 32.052948, 42.151947, 32.052948, 40.70222, 31.500021);
((GeneralPath)shape).curveTo(39.2525, 30.947094, 38.359787, 29.925295, 38.360542, 28.819729);
((GeneralPath)shape).curveTo(38.359787, 27.714163, 39.2525, 26.692364, 40.70222, 26.139437);
((GeneralPath)shape).curveTo(42.151947, 25.58651, 43.9383, 25.58651, 45.388027, 26.139437);
((GeneralPath)shape).curveTo(46.83775, 26.692364, 47.73046, 27.714163, 47.729706, 28.819729);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_8);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_9 = g.getTransform();
g.transform(new AffineTransform(1.1171870231628418f, 0.0f, 0.0f, 1.1171870231628418f, -4.5145039558410645f, -8.04507827758789f));
// _0_0_9
paint = new Color(203, 203, 203, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.857143, 23.714285);
((GeneralPath)shape).curveTo(43.857143, 30.026112, 35.67035, 35.142857, 25.571428, 35.142857);
((GeneralPath)shape).curveTo(15.4725065, 35.142857, 7.285713, 30.026112, 7.285713, 23.714285);
((GeneralPath)shape).curveTo(7.285713, 17.402458, 15.4725065, 12.285713, 25.571428, 12.285713);
((GeneralPath)shape).curveTo(35.67035, 12.285713, 43.857143, 17.402458, 43.857143, 23.714285);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_9);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_10 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -2.104706048965454f, -2.2261369228363037f));
// _0_0_10
paint = new Color(203, 203, 203, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(47.729706, 28.819729);
((GeneralPath)shape).curveTo(47.73046, 29.925295, 46.83775, 30.947094, 45.388027, 31.500021);
((GeneralPath)shape).curveTo(43.9383, 32.052948, 42.151947, 32.052948, 40.70222, 31.500021);
((GeneralPath)shape).curveTo(39.2525, 30.947094, 38.359787, 29.925295, 38.360542, 28.819729);
((GeneralPath)shape).curveTo(38.359787, 27.714163, 39.2525, 26.692364, 40.70222, 26.139437);
((GeneralPath)shape).curveTo(42.151947, 25.58651, 43.9383, 25.58651, 45.388027, 26.139437);
((GeneralPath)shape).curveTo(46.83775, 26.692364, 47.73046, 27.714163, 47.729706, 28.819729);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_10);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_11 = g.getTransform();
g.transform(new AffineTransform(0.8602420091629028f, 0.0f, 0.0f, 0.8602420091629028f, 1.6256589889526367f, -14.90546989440918f));
// _0_0_11
paint = new Color(203, 203, 203, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(47.729706, 28.819729);
((GeneralPath)shape).curveTo(47.73046, 29.925295, 46.83775, 30.947094, 45.388027, 31.500021);
((GeneralPath)shape).curveTo(43.9383, 32.052948, 42.151947, 32.052948, 40.70222, 31.500021);
((GeneralPath)shape).curveTo(39.2525, 30.947094, 38.359787, 29.925295, 38.360542, 28.819729);
((GeneralPath)shape).curveTo(38.359787, 27.714163, 39.2525, 26.692364, 40.70222, 26.139437);
((GeneralPath)shape).curveTo(42.151947, 25.58651, 43.9383, 25.58651, 45.388027, 26.139437);
((GeneralPath)shape).curveTo(46.83775, 26.692364, 47.73046, 27.714163, 47.729706, 28.819729);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_11);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_12 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -1.517853021621704f, -5.266058921813965f));
// _0_0_12
paint = new RadialGradientPaint(new Point2D.Double(25.940555572509766, 41.70638656616211), 26.594908f, new Point2D.Double(25.940555572509766, 41.70638656616211), new float[] {0.0f,1.0f}, new Color[] {new Color(173, 173, 173, 255),new Color(116, 116, 116, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.3479249477386475f, 0.0f, 0.0f, 0.7418810129165649f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.857143, 23.714285);
((GeneralPath)shape).curveTo(43.857143, 30.026112, 35.67035, 35.142857, 25.571428, 35.142857);
((GeneralPath)shape).curveTo(15.4725065, 35.142857, 7.285713, 30.026112, 7.285713, 23.714285);
((GeneralPath)shape).curveTo(7.285713, 17.402458, 15.4725065, 12.285713, 25.571428, 12.285713);
((GeneralPath)shape).curveTo(35.67035, 12.285713, 43.857143, 17.402458, 43.857143, 23.714285);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_12);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_13 = g.getTransform();
g.transform(new AffineTransform(0.9012359976768494f, 0.0f, 0.0f, 1.0281699895858765f, 0.5526440143585205f, -6.002357006072998f));
// _0_0_13
paint = new RadialGradientPaint(new Point2D.Double(16.33121109008789, 34.83351135253906), 15.231354f, new Point2D.Double(16.33121109008789, 34.83351135253906), new float[] {0.0f,1.0f}, new Color[] {new Color(173, 173, 173, 255),new Color(116, 116, 116, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.3479249477386475f, 0.0f, 0.0f, 0.7418810129165649f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(35.42857, 28.071428);
((GeneralPath)shape).curveTo(35.42857, 30.872301, 31.303194, 33.142857, 26.214283, 33.142857);
((GeneralPath)shape).curveTo(21.125374, 33.142857, 16.999998, 30.872301, 16.999998, 28.071428);
((GeneralPath)shape).curveTo(16.999998, 25.270555, 21.125374, 23.0, 26.214283, 23.0);
((GeneralPath)shape).curveTo(31.303194, 23.0, 35.42857, 25.270555, 35.42857, 28.071428);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_13);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_14 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_14
paint = new Color(255, 255, 255, 219);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(38.839287, 11.785714);
((GeneralPath)shape).curveTo(50.385742, 23.087751, 25.849808, 36.998737, 8.276786, 24.129463);
((GeneralPath)shape).curveTo(11.43565, 27.555058, 17.281734, 29.879463, 24.058037, 29.879463);
((GeneralPath)shape).curveTo(34.151752, 29.879463, 42.339287, 24.750534, 42.339287, 18.441963);
((GeneralPath)shape).curveTo(42.339287, 15.943648, 41.01813, 13.667046, 38.839287, 11.785714);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_14);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_15 = g.getTransform();
g.transform(new AffineTransform(0.7958269715309143f, 0.0f, 0.0f, 0.9477630257606506f, 9.51871109008789f, 3.2453360557556152f));
// _0_0_15
paint = new RadialGradientPaint(new Point2D.Double(30.873167037963867, 31.26536750793457), 3.2488604f, new Point2D.Double(30.873167037963867, 31.26536750793457), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(147, 147, 147, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.2875930070877075f, 0.0f, 0.0f, 0.7766429781913757f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.398678, 25.195807);
((GeneralPath)shape).curveTo(43.398678, 26.123302, 42.152134, 26.875185, 40.614445, 26.875185);
((GeneralPath)shape).curveTo(39.076756, 26.875185, 37.83021, 26.123302, 37.83021, 25.195807);
((GeneralPath)shape).curveTo(37.83021, 24.26831, 39.076756, 23.516428, 40.614445, 23.516428);
((GeneralPath)shape).curveTo(42.152134, 23.516428, 43.398678, 24.26831, 43.398678, 25.195807);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_15);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_16 = g.getTransform();
g.transform(new AffineTransform(0.7958269715309143f, 0.0f, 0.0f, 0.9477630257606506f, -24.912839889526367f, 3.2453360557556152f));
// _0_0_16
paint = new RadialGradientPaint(new Point2D.Double(30.873167037963867, 31.26536750793457), 3.2488604f, new Point2D.Double(30.873167037963867, 31.26536750793457), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(147, 147, 147, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.2875930070877075f, 0.0f, 0.0f, 0.7766429781913757f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.398678, 25.195807);
((GeneralPath)shape).curveTo(43.398678, 26.123302, 42.152134, 26.875185, 40.614445, 26.875185);
((GeneralPath)shape).curveTo(39.076756, 26.875185, 37.83021, 26.123302, 37.83021, 25.195807);
((GeneralPath)shape).curveTo(37.83021, 24.26831, 39.076756, 23.516428, 40.614445, 23.516428);
((GeneralPath)shape).curveTo(42.152134, 23.516428, 43.398678, 24.26831, 43.398678, 25.195807);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_16);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_17 = g.getTransform();
g.transform(new AffineTransform(0.6725940108299255f, 0.0f, 0.0f, 0.8010029792785645f, 12.185310363769531f, -11.027099609375f));
// _0_0_17
paint = new RadialGradientPaint(new Point2D.Double(30.873167037963867, 31.26536750793457), 3.2488604f, new Point2D.Double(30.873167037963867, 31.26536750793457), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(147, 147, 147, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.2875930070877075f, 0.0f, 0.0f, 0.7766429781913757f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.398678, 25.195807);
((GeneralPath)shape).curveTo(43.398678, 26.123302, 42.152134, 26.875185, 40.614445, 26.875185);
((GeneralPath)shape).curveTo(39.076756, 26.875185, 37.83021, 26.123302, 37.83021, 25.195807);
((GeneralPath)shape).curveTo(37.83021, 24.26831, 39.076756, 23.516428, 40.614445, 23.516428);
((GeneralPath)shape).curveTo(42.152134, 23.516428, 43.398678, 24.26831, 43.398678, 25.195807);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_17);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_18 = g.getTransform();
g.transform(new AffineTransform(0.6725940108299255f, 0.0f, 0.0f, 0.8010029792785645f, -17.56468963623047f, -11.027099609375f));
// _0_0_18
paint = new RadialGradientPaint(new Point2D.Double(30.873167037963867, 31.26536750793457), 3.2488604f, new Point2D.Double(30.873167037963867, 31.26536750793457), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(147, 147, 147, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.2875930070877075f, 0.0f, 0.0f, 0.7766429781913757f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(43.398678, 25.195807);
((GeneralPath)shape).curveTo(43.398678, 26.123302, 42.152134, 26.875185, 40.614445, 26.875185);
((GeneralPath)shape).curveTo(39.076756, 26.875185, 37.83021, 26.123302, 37.83021, 25.195807);
((GeneralPath)shape).curveTo(37.83021, 24.26831, 39.076756, 23.516428, 40.614445, 23.516428);
((GeneralPath)shape).curveTo(42.152134, 23.516428, 43.398678, 24.26831, 43.398678, 25.195807);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_18);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_19 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_19
paint = new LinearGradientPaint(new Point2D.Double(11.5623140335083, 8.080925941467285), new Point2D.Double(30.750120162963867, 53.65898513793945), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 155),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0725270509719849f, 0.0f, 0.0f, 0.9323779940605164f, 0.5f, 0.75f));
stroke = new BasicStroke(0.96009976f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.083696, 6.16755);
((GeneralPath)shape).curveTo(20.071098, 6.16755, 16.0813, 7.0687304, 12.972569, 8.362765);
((GeneralPath)shape).curveTo(12.340267, 8.065582, 11.677, 7.762703, 10.842347, 7.7627025);
((GeneralPath)shape).curveTo(8.7066145, 7.7627025, 7.0969453, 8.777578, 7.0969453, 10.187968);
((GeneralPath)shape).curveTo(7.0969453, 10.684216, 7.48081, 11.145939, 7.8520107, 11.538108);
((GeneralPath)shape).curveTo(5.718489, 13.499999, 4.0866585, 15.859547, 4.0866585, 18.408821);
((GeneralPath)shape).curveTo(4.0866585, 20.339582, 5.22783, 22.654171, 6.50187, 24.27938);
((GeneralPath)shape).curveTo(5.2536035, 24.807384, 4.0266523, 25.688725, 4.0266523, 26.739635);
((GeneralPath)shape).curveTo(4.0266523, 28.379162, 6.3894043, 29.709946, 8.872117, 29.709944);
((GeneralPath)shape).curveTo(9.230342, 29.709944, 9.558122, 29.612263, 9.892222, 29.559929);
((GeneralPath)shape).curveTo(9.785922, 29.915771, 9.6822, 30.26938, 9.6822, 30.640041);
((GeneralPath)shape).curveTo(9.6822, 31.308067, 9.6822, 32.133034, 9.6822, 32.80106);
((GeneralPath)shape).curveTo(9.6822, 36.844776, 16.239985, 40.12182, 24.293718, 40.121822);
((GeneralPath)shape).curveTo(32.347454, 40.121822, 38.875233, 36.844776, 38.875233, 32.80106);
((GeneralPath)shape).curveTo(38.875233, 32.13141, 38.875233, 31.309694, 38.875233, 30.640041);
((GeneralPath)shape).curveTo(38.875233, 30.24801, 38.783363, 29.875254, 38.66521, 29.499922);
((GeneralPath)shape).curveTo(39.17242, 29.630936, 39.708157, 29.709944, 40.28538, 29.709944);
((GeneralPath)shape).curveTo(42.768093, 29.709944, 45.160847, 28.379162, 45.160847, 26.739635);
((GeneralPath)shape).curveTo(45.160847, 25.47436, 43.564518, 24.407074, 41.875546, 23.97935);
((GeneralPath)shape).curveTo(43.009758, 22.429134, 43.92573, 20.223873, 43.92573, 18.408821);
((GeneralPath)shape).curveTo(43.92573, 16.067993, 42.589188, 13.909281, 40.76543, 12.048161);
((GeneralPath)shape).curveTo(41.494617, 11.583394, 41.965553, 10.909554, 41.965553, 10.187968);
((GeneralPath)shape).curveTo(41.965553, 8.777578, 40.855885, 7.762703, 38.720154, 7.7627025);
((GeneralPath)shape).curveTo(37.632877, 7.7627025, 36.66296, 8.065425, 35.959866, 8.542784);
((GeneralPath)shape).curveTo(32.76804, 7.136519, 28.282911, 6.1675496, 24.083696, 6.16755);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_19);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 2;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 5;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 47;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 43;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public AudioCardSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

