package org.freedesktop.tango.devices;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class BatterySvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0587519407272339f, 0.0f, 0.0f, 1.151258945465088f, -1.1159440279006958f, -10.276909828186035f));
// _0_0_0
paint = new RadialGradientPaint(new Point2D.Double(23.85714340209961, 40.0), 17.142857f, new Point2D.Double(23.85714340209961, 40.0), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.5f, -7.259030853354938E-15f, 20.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(41.0, 40.0);
((GeneralPath)shape).curveTo(41.0, 44.733868, 33.324883, 48.571426, 23.857143, 48.571426);
((GeneralPath)shape).curveTo(14.389405, 48.571426, 6.714287, 44.733868, 6.714287, 40.0);
((GeneralPath)shape).curveTo(6.714287, 35.266132, 14.389405, 31.428572, 23.857143, 31.428572);
((GeneralPath)shape).curveTo(33.324883, 31.428572, 41.0, 35.266132, 41.0, 40.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new LinearGradientPaint(new Point2D.Double(9.30305290222168, 26.71875), new Point2D.Double(38.826412200927734, 26.71875), new float[] {0.0f,0.25f,0.5f,1.0f}, new Color[] {new Color(126, 128, 122, 255),new Color(186, 187, 184, 255),new Color(165, 166, 163, 255),new Color(51, 52, 50, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -1.1428569450799841E-6f, -1.7142839431762695f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.937498, 7.191965);
((GeneralPath)shape).curveTo(16.078072, 7.191965, 9.6875, 9.994466, 9.687499, 13.441966);
((GeneralPath)shape).curveTo(9.687499, 13.689351, 9.687499, 36.309326, 9.687499, 36.566967);
((GeneralPath)shape).curveTo(9.687499, 40.014465, 16.078072, 42.816967, 23.937498, 42.816967);
((GeneralPath)shape).curveTo(31.796926, 42.816967, 38.441963, 40.014465, 38.441963, 36.566967);
((GeneralPath)shape).curveTo(38.441963, 36.362904, 38.441963, 13.646027, 38.441963, 13.441966);
((GeneralPath)shape).curveTo(38.441963, 9.994465, 31.796926, 7.191965, 23.937498, 7.191965);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new LinearGradientPaint(new Point2D.Double(25.06473159790039, 21.85714340209961), new Point2D.Double(25.20758819580078, 25.428571701049805), new float[] {0.0f,1.0f}, new Color[] {new Color(125, 75, 1, 255),new Color(83, 83, 83, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -1.1428569450799841E-6f, -1.7142839431762695f));
stroke = new BasicStroke(1.0f,0,0,10.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.937498, 7.191965);
((GeneralPath)shape).curveTo(16.078072, 7.191965, 9.6875, 9.994466, 9.687499, 13.441966);
((GeneralPath)shape).curveTo(9.687499, 13.689351, 9.687499, 36.309326, 9.687499, 36.566967);
((GeneralPath)shape).curveTo(9.687499, 40.014465, 16.078072, 42.816967, 23.937498, 42.816967);
((GeneralPath)shape).curveTo(31.796926, 42.816967, 38.441963, 40.014465, 38.441963, 36.566967);
((GeneralPath)shape).curveTo(38.441963, 36.362904, 38.441963, 13.646027, 38.441963, 13.441966);
((GeneralPath)shape).curveTo(38.441963, 9.994465, 31.796926, 7.191965, 23.937498, 7.191965);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new LinearGradientPaint(new Point2D.Double(10.116070747375488, 17.511775970458984), new Point2D.Double(38.01339340209961, 17.511775970458984), new float[] {0.0f,0.18691589f,0.43008122f,1.0f}, new Color[] {new Color(247, 148, 3, 255),new Color(253, 179, 67, 255),new Color(253, 183, 79, 255),new Color(143, 86, 1, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -1.1428569450799841E-6f, -1.7142839431762695f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.941292, 7.4484873);
((GeneralPath)shape).curveTo(16.316147, 7.4484873, 10.116071, 10.16745, 10.11607, 13.512182);
((GeneralPath)shape).curveTo(10.11607, 13.752193, 10.11607, 19.820066, 10.11607, 20.070026);
((GeneralPath)shape).curveTo(10.11607, 23.41476, 16.316147, 25.717924, 23.941292, 25.717924);
((GeneralPath)shape).curveTo(31.566439, 25.717924, 38.013393, 23.41476, 38.013393, 20.070026);
((GeneralPath)shape).curveTo(38.013393, 19.872047, 38.013393, 13.71016, 38.013393, 13.512182);
((GeneralPath)shape).curveTo(38.013393, 10.167449, 31.566437, 7.4484873, 23.941292, 7.4484873);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 0.5443038f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
paint = new LinearGradientPaint(new Point2D.Double(17.16009521484375, 14.00448226928711), new Point2D.Double(37.969398498535156, 56.57591247558594), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -1.1428569450799841E-6f, -1.7142839431762695f));
stroke = new BasicStroke(1.0f,0,0,10.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.946121, 7.971286);
((GeneralPath)shape).curveTo(16.618364, 7.971286, 10.660096, 10.584206, 10.660095, 13.798491);
((GeneralPath)shape).curveTo(10.660095, 14.029142, 10.660095, 35.68455, 10.660095, 35.924763);
((GeneralPath)shape).curveTo(10.660095, 39.13905, 16.618362, 41.75197, 23.946121, 41.75197);
((GeneralPath)shape).curveTo(31.27388, 41.75197, 37.4694, 39.13905, 37.4694, 35.924763);
((GeneralPath)shape).curveTo(37.4694, 35.734505, 37.4694, 13.988749, 37.4694, 13.798491);
((GeneralPath)shape).curveTo(37.4694, 10.584205, 31.273878, 7.971286, 23.946121, 7.971286);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.0372910499572754f, 0.0f, 0.0f, 0.9546189904212952f, -0.8949790000915527f, -0.07572056353092194f));
// _0_0_4
paint = new Color(254, 212, 150, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.857143, 14.071428);
((GeneralPath)shape).curveTo(36.857143, 17.108995, 31.100805, 19.571428, 24.0, 19.571428);
((GeneralPath)shape).curveTo(16.899197, 19.571428, 11.142858, 17.108995, 11.142858, 14.071428);
((GeneralPath)shape).curveTo(11.142858, 11.033862, 16.899197, 8.571428, 24.0, 8.571428);
((GeneralPath)shape).curveTo(31.100805, 8.571428, 36.857143, 11.033862, 36.857143, 14.071428);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new LinearGradientPaint(new Point2D.Double(24.0, 16.525081634521484), new Point2D.Double(24.0, 13.284961700439453), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(231, 230, 174, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(1.004927f,0,0,10.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.857143, 14.071428);
((GeneralPath)shape).curveTo(36.857143, 17.108995, 31.100805, 19.571428, 24.0, 19.571428);
((GeneralPath)shape).curveTo(16.899197, 19.571428, 11.142858, 17.108995, 11.142858, 14.071428);
((GeneralPath)shape).curveTo(11.142858, 11.033862, 16.899197, 8.571428, 24.0, 8.571428);
((GeneralPath)shape).curveTo(31.100805, 8.571428, 36.857143, 11.033862, 36.857143, 14.071428);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 0.65822786f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(0.363429993391037f, 0.0f, 0.0f, 0.363429993391037f, 15.4724702835083f, -4.118577003479004f));
// _0_0_5
paint = new RadialGradientPaint(new Point2D.Double(23.85714340209961, 40.0), 17.142857f, new Point2D.Double(23.85714340209961, 40.0), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.5f, -4.4036480598098546E-15f, 20.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(41.0, 40.0);
((GeneralPath)shape).curveTo(41.0, 44.733868, 33.324883, 48.571426, 23.857143, 48.571426);
((GeneralPath)shape).curveTo(14.389405, 48.571426, 6.714287, 44.733868, 6.714287, 40.0);
((GeneralPath)shape).curveTo(6.714287, 35.266132, 14.389405, 31.428572, 23.857143, 31.428572);
((GeneralPath)shape).curveTo(33.324883, 31.428572, 41.0, 35.266132, 41.0, 40.0);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new Color(252, 175, 62, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.889442, 6.465348);
((GeneralPath)shape).curveTo(21.886648, 6.465348, 19.25816, 7.179501, 19.25816, 8.058017);
((GeneralPath)shape).curveTo(19.25816, 8.1210575, 19.25816, 10.622022, 19.25816, 10.687676);
((GeneralPath)shape).curveTo(19.25816, 11.566192, 21.886648, 12.280345, 23.889442, 12.280345);
((GeneralPath)shape).curveTo(25.892239, 12.280345, 28.299858, 11.566192, 28.299858, 10.687676);
((GeneralPath)shape).curveTo(28.299858, 10.635676, 28.299858, 8.110017, 28.299858, 8.058017);
((GeneralPath)shape).curveTo(28.299858, 7.1795, 25.892239, 6.465348, 23.889442, 6.465348);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new Color(180, 108, 2, 255);
stroke = new BasicStroke(1.0f,0,0,10.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(23.889442, 6.465348);
((GeneralPath)shape).curveTo(21.886648, 6.465348, 19.25816, 7.179501, 19.25816, 8.058017);
((GeneralPath)shape).curveTo(19.25816, 8.1210575, 19.25816, 10.622022, 19.25816, 10.687676);
((GeneralPath)shape).curveTo(19.25816, 11.566192, 21.886648, 12.280345, 23.889442, 12.280345);
((GeneralPath)shape).curveTo(25.892239, 12.280345, 28.299858, 11.566192, 28.299858, 10.687676);
((GeneralPath)shape).curveTo(28.299858, 10.635676, 28.299858, 8.110017, 28.299858, 8.058017);
((GeneralPath)shape).curveTo(28.299858, 7.1795, 25.892239, 6.465348, 23.889442, 6.465348);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 0.49367085f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7
paint = new LinearGradientPaint(new Point2D.Double(16.071430206298828, 19.5), new Point2D.Double(15.785715103149414, 30.0), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.14285700023174286f, 0.9285709857940674f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(13.642858, 17.999998);
((GeneralPath)shape).lineTo(14.0, 34.785713);
((GeneralPath)shape).lineTo(18.571428, 36.071426);
((GeneralPath)shape).lineTo(18.428572, 19.357141);
((GeneralPath)shape).curveTo(18.428572, 19.357141, 20.5, 19.357141, 23.857143, 19.142857);
((GeneralPath)shape).curveTo(18.6414, 18.909782, 12.67377, 16.668177, 10.642858, 15.214285);
((GeneralPath)shape).curveTo(12.059757, 17.306461, 13.642858, 17.999998, 13.642858, 17.999998);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(0.2719790041446686f, 0.0f, 0.0f, 0.21661899983882904f, 17.270479202270508f, 5.4097418785095215f));
// _0_0_8
paint = new Color(254, 212, 150, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.857143, 14.071428);
((GeneralPath)shape).curveTo(36.857143, 17.108995, 31.100805, 19.571428, 24.0, 19.571428);
((GeneralPath)shape).curveTo(16.899197, 19.571428, 11.142858, 17.108995, 11.142858, 14.071428);
((GeneralPath)shape).curveTo(11.142858, 11.033862, 16.899197, 8.571428, 24.0, 8.571428);
((GeneralPath)shape).curveTo(31.100805, 8.571428, 36.857143, 11.033862, 36.857143, 14.071428);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
paint = new LinearGradientPaint(new Point2D.Double(24.0, 16.525081634521484), new Point2D.Double(24.0, 13.284961700439453), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(231, 230, 174, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(4.1198664f,0,0,10.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(36.857143, 14.071428);
((GeneralPath)shape).curveTo(36.857143, 17.108995, 31.100805, 19.571428, 24.0, 19.571428);
((GeneralPath)shape).curveTo(16.899197, 19.571428, 11.142858, 17.108995, 11.142858, 14.071428);
((GeneralPath)shape).curveTo(11.142858, 11.033862, 16.899197, 8.571428, 24.0, 8.571428);
((GeneralPath)shape).curveTo(31.100805, 8.571428, 36.857143, 11.033862, 36.857143, 14.071428);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_8);
g.setTransform(defaultTransform__0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_1
g.setTransform(defaultTransform__0_1);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 6;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 6;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 37;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 40;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public BatterySvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

