package org.freedesktop.tango.devices;

import java.awt.*;
import java.awt.geom.*;

/**
 * This class has been automatically generated using <a
 * href="https://flamingo.dev.java.net">Flamingo SVG transcoder</a>.
 */
public class InputGamingSvgIcon implements
		org.pushingpixels.flamingo.api.common.icon.ResizableIcon {
	/**
	 * Paints the transcoded SVG image on the specified graphics context. You
	 * can install a custom transformation on the graphics context to scale the
	 * image.
	 * 
	 * @param g
	 *            Graphics context.
	 */
	public static void paint(Graphics2D g) {
        Shape shape = null;
        Paint paint = null;
        Stroke stroke = null;
         
        float origAlpha = 1.0f;
        Composite origComposite = ((Graphics2D)g).getComposite();
        if (origComposite instanceof AlphaComposite) {
            AlphaComposite origAlphaComposite = 
                (AlphaComposite)origComposite;
            if (origAlphaComposite.getRule() == AlphaComposite.SRC_OVER) {
                origAlpha = origAlphaComposite.getAlpha();
            }
        }
        
	    AffineTransform defaultTransform_ = g.getTransform();
// 
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_0 = g.getTransform();
g.transform(new AffineTransform(0.023542389273643494f, 0.0f, 0.0f, 0.02086758054792881f, 45.3144416809082f, 40.27859878540039f));
// _0_0_0
g.setComposite(AlphaComposite.getInstance(3, 0.40206185f * origAlpha));
AffineTransform defaultTransform__0_0_0_0 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0_0
paint = new LinearGradientPaint(new Point2D.Double(302.8571472167969, 366.64788818359375), new Point2D.Double(302.8571472167969, 609.5050659179688), new float[] {0.0f,0.5f,1.0f}, new Color[] {new Color(0, 0, 0, 0),new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(2.7743890285491943f, 0.0f, 0.0f, 1.9697060585021973f, -1892.178955078125f, -872.8853759765625f));
shape = new Rectangle2D.Double(-1559.2523193359375, -150.6968536376953, 1339.633544921875, 478.357177734375);
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 0.40206185f * origAlpha));
AffineTransform defaultTransform__0_0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0_1
paint = new RadialGradientPaint(new Point2D.Double(605.7142944335938, 486.64788818359375), 117.14286f, new Point2D.Double(605.7142944335938, 486.64788818359375), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(2.7743890285491943f, 0.0f, 0.0f, 1.9697060585021973f, -1891.633056640625f, -872.8853759765625f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-219.61876, -150.68037);
((GeneralPath)shape).curveTo(-219.61876, -150.68037, -219.61876, 327.65042, -219.61876, 327.65042);
((GeneralPath)shape).curveTo(-76.74459, 328.55087, 125.78146, 220.48074, 125.78138, 88.45424);
((GeneralPath)shape).curveTo(125.78138, -43.572304, -33.655437, -150.68036, -219.61876, -150.68037);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 0.40206185f * origAlpha));
AffineTransform defaultTransform__0_0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_0_2
paint = new RadialGradientPaint(new Point2D.Double(605.7142944335938, 486.64788818359375), 117.14286f, new Point2D.Double(605.7142944335938, 486.64788818359375), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(-2.7743890285491943f, 0.0f, 0.0f, 1.9697060585021973f, 112.76229858398438f, -872.8853759765625f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(-1559.2523, -150.68037);
((GeneralPath)shape).curveTo(-1559.2523, -150.68037, -1559.2523, 327.65042, -1559.2523, 327.65042);
((GeneralPath)shape).curveTo(-1702.1265, 328.55087, -1904.6525, 220.48074, -1904.6525, 88.45424);
((GeneralPath)shape).curveTo(-1904.6525, -43.572304, -1745.2157, -150.68036, -1559.2523, -150.68037);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_0_2);
g.setTransform(defaultTransform__0_0_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_1 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_1
paint = new Color(83, 83, 83, 255);
stroke = new BasicStroke(2.0f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(9.28569, 22.018085);
((GeneralPath)shape).curveTo(8.66069, 22.018085, 8.254441, 22.308266, 8.004442, 22.861837);
((GeneralPath)shape).curveTo(8.004441, 22.861837, 3.5356915, 33.9654, 3.5356915, 33.9654);
((GeneralPath)shape).curveTo(3.5356915, 33.9654, 3.2856915, 34.636963, 3.2856915, 35.74665);
((GeneralPath)shape).curveTo(3.2856915, 35.74665, 3.2856915, 41.39662, 3.2856915, 41.39662);
((GeneralPath)shape).curveTo(3.2856915, 42.479233, 3.943477, 43.02162, 4.9419417, 43.02162);
((GeneralPath)shape).lineTo(43.50444, 43.02162);
((GeneralPath)shape).curveTo(44.489292, 43.02162, 45.09819, 42.30344, 45.09819, 41.17787);
((GeneralPath)shape).lineTo(45.09819, 35.5279);
((GeneralPath)shape).curveTo(45.09819, 35.5279, 45.20415, 34.75748, 45.00444, 34.2154);
((GeneralPath)shape).lineTo(40.28569, 23.01809);
((GeneralPath)shape).curveTo(40.101166, 22.506182, 39.648785, 22.029991, 39.16069, 22.018085);
((GeneralPath)shape).lineTo(9.28569, 22.018085);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_1);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_2 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_2
paint = new LinearGradientPaint(new Point2D.Double(7.604620456695557, 28.481176376342773), new Point2D.Double(36.183067321777344, 40.94393539428711), new float[] {0.0f,1.0f}, new Color[] {new Color(187, 187, 187, 255),new Color(159, 159, 159, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 8.055462837219238f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(3.2735915, 35.052277);
((GeneralPath)shape).lineTo(4.0381937, 34.36006);
((GeneralPath)shape).lineTo(41.647884, 34.42256);
((GeneralPath)shape).lineTo(45.11029, 34.73986);
((GeneralPath)shape).lineTo(45.11029, 41.17839);
((GeneralPath)shape).curveTo(45.11029, 42.30396, 44.503273, 43.02172, 43.518417, 43.02172);
((GeneralPath)shape).lineTo(4.9354315, 43.02172);
((GeneralPath)shape).curveTo(3.9369667, 43.02172, 3.2735915, 42.47967, 3.2735915, 41.397057);
((GeneralPath)shape).lineTo(3.2735915, 35.052277);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_2);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_3 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_3
paint = new Color(102, 102, 102, 255);
stroke = new BasicStroke(2.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.5625, 19.75);
((GeneralPath)shape).curveTo(21.937845, 19.75, 19.852749, 20.801914, 19.6875, 22.125);
((GeneralPath)shape).lineTo(19.625, 22.125);
((GeneralPath)shape).curveTo(19.625, 22.125, 18.34375, 27.3125, 18.34375, 27.3125);
((GeneralPath)shape).curveTo(18.125, 28.40625, 20.422495, 30.34375, 24.5625, 30.34375);
((GeneralPath)shape).curveTo(28.733892, 30.34375, 31.125, 28.375, 30.71875, 26.90625);
((GeneralPath)shape).curveTo(30.71875, 26.90625, 29.53125, 22.125, 29.53125, 22.125);
((GeneralPath)shape).lineTo(29.46875, 22.125);
((GeneralPath)shape).curveTo(29.30511, 20.801123, 27.188265, 19.750002, 24.5625, 19.75);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_3);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_4 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_4
paint = new RadialGradientPaint(new Point2D.Double(15.571491241455078, 2.9585189819335938), 20.935818f, new Point2D.Double(15.571491241455078, 2.9585189819335938), new float[] {0.0f,1.0f}, new Color[] {new Color(228, 228, 228, 255),new Color(211, 211, 211, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.2862420082092285f, 0.7816979885101318f, -0.710781991481781f, 1.169551968574524f, -2.3543479442596436f, 3.1786019802093506f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(3.5490842, 33.969868);
((GeneralPath)shape).curveTo(2.8347986, 35.434155, 3.5484686, 36.362724, 4.5847983, 36.362724);
((GeneralPath)shape).curveTo(4.5847983, 36.362724, 43.584797, 36.362724, 43.584797, 36.362724);
((GeneralPath)shape).curveTo(44.703842, 36.338917, 45.430035, 35.35082, 45.013367, 34.219868);
((GeneralPath)shape).lineTo(40.299084, 23.009163);
((GeneralPath)shape).curveTo(40.11456, 22.497255, 39.64432, 22.021063, 39.156223, 22.009157);
((GeneralPath)shape).lineTo(9.299083, 22.009157);
((GeneralPath)shape).curveTo(8.674083, 22.009157, 8.26337, 22.31273, 8.0133705, 22.866304);
((GeneralPath)shape).curveTo(8.0133705, 22.866304, 3.5490842, 33.969868, 3.5490842, 33.969868);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_4);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_5 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.15467900037765503f, 0.2872610092163086f));
// _0_0_5
paint = new RadialGradientPaint(new Point2D.Double(10.363533973693848, 32.70881652832031), 3.822796f, new Point2D.Double(10.363533973693848, 32.70881652832031), new float[] {0.0f,1.0f}, new Color[] {new Color(0, 0, 0, 255),new Color(0, 0, 0, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 0.6242769956588745f, 0.0f, 12.289440155029297f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(14.18633, 32.708817);
((GeneralPath)shape).curveTo(14.186812, 33.561626, 13.458297, 34.349785, 12.275322, 34.776276);
((GeneralPath)shape).curveTo(11.092346, 35.202766, 9.634722, 35.202766, 8.451746, 34.776276);
((GeneralPath)shape).curveTo(7.2687707, 34.349785, 6.5402555, 33.561626, 6.540738, 32.708817);
((GeneralPath)shape).curveTo(6.5402555, 31.856007, 7.2687707, 31.067848, 8.451746, 30.641357);
((GeneralPath)shape).curveTo(9.634722, 30.214865, 11.092346, 30.214865, 12.275322, 30.641357);
((GeneralPath)shape).curveTo(13.458297, 31.067848, 14.186812, 31.856007, 14.18633, 32.708817);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_5);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_6 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_6
paint = new Color(255, 255, 255, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(44.79616, 33.68415);
((GeneralPath)shape).curveTo(44.859684, 34.934128, 44.38216, 35.999992, 43.474045, 36.0279);
((GeneralPath)shape).curveTo(43.474045, 36.0279, 5.3553295, 36.0279, 5.3553295, 36.0279);
((GeneralPath)shape).curveTo(4.0660977, 36.0279, 3.4875937, 35.702953, 3.271279, 35.159847);
((GeneralPath)shape).curveTo(3.3630404, 36.10418, 4.0970964, 36.80915, 5.3553295, 36.80915);
((GeneralPath)shape).curveTo(5.3553295, 36.80915, 43.474045, 36.80915, 43.474045, 36.80915);
((GeneralPath)shape).curveTo(44.550053, 36.77608, 45.226852, 35.385128, 44.82621, 33.81436);
((GeneralPath)shape).lineTo(44.79616, 33.68415);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_6);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_7 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_7
paint = new LinearGradientPaint(new Point2D.Double(12.37835693359375, 4.433135986328125), new Point2D.Double(44.096099853515625, 47.620635986328125), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 8.055462837219238f));
stroke = new BasicStroke(1.0000002f,1,1,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(9.642515, 22.47118);
((GeneralPath)shape).curveTo(9.040823, 22.47118, 8.649724, 22.75054, 8.409049, 23.283466);
((GeneralPath)shape).curveTo(8.409048, 23.283466, 3.994034, 33.874195, 3.994034, 33.874195);
((GeneralPath)shape).curveTo(3.994034, 33.874195, 3.7533574, 34.52071, 3.7533574, 35.58902);
((GeneralPath)shape).curveTo(3.7533574, 35.58902, 3.7533574, 40.879116, 3.7533574, 40.879116);
((GeneralPath)shape).curveTo(3.7533574, 42.233856, 4.1974134, 42.506016, 5.3478413, 42.506016);
((GeneralPath)shape).lineTo(43.034744, 42.506016);
((GeneralPath)shape).curveTo(44.357872, 42.506016, 44.56906, 42.189617, 44.56906, 40.66852);
((GeneralPath)shape).lineTo(44.56906, 35.378426);
((GeneralPath)shape).curveTo(44.56906, 35.378426, 44.67107, 34.636734, 44.478806, 34.114872);
((GeneralPath)shape).lineTo(39.885616, 23.308891);
((GeneralPath)shape).curveTo(39.707973, 22.816074, 39.334965, 22.482641, 38.86507, 22.47118);
((GeneralPath)shape).lineTo(9.642515, 22.47118);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_7);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_8 = g.getTransform();
g.transform(new AffineTransform(1.581300973892212f, 0.0f, 0.0f, 1.581300973892212f, -14.283699989318848f, -16.590700149536133f));
// _0_0_8
paint = new Color(255, 255, 255, 122);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.819805, 28.377787);
((GeneralPath)shape).curveTo(31.819805, 30.42804, 28.574835, 32.090096, 24.57196, 32.090096);
((GeneralPath)shape).curveTo(20.569086, 32.090096, 17.324116, 30.42804, 17.324116, 28.377787);
((GeneralPath)shape).curveTo(17.324116, 26.327534, 20.569086, 24.665476, 24.57196, 24.665476);
((GeneralPath)shape).curveTo(28.574835, 24.665476, 31.819805, 26.327534, 31.819805, 28.377787);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_8);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_9 = g.getTransform();
g.transform(new AffineTransform(0.8536589741706848f, 0.0f, 0.0f, 0.8536589741706848f, 3.5958969593048096f, 2.933177947998047f));
// _0_0_9
paint = new Color(201, 201, 201, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.819805, 28.377787);
((GeneralPath)shape).curveTo(31.819805, 30.42804, 28.574835, 32.090096, 24.57196, 32.090096);
((GeneralPath)shape).curveTo(20.569086, 32.090096, 17.324116, 30.42804, 17.324116, 28.377787);
((GeneralPath)shape).curveTo(17.324116, 26.327534, 20.569086, 24.665476, 24.57196, 24.665476);
((GeneralPath)shape).curveTo(28.574835, 24.665476, 31.819805, 26.327534, 31.819805, 28.377787);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_9);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_10 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_10
paint = new Color(102, 102, 102, 255);
stroke = new BasicStroke(2.0f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.5625, 1.34375);
((GeneralPath)shape).curveTo(20.903221, 1.34375, 17.9375, 4.3094726, 17.9375, 7.96875);
((GeneralPath)shape).curveTo(17.9375, 10.576309, 19.496574, 12.761497, 21.6875, 13.84375);
((GeneralPath)shape).lineTo(21.6875, 22.3125);
((GeneralPath)shape).curveTo(21.6875, 22.3125, 21.6875, 22.348137, 21.6875, 22.375);
((GeneralPath)shape).curveTo(21.6875, 23.188967, 22.973326, 23.843752, 24.5625, 23.84375);
((GeneralPath)shape).curveTo(26.151674, 23.84375, 27.4375, 23.188967, 27.4375, 22.375);
((GeneralPath)shape).lineTo(27.4375, 22.3125);
((GeneralPath)shape).lineTo(27.4375, 13.875);
((GeneralPath)shape).curveTo(29.647942, 12.799796, 31.1875, 10.590605, 31.1875, 7.96875);
((GeneralPath)shape).curveTo(31.1875, 4.3094726, 28.221779, 1.34375, 24.5625, 1.34375);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_10);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_11 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_11
paint = new LinearGradientPaint(new Point2D.Double(28.46875, 28.125), new Point2D.Double(20.0, 26.375), new float[] {0.0f,1.0f}, new Color[] {new Color(170, 170, 170, 255),new Color(205, 205, 205, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, -0.625f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(29.53125, 22.125);
((GeneralPath)shape).curveTo(29.53125, 22.125, 30.71875, 26.90625, 30.71875, 26.90625);
((GeneralPath)shape).curveTo(31.125, 28.375, 28.733892, 30.34375, 24.5625, 30.34375);
((GeneralPath)shape).curveTo(20.422495, 30.34375, 18.125, 28.40625, 18.34375, 27.3125);
((GeneralPath)shape).curveTo(18.34375, 27.3125, 19.625, 22.125, 19.625, 22.125);
((GeneralPath)shape).lineTo(29.53125, 22.125);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_11);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_12 = g.getTransform();
g.transform(new AffineTransform(0.6829270124435425f, 0.0f, 0.0f, 0.6829270124435425f, 7.791110038757324f, 2.9031660556793213f));
// _0_0_12
paint = new Color(228, 228, 228, 255);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.819805, 28.377787);
((GeneralPath)shape).curveTo(31.819805, 30.42804, 28.574835, 32.090096, 24.57196, 32.090096);
((GeneralPath)shape).curveTo(20.569086, 32.090096, 17.324116, 30.42804, 17.324116, 28.377787);
((GeneralPath)shape).curveTo(17.324116, 26.327534, 20.569086, 24.665476, 24.57196, 24.665476);
((GeneralPath)shape).curveTo(28.574835, 24.665476, 31.819805, 26.327534, 31.819805, 28.377787);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_12);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_13 = g.getTransform();
g.transform(new AffineTransform(0.6336349844932556f, 0.0f, 0.0f, 0.6336349844932556f, 9.123851776123047f, 4.176869869232178f));
// _0_0_13
paint = new LinearGradientPaint(new Point2D.Double(24.237060546875, 31.71243667602539), new Point2D.Double(24.237060546875, 28.35917091369629), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(1.0777932f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.5625, 24.65625);
((GeneralPath)shape).curveTo(20.56169, 24.65625, 17.3125, 26.325806, 17.3125, 28.375);
((GeneralPath)shape).curveTo(17.3125, 30.424194, 20.56169, 32.093754, 24.5625, 32.09375);
((GeneralPath)shape).curveTo(28.56331, 32.09375, 31.8125, 30.424194, 31.8125, 28.375);
((GeneralPath)shape).curveTo(31.8125, 26.325806, 28.56331, 24.65625, 24.5625, 24.65625);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_13);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_14 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_14
paint = new LinearGradientPaint(new Point2D.Double(26.3125, 17.5), new Point2D.Double(23.0625, 17.5), new float[] {0.0f,1.0f}, new Color[] {new Color(170, 170, 170, 255),new Color(205, 205, 205, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, -0.625f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.5625, 6.28125);
((GeneralPath)shape).curveTo(22.973326, 6.28125, 21.687502, 6.936033, 21.6875, 7.75);
((GeneralPath)shape).curveTo(21.6875, 7.7768636, 21.747227, 7.785989, 21.75, 7.8125);
((GeneralPath)shape).lineTo(21.6875, 7.8125);
((GeneralPath)shape).lineTo(21.6875, 21.6875);
((GeneralPath)shape).lineTo(21.75, 21.6875);
((GeneralPath)shape).curveTo(21.747227, 21.71401, 21.6875, 21.723137, 21.6875, 21.75);
((GeneralPath)shape).curveTo(21.6875, 22.563967, 22.973326, 23.218752, 24.5625, 23.21875);
((GeneralPath)shape).curveTo(26.151674, 23.21875, 27.4375, 22.563967, 27.4375, 21.75);
((GeneralPath)shape).curveTo(27.4375, 21.723137, 27.377773, 21.71401, 27.375, 21.6875);
((GeneralPath)shape).lineTo(27.4375, 21.6875);
((GeneralPath)shape).lineTo(27.4375, 7.8125);
((GeneralPath)shape).lineTo(27.375, 7.8125);
((GeneralPath)shape).curveTo(27.377773, 7.785989, 27.4375, 7.7768636, 27.4375, 7.75);
((GeneralPath)shape).curveTo(27.4375, 6.936033, 26.151674, 6.28125, 24.5625, 6.28125);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_14);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_15 = g.getTransform();
g.transform(new AffineTransform(0.9675769805908203f, 0.0f, 0.0f, 0.9675769805908203f, 0.9677299857139587f, -0.1686599999666214f));
// _0_0_15
paint = new RadialGradientPaint(new Point2D.Double(22.69399070739746, 4.936570644378662), 6.629126f, new Point2D.Double(22.69399070739746, 4.936570644378662), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 138, 43, 255),new Color(131, 58, 0, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(2.3855628967285156f, 1.1077670525945927E-15f, -1.1077670525945927E-15f, 2.3855628967285156f, -30.843700408935547f, -6.089588165283203f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.02431, 8.40202);
((GeneralPath)shape).curveTo(31.02431, 12.063186, 28.056349, 15.031147, 24.395184, 15.031147);
((GeneralPath)shape).curveTo(20.734016, 15.031147, 17.766056, 12.063186, 17.766056, 8.40202);
((GeneralPath)shape).curveTo(17.766056, 4.7408547, 20.734016, 1.7728939, 24.395184, 1.7728939);
((GeneralPath)shape).curveTo(28.056349, 1.7728939, 31.02431, 4.7408547, 31.02431, 8.40202);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_15);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_16 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 0.8496599793434143f, 0.8106619715690613f, 5.224198818206787f));
// _0_0_16
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_16_0 = g.getTransform();
g.transform(new AffineTransform(0.5103309750556946f, 0.0f, 0.0f, 0.3547520041465759f, -2.8776700496673584f, 29.416950225830078f));
// _0_0_16_0
paint = new LinearGradientPaint(new Point2D.Double(23.599132537841797, 3.49342679977417), new Point2D.Double(26.032751083374023, 13.09520435333252), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 138, 43, 255),new Color(131, 58, 0, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.02431, 8.40202);
((GeneralPath)shape).curveTo(31.02431, 12.063186, 28.056349, 15.031147, 24.395184, 15.031147);
((GeneralPath)shape).curveTo(20.734016, 15.031147, 17.766056, 12.063186, 17.766056, 8.40202);
((GeneralPath)shape).curveTo(17.766056, 4.7408547, 20.734016, 1.7728939, 24.395184, 1.7728939);
((GeneralPath)shape).curveTo(28.056349, 1.7728939, 31.02431, 4.7408547, 31.02431, 8.40202);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_16_0);
g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
AffineTransform defaultTransform__0_0_16_1 = g.getTransform();
g.transform(new AffineTransform(0.4301930069923401f, 0.0f, 0.0f, 0.29904499650001526f, -0.9226740002632141f, 29.603750228881836f));
// _0_0_16_1
paint = new LinearGradientPaint(new Point2D.Double(24.395183563232422, 11.509590148925781), new Point2D.Double(17.76605796813965, -6.460710525512695), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 138, 43, 255),new Color(131, 58, 0, 255)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
shape = new GeneralPath();
((GeneralPath)shape).moveTo(31.02431, 8.40202);
((GeneralPath)shape).curveTo(31.02431, 12.063186, 28.056349, 15.031147, 24.395184, 15.031147);
((GeneralPath)shape).curveTo(20.734016, 15.031147, 17.766056, 12.063186, 17.766056, 8.40202);
((GeneralPath)shape).curveTo(17.766056, 4.7408547, 20.734016, 1.7728939, 24.395184, 1.7728939);
((GeneralPath)shape).curveTo(28.056349, 1.7728939, 31.02431, 4.7408547, 31.02431, 8.40202);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.fill(shape);
g.setTransform(defaultTransform__0_0_16_1);
g.setTransform(defaultTransform__0_0_16);
g.setComposite(AlphaComposite.getInstance(3, 0.5257143f * origAlpha));
AffineTransform defaultTransform__0_0_17 = g.getTransform();
g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
// _0_0_17
paint = new LinearGradientPaint(new Point2D.Double(21.057628631591797, 2.4374961853027344), new Point2D.Double(26.286109924316406, 29.562496185302734), new float[] {0.0f,1.0f}, new Color[] {new Color(255, 255, 255, 255),new Color(255, 255, 255, 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
stroke = new BasicStroke(0.99999976f,0,0,4.0f,null,0.0f);
shape = new GeneralPath();
((GeneralPath)shape).moveTo(24.563623, 2.0718822);
((GeneralPath)shape).curveTo(21.278748, 2.0718822, 18.620129, 4.7594943, 18.620129, 8.044369);
((GeneralPath)shape).curveTo(18.620129, 10.357138, 20.280153, 12.307309, 22.208797, 13.29204);
((GeneralPath)shape).lineTo(22.208797, 20.414005);
((GeneralPath)shape).curveTo(21.341562, 20.809402, 20.055668, 21.457195, 20.040768, 22.09558);
((GeneralPath)shape).curveTo(20.040768, 22.09558, 18.794085, 27.240824, 18.794085, 27.240824);
((GeneralPath)shape).curveTo(18.591137, 28.255568, 20.722672, 30.05311, 24.563623, 30.05311);
((GeneralPath)shape).curveTo(28.433695, 30.05311, 30.65208, 28.226574, 30.275175, 26.863918);
((GeneralPath)shape).lineTo(29.057486, 22.0086);
((GeneralPath)shape).curveTo(29.041525, 21.324823, 27.831797, 20.896706, 26.855947, 20.500982);
((GeneralPath)shape).lineTo(26.855947, 13.29204);
((GeneralPath)shape).curveTo(28.784592, 12.307309, 30.53611, 10.357138, 30.53611, 8.044369);
((GeneralPath)shape).curveTo(30.53611, 4.7594943, 27.848497, 2.0718822, 24.563623, 2.0718822);
((GeneralPath)shape).closePath();
g.setPaint(paint);
g.setStroke(stroke);
g.draw(shape);
g.setTransform(defaultTransform__0_0_17);
g.setTransform(defaultTransform__0_0);
g.setTransform(defaultTransform__0);
g.setTransform(defaultTransform_);

	}

    /**
     * Returns the X of the bounding box of the original SVG image.
     * 
     * @return The X of the bounding box of the original SVG image.
     */
    public static int getOrigX() {
        return 1;
    }

    /**
     * Returns the Y of the bounding box of the original SVG image.
     * 
     * @return The Y of the bounding box of the original SVG image.
     */
    public static int getOrigY() {
        return 1;
    }

	/**
	 * Returns the width of the bounding box of the original SVG image.
	 * 
	 * @return The width of the bounding box of the original SVG image.
	 */
	public static int getOrigWidth() {
		return 48;
	}

	/**
	 * Returns the height of the bounding box of the original SVG image.
	 * 
	 * @return The height of the bounding box of the original SVG image.
	 */
	public static int getOrigHeight() {
		return 47;
	}

	/**
	 * The current width of this resizable icon.
	 */
	int width;

	/**
	 * The current height of this resizable icon.
	 */
	int height;

	/**
	 * Creates a new transcoded SVG image.
	 */
	public InputGamingSvgIcon() {
        this.width = getOrigWidth();
        this.height = getOrigHeight();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconHeight()
	 */
    @Override
	public int getIconHeight() {
		return height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#getIconWidth()
	 */
    @Override
	public int getIconWidth() {
		return width;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.jvnet.flamingo.common.icon.ResizableIcon#setDimension(java.awt.Dimension
	 * )
	 */
	@Override
	public void setDimension(Dimension newDimension) {
		this.width = newDimension.width;
		this.height = newDimension.height;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics,
	 * int, int)
	 */
    @Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Graphics2D g2d = (Graphics2D) g.create();
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.translate(x, y);

		double coef1 = (double) this.width / (double) getOrigWidth();
		double coef2 = (double) this.height / (double) getOrigHeight();
		double coef = Math.min(coef1, coef2);
		g2d.scale(coef, coef);
		paint(g2d);
		g2d.dispose();
	}
}

